#!/bin/sh -f
#
# Script to run GILPS on parallel on all lake machines
#
# Author: Jose Santos <jcas81@gmail.com>, 13 Dec 2009
#
# We are assuming ssh won't ask for password and shares the same filesystem as the computer from which this script is executed

yap_dir='/homes/jcs06/bin/yap6/bin/yap'
#yap_dir='yap'
gilps_file='/vol/comp-bio/jcas/ILP/paper/GILPS/gilps' # where to load GILPS
common_modes_file='/vol/comp-bio/jcas/ILP/paper/datasets/phase_transition/modes' # where mode file common to all problems is
problems_dir='/vol/comp-bio/jcas/ILP/paper/datasets/phase_transition' # where all problems are
cur_dir=`pwd`
save_to_dir=${cur_dir}/results
mkdir ${save_to_dir}
for pno in p.m6.l12 p.m7.l12 p.m8.l12 p.m10.l12 p.m11.l12 p.m14.l12 p.m16.l12 p.m17.l12 # problem number
do
  echo ${pno}
  problem_dir=${problems_dir}/${pno} # current problem directory
   ${yap_dir} -L ${cur_dir}/run_gilps_pt -- ${gilps_file} ${problem_dir} ${common_modes_file} ${save_to_dir}> ${save_to_dir}/${pno}.txt # save result
done
