%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Author: Jose Santos <jcas81@gmail.com>
% Date: 2009-12-13
%
% This file has the script to execute bota et al phase transition dataset
%
% It is expecting four arguments from the command line: GILPS file, Problem Directory, Common Modes File, Results_Dir
%
% E.g. 
%  yap -l create_ground_bottoms.pl GILPS Problem_Directory Common_modes_file Results_Dir
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:- use_module(library(lists), [append/3, reverse/2]).

%basename(+FullStr, -BaseStr)
% E.g. basename('/vol/comp-bio/jcas/ILP/GILPS/datasets/long_concept/pt/progol', 'progol')

basename(FullStr, BaseStr):-
  atom_codes(FullStr, FullAsCodes),
  reverse(FullAsCodes, RCodes),
  append(RBaseAsCodes, [47|_], RCodes),!, % 47 is the ASCII code for '/'
  reverse(RBaseAsCodes, BaseAsCodes),
  atom_codes(BaseStr, BaseAsCodes).

load_problem(ProblemDir, Common_Modes_File):-
  atom_concat([ProblemDir, '/', all_brel], File1),
  atom_concat([ProblemDir, '/', gilps_train], File2),
  consult([File1, File2]),
  read_problem(Common_Modes_File).

construct_theory(ProblemDir, ResultsDir):-
  atom_concat([ProblemDir, '/gilps_test'], TestFile),
  basename(ProblemDir, ProblemName),
  atom_concat([ResultsDir, '/', ProblemName, '.pl'], TheoryFile),
  set(output_theory_file, TheoryFile),
  build_theory,
  evaluate_theory(TheoryFile, TestFile).
 % show_settings.

define_settings(GILPS):-
  consult(GILPS),
  %set(example_inflation, 1),
  set(star_default_recall, 2),
  set(verbose, 2),
  set(evalfn, compression),
  set(engine, progolem),
  %set(cut_transformation, true),
  %set(clause_evaluation, smallest_predicate_domain),
  %set(clause_evaluation, smallest_variable_domain),
  set(clause_evaluation, advanced),
  set(min_resolutions, +inf),
  set(progolem_mode, single),
  %set(progolem_mode, pairs),
  set(progolem_beam_width, 2),
  set(progolem_initial_pairs_sample, 10),
  set(progolem_iteration_sample_size, 10),
  set(negative_reduction_measure, precision),
  set(progolem_refinement_operator, armg),
  set(theory_construction, incremental),
  set(max_uncompressive_examples, 10),
  set(maxneg, 0),
  set(noise, 0).

run:-
  yap_flag(argv, [GILPS, Problem_Dir, Common_Modes_File, Results_Dir]),  
  define_settings(GILPS),
  load_problem(Problem_Dir, Common_Modes_File),
  construct_theory(Problem_Dir, Results_Dir).

%:- yap_flag(profiling, on), profinit, profon.
:- run.
%:- profoff, showprofres(10).
