% Author: Jose Santos <jcas81@gmail.com>

%:- yap_flag(profiling, on), profinit, profon.

:- use_module('GILPS/gilps').

apply_settings:-
  %set(clause_evaluation, smallest_variable_domain),
  %set(clause_evaluation, advanced),
  set(theory_construction, incremental),
  set(engine, progolem),
  set(progolem_mode, single),
  set(progolem_iteration_sample_size, 5),
  set(progolem_beam_width, 2),
  set(evalfn, compression),
  set(negative_reduction_measure, precision),
  set(progolem_refinement_operator, armg),
  %set(min_resolutions, +inf),
  set(max_uncompressive_examples, +inf).

% Datasets evaluated with 10 fold cross validation

alzheimers_amine:-
  apply_settings,
  set(maxneg, 10),
  set(cross_validation_folds, 10),
  read_problem('datasets/classical/alzheimers/amine'),
  build_theory,
  halt.

carcinogenesis:-
  apply_settings,
  set(maxneg, 30),
  set(cross_validation_folds, 10),
  read_problem('datasets/classical/carcinogenesis/carcinogenesis'),
  build_theory,
  halt.

dsstox:-
  apply_settings,
  set(maxneg, 10),
  set(cross_validation_folds, 10),
  set(evalfn, coverage),
  read_problem('datasets/classical/dsstox/dsstox'),
  build_theory,
  halt.

metabolism:-
  apply_settings,
  set(maxneg, 10),
  set(cross_validation_folds, 10),
  read_problem('datasets/classical/metabolism/metabolism'),
  build_theory,
  halt.

% Datasets evaluated with hold-out evaluation

proteins:-
  apply_settings,
  set(maxneg, 30),
  read_problem('datasets/classical/proteins/proteins'),
  build_theory,
  evaluate_theory('theory.pl', 'datasets/classical/proteins/examples_test'),
  halt.

pyrimidines:-
  apply_settings,
  set(maxneg, 10),
  read_problem('datasets/classical/pyrimidines/pyrimidines'),
  build_theory,
  evaluate_theory('theory.pl', 'datasets/classical/pyrimidines/examples_test'),
  halt.
