:- set_prolog_flag(single_var_warnings, off).

program_stats:-
  statistics(program, [P,_]),
  statistics(global_stack, [GS,_]),
  statistics(local_stack, [LS,_]),
  statistics(trail, [T, _]),
  statistics(runtime, [Time, _]),
  RamUsed is P+GS+LS+T,
  format("Total memory used (in bytes): ~D", [RamUsed]),nl,
  format("Total cputime (in ms): ~D", [Time]),nl.

:-[aleph].

%:- set(search, heuristic).
:- set(evalfn, compression).
:- set(minpos, 2).

:- set(verbosity, 0).

:- set(i, 2).
%:- set(minacc,0.70).
:- set(nodes, 1000).
:- set(clauselength, 5).

run:-
  induce,
  program_stats,
  halt.

