:- modeh(1,active(+molecule)).

:- modeb(*,atom(+molecule,-atomid,#element)).
:- modeb(*,sbond(+molecule,+atomid,-atomid,#bondtype)).
:- modeb(*,linked(+molecule,+atomid,-atomid,#element,#bondtype)).
:- modeb(1,dsstox_filename(+molecule,#filename)).
:- modeb(1,cas(+molecule,-cas)).
:- modeb(1,chemclass_erb(+molecule,-chemclass_erb)).
:- modeb(1,chemcount(+molecule,#chemcount)).
:- modeb(1,chemname(+molecule,-chemname)).
:- modeb(1,chemnote(+molecule,-chemnote)).
:- modeb(1,er_rba(+molecule,-float)).
:- modeb(1,f1_ring(+molecule,#ring)).
:- modeb(1,f1_ring(+molecule,-ring)).
:- modeb(1,f2_aromatic_ring(+molecule,-ring)).
:- modeb(1,f3_phenolic_ring(+molecule,-ring)).
:- modeb(1,f4_heteroatom(+molecule,-ring)).
:- modeb(1,f5_phenol3nphenyl(+molecule,-ring)).
:- modeb(1,f6_other_key_features(+molecule,-ring)).
:- modeb(1,formula(+molecule,-formula)).
:- modeb(1,log_er_rba(+molecule,-float)).
:- modeb(1,logp(+molecule,-float)).
:- modeb(1,mean_er_rba_chemclass(+molecule,-float)).
:- modeb(1,molweight(+molecule,-float)).
:- modeb(1,structureshown(+molecule,#structure)).
:- modeb(1,substancetype(+molecule,#substype)).
:- modeb(1,testedform(+molecule,#substype)).
:- modeb(1,smiles(+molecule,-smiles)).

:- set(minpos,2).
:- set(verbose,1).

:- set(noise, 0.30).
:- set(cross_validation_folds, 5).

:- [examples_nfoil].

sbond(M,A1,A2,T) :- bond(M,A1,A2,T);bond(M,A2,A1,T).
linked(M,A1,A2,E,B) :- sbond(M,A1,A2,B), atom(M,A2,E).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id1,1).
dsstox_filename(id1,nctrer_v1a_232_23oct03).
activity_category_er_rba(id1,active_medium).
cas(id1,'446-72-0').
chemclass_erb(id1,phytoestrogens_isoflavones).
chemcount(id1,'1').
chemname(id1,'genistein').
chemnote(id1,'blank').
er_rba(id1,0.436).
f1_ring(id1,1).
f2_aromatic_ring(id1,1).
f3_phenolic_ring(id1,1).
f4_heteroatom(id1,0).
f5_phenol3nphenyl(id1,1).
f6_other_key_features(id1,0).
formula(id1,c15h10o5).
log_er_rba(id1,-0.36).
logp(id1,2.84).
mean_er_rba_chemclass(id1,0.019).
molweight(id1,270.241).
structureshown(id1,tested_form).
substancetype(id1,defined_organic).
testedform(id1,parent).
smiles(id1,'c1(c2c(cc(cc2o)o)occ1c1ccc(cc1)o)=o_').
%activity(id1,active).
atom(id1,a1,'C').
atom(id1,a2,'C').
atom(id1,a3,'C').
atom(id1,a4,'C').
atom(id1,a5,'C').
atom(id1,a6,'C').
atom(id1,a7,'C').
atom(id1,a8,'O').
atom(id1,a9,'O').
atom(id1,a10,'O').
atom(id1,a11,'C').
atom(id1,a12,'C').
atom(id1,a13,'C').
atom(id1,a14,'C').
atom(id1,a15,'C').
atom(id1,a16,'C').
atom(id1,a17,'C').
atom(id1,a18,'C').
atom(id1,a19,'O').
atom(id1,a20,'O').
bond(id1,a2,a1,single).
bond(id1,a3,a2,double).
bond(id1,a4,a3,single).
bond(id1,a5,a4,double).
bond(id1,a6,a5,single).
bond(id1,a7,a6,double).
bond(id1,a7,a2,single).
bond(id1,a8,a7,single).
bond(id1,a9,a5,single).
bond(id1,a10,a3,single).
bond(id1,a11,a10,single).
bond(id1,a12,a11,double).
bond(id1,a12,a1,single).
bond(id1,a13,a12,single).
bond(id1,a14,a13,single).
bond(id1,a15,a14,double).
bond(id1,a16,a15,single).
bond(id1,a17,a16,double).
bond(id1,a18,a17,single).
bond(id1,a18,a13,double).
bond(id1,a19,a16,single).
bond(id1,a20,a1,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 2
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id2,2).
dsstox_filename(id2,nctrer_v1a_232_23oct03).
activity_category_er_rba(id2,active_medium).
cas(id2,'531-95-3').
chemclass_erb(id2,phytoestrogens_isoflavones).
chemcount(id2,'1').
chemname(id2,'equol').
chemnote(id2,'unknown').
er_rba(id2,0.151).
f1_ring(id2,1).
f2_aromatic_ring(id2,1).
f3_phenolic_ring(id2,1).
f4_heteroatom(id2,0).
f5_phenol3nphenyl(id2,1).
f6_other_key_features(id2,0).
formula(id2,c15h14o3).
log_er_rba(id2,-0.82).
logp(id2,3.67).
mean_er_rba_chemclass(id2,0.019).
molweight(id2,242.2738).
structureshown(id2,tested_form).
substancetype(id2,defined_organic).
testedform(id2,parent).
smiles(id2,'c12occ(cc1ccc(c2)o)c1ccc(cc1)o_').
%activity(id2,active).
atom(id2,a1,'C').
atom(id2,a2,'O').
atom(id2,a3,'C').
atom(id2,a4,'C').
atom(id2,a5,'C').
atom(id2,a6,'C').
atom(id2,a7,'C').
atom(id2,a8,'C').
atom(id2,a9,'C').
atom(id2,a10,'C').
atom(id2,a11,'O').
atom(id2,a12,'C').
atom(id2,a13,'C').
atom(id2,a14,'C').
atom(id2,a15,'C').
atom(id2,a16,'C').
atom(id2,a17,'C').
atom(id2,a18,'O').
bond(id2,a2,a1,single).
bond(id2,a3,a2,single).
bond(id2,a4,a3,single).
bond(id2,a5,a4,single).
bond(id2,a6,a5,single).
bond(id2,a6,a1,double).
bond(id2,a7,a6,single).
bond(id2,a8,a7,double).
bond(id2,a9,a8,single).
bond(id2,a10,a9,double).
bond(id2,a10,a1,single).
bond(id2,a11,a9,single).
bond(id2,a13,a12,double).
bond(id2,a14,a13,single).
bond(id2,a15,a14,double).
bond(id2,a16,a15,single).
bond(id2,a17,a16,double).
bond(id2,a17,a12,single).
bond(id2,a18,a15,single).
bond(id2,a12,a4,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 3
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id3,3).
dsstox_filename(id3,nctrer_v1a_232_23oct03).
activity_category_er_rba(id3,active_medium).
cas(id3,'486-66-8').
chemclass_erb(id3,phytoestrogens_isoflavones).
chemcount(id3,'1').
chemname(id3,'daidzein').
chemnote(id3,'unknown').
er_rba(id3,0.022).
f1_ring(id3,1).
f2_aromatic_ring(id3,1).
f3_phenolic_ring(id3,1).
f4_heteroatom(id3,0).
f5_phenol3nphenyl(id3,1).
f6_other_key_features(id3,0).
formula(id3,c15h10o4).
log_er_rba(id3,-1.65).
logp(id3,2.55).
mean_er_rba_chemclass(id3,0.019).
molweight(id3,254.2416).
structureshown(id3,tested_form).
substancetype(id3,defined_organic).
testedform(id3,parent).
smiles(id3,'c1(c(c2ccc(cc2oc1)o)=o)c1ccc(cc1)o_').
%activity(id3,active).
atom(id3,a1,'C').
atom(id3,a2,'C').
atom(id3,a3,'C').
atom(id3,a4,'C').
atom(id3,a5,'C').
atom(id3,a6,'C').
atom(id3,a7,'C').
atom(id3,a8,'C').
atom(id3,a9,'O').
atom(id3,a10,'C').
atom(id3,a11,'O').
atom(id3,a12,'O').
atom(id3,a13,'C').
atom(id3,a14,'C').
atom(id3,a15,'C').
atom(id3,a16,'C').
atom(id3,a17,'C').
atom(id3,a18,'C').
atom(id3,a19,'O').
bond(id3,a2,a1,single).
bond(id3,a3,a2,single).
bond(id3,a4,a3,single).
bond(id3,a5,a4,double).
bond(id3,a6,a5,single).
bond(id3,a7,a6,double).
bond(id3,a8,a7,single).
bond(id3,a9,a8,single).
bond(id3,a10,a9,single).
bond(id3,a10,a1,double).
bond(id3,a8,a3,double).
bond(id3,a11,a6,single).
bond(id3,a12,a2,double).
bond(id3,a13,a1,single).
bond(id3,a14,a13,double).
bond(id3,a15,a14,single).
bond(id3,a16,a15,double).
bond(id3,a17,a16,single).
bond(id3,a18,a17,double).
bond(id3,a18,a13,single).
bond(id3,a19,a16,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 4
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id4,4).
dsstox_filename(id4,nctrer_v1a_232_23oct03).
activity_category_er_rba(id4,active_weak).
cas(id4,'485-72-3').
chemclass_erb(id4,phytoestrogens_isoflavones).
chemcount(id4,'1').
chemname(id4,'formononetin').
chemnote(id4,'unknown').
er_rba(id4,0.00104).
f1_ring(id4,1).
f2_aromatic_ring(id4,1).
f3_phenolic_ring(id4,1).
f4_heteroatom(id4,0).
f5_phenol3nphenyl(id4,1).
f6_other_key_features(id4,0).
formula(id4,c16h12o4).
log_er_rba(id4,-2.98).
logp(id4,3.11).
mean_er_rba_chemclass(id4,0.019).
molweight(id4,268.2684).
structureshown(id4,tested_form).
substancetype(id4,defined_organic).
testedform(id4,parent).
smiles(id4,'c1(c(c2ccc(cc2oc1)o)=o)c1ccc(cc1)oc_').
%activity(id4,active).
atom(id4,a1,'C').
atom(id4,a2,'C').
atom(id4,a3,'C').
atom(id4,a4,'C').
atom(id4,a5,'C').
atom(id4,a6,'C').
atom(id4,a7,'C').
atom(id4,a8,'C').
atom(id4,a9,'O').
atom(id4,a10,'C').
atom(id4,a11,'O').
atom(id4,a12,'O').
atom(id4,a13,'C').
atom(id4,a14,'C').
atom(id4,a15,'C').
atom(id4,a16,'C').
atom(id4,a17,'C').
atom(id4,a18,'C').
atom(id4,a19,'O').
atom(id4,a20,'C').
bond(id4,a2,a1,single).
bond(id4,a3,a2,single).
bond(id4,a4,a3,single).
bond(id4,a5,a4,double).
bond(id4,a6,a5,single).
bond(id4,a7,a6,double).
bond(id4,a8,a7,single).
bond(id4,a9,a8,single).
bond(id4,a10,a9,single).
bond(id4,a10,a1,double).
bond(id4,a8,a3,double).
bond(id4,a11,a6,single).
bond(id4,a12,a2,double).
bond(id4,a13,a1,single).
bond(id4,a14,a13,double).
bond(id4,a15,a14,single).
bond(id4,a16,a15,double).
bond(id4,a17,a16,single).
bond(id4,a18,a17,double).
bond(id4,a18,a13,single).
bond(id4,a19,a16,single).
bond(id4,a20,a19,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 5
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id5,5).
dsstox_filename(id5,nctrer_v1a_232_23oct03).
activity_category_er_rba(id5,active_weak).
cas(id5,'1806-26-4').
chemclass_erb(id5,phenols_alkyl).
chemcount(id5,'1').
chemname(id5,'4-n-octylphenol').
chemnote(id5,'unknown').
er_rba(id5,0.0049).
f1_ring(id5,1).
f2_aromatic_ring(id5,1).
f3_phenolic_ring(id5,1).
f4_heteroatom(id5,0).
f5_phenol3nphenyl(id5,0).
f6_other_key_features(id5,0).
formula(id5,c14h22o).
log_er_rba(id5,-2.31).
logp(id5,5.5).
mean_er_rba_chemclass(id5,0.00088).
molweight(id5,206.3272).
structureshown(id5,tested_form).
substancetype(id5,defined_organic).
testedform(id5,parent).
smiles(id5,'c1(ccc(cc1)cccccccc)o_').
%activity(id5,active).
atom(id5,a1,'C').
atom(id5,a2,'C').
atom(id5,a3,'C').
atom(id5,a4,'C').
atom(id5,a5,'C').
atom(id5,a6,'C').
atom(id5,a7,'C').
atom(id5,a8,'C').
atom(id5,a9,'C').
atom(id5,a10,'C').
atom(id5,a11,'C').
atom(id5,a12,'C').
atom(id5,a13,'C').
atom(id5,a14,'C').
atom(id5,a15,'O').
bond(id5,a2,a1,double).
bond(id5,a3,a2,single).
bond(id5,a4,a3,double).
bond(id5,a5,a4,single).
bond(id5,a6,a5,double).
bond(id5,a6,a1,single).
bond(id5,a7,a4,single).
bond(id5,a8,a7,single).
bond(id5,a9,a8,single).
bond(id5,a10,a9,single).
bond(id5,a11,a10,single).
bond(id5,a12,a11,single).
bond(id5,a13,a12,single).
bond(id5,a14,a13,single).
bond(id5,a15,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 6
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id6,6).
dsstox_filename(id6,nctrer_v1a_232_23oct03).
activity_category_er_rba(id6,slight_binder).
cas(id6,'3424-82-6').
chemclass_erb(id6,diphenylmethanes_ddts).
chemcount(id6,'1').
chemname(id6,'o,p_-dde').
chemnote(id6,'unknown').
er_rba(id6,0).
f1_ring(id6,1).
f2_aromatic_ring(id6,1).
f3_phenolic_ring(id6,0).
f4_heteroatom(id6,0).
f5_phenol3nphenyl(id6,0).
f6_other_key_features(id6,1).
formula(id6,c14h8cl4).
log_er_rba(id6,-5000).
logp(id6,6).
mean_er_rba_chemclass(id6,0.0087).
molweight(id6,318.0292).
structureshown(id6,tested_form).
substancetype(id6,defined_organic).
testedform(id6,parent).
smiles(id6,'c1(ccccc1c(=c(cl)cl)c1ccc(cc1)cl)cl_').
%activity(id6,inactive).
atom(id6,a1,'C').
atom(id6,a2,'C').
atom(id6,a3,'C').
atom(id6,a4,'C').
atom(id6,a5,'C').
atom(id6,a6,'C').
atom(id6,a7,'C').
atom(id6,a8,'C').
atom(id6,a9,'Cl').
atom(id6,a10,'Cl').
atom(id6,a11,'C').
atom(id6,a12,'C').
atom(id6,a13,'C').
atom(id6,a14,'C').
atom(id6,a15,'C').
atom(id6,a16,'C').
atom(id6,a17,'Cl').
atom(id6,a18,'Cl').
bond(id6,a2,a1,single).
bond(id6,a3,a2,double).
bond(id6,a4,a3,single).
bond(id6,a5,a4,double).
bond(id6,a6,a5,single).
bond(id6,a6,a1,double).
bond(id6,a7,a6,single).
bond(id6,a8,a7,double).
bond(id6,a9,a8,single).
bond(id6,a10,a8,single).
bond(id6,a11,a7,single).
bond(id6,a12,a11,double).
bond(id6,a13,a12,single).
bond(id6,a14,a13,double).
bond(id6,a15,a14,single).
bond(id6,a16,a15,double).
bond(id6,a16,a11,single).
bond(id6,a17,a14,single).
bond(id6,a18,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 7
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id7,7).
dsstox_filename(id7,nctrer_v1a_232_23oct03).
activity_category_er_rba(id7,slight_binder).
cas(id7,'117-81-7').
chemclass_erb(id7,misc).
chemcount(id7,'1').
chemname(id7,'bis(2-ethylhexyl)phthalate').
chemnote(id7,'unknown').
er_rba(id7,0).
f1_ring(id7,1).
f2_aromatic_ring(id7,1).
f3_phenolic_ring(id7,0).
f4_heteroatom(id7,0).
f5_phenol3nphenyl(id7,0).
f6_other_key_features(id7,0).
formula(id7,c24h38o4).
log_er_rba(id7,-5000).
logp(id7,8.39).
mean_er_rba_chemclass(id7,na).
molweight(id7,390.5618).
structureshown(id7,tested_form).
substancetype(id7,defined_organic).
testedform(id7,parent).
smiles(id7,'c1(c(c(occ(cc)cccc)=o)cccc1)c(occ(cc)cccc)=o_').
%activity(id7,inactive).
atom(id7,a1,'C').
atom(id7,a2,'C').
atom(id7,a3,'C').
atom(id7,a4,'O').
atom(id7,a5,'C').
atom(id7,a6,'C').
atom(id7,a7,'C').
atom(id7,a8,'C').
atom(id7,a9,'C').
atom(id7,a10,'C').
atom(id7,a11,'C').
atom(id7,a12,'C').
atom(id7,a13,'O').
atom(id7,a14,'C').
atom(id7,a15,'C').
atom(id7,a16,'C').
atom(id7,a17,'C').
atom(id7,a18,'C').
atom(id7,a19,'O').
atom(id7,a20,'C').
atom(id7,a21,'C').
atom(id7,a22,'C').
atom(id7,a23,'C').
atom(id7,a24,'C').
atom(id7,a25,'C').
atom(id7,a26,'C').
atom(id7,a27,'C').
atom(id7,a28,'O').
bond(id7,a2,a1,double).
bond(id7,a3,a2,single).
bond(id7,a4,a3,single).
bond(id7,a5,a4,single).
bond(id7,a6,a5,single).
bond(id7,a7,a6,single).
bond(id7,a8,a7,single).
bond(id7,a9,a6,single).
bond(id7,a10,a9,single).
bond(id7,a11,a10,single).
bond(id7,a12,a11,single).
bond(id7,a13,a3,double).
bond(id7,a14,a2,single).
bond(id7,a15,a14,double).
bond(id7,a16,a15,single).
bond(id7,a17,a16,double).
bond(id7,a17,a1,single).
bond(id7,a18,a1,single).
bond(id7,a19,a18,single).
bond(id7,a20,a19,single).
bond(id7,a21,a20,single).
bond(id7,a22,a21,single).
bond(id7,a23,a22,single).
bond(id7,a24,a21,single).
bond(id7,a25,a24,single).
bond(id7,a26,a25,single).
bond(id7,a27,a26,single).
bond(id7,a28,a18,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 8
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id8,8).
dsstox_filename(id8,nctrer_v1a_232_23oct03).
activity_category_er_rba(id8,active_strong).
cas(id8,'55331-29-8').
chemclass_erb(id8,phytoestrogens_mycoestrogens).
chemcount(id8,'1_of_2').
chemname(id8,'alpha_zearalanol').
chemnote(id8,'stereochem,_2d_replicate_of_beta_form_cas_[42422-68-4]').
er_rba(id8,30.2).
f1_ring(id8,1).
f2_aromatic_ring(id8,1).
f3_phenolic_ring(id8,1).
f4_heteroatom(id8,0).
f5_phenol3nphenyl(id8,0).
f6_other_key_features(id8,0).
formula(id8,c18h26o5).
log_er_rba(id8,1.48).
logp(id8,5.37).
mean_er_rba_chemclass(id8,0.019).
molweight(id8,322.4004).
structureshown(id8,tested_form).
substancetype(id8,defined_organic).
testedform(id8,parent).
smiles(id8,'c1(c2c(cc(cc2cccccc(o)cccc(o1)c)o)o)=o_').
%activity(id8,active).
atom(id8,a1,'C').
atom(id8,a2,'C').
atom(id8,a3,'C').
atom(id8,a4,'C').
atom(id8,a5,'C').
atom(id8,a6,'C').
atom(id8,a7,'C').
atom(id8,a8,'C').
atom(id8,a9,'C').
atom(id8,a10,'C').
atom(id8,a11,'C').
atom(id8,a12,'C').
atom(id8,a13,'C').
atom(id8,a14,'O').
atom(id8,a15,'C').
atom(id8,a16,'C').
atom(id8,a17,'C').
atom(id8,a18,'C').
atom(id8,a19,'O').
atom(id8,a20,'C').
atom(id8,a21,'O').
atom(id8,a22,'O').
atom(id8,a23,'O').
bond(id8,a2,a1,single).
bond(id8,a3,a2,double).
bond(id8,a4,a3,single).
bond(id8,a5,a4,double).
bond(id8,a6,a5,single).
bond(id8,a7,a6,double).
bond(id8,a7,a2,single).
bond(id8,a8,a7,single).
bond(id8,a9,a8,single).
bond(id8,a10,a9,single).
bond(id8,a11,a10,single).
bond(id8,a12,a11,single).
bond(id8,a13,a12,single).
bond(id8,a15,a13,single).
bond(id8,a16,a15,single).
bond(id8,a17,a16,single).
bond(id8,a18,a17,single).
bond(id8,a19,a18,single).
bond(id8,a19,a1,single).
bond(id8,a21,a5,single).
bond(id8,a22,a3,single).
bond(id8,a23,a1,double).
bond(id8,a,a,double).
bond(id8,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 9
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id9,9).
dsstox_filename(id9,nctrer_v1a_232_23oct03).
activity_category_er_rba(id9,inactive).
cas(id9,'117-39-5').
chemclass_erb(id9,phytoestrogens_flavones).
chemcount(id9,'1').
chemname(id9,'quercetin').
chemnote(id9,'unknown').
er_rba(id9,0).
f1_ring(id9,1).
f2_aromatic_ring(id9,1).
f3_phenolic_ring(id9,1).
f4_heteroatom(id9,0).
f5_phenol3nphenyl(id9,1).
f6_other_key_features(id9,0).
formula(id9,c15h10o7).
log_er_rba(id9,-10000).
logp(id9,1.48).
mean_er_rba_chemclass(id9,0.019).
molweight(id9,302.2398).
structureshown(id9,tested_form).
substancetype(id9,defined_organic).
testedform(id9,parent).
smiles(id9,'c1(c(oc2c(c1=o)c(cc(o)c2)o)c1cc(o)c(cc1)o)o_').
%activity(id9,inactive).
atom(id9,a1,'C').
atom(id9,a2,'C').
atom(id9,a3,'O').
atom(id9,a4,'C').
atom(id9,a5,'C').
atom(id9,a6,'C').
atom(id9,a7,'O').
atom(id9,a8,'C').
atom(id9,a9,'C').
atom(id9,a10,'C').
atom(id9,a11,'O').
atom(id9,a12,'C').
atom(id9,a13,'O').
atom(id9,a14,'C').
atom(id9,a15,'C').
atom(id9,a16,'C').
atom(id9,a17,'O').
atom(id9,a18,'C').
atom(id9,a19,'C').
atom(id9,a20,'C').
atom(id9,a21,'O').
atom(id9,a22,'O').
bond(id9,a2,a1,double).
bond(id9,a3,a2,single).
bond(id9,a4,a3,single).
bond(id9,a5,a4,double).
bond(id9,a6,a5,single).
bond(id9,a6,a1,single).
bond(id9,a7,a6,double).
bond(id9,a8,a5,single).
bond(id9,a9,a8,double).
bond(id9,a10,a9,single).
bond(id9,a11,a10,single).
bond(id9,a12,a10,double).
bond(id9,a12,a4,single).
bond(id9,a13,a8,single).
bond(id9,a14,a2,single).
bond(id9,a15,a14,double).
bond(id9,a16,a15,single).
bond(id9,a17,a16,single).
bond(id9,a18,a16,double).
bond(id9,a19,a18,single).
bond(id9,a20,a19,double).
bond(id9,a20,a14,single).
bond(id9,a21,a18,single).
bond(id9,a22,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 10
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id10,10).
dsstox_filename(id10,nctrer_v1a_232_23oct03).
activity_category_er_rba(id10,active_weak).
cas(id10,'528-48-3').
chemclass_erb(id10,phytoestrogens_flavones).
chemcount(id10,'1').
chemname(id10,'fisetin').
chemnote(id10,'unknown').
er_rba(id10,0.00446).
f1_ring(id10,1).
f2_aromatic_ring(id10,1).
f3_phenolic_ring(id10,1).
f4_heteroatom(id10,0).
f5_phenol3nphenyl(id10,1).
f6_other_key_features(id10,0).
formula(id10,c15h10o6).
log_er_rba(id10,-2.35).
logp(id10,1.18).
mean_er_rba_chemclass(id10,0.019).
molweight(id10,286.2404).
structureshown(id10,tested_form).
substancetype(id10,defined_organic).
testedform(id10,parent).
smiles(id10,'c1(c(c(=o)c2c(o1)cc(cc2)o)o)c1cc(o)c(cc1)o_').
%activity(id10,active).
atom(id10,a1,'C').
atom(id10,a2,'C').
atom(id10,a3,'C').
atom(id10,a4,'O').
atom(id10,a5,'C').
atom(id10,a6,'C').
atom(id10,a7,'O').
atom(id10,a8,'C').
atom(id10,a9,'C').
atom(id10,a10,'C').
atom(id10,a11,'C').
atom(id10,a12,'O').
atom(id10,a13,'O').
atom(id10,a14,'C').
atom(id10,a15,'C').
atom(id10,a16,'C').
atom(id10,a17,'O').
atom(id10,a18,'C').
atom(id10,a19,'C').
atom(id10,a20,'C').
atom(id10,a21,'O').
bond(id10,a2,a1,double).
bond(id10,a3,a2,single).
bond(id10,a4,a3,double).
bond(id10,a5,a3,single).
bond(id10,a6,a5,double).
bond(id10,a7,a6,single).
bond(id10,a7,a1,single).
bond(id10,a8,a6,single).
bond(id10,a9,a8,double).
bond(id10,a10,a9,single).
bond(id10,a11,a10,double).
bond(id10,a11,a5,single).
bond(id10,a12,a9,single).
bond(id10,a13,a2,single).
bond(id10,a14,a1,single).
bond(id10,a15,a14,double).
bond(id10,a16,a15,single).
bond(id10,a17,a16,single).
bond(id10,a18,a16,double).
bond(id10,a19,a18,single).
bond(id10,a20,a19,double).
bond(id10,a20,a14,single).
bond(id10,a21,a18,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 11
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id11,11).
dsstox_filename(id11,nctrer_v1a_232_23oct03).
activity_category_er_rba(id11,inactive).
cas(id11,'487-26-3').
chemclass_erb(id11,phytoestrogens_flavanones).
chemcount(id11,'1').
chemname(id11,'flavanone').
chemnote(id11,'unknown').
er_rba(id11,0).
f1_ring(id11,1).
f2_aromatic_ring(id11,1).
f3_phenolic_ring(id11,0).
f4_heteroatom(id11,0).
f5_phenol3nphenyl(id11,0).
f6_other_key_features(id11,0).
formula(id11,c15h12o2).
log_er_rba(id11,-10000).
logp(id11,3.28).
mean_er_rba_chemclass(id11,0.019).
molweight(id11,224.2586).
structureshown(id11,tested_form).
substancetype(id11,defined_organic).
testedform(id11,parent).
smiles(id11,'o1c2c(cccc2)c(cc1c1ccccc1)=o_').
%activity(id11,inactive).
atom(id11,a1,'O').
atom(id11,a2,'C').
atom(id11,a3,'C').
atom(id11,a4,'C').
atom(id11,a5,'C').
atom(id11,a6,'C').
atom(id11,a7,'C').
atom(id11,a8,'C').
atom(id11,a9,'C').
atom(id11,a10,'C').
atom(id11,a11,'C').
atom(id11,a12,'C').
atom(id11,a13,'C').
atom(id11,a14,'C').
atom(id11,a15,'C').
atom(id11,a16,'C').
atom(id11,a17,'O').
bond(id11,a2,a1,single).
bond(id11,a3,a2,double).
bond(id11,a4,a3,single).
bond(id11,a5,a4,double).
bond(id11,a6,a5,single).
bond(id11,a7,a6,double).
bond(id11,a7,a2,single).
bond(id11,a8,a3,single).
bond(id11,a9,a8,single).
bond(id11,a10,a9,single).
bond(id11,a10,a1,single).
bond(id11,a10,a11,single).
bond(id11,a12,a11,single).
bond(id11,a13,a12,double).
bond(id11,a14,a13,single).
bond(id11,a15,a14,double).
bond(id11,a16,a15,single).
bond(id11,a16,a11,double).
bond(id11,a17,a8,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 12
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id12,12).
dsstox_filename(id12,nctrer_v1a_232_23oct03).
activity_category_er_rba(id12,inactive).
cas(id12,'520-33-2').
chemclass_erb(id12,phytoestrogens_flavanones).
chemcount(id12,'1').
chemname(id12,'hesperetin').
chemnote(id12,'unknown').
er_rba(id12,0).
f1_ring(id12,1).
f2_aromatic_ring(id12,1).
f3_phenolic_ring(id12,1).
f4_heteroatom(id12,0).
f5_phenol3nphenyl(id12,1).
f6_other_key_features(id12,0).
formula(id12,c16h14o6).
log_er_rba(id12,-10000).
logp(id12,2.44).
mean_er_rba_chemclass(id12,0.019).
molweight(id12,302.283).
structureshown(id12,tested_form).
substancetype(id12,defined_organic).
testedform(id12,parent).
smiles(id12,'c12c(cc(oc1cc(cc2o)o)c1cc(o)c(cc1)oc)=o_').
%activity(id12,inactive).
atom(id12,a1,'C').
atom(id12,a2,'C').
atom(id12,a3,'C').
atom(id12,a4,'C').
atom(id12,a5,'O').
atom(id12,a6,'C').
atom(id12,a7,'C').
atom(id12,a8,'C').
atom(id12,a9,'C').
atom(id12,a10,'C').
atom(id12,a11,'O').
atom(id12,a12,'O').
atom(id12,a13,'C').
atom(id12,a14,'C').
atom(id12,a15,'C').
atom(id12,a16,'O').
atom(id12,a17,'C').
atom(id12,a18,'C').
atom(id12,a19,'C').
atom(id12,a20,'O').
atom(id12,a21,'C').
atom(id12,a22,'O').
bond(id12,a2,a1,single).
bond(id12,a3,a2,single).
bond(id12,a4,a3,single).
bond(id12,a5,a4,single).
bond(id12,a6,a5,single).
bond(id12,a6,a1,double).
bond(id12,a7,a6,single).
bond(id12,a8,a7,double).
bond(id12,a9,a8,single).
bond(id12,a10,a9,double).
bond(id12,a10,a1,single).
bond(id12,a11,a10,single).
bond(id12,a12,a8,single).
bond(id12,a4,a13,single).
bond(id12,a14,a13,double).
bond(id12,a15,a14,single).
bond(id12,a16,a15,single).
bond(id12,a17,a15,double).
bond(id12,a18,a17,single).
bond(id12,a19,a18,double).
bond(id12,a19,a13,single).
bond(id12,a20,a17,single).
bond(id12,a21,a20,single).
bond(id12,a22,a2,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 13
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id13,13).
dsstox_filename(id13,nctrer_v1a_232_23oct03).
activity_category_er_rba(id13,active_weak).
cas(id13,'58-72-0').
chemclass_erb(id13,des_triphenylethylenes).
chemcount(id13,'1').
chemname(id13,'triphenylethylene').
chemnote(id13,'no_phenolic_ring').
er_rba(id13,0.00165).
f1_ring(id13,1).
f2_aromatic_ring(id13,1).
f3_phenolic_ring(id13,0).
f4_heteroatom(id13,0).
f5_phenol3nphenyl(id13,0).
f6_other_key_features(id13,1).
formula(id13,c20h16).
log_er_rba(id13,-2.78).
logp(id13,5.49).
mean_er_rba_chemclass(id13,2.14).
molweight(id13,256.3464).
structureshown(id13,tested_form).
substancetype(id13,defined_organic).
testedform(id13,parent).
smiles(id13,'c(=cc1ccccc1)(c1ccccc1)c1ccccc1_').
%activity(id13,active).
atom(id13,a1,'C').
atom(id13,a2,'C').
atom(id13,a3,'C').
atom(id13,a4,'C').
atom(id13,a5,'C').
atom(id13,a6,'C').
atom(id13,a7,'C').
atom(id13,a8,'C').
atom(id13,a9,'C').
atom(id13,a10,'C').
atom(id13,a11,'C').
atom(id13,a12,'C').
atom(id13,a13,'C').
atom(id13,a14,'C').
atom(id13,a15,'C').
atom(id13,a16,'C').
atom(id13,a17,'C').
atom(id13,a18,'C').
atom(id13,a19,'C').
atom(id13,a20,'C').
bond(id13,a2,a1,double).
bond(id13,a3,a2,single).
bond(id13,a4,a3,double).
bond(id13,a5,a4,single).
bond(id13,a6,a5,double).
bond(id13,a7,a6,single).
bond(id13,a8,a7,double).
bond(id13,a8,a3,single).
bond(id13,a9,a1,single).
bond(id13,a10,a9,double).
bond(id13,a11,a10,single).
bond(id13,a12,a11,double).
bond(id13,a13,a12,single).
bond(id13,a14,a13,double).
bond(id13,a14,a9,single).
bond(id13,a15,a1,single).
bond(id13,a16,a15,double).
bond(id13,a17,a16,single).
bond(id13,a18,a17,double).
bond(id13,a19,a18,single).
bond(id13,a20,a19,double).
bond(id13,a20,a15,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 14
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id14,14).
dsstox_filename(id14,nctrer_v1a_232_23oct03).
activity_category_er_rba(id14,inactive).
cas(id14,'101-61-1').
chemclass_erb(id14,misc).
chemcount(id14,'1').
chemname(id14,'4,4_-methylenebis(n,n-dimethylaniline)').
chemnote(id14,'unknown').
er_rba(id14,0).
f1_ring(id14,1).
f2_aromatic_ring(id14,1).
f3_phenolic_ring(id14,0).
f4_heteroatom(id14,0).
f5_phenol3nphenyl(id14,1).
f6_other_key_features(id14,0).
formula(id14,c17h22n2).
log_er_rba(id14,-10000).
logp(id14,4.37).
mean_er_rba_chemclass(id14,na).
molweight(id14,254.3742).
structureshown(id14,tested_form).
substancetype(id14,defined_organic).
testedform(id14,parent).
smiles(id14,'c1(n(c)c)ccc(cc1)cc1ccc(cc1)n(c)c_').
%activity(id14,inactive).
atom(id14,a1,'C').
atom(id14,a2,'N').
atom(id14,a3,'C').
atom(id14,a4,'C').
atom(id14,a5,'C').
atom(id14,a6,'C').
atom(id14,a7,'C').
atom(id14,a8,'C').
atom(id14,a9,'C').
atom(id14,a10,'C').
atom(id14,a11,'C').
atom(id14,a12,'C').
atom(id14,a13,'C').
atom(id14,a14,'C').
atom(id14,a15,'C').
atom(id14,a16,'C').
atom(id14,a17,'N').
atom(id14,a18,'C').
atom(id14,a19,'C').
bond(id14,a2,a1,single).
bond(id14,a3,a2,single).
bond(id14,a4,a2,single).
bond(id14,a5,a1,double).
bond(id14,a6,a5,single).
bond(id14,a7,a6,double).
bond(id14,a8,a7,single).
bond(id14,a9,a8,double).
bond(id14,a9,a1,single).
bond(id14,a10,a7,single).
bond(id14,a11,a10,single).
bond(id14,a12,a11,double).
bond(id14,a13,a12,single).
bond(id14,a14,a13,double).
bond(id14,a15,a14,single).
bond(id14,a16,a15,double).
bond(id14,a16,a11,single).
bond(id14,a17,a14,single).
bond(id14,a18,a17,single).
bond(id14,a19,a17,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 15
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id15,15).
dsstox_filename(id15,nctrer_v1a_232_23oct03).
activity_category_er_rba(id15,inactive).
cas(id15,'154-23-4').
chemclass_erb(id15,phytoestrogens_flavanones).
chemcount(id15,'1').
chemname(id15,'catechin').
chemnote(id15,'racemic_mixture').
er_rba(id15,0).
f1_ring(id15,1).
f2_aromatic_ring(id15,1).
f3_phenolic_ring(id15,1).
f4_heteroatom(id15,0).
f5_phenol3nphenyl(id15,1).
f6_other_key_features(id15,0).
formula(id15,c15h14o6).
log_er_rba(id15,-10000).
logp(id15,1.18).
mean_er_rba_chemclass(id15,0.019).
molweight(id15,290.272).
structureshown(id15,tested_form).
substancetype(id15,defined_organic).
testedform(id15,parent).
smiles(id15,'o1c2c(c(o)cc(c2)o)cc(c1c1cc(o)c(cc1)o)o_').
%activity(id15,inactive).
atom(id15,a1,'O').
atom(id15,a2,'C').
atom(id15,a3,'C').
atom(id15,a4,'C').
atom(id15,a5,'O').
atom(id15,a6,'C').
atom(id15,a7,'C').
atom(id15,a8,'C').
atom(id15,a9,'O').
atom(id15,a10,'C').
atom(id15,a11,'C').
atom(id15,a12,'C').
atom(id15,a13,'C').
atom(id15,a14,'C').
atom(id15,a15,'C').
atom(id15,a16,'O').
atom(id15,a17,'C').
atom(id15,a18,'C').
atom(id15,a19,'C').
atom(id15,a20,'O').
atom(id15,a21,'O').
bond(id15,a2,a1,single).
bond(id15,a3,a2,double).
bond(id15,a4,a3,single).
bond(id15,a5,a4,single).
bond(id15,a6,a4,double).
bond(id15,a7,a6,single).
bond(id15,a8,a7,double).
bond(id15,a8,a2,single).
bond(id15,a9,a7,single).
bond(id15,a10,a3,single).
bond(id15,a11,a10,single).
bond(id15,a12,a11,single).
bond(id15,a12,a1,single).
bond(id15,a12,a13,single).
bond(id15,a14,a13,single).
bond(id15,a15,a14,double).
bond(id15,a16,a15,single).
bond(id15,a17,a15,single).
bond(id15,a18,a17,double).
bond(id15,a19,a18,single).
bond(id15,a19,a13,double).
bond(id15,a20,a17,single).
bond(id15,a11,a21,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 16
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id16,16).
dsstox_filename(id16,nctrer_v1a_232_23oct03).
activity_category_er_rba(id16,inactive).
cas(id16,'525-82-6').
chemclass_erb(id16,phytoestrogens_flavones).
chemcount(id16,'1').
chemname(id16,'flavone').
chemnote(id16,'unknown').
er_rba(id16,0).
f1_ring(id16,1).
f2_aromatic_ring(id16,1).
f3_phenolic_ring(id16,0).
f4_heteroatom(id16,0).
f5_phenol3nphenyl(id16,0).
f6_other_key_features(id16,0).
formula(id16,c15h10o2).
log_er_rba(id16,-10000).
logp(id16,3.51).
mean_er_rba_chemclass(id16,0.019).
molweight(id16,222.2428).
structureshown(id16,tested_form).
substancetype(id16,defined_organic).
testedform(id16,parent).
smiles(id16,'c1(cc(=o)c2c(o1)cccc2)c1ccccc1_').
%activity(id16,inactive).
atom(id16,a1,'C').
atom(id16,a2,'C').
atom(id16,a3,'O').
atom(id16,a4,'C').
atom(id16,a5,'C').
atom(id16,a6,'C').
atom(id16,a7,'C').
atom(id16,a8,'O').
atom(id16,a9,'C').
atom(id16,a10,'C').
atom(id16,a11,'C').
atom(id16,a12,'C').
atom(id16,a13,'C').
atom(id16,a14,'C').
atom(id16,a15,'C').
atom(id16,a16,'C').
atom(id16,a17,'C').
bond(id16,a0,a0,double).
bond(id16,a0,a0,double).
bond(id16,a0,a0,double).
bond(id16,a0,a0,double).
bond(id16,a0,a0,double).
bond(id16,a2,a1,double).
bond(id16,a3,a1,single).
bond(id16,a4,a2,single).
bond(id16,a5,a6,single).
bond(id16,a6,a3,single).
bond(id16,a7,a1,single).
bond(id16,a8,a4,double).
bond(id16,a9,a5,double).
bond(id16,a10,a6,double).
bond(id16,a11,a7,single).
bond(id16,a12,a7,double).
bond(id16,a13,a14,double).
bond(id16,a14,a10,single).
bond(id16,a15,a12,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 17
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id17,17).
dsstox_filename(id17,nctrer_v1a_232_23oct03).
activity_category_er_rba(id17,inactive).
cas(id17,'529-59-9').
chemclass_erb(id17,phytoestrogens_isoflavones).
chemcount(id17,'1').
chemname(id17,'genistin').
chemnote(id17,'unknown').
er_rba(id17,0).
f1_ring(id17,1).
f2_aromatic_ring(id17,1).
f3_phenolic_ring(id17,1).
f4_heteroatom(id17,0).
f5_phenol3nphenyl(id17,1).
f6_other_key_features(id17,0).
formula(id17,c21h20o10).
log_er_rba(id17,-10000).
logp(id17,0.83).
mean_er_rba_chemclass(id17,0.019).
molweight(id17,432.383).
structureshown(id17,tested_form).
substancetype(id17,defined_organic).
testedform(id17,parent).
smiles(id17,'c12c(c(c(co1)c1ccc(cc1)o)=o)c(cc(c2)oc1oc(c(c(c1o)o)o)co)o_').
%activity(id17,inactive).
atom(id17,a1,'C').
atom(id17,a2,'C').
atom(id17,a3,'C').
atom(id17,a4,'C').
atom(id17,a5,'C').
atom(id17,a6,'O').
atom(id17,a7,'C').
atom(id17,a8,'C').
atom(id17,a9,'C').
atom(id17,a10,'C').
atom(id17,a11,'C').
atom(id17,a12,'C').
atom(id17,a13,'O').
atom(id17,a14,'O').
atom(id17,a15,'C').
atom(id17,a16,'C').
atom(id17,a17,'C').
atom(id17,a18,'C').
atom(id17,a19,'O').
atom(id17,a20,'C').
atom(id17,a21,'O').
atom(id17,a22,'C').
atom(id17,a23,'C').
atom(id17,a24,'C').
atom(id17,a25,'C').
atom(id17,a26,'O').
atom(id17,a27,'O').
atom(id17,a28,'O').
atom(id17,a29,'C').
atom(id17,a30,'O').
atom(id17,a31,'O').
bond(id17,a2,a1,single).
bond(id17,a3,a2,single).
bond(id17,a4,a3,single).
bond(id17,a5,a4,double).
bond(id17,a6,a5,single).
bond(id17,a6,a1,single).
bond(id17,a7,a4,single).
bond(id17,a8,a7,double).
bond(id17,a9,a8,single).
bond(id17,a10,a9,double).
bond(id17,a11,a10,single).
bond(id17,a12,a11,double).
bond(id17,a12,a7,single).
bond(id17,a13,a10,single).
bond(id17,a14,a3,double).
bond(id17,a15,a2,double).
bond(id17,a16,a15,single).
bond(id17,a17,a16,double).
bond(id17,a18,a17,single).
bond(id17,a18,a1,double).
bond(id17,a19,a17,single).
bond(id17,a20,a19,single).
bond(id17,a21,a20,single).
bond(id17,a22,a21,single).
bond(id17,a23,a22,single).
bond(id17,a24,a23,single).
bond(id17,a25,a24,single).
bond(id17,a25,a20,single).
bond(id17,a26,a25,single).
bond(id17,a27,a24,single).
bond(id17,a28,a23,single).
bond(id17,a29,a22,single).
bond(id17,a30,a29,single).
bond(id17,a31,a15,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 18
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id18,18).
dsstox_filename(id18,nctrer_v1a_232_23oct03).
activity_category_er_rba(id18,active_medium).
cas(id18,'2971-36-0').
chemclass_erb(id18,diphenylmethanes_ddts).
chemcount(id18,'1').
chemname(id18,'hpte').
chemnote(id18,'unknown').
er_rba(id18,0.2512).
f1_ring(id18,1).
f2_aromatic_ring(id18,1).
f3_phenolic_ring(id18,1).
f4_heteroatom(id18,0).
f5_phenol3nphenyl(id18,1).
f6_other_key_features(id18,0).
formula(id18,c14h11cl3o2).
log_er_rba(id18,-0.6).
logp(id18,4.55).
mean_er_rba_chemclass(id18,0.0087).
molweight(id18,317.5987).
structureshown(id18,tested_form).
substancetype(id18,defined_organic).
testedform(id18,parent).
smiles(id18,'c(c(c1ccc(cc1)o)c1ccc(cc1)o)(cl)(cl)cl_').
%activity(id18,active).
atom(id18,a1,'C').
atom(id18,a2,'C').
atom(id18,a3,'C').
atom(id18,a4,'C').
atom(id18,a5,'C').
atom(id18,a6,'C').
atom(id18,a7,'C').
atom(id18,a8,'C').
atom(id18,a9,'O').
atom(id18,a10,'C').
atom(id18,a11,'C').
atom(id18,a12,'C').
atom(id18,a13,'C').
atom(id18,a14,'C').
atom(id18,a15,'C').
atom(id18,a16,'O').
atom(id18,a17,'Cl').
atom(id18,a18,'Cl').
atom(id18,a19,'Cl').
bond(id18,a2,a1,single).
bond(id18,a3,a2,single).
bond(id18,a4,a3,single).
bond(id18,a5,a4,double).
bond(id18,a6,a5,single).
bond(id18,a7,a6,double).
bond(id18,a8,a7,single).
bond(id18,a8,a3,double).
bond(id18,a9,a6,single).
bond(id18,a10,a2,single).
bond(id18,a11,a10,single).
bond(id18,a12,a11,double).
bond(id18,a13,a12,single).
bond(id18,a14,a13,double).
bond(id18,a15,a14,single).
bond(id18,a15,a10,double).
bond(id18,a16,a13,single).
bond(id18,a17,a1,single).
bond(id18,a18,a1,single).
bond(id18,a19,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 19
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id19,19).
dsstox_filename(id19,nctrer_v1a_232_23oct03).
activity_category_er_rba(id19,active_weak).
cas(id19,'153-18-4').
chemclass_erb(id19,phytoestrogens_flavones).
chemcount(id19,'1').
chemname(id19,'rutin').
chemnote(id19,'stereochem').
er_rba(id19,8.0E-005).
f1_ring(id19,1).
f2_aromatic_ring(id19,1).
f3_phenolic_ring(id19,1).
f4_heteroatom(id19,0).
f5_phenol3nphenyl(id19,1).
f6_other_key_features(id19,0).
formula(id19,c27h30o16).
log_er_rba(id19,-4.09).
logp(id19,-1.11).
mean_er_rba_chemclass(id19,0.019).
molweight(id19,610.5244).
structureshown(id19,tested_form).
substancetype(id19,defined_organic).
testedform(id19,parent).
smiles(id19,'c1(c(oc2c(c1=o)c(cc(c2)o)o)c1cc(o)c(cc1)o)oc1oc(c(c(c1o)o)o)coc1c(c(c(c(o1)c)o)o)o_').
%activity(id19,active).
atom(id19,a1,'C').
atom(id19,a2,'C').
atom(id19,a3,'O').
atom(id19,a4,'C').
atom(id19,a5,'C').
atom(id19,a6,'C').
atom(id19,a7,'O').
atom(id19,a8,'C').
atom(id19,a9,'C').
atom(id19,a10,'C').
atom(id19,a11,'C').
atom(id19,a12,'O').
atom(id19,a13,'O').
atom(id19,a14,'C').
atom(id19,a15,'C').
atom(id19,a16,'C').
atom(id19,a17,'O').
atom(id19,a18,'C').
atom(id19,a19,'C').
atom(id19,a20,'C').
atom(id19,a21,'O').
atom(id19,a22,'O').
atom(id19,a23,'C').
atom(id19,a24,'O').
atom(id19,a25,'C').
atom(id19,a26,'C').
atom(id19,a27,'C').
atom(id19,a28,'C').
atom(id19,a29,'O').
atom(id19,a30,'O').
atom(id19,a31,'O').
atom(id19,a32,'C').
atom(id19,a33,'O').
atom(id19,a34,'C').
atom(id19,a35,'C').
atom(id19,a36,'C').
atom(id19,a37,'C').
atom(id19,a38,'C').
atom(id19,a39,'O').
atom(id19,a40,'C').
atom(id19,a41,'O').
atom(id19,a42,'O').
atom(id19,a43,'O').
bond(id19,a2,a1,double).
bond(id19,a3,a2,single).
bond(id19,a4,a3,single).
bond(id19,a5,a4,double).
bond(id19,a6,a5,single).
bond(id19,a6,a1,single).
bond(id19,a7,a6,double).
bond(id19,a8,a5,single).
bond(id19,a9,a8,double).
bond(id19,a10,a9,single).
bond(id19,a11,a10,double).
bond(id19,a11,a4,single).
bond(id19,a12,a10,single).
bond(id19,a13,a8,single).
bond(id19,a14,a2,single).
bond(id19,a15,a14,double).
bond(id19,a16,a15,single).
bond(id19,a17,a16,single).
bond(id19,a18,a16,double).
bond(id19,a19,a18,single).
bond(id19,a20,a19,double).
bond(id19,a20,a14,single).
bond(id19,a21,a18,single).
bond(id19,a22,a1,single).
bond(id19,a24,a23,single).
bond(id19,a25,a24,single).
bond(id19,a26,a25,single).
bond(id19,a27,a26,single).
bond(id19,a28,a27,single).
bond(id19,a28,a23,single).
bond(id19,a33,a32,single).
bond(id19,a35,a34,single).
bond(id19,a36,a35,single).
bond(id19,a37,a36,single).
bond(id19,a38,a37,single).
bond(id19,a39,a38,single).
bond(id19,a39,a34,single).
bond(id19,a,a,double).
bond(id19,a,a,double).
bond(id19,a,a,double).
bond(id19,a,a,double).
bond(id19,a,a,double).
bond(id19,a,a,double).
bond(id19,a,a,double).
bond(id19,a,a,double).
bond(id19,a,a,double).
bond(id19,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 20
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id20,20).
dsstox_filename(id20,nctrer_v1a_232_23oct03).
activity_category_er_rba(id20,active_weak).
cas(id20,'6665-83-4').
chemclass_erb(id20,phytoestrogens_flavones).
chemcount(id20,'1').
chemname(id20,'6-hydroxyflavone').
chemnote(id20,'unknown').
er_rba(id20,0.00038).
f1_ring(id20,1).
f2_aromatic_ring(id20,1).
f3_phenolic_ring(id20,1).
f4_heteroatom(id20,0).
f5_phenol3nphenyl(id20,1).
f6_other_key_features(id20,0).
formula(id20,c15h10o3).
log_er_rba(id20,-3.41).
logp(id20,3.03).
mean_er_rba_chemclass(id20,0.019).
molweight(id20,238.2422).
structureshown(id20,tested_form).
substancetype(id20,defined_organic).
testedform(id20,parent).
smiles(id20,'c1(cc(=o)c2c(o1)ccc(o)c2)c1ccccc1_').
%activity(id20,active).
atom(id20,a1,'C').
atom(id20,a2,'C').
atom(id20,a3,'C').
atom(id20,a4,'C').
atom(id20,a5,'O').
atom(id20,a6,'C').
atom(id20,a7,'C').
atom(id20,a8,'C').
atom(id20,a9,'O').
atom(id20,a10,'C').
atom(id20,a11,'C').
atom(id20,a12,'C').
atom(id20,a13,'O').
atom(id20,a14,'C').
atom(id20,a15,'C').
atom(id20,a16,'C').
atom(id20,a17,'C').
atom(id20,a18,'C').
bond(id20,a0,a0,double).
bond(id20,a0,a0,double).
bond(id20,a0,a0,double).
bond(id20,a0,a0,double).
bond(id20,a0,a0,double).
bond(id20,a0,a0,double).
bond(id20,a2,a1,double).
bond(id20,a3,a6,single).
bond(id20,a4,a2,single).
bond(id20,a5,a1,single).
bond(id20,a6,a5,single).
bond(id20,a7,a3,double).
bond(id20,a8,a1,single).
bond(id20,a9,a4,double).
bond(id20,a10,a6,double).
bond(id20,a11,a12,double).
bond(id20,a12,a10,single).
bond(id20,a13,a11,single).
bond(id20,a14,a8,double).
bond(id20,a15,a8,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 21
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id21,21).
dsstox_filename(id21,nctrer_v1a_232_23oct03).
activity_category_er_rba(id21,inactive).
cas(id21,'6665-86-7').
chemclass_erb(id21,phytoestrogens_flavones).
chemcount(id21,'1').
chemname(id21,'7-hydroxyflavone').
chemnote(id21,'unknown').
er_rba(id21,0).
f1_ring(id21,1).
f2_aromatic_ring(id21,1).
f3_phenolic_ring(id21,1).
f4_heteroatom(id21,0).
f5_phenol3nphenyl(id21,1).
f6_other_key_features(id21,0).
formula(id21,c15h10o3).
log_er_rba(id21,-10000).
logp(id21,3.03).
mean_er_rba_chemclass(id21,0.019).
molweight(id21,238.2422).
structureshown(id21,tested_form).
substancetype(id21,defined_organic).
testedform(id21,parent).
smiles(id21,'c1(cc(=o)c2c(o1)cc(cc2)o)c1ccccc1_').
%activity(id21,inactive).
atom(id21,a1,'C').
atom(id21,a2,'C').
atom(id21,a3,'C').
atom(id21,a4,'O').
atom(id21,a5,'C').
atom(id21,a6,'C').
atom(id21,a7,'C').
atom(id21,a8,'C').
atom(id21,a9,'C').
atom(id21,a10,'O').
atom(id21,a11,'C').
atom(id21,a12,'C').
atom(id21,a13,'O').
atom(id21,a14,'C').
atom(id21,a15,'C').
atom(id21,a16,'C').
atom(id21,a17,'C').
atom(id21,a18,'C').
bond(id21,a0,a0,double).
bond(id21,a0,a0,double).
bond(id21,a0,a0,double).
bond(id21,a0,a0,double).
bond(id21,a0,a0,double).
bond(id21,a0,a0,double).
bond(id21,a2,a1,double).
bond(id21,a3,a4,single).
bond(id21,a4,a1,single).
bond(id21,a5,a2,single).
bond(id21,a6,a3,single).
bond(id21,a7,a3,double).
bond(id21,a8,a6,double).
bond(id21,a9,a1,single).
bond(id21,a10,a5,double).
bond(id21,a11,a7,single).
bond(id21,a12,a11,double).
bond(id21,a13,a11,single).
bond(id21,a14,a9,double).
bond(id21,a15,a9,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 22
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id22,22).
dsstox_filename(id22,nctrer_v1a_232_23oct03).
activity_category_er_rba(id22,inactive).
cas(id22,'481-30-1').
chemclass_erb(id22,steroids_without_aromatic_a_ring).
chemcount(id22,'1_of_2').
chemname(id22,'alpha_epitestosterone').
chemnote(id22,'stereochem,_2d_replicate_of_beta_form_cas_[58-22-0]').
er_rba(id22,0).
f1_ring(id22,1).
f2_aromatic_ring(id22,0).
f3_phenolic_ring(id22,0).
f4_heteroatom(id22,1).
f5_phenol3nphenyl(id22,0).
f6_other_key_features(id22,1).
formula(id22,c19h28o2).
log_er_rba(id22,-10000).
logp(id22,3.27).
mean_er_rba_chemclass(id22,1.24).
molweight(id22,288.429).
structureshown(id22,tested_form).
substancetype(id22,defined_organic).
testedform(id22,parent).
smiles(id22,'c1c2c3c(ccc2c2(c(c1)=cc(cc2)=o)c)(c(cc3)o)c_').
%activity(id22,inactive).
atom(id22,a1,'C').
atom(id22,a2,'C').
atom(id22,a3,'C').
atom(id22,a4,'C').
atom(id22,a5,'C').
atom(id22,a6,'C').
atom(id22,a7,'C').
atom(id22,a8,'C').
atom(id22,a9,'C').
atom(id22,a10,'C').
atom(id22,a11,'C').
atom(id22,a12,'C').
atom(id22,a13,'C').
atom(id22,a14,'O').
atom(id22,a15,'C').
atom(id22,a16,'C').
atom(id22,a17,'C').
atom(id22,a18,'C').
atom(id22,a19,'O').
atom(id22,a20,'C').
atom(id22,a21,'H').
atom(id22,a22,'H').
atom(id22,a23,'H').
atom(id22,a24,'C').
bond(id22,a1,a2,single).
bond(id22,a2,a3,single).
bond(id22,a3,a4,single).
bond(id22,a4,a5,single).
bond(id22,a5,a6,single).
bond(id22,a6,a7,single).
bond(id22,a7,a8,single).
bond(id22,a8,a9,single).
bond(id22,a9,a10,single).
bond(id22,a1,a10,single).
bond(id22,a3,a8,single).
bond(id22,a7,a11,single).
bond(id22,a11,a12,single).
bond(id22,a12,a13,single).
bond(id22,a13,a14,double).
bond(id22,a13,a15,single).
bond(id22,a6,a15,double).
bond(id22,a2,a16,single).
bond(id22,a16,a17,single).
bond(id22,a17,a18,single).
bond(id22,a1,a18,single).
bond(id22,a,a,double).
bond(id22,a,a,double).
bond(id22,a,a,double).
bond(id22,a,a,double).
bond(id22,a,a,double).
bond(id22,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 23
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id23,23).
dsstox_filename(id23,nctrer_v1a_232_23oct03).
activity_category_er_rba(id23,inactive).
cas(id23,'309-00-2').
chemclass_erb(id23,misc).
chemcount(id23,'1').
chemname(id23,'aldrin').
chemnote(id23,'stereochem').
er_rba(id23,0).
f1_ring(id23,1).
f2_aromatic_ring(id23,0).
f3_phenolic_ring(id23,0).
f4_heteroatom(id23,0).
f5_phenol3nphenyl(id23,0).
f6_other_key_features(id23,0).
formula(id23,c12h8cl6).
log_er_rba(id23,-10000).
logp(id23,6.75).
mean_er_rba_chemclass(id23,na).
molweight(id23,364.9132).
structureshown(id23,tested_form).
substancetype(id23,defined_organic).
testedform(id23,parent).
smiles(id23,'c1(c2(c3c(c4c=cc3c4)c1(cl)c(=c2cl)cl)cl)(cl)cl_').
%activity(id23,inactive).
atom(id23,a1,'C').
atom(id23,a2,'C').
atom(id23,a3,'C').
atom(id23,a4,'C').
atom(id23,a5,'Cl').
atom(id23,a6,'C').
atom(id23,a7,'C').
atom(id23,a8,'C').
atom(id23,a9,'Cl').
atom(id23,a10,'Cl').
atom(id23,a11,'C').
atom(id23,a12,'Cl').
atom(id23,a13,'C').
atom(id23,a14,'C').
atom(id23,a15,'C').
atom(id23,a16,'Cl').
atom(id23,a17,'Cl').
atom(id23,a18,'C').
atom(id23,a19,'H').
atom(id23,a20,'H').
atom(id23,a21,'H').
atom(id23,a22,'H').
bond(id23,a1,a2,single).
bond(id23,a1,a3,single).
bond(id23,a1,a4,single).
bond(id23,a2,a6,single).
bond(id23,a2,a7,single).
bond(id23,a3,a8,single).
bond(id23,a3,a9,single).
bond(id23,a3,a10,single).
bond(id23,a4,a11,double).
bond(id23,a4,a12,single).
bond(id23,a6,a13,single).
bond(id23,a6,a8,single).
bond(id23,a7,a14,single).
bond(id23,a7,a15,single).
bond(id23,a8,a11,single).
bond(id23,a11,a17,single).
bond(id23,a13,a18,single).
bond(id23,a13,a14,single).
bond(id23,a15,a18,double).
bond(id23,a,a,double).
bond(id23,a,a,double).
bond(id23,a,a,double).
bond(id23,a,a,double).
bond(id23,a,a,double).
bond(id23,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 24
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id24,24).
dsstox_filename(id24,nctrer_v1a_232_23oct03).
activity_category_er_rba(id24,active_weak).
cas(id24,'89-72-5').
chemclass_erb(id24,phenols_alkyl).
chemcount(id24,'1').
chemname(id24,'2-sec-butylphenol').
chemnote(id24,'unknown').
er_rba(id24,0.00028).
f1_ring(id24,1).
f2_aromatic_ring(id24,1).
f3_phenolic_ring(id24,1).
f4_heteroatom(id24,0).
f5_phenol3nphenyl(id24,0).
f6_other_key_features(id24,0).
formula(id24,c10h14o).
log_er_rba(id24,-3.54).
logp(id24,3.46).
mean_er_rba_chemclass(id24,0.00088).
molweight(id24,150.22).
structureshown(id24,tested_form).
substancetype(id24,defined_organic).
testedform(id24,parent).
smiles(id24,'c1(c(o)cccc1)c(cc)c_').
%activity(id24,active).
atom(id24,a1,'C').
atom(id24,a2,'C').
atom(id24,a3,'C').
atom(id24,a4,'O').
atom(id24,a5,'C').
atom(id24,a6,'C').
atom(id24,a7,'C').
atom(id24,a8,'C').
atom(id24,a9,'C').
atom(id24,a10,'C').
atom(id24,a11,'C').
bond(id24,a2,a1,double).
bond(id24,a3,a1,single).
bond(id24,a4,a2,single).
bond(id24,a5,a1,single).
bond(id24,a6,a2,single).
bond(id24,a7,a3,single).
bond(id24,a8,a3,single).
bond(id24,a9,a7,single).
bond(id24,a10,a5,double).
bond(id24,a11,a10,single).
bond(id24,a6,a11,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 25
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id25,25).
dsstox_filename(id25,nctrer_v1a_232_23oct03).
activity_category_er_rba(id25,active_weak).
cas(id25,'99-71-8').
chemclass_erb(id25,phenols_alkyl).
chemcount(id25,'1').
chemname(id25,'4-sec-butylphenol').
chemnote(id25,'unknown').
er_rba(id25,0.00042).
f1_ring(id25,1).
f2_aromatic_ring(id25,1).
f3_phenolic_ring(id25,1).
f4_heteroatom(id25,0).
f5_phenol3nphenyl(id25,0).
f6_other_key_features(id25,0).
formula(id25,c10h14o).
log_er_rba(id25,-3.37).
logp(id25,3.46).
mean_er_rba_chemclass(id25,0.00088).
molweight(id25,150.22).
structureshown(id25,tested_form).
substancetype(id25,defined_organic).
testedform(id25,parent).
smiles(id25,'c1(ccc(cc1)o)c(cc)c_').
%activity(id25,active).
atom(id25,a1,'C').
atom(id25,a2,'C').
atom(id25,a3,'C').
atom(id25,a4,'C').
atom(id25,a5,'C').
atom(id25,a6,'C').
atom(id25,a7,'C').
atom(id25,a8,'O').
atom(id25,a9,'C').
atom(id25,a10,'C').
atom(id25,a11,'C').
bond(id25,a2,a1,double).
bond(id25,a3,a1,single).
bond(id25,a4,a7,single).
bond(id25,a5,a1,single).
bond(id25,a6,a2,single).
bond(id25,a7,a3,double).
bond(id25,a8,a4,single).
bond(id25,a9,a5,single).
bond(id25,a10,a5,single).
bond(id25,a11,a9,single).
bond(id25,a4,a6,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 26
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id26,26).
dsstox_filename(id26,nctrer_v1a_232_23oct03).
activity_category_er_rba(id26,inactive).
cas(id26,'135-98-8').
chemclass_erb(id26,misc).
chemcount(id26,'1').
chemname(id26,'sec-butylbenzene').
chemnote(id26,'unknown').
er_rba(id26,0).
f1_ring(id26,1).
f2_aromatic_ring(id26,1).
f3_phenolic_ring(id26,0).
f4_heteroatom(id26,0).
f5_phenol3nphenyl(id26,0).
f6_other_key_features(id26,0).
formula(id26,c10h14).
log_er_rba(id26,-10000).
logp(id26,3.94).
mean_er_rba_chemclass(id26,na).
molweight(id26,134.2206).
structureshown(id26,tested_form).
substancetype(id26,defined_organic).
testedform(id26,parent).
smiles(id26,'c1(c(cc)c)ccccc1_').
%activity(id26,inactive).
atom(id26,a1,'C').
atom(id26,a2,'C').
atom(id26,a3,'C').
atom(id26,a4,'C').
atom(id26,a5,'C').
atom(id26,a6,'C').
atom(id26,a7,'C').
atom(id26,a8,'C').
atom(id26,a9,'C').
atom(id26,a10,'C').
bond(id26,a2,a1,single).
bond(id26,a3,a1,double).
bond(id26,a4,a1,single).
bond(id26,a5,a2,single).
bond(id26,a6,a2,single).
bond(id26,a7,a5,single).
bond(id26,a8,a4,double).
bond(id26,a9,a3,single).
bond(id26,a10,a8,single).
bond(id26,a9,a10,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 27
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id27,27).
dsstox_filename(id27,nctrer_v1a_232_23oct03).
activity_category_er_rba(id27,inactive).
cas(id27,'84-66-2').
chemclass_erb(id27,misc).
chemcount(id27,'1').
chemname(id27,'diethyl_phthalate').
chemnote(id27,'misc').
er_rba(id27,0).
f1_ring(id27,1).
f2_aromatic_ring(id27,1).
f3_phenolic_ring(id27,0).
f4_heteroatom(id27,0).
f5_phenol3nphenyl(id27,0).
f6_other_key_features(id27,0).
formula(id27,c12h14o4).
log_er_rba(id27,-10000).
logp(id27,2.65).
mean_er_rba_chemclass(id27,na).
molweight(id27,222.2402).
structureshown(id27,tested_form).
substancetype(id27,defined_organic).
testedform(id27,parent).
smiles(id27,'c1(c(c(=o)occ)cccc1)c(=o)occ_').
%activity(id27,inactive).
atom(id27,a1,'C').
atom(id27,a2,'C').
atom(id27,a3,'C').
atom(id27,a4,'O').
atom(id27,a5,'O').
atom(id27,a6,'C').
atom(id27,a7,'C').
atom(id27,a8,'C').
atom(id27,a9,'C').
atom(id27,a10,'C').
atom(id27,a11,'C').
atom(id27,a12,'C').
atom(id27,a13,'O').
atom(id27,a14,'O').
atom(id27,a15,'C').
atom(id27,a16,'C').
bond(id27,a2,a1,double).
bond(id27,a3,a2,single).
bond(id27,a4,a3,double).
bond(id27,a5,a3,single).
bond(id27,a6,a5,single).
bond(id27,a7,a6,single).
bond(id27,a8,a2,single).
bond(id27,a9,a8,double).
bond(id27,a10,a9,single).
bond(id27,a11,a10,double).
bond(id27,a11,a1,single).
bond(id27,a12,a1,single).
bond(id27,a13,a12,double).
bond(id27,a14,a12,single).
bond(id27,a15,a14,single).
bond(id27,a16,a15,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 28
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id28,28).
dsstox_filename(id28,nctrer_v1a_232_23oct03).
activity_category_er_rba(id28,inactive).
cas(id28,'72-43-5').
chemclass_erb(id28,diphenylmethanes_ddts).
chemcount(id28,'1').
chemname(id28,'p,p_-methoxychlor').
chemnote(id28,'unknown').
er_rba(id28,0).
f1_ring(id28,1).
f2_aromatic_ring(id28,1).
f3_phenolic_ring(id28,0).
f4_heteroatom(id28,0).
f5_phenol3nphenyl(id28,1).
f6_other_key_features(id28,0).
formula(id28,c16h15cl3o2).
log_er_rba(id28,-10000).
logp(id28,5.67).
mean_er_rba_chemclass(id28,0.0087).
molweight(id28,345.6523).
structureshown(id28,tested_form).
substancetype(id28,defined_organic).
testedform(id28,parent).
smiles(id28,'c(c(c1ccc(cc1)oc)c1ccc(cc1)oc)(cl)(cl)cl_').
%activity(id28,inactive).
atom(id28,a1,'C').
atom(id28,a2,'C').
atom(id28,a3,'C').
atom(id28,a4,'C').
atom(id28,a5,'C').
atom(id28,a6,'C').
atom(id28,a7,'C').
atom(id28,a8,'C').
atom(id28,a9,'O').
atom(id28,a10,'C').
atom(id28,a11,'C').
atom(id28,a12,'C').
atom(id28,a13,'C').
atom(id28,a14,'C').
atom(id28,a15,'C').
atom(id28,a16,'C').
atom(id28,a17,'O').
atom(id28,a18,'C').
atom(id28,a19,'Cl').
atom(id28,a20,'Cl').
atom(id28,a21,'Cl').
bond(id28,a2,a1,single).
bond(id28,a3,a2,single).
bond(id28,a4,a3,double).
bond(id28,a5,a4,single).
bond(id28,a6,a5,double).
bond(id28,a7,a6,single).
bond(id28,a8,a7,double).
bond(id28,a8,a3,single).
bond(id28,a9,a6,single).
bond(id28,a10,a9,single).
bond(id28,a11,a2,single).
bond(id28,a12,a11,double).
bond(id28,a13,a12,single).
bond(id28,a14,a13,double).
bond(id28,a15,a14,single).
bond(id28,a16,a15,double).
bond(id28,a16,a11,single).
bond(id28,a17,a14,single).
bond(id28,a18,a17,single).
bond(id28,a19,a1,single).
bond(id28,a20,a1,single).
bond(id28,a21,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 29
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id29,29).
dsstox_filename(id29,nctrer_v1a_232_23oct03).
activity_category_er_rba(id29,inactive).
cas(id29,'57-74-9').
chemclass_erb(id29,misc).
chemcount(id29,'1').
chemname(id29,'chlordane').
chemnote(id29,'stereochem').
er_rba(id29,0).
f1_ring(id29,1).
f2_aromatic_ring(id29,0).
f3_phenolic_ring(id29,0).
f4_heteroatom(id29,0).
f5_phenol3nphenyl(id29,0).
f6_other_key_features(id29,0).
formula(id29,c10h6cl8).
log_er_rba(id29,-10000).
logp(id29,6.26).
mean_er_rba_chemclass(id29,na).
molweight(id29,409.7814).
structureshown(id29,tested_form).
substancetype(id29,defined_organic).
testedform(id29,parent).
smiles(id29,'c1c(c(c2c1c1(c(=c(c2(c1(cl)cl)cl)cl)cl)cl)cl)cl_').
%activity(id29,inactive).
atom(id29,a1,'C').
atom(id29,a2,'C').
atom(id29,a3,'C').
atom(id29,a4,'C').
atom(id29,a5,'C').
atom(id29,a6,'C').
atom(id29,a7,'C').
atom(id29,a8,'C').
atom(id29,a9,'C').
atom(id29,a10,'Cl').
atom(id29,a11,'C').
atom(id29,a12,'Cl').
atom(id29,a13,'Cl').
atom(id29,a14,'Cl').
atom(id29,a15,'Cl').
atom(id29,a16,'Cl').
atom(id29,a17,'Cl').
atom(id29,a18,'Cl').
bond(id29,a1,a2,single).
bond(id29,a2,a3,single).
bond(id29,a1,a4,single).
bond(id29,a4,a5,single).
bond(id29,a5,a3,single).
bond(id29,a3,a6,single).
bond(id29,a6,a7,single).
bond(id29,a7,a8,double).
bond(id29,a8,a9,single).
bond(id29,a9,a5,single).
bond(id29,a9,a11,single).
bond(id29,a11,a6,single).
bond(id29,a11,a12,single).
bond(id29,a11,a13,single).
bond(id29,a7,a15,single).
bond(id29,a8,a16,single).
bond(id29,a1,a18,single).
bond(id29,a4,a17,single).
bond(id29,a,a,double).
bond(id29,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 30
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id30,30).
dsstox_filename(id30,nctrer_v1a_232_23oct03).
activity_category_er_rba(id30,inactive).
cas(id30,'93-76-5').
chemclass_erb(id30,misc).
chemcount(id30,'1').
chemname(id30,'2,4,5-t').
chemnote(id30,'unknown').
er_rba(id30,0).
f1_ring(id30,1).
f2_aromatic_ring(id30,1).
f3_phenolic_ring(id30,0).
f4_heteroatom(id30,0).
f5_phenol3nphenyl(id30,0).
f6_other_key_features(id30,0).
formula(id30,c8h5cl3o3).
log_er_rba(id30,-10000).
logp(id30,3.26).
mean_er_rba_chemclass(id30,na).
molweight(id30,255.4847).
structureshown(id30,tested_form).
substancetype(id30,defined_organic).
testedform(id30,parent).
smiles(id30,'c1c(c(cl)cc(c1cl)cl)occ(=o)o_').
%activity(id30,inactive).
atom(id30,a1,'C').
atom(id30,a2,'C').
atom(id30,a3,'C').
atom(id30,a4,'Cl').
atom(id30,a5,'C').
atom(id30,a6,'C').
atom(id30,a7,'C').
atom(id30,a8,'Cl').
atom(id30,a9,'Cl').
atom(id30,a10,'O').
atom(id30,a11,'C').
atom(id30,a12,'C').
atom(id30,a13,'O').
atom(id30,a14,'O').
bond(id30,a2,a1,single).
bond(id30,a3,a2,double).
bond(id30,a4,a3,single).
bond(id30,a5,a3,single).
bond(id30,a6,a5,double).
bond(id30,a7,a6,single).
bond(id30,a7,a1,double).
bond(id30,a8,a7,single).
bond(id30,a9,a6,single).
bond(id30,a10,a2,single).
bond(id30,a11,a10,single).
bond(id30,a12,a11,single).
bond(id30,a13,a12,double).
bond(id30,a14,a12,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 31
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id31,31).
dsstox_filename(id31,nctrer_v1a_232_23oct03).
activity_category_er_rba(id31,inactive).
cas(id31,'2385-85-5').
chemclass_erb(id31,misc).
chemcount(id31,'1').
chemname(id31,'mirex').
chemnote(id31,'stereochem').
er_rba(id31,0).
f1_ring(id31,1).
f2_aromatic_ring(id31,0).
f3_phenolic_ring(id31,0).
f4_heteroatom(id31,0).
f5_phenol3nphenyl(id31,0).
f6_other_key_features(id31,0).
formula(id31,c10cl12).
log_er_rba(id31,-10000).
logp(id31,7.01).
mean_er_rba_chemclass(id31,na).
molweight(id31,545.546).
structureshown(id31,tested_form).
substancetype(id31,defined_organic).
testedform(id31,parent).
smiles(id31,'clc12c3(c4(c5(c3(cl)c(c2(cl)c5(c1(c4(cl)cl)cl)cl)(cl)cl)cl)cl)cl_').
%activity(id31,inactive).
atom(id31,a1,'C').
atom(id31,a2,'C').
atom(id31,a3,'C').
atom(id31,a4,'C').
atom(id31,a5,'Cl').
atom(id31,a6,'C').
atom(id31,a7,'C').
atom(id31,a8,'Cl').
atom(id31,a9,'C').
atom(id31,a10,'C').
atom(id31,a11,'Cl').
atom(id31,a12,'C').
atom(id31,a13,'Cl').
atom(id31,a14,'C').
atom(id31,a15,'Cl').
atom(id31,a16,'Cl').
atom(id31,a17,'Cl').
atom(id31,a18,'Cl').
atom(id31,a19,'Cl').
atom(id31,a20,'Cl').
atom(id31,a21,'Cl').
atom(id31,a22,'Cl').
bond(id31,a1,a2,single).
bond(id31,a1,a3,single).
bond(id31,a1,a4,single).
bond(id31,a2,a6,single).
bond(id31,a2,a7,single).
bond(id31,a3,a9,single).
bond(id31,a3,a10,single).
bond(id31,a4,a12,single).
bond(id31,a4,a9,single).
bond(id31,a6,a14,single).
bond(id31,a6,a10,single).
bond(id31,a7,a12,single).
bond(id31,a7,a14,single).
bond(id31,a9,a14,single).
bond(id31,a10,a18,single).
bond(id31,a10,a19,single).
bond(id31,a12,a20,single).
bond(id31,a12,a21,single).
bond(id31,a,a,double).
bond(id31,a,a,double).
bond(id31,a,a,double).
bond(id31,a,a,double).
bond(id31,a,a,double).
bond(id31,a,a,double).
bond(id31,a,a,double).
bond(id31,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 32
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id32,32).
dsstox_filename(id32,nctrer_v1a_232_23oct03).
activity_category_er_rba(id32,inactive).
cas(id32,'76-44-8').
chemclass_erb(id32,misc).
chemcount(id32,'1').
chemname(id32,'heptachlor').
chemnote(id32,'stereochem').
er_rba(id32,0).
f1_ring(id32,1).
f2_aromatic_ring(id32,0).
f3_phenolic_ring(id32,0).
f4_heteroatom(id32,0).
f5_phenol3nphenyl(id32,0).
f6_other_key_features(id32,0).
formula(id32,c10h5cl7).
log_er_rba(id32,-10000).
logp(id32,5.86).
mean_er_rba_chemclass(id32,na).
molweight(id32,373.3205).
structureshown(id32,tested_form).
substancetype(id32,defined_organic).
testedform(id32,parent).
smiles(id32,'c=1(c2(c3c(c(c1cl)(cl)c2(cl)cl)c=cc3cl)cl)cl_').
%activity(id32,inactive).
atom(id32,a1,'C').
atom(id32,a2,'C').
atom(id32,a3,'C').
atom(id32,a4,'C').
atom(id32,a5,'C').
atom(id32,a6,'C').
atom(id32,a7,'C').
atom(id32,a8,'C').
atom(id32,a9,'C').
atom(id32,a10,'Cl').
atom(id32,a11,'Cl').
atom(id32,a12,'Cl').
atom(id32,a13,'Cl').
atom(id32,a14,'Cl').
atom(id32,a15,'C').
atom(id32,a16,'Cl').
atom(id32,a17,'Cl').
bond(id32,a1,a2,single).
bond(id32,a2,a3,double).
bond(id32,a3,a4,single).
bond(id32,a4,a5,single).
bond(id32,a5,a6,single).
bond(id32,a6,a1,single).
bond(id32,a5,a7,single).
bond(id32,a7,a8,double).
bond(id32,a8,a9,single).
bond(id32,a9,a6,single).
bond(id32,a9,a10,single).
bond(id32,a2,a12,single).
bond(id32,a3,a13,single).
bond(id32,a4,a15,single).
bond(id32,a15,a1,single).
bond(id32,a15,a16,single).
bond(id32,a15,a17,single).
bond(id32,a,a,double).
bond(id32,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 33
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id33,33).
dsstox_filename(id33,nctrer_v1a_232_23oct03).
activity_category_er_rba(id33,slight_binder).
cas(id33,'53-19-0').
chemclass_erb(id33,diphenylmethanes_ddts).
chemcount(id33,'1').
chemname(id33,'o,p_-ddd').
chemnote(id33,'unknown').
er_rba(id33,0).
f1_ring(id33,1).
f2_aromatic_ring(id33,1).
f3_phenolic_ring(id33,0).
f4_heteroatom(id33,0).
f5_phenol3nphenyl(id33,0).
f6_other_key_features(id33,1).
formula(id33,c14h10cl4).
log_er_rba(id33,-5000).
logp(id33,5.87).
mean_er_rba_chemclass(id33,0.0087).
molweight(id33,320.045).
structureshown(id33,tested_form).
substancetype(id33,defined_organic).
testedform(id33,parent).
smiles(id33,'c1(c(c(cl)cl)c2ccc(cc2)cl)c(cl)cccc1_').
%activity(id33,inactive).
atom(id33,a1,'C').
atom(id33,a2,'C').
atom(id33,a3,'C').
atom(id33,a4,'Cl').
atom(id33,a5,'C').
atom(id33,a6,'C').
atom(id33,a7,'C').
atom(id33,a8,'C').
atom(id33,a9,'C').
atom(id33,a10,'Cl').
atom(id33,a11,'Cl').
atom(id33,a12,'C').
atom(id33,a13,'C').
atom(id33,a14,'C').
atom(id33,a15,'C').
atom(id33,a16,'C').
atom(id33,a17,'C').
atom(id33,a18,'Cl').
bond(id33,a1,a2,single).
bond(id33,a3,a2,double).
bond(id33,a4,a3,single).
bond(id33,a5,a3,single).
bond(id33,a6,a5,double).
bond(id33,a7,a6,single).
bond(id33,a8,a7,double).
bond(id33,a8,a2,single).
bond(id33,a9,a1,single).
bond(id33,a10,a9,single).
bond(id33,a11,a9,single).
bond(id33,a12,a1,single).
bond(id33,a13,a12,double).
bond(id33,a14,a13,single).
bond(id33,a15,a14,double).
bond(id33,a16,a15,single).
bond(id33,a17,a16,double).
bond(id33,a17,a12,single).
bond(id33,a18,a15,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 34
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id34,34).
dsstox_filename(id34,nctrer_v1a_232_23oct03).
activity_category_er_rba(id34,inactive).
cas(id34,'1610-18-0').
chemclass_erb(id34,misc).
chemcount(id34,'1').
chemname(id34,'prometon').
chemnote(id34,'unknown').
er_rba(id34,0).
f1_ring(id34,1).
f2_aromatic_ring(id34,1).
f3_phenolic_ring(id34,0).
f4_heteroatom(id34,0).
f5_phenol3nphenyl(id34,0).
f6_other_key_features(id34,0).
formula(id34,c10h19n5o).
log_er_rba(id34,-10000).
logp(id34,3.57).
mean_er_rba_chemclass(id34,na).
molweight(id34,225.293).
structureshown(id34,tested_form).
substancetype(id34,defined_organic).
testedform(id34,parent).
smiles(id34,'c1(nc(nc(c)c)nc(n1)oc)nc(c)c_').
%activity(id34,inactive).
atom(id34,a1,'C').
atom(id34,a2,'N').
atom(id34,a3,'C').
atom(id34,a4,'N').
atom(id34,a5,'C').
atom(id34,a6,'C').
atom(id34,a7,'C').
atom(id34,a8,'N').
atom(id34,a9,'C').
atom(id34,a10,'N').
atom(id34,a11,'O').
atom(id34,a12,'C').
atom(id34,a13,'N').
atom(id34,a14,'C').
atom(id34,a15,'C').
atom(id34,a16,'C').
bond(id34,a2,a1,single).
bond(id34,a3,a2,double).
bond(id34,a4,a3,single).
bond(id34,a5,a4,single).
bond(id34,a6,a5,single).
bond(id34,a7,a5,single).
bond(id34,a8,a3,single).
bond(id34,a9,a8,double).
bond(id34,a10,a9,single).
bond(id34,a10,a1,double).
bond(id34,a11,a9,single).
bond(id34,a12,a11,single).
bond(id34,a13,a1,single).
bond(id34,a14,a13,single).
bond(id34,a15,a14,single).
bond(id34,a16,a14,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 35
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id35,35).
dsstox_filename(id35,nctrer_v1a_232_23oct03).
activity_category_er_rba(id35,inactive).
cas(id35,'122-34-9').
chemclass_erb(id35,misc).
chemcount(id35,'1').
chemname(id35,'simazine').
chemnote(id35,'unknown').
er_rba(id35,0).
f1_ring(id35,1).
f2_aromatic_ring(id35,1).
f3_phenolic_ring(id35,0).
f4_heteroatom(id35,0).
f5_phenol3nphenyl(id35,0).
f6_other_key_features(id35,0).
formula(id35,c7h12cln5).
log_er_rba(id35,-10000).
logp(id35,2.4).
mean_er_rba_chemclass(id35,na).
molweight(id35,201.6583).
structureshown(id35,tested_form).
substancetype(id35,defined_organic).
testedform(id35,parent).
smiles(id35,'n1c(nc(nc1ncc)cl)ncc_').
%activity(id35,inactive).
atom(id35,a1,'N').
atom(id35,a2,'C').
atom(id35,a3,'N').
atom(id35,a4,'C').
atom(id35,a5,'N').
atom(id35,a6,'C').
atom(id35,a7,'N').
atom(id35,a8,'C').
atom(id35,a9,'C').
atom(id35,a10,'Cl').
atom(id35,a11,'N').
atom(id35,a12,'C').
atom(id35,a13,'C').
bond(id35,a2,a1,single).
bond(id35,a3,a2,double).
bond(id35,a4,a3,single).
bond(id35,a5,a4,double).
bond(id35,a6,a5,single).
bond(id35,a6,a1,double).
bond(id35,a7,a6,single).
bond(id35,a8,a7,single).
bond(id35,a9,a8,single).
bond(id35,a10,a4,single).
bond(id35,a11,a2,single).
bond(id35,a12,a11,single).
bond(id35,a13,a12,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 36
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id36,36).
dsstox_filename(id36,nctrer_v1a_232_23oct03).
activity_category_er_rba(id36,inactive).
cas(id36,'525-82-6').
chemclass_erb(id36,phytoestrogens_flavones).
chemcount(id36,'1').
chemname(id36,'6-hydroxy-2_-methoxy_flavone').
chemnote(id36,'unknown').
er_rba(id36,0).
f1_ring(id36,1).
f2_aromatic_ring(id36,1).
f3_phenolic_ring(id36,1).
f4_heteroatom(id36,0).
f5_phenol3nphenyl(id36,1).
f6_other_key_features(id36,0).
formula(id36,c16h12o4).
log_er_rba(id36,-10000).
logp(id36,3.11).
mean_er_rba_chemclass(id36,0.019).
molweight(id36,268.2684).
structureshown(id36,tested_form).
substancetype(id36,defined_organic).
testedform(id36,parent).
smiles(id36,'c1(cc(=o)c2c(o1)ccc(o)c2)c1c(oc)cccc1_').
%activity(id36,inactive).
atom(id36,a1,'C').
atom(id36,a2,'C').
atom(id36,a3,'C').
atom(id36,a4,'O').
atom(id36,a5,'C').
atom(id36,a6,'C').
atom(id36,a7,'O').
atom(id36,a8,'C').
atom(id36,a9,'C').
atom(id36,a10,'C').
atom(id36,a11,'O').
atom(id36,a12,'C').
atom(id36,a13,'C').
atom(id36,a14,'C').
atom(id36,a15,'O').
atom(id36,a16,'C').
atom(id36,a17,'C').
atom(id36,a18,'C').
atom(id36,a19,'C').
atom(id36,a20,'C').
bond(id36,a2,a1,double).
bond(id36,a3,a2,single).
bond(id36,a4,a3,double).
bond(id36,a5,a3,single).
bond(id36,a6,a5,single).
bond(id36,a7,a6,single).
bond(id36,a7,a1,single).
bond(id36,a8,a6,double).
bond(id36,a9,a8,single).
bond(id36,a10,a9,double).
bond(id36,a11,a10,single).
bond(id36,a12,a10,single).
bond(id36,a12,a5,double).
bond(id36,a13,a1,single).
bond(id36,a14,a13,double).
bond(id36,a15,a14,single).
bond(id36,a16,a15,single).
bond(id36,a17,a14,single).
bond(id36,a18,a17,double).
bond(id36,a19,a18,single).
bond(id36,a20,a19,double).
bond(id36,a20,a13,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 37
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id37,37).
dsstox_filename(id37,nctrer_v1a_232_23oct03).
activity_category_er_rba(id37,active_weak).
cas(id37,'487-26-3').
chemclass_erb(id37,phytoestrogens_flavanones).
chemcount(id37,'1').
chemname(id37,'3_-hydroxy_flavanone').
chemnote(id37,'unknown').
er_rba(id37,0.00165).
f1_ring(id37,1).
f2_aromatic_ring(id37,1).
f3_phenolic_ring(id37,1).
f4_heteroatom(id37,0).
f5_phenol3nphenyl(id37,1).
f6_other_key_features(id37,0).
formula(id37,c15h12o3).
log_er_rba(id37,-2.78).
logp(id37,2.8).
mean_er_rba_chemclass(id37,0.019).
molweight(id37,240.258).
structureshown(id37,tested_form).
substancetype(id37,defined_organic).
testedform(id37,parent).
smiles(id37,'o1c(cc(=o)c2c1cccc2)c1cc(o)ccc1_').
%activity(id37,active).
atom(id37,a1,'O').
atom(id37,a2,'C').
atom(id37,a3,'C').
atom(id37,a4,'C').
atom(id37,a5,'O').
atom(id37,a6,'C').
atom(id37,a7,'C').
atom(id37,a8,'C').
atom(id37,a9,'C').
atom(id37,a10,'C').
atom(id37,a11,'C').
atom(id37,a12,'C').
atom(id37,a13,'C').
atom(id37,a14,'C').
atom(id37,a15,'O').
atom(id37,a16,'C').
atom(id37,a17,'C').
atom(id37,a18,'C').
bond(id37,a2,a1,single).
bond(id37,a3,a2,single).
bond(id37,a4,a3,single).
bond(id37,a5,a4,double).
bond(id37,a6,a4,single).
bond(id37,a7,a6,single).
bond(id37,a7,a1,single).
bond(id37,a8,a7,double).
bond(id37,a9,a8,single).
bond(id37,a10,a9,double).
bond(id37,a11,a10,single).
bond(id37,a11,a6,double).
bond(id37,a2,a12,single).
bond(id37,a13,a12,single).
bond(id37,a14,a13,double).
bond(id37,a15,a14,single).
bond(id37,a16,a14,single).
bond(id37,a17,a16,double).
bond(id37,a18,a17,single).
bond(id37,a18,a12,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 38
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id38,38).
dsstox_filename(id38,nctrer_v1a_232_23oct03).
activity_category_er_rba(id38,active_weak).
cas(id38,'789-02-6').
chemclass_erb(id38,diphenylmethanes_ddts).
chemcount(id38,'1').
chemname(id38,'o,p_-ddt').
chemnote(id38,'unknown').
er_rba(id38,0.00141).
f1_ring(id38,1).
f2_aromatic_ring(id38,1).
f3_phenolic_ring(id38,0).
f4_heteroatom(id38,0).
f5_phenol3nphenyl(id38,0).
f6_other_key_features(id38,1).
formula(id38,c14h9cl5).
log_er_rba(id38,-2.85).
logp(id38,6.79).
mean_er_rba_chemclass(id38,0.0087).
molweight(id38,354.4901).
structureshown(id38,tested_form).
substancetype(id38,defined_organic).
testedform(id38,parent).
smiles(id38,'c1cccc(c1c(c(cl)(cl)cl)c1ccc(cc1)cl)cl_').
%activity(id38,active).
atom(id38,a1,'C').
atom(id38,a2,'C').
atom(id38,a3,'C').
atom(id38,a4,'C').
atom(id38,a5,'C').
atom(id38,a6,'C').
atom(id38,a7,'C').
atom(id38,a8,'C').
atom(id38,a9,'Cl').
atom(id38,a10,'Cl').
atom(id38,a11,'Cl').
atom(id38,a12,'C').
atom(id38,a13,'C').
atom(id38,a14,'C').
atom(id38,a15,'C').
atom(id38,a16,'C').
atom(id38,a17,'C').
atom(id38,a18,'Cl').
atom(id38,a19,'Cl').
bond(id38,a2,a1,single).
bond(id38,a3,a2,double).
bond(id38,a4,a3,single).
bond(id38,a5,a4,double).
bond(id38,a6,a5,single).
bond(id38,a6,a1,double).
bond(id38,a7,a6,single).
bond(id38,a8,a7,single).
bond(id38,a9,a8,single).
bond(id38,a10,a8,single).
bond(id38,a11,a8,single).
bond(id38,a12,a7,single).
bond(id38,a13,a12,double).
bond(id38,a14,a13,single).
bond(id38,a15,a14,double).
bond(id38,a16,a15,single).
bond(id38,a17,a16,double).
bond(id38,a17,a12,single).
bond(id38,a18,a15,single).
bond(id38,a5,a19,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 39
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id39,39).
dsstox_filename(id39,nctrer_v1a_232_23oct03).
activity_category_er_rba(id39,inactive).
cas(id39,'118-74-1').
chemclass_erb(id39,misc).
chemcount(id39,'1').
chemname(id39,'hexachlorobenzene').
chemnote(id39,'unknown').
er_rba(id39,0).
f1_ring(id39,1).
f2_aromatic_ring(id39,1).
f3_phenolic_ring(id39,1).
f4_heteroatom(id39,0).
f5_phenol3nphenyl(id39,0).
f6_other_key_features(id39,0).
formula(id39,c6cl6).
log_er_rba(id39,-10000).
logp(id39,5.86).
mean_er_rba_chemclass(id39,na).
molweight(id39,284.784).
structureshown(id39,tested_form).
substancetype(id39,defined_organic).
testedform(id39,parent).
smiles(id39,'c1(c(c(cl)c(c(c1cl)cl)cl)cl)cl_').
%activity(id39,inactive).
atom(id39,a1,'C').
atom(id39,a2,'C').
atom(id39,a3,'C').
atom(id39,a4,'C').
atom(id39,a5,'C').
atom(id39,a6,'C').
atom(id39,a7,'Cl').
atom(id39,a8,'Cl').
atom(id39,a9,'Cl').
atom(id39,a10,'Cl').
atom(id39,a11,'Cl').
atom(id39,a12,'Cl').
bond(id39,a0,a0,double).
bond(id39,a0,a0,double).
bond(id39,a0,a0,double).
bond(id39,a2,a1,double).
bond(id39,a3,a2,single).
bond(id39,a4,a5,single).
bond(id39,a5,a6,double).
bond(id39,a6,a1,single).
bond(id39,a7,a3,single).
bond(id39,a8,a5,single).
bond(id39,a9,a2,single).
bond(id39,a10,a6,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 40
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id40,40).
dsstox_filename(id40,nctrer_v1a_232_23oct03).
activity_category_er_rba(id40,inactive).
cas(id40,'72-54-8').
chemclass_erb(id40,diphenylmethanes_ddts).
chemcount(id40,'1').
chemname(id40,'p,p_-ddd').
chemnote(id40,'unknown').
er_rba(id40,0).
f1_ring(id40,1).
f2_aromatic_ring(id40,1).
f3_phenolic_ring(id40,0).
f4_heteroatom(id40,0).
f5_phenol3nphenyl(id40,1).
f6_other_key_features(id40,0).
formula(id40,c14h10cl4).
log_er_rba(id40,-10000).
logp(id40,5.87).
mean_er_rba_chemclass(id40,0.0087).
molweight(id40,320.045).
structureshown(id40,tested_form).
substancetype(id40,defined_organic).
testedform(id40,parent).
smiles(id40,'c(c(cl)cl)(c1ccc(cc1)cl)c1ccc(cc1)cl_').
%activity(id40,inactive).
atom(id40,a1,'C').
atom(id40,a2,'C').
atom(id40,a3,'Cl').
atom(id40,a4,'Cl').
atom(id40,a5,'C').
atom(id40,a6,'C').
atom(id40,a7,'C').
atom(id40,a8,'C').
atom(id40,a9,'C').
atom(id40,a10,'C').
atom(id40,a11,'Cl').
atom(id40,a12,'C').
atom(id40,a13,'C').
atom(id40,a14,'C').
atom(id40,a15,'C').
atom(id40,a16,'C').
atom(id40,a17,'C').
atom(id40,a18,'Cl').
bond(id40,a1,a2,single).
bond(id40,a2,a3,single).
bond(id40,a2,a4,single).
bond(id40,a1,a5,single).
bond(id40,a5,a6,double).
bond(id40,a6,a7,single).
bond(id40,a7,a8,double).
bond(id40,a8,a9,single).
bond(id40,a9,a10,double).
bond(id40,a5,a10,single).
bond(id40,a8,a11,single).
bond(id40,a1,a12,single).
bond(id40,a12,a13,single).
bond(id40,a13,a14,double).
bond(id40,a14,a15,single).
bond(id40,a15,a16,double).
bond(id40,a16,a17,single).
bond(id40,a12,a17,double).
bond(id40,a15,a18,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 41
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id41,41).
dsstox_filename(id41,nctrer_v1a_232_23oct03).
activity_category_er_rba(id41,inactive).
cas(id41,'72-55-9').
chemclass_erb(id41,diphenylmethanes_ddts).
chemcount(id41,'1').
chemname(id41,'p,p_-dde').
chemnote(id41,'unknown').
er_rba(id41,0).
f1_ring(id41,1).
f2_aromatic_ring(id41,1).
f3_phenolic_ring(id41,0).
f4_heteroatom(id41,0).
f5_phenol3nphenyl(id41,1).
f6_other_key_features(id41,0).
formula(id41,c14h8cl4).
log_er_rba(id41,-10000).
logp(id41,6).
mean_er_rba_chemclass(id41,0.0087).
molweight(id41,318.0292).
structureshown(id41,tested_form).
substancetype(id41,defined_organic).
testedform(id41,parent).
smiles(id41,'c(=c(cl)cl)(c1ccc(cc1)cl)c1ccc(cc1)cl_').
%activity(id41,inactive).
atom(id41,a1,'C').
atom(id41,a2,'C').
atom(id41,a3,'Cl').
atom(id41,a4,'Cl').
atom(id41,a5,'C').
atom(id41,a6,'C').
atom(id41,a7,'C').
atom(id41,a8,'C').
atom(id41,a9,'C').
atom(id41,a10,'C').
atom(id41,a11,'Cl').
atom(id41,a12,'C').
atom(id41,a13,'C').
atom(id41,a14,'C').
atom(id41,a15,'C').
atom(id41,a16,'C').
atom(id41,a17,'C').
atom(id41,a18,'Cl').
bond(id41,a1,a2,double).
bond(id41,a2,a3,single).
bond(id41,a2,a4,single).
bond(id41,a1,a5,single).
bond(id41,a5,a6,single).
bond(id41,a6,a7,double).
bond(id41,a7,a8,single).
bond(id41,a8,a9,double).
bond(id41,a9,a10,single).
bond(id41,a5,a10,double).
bond(id41,a8,a11,single).
bond(id41,a1,a12,single).
bond(id41,a12,a13,double).
bond(id41,a13,a14,single).
bond(id41,a14,a15,double).
bond(id41,a15,a16,single).
bond(id41,a16,a17,double).
bond(id41,a12,a17,single).
bond(id41,a15,a18,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 42
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id42,42).
dsstox_filename(id42,nctrer_v1a_232_23oct03).
activity_category_er_rba(id42,inactive).
cas(id42,'50-29-3').
chemclass_erb(id42,diphenylmethanes_ddts).
chemcount(id42,'1').
chemname(id42,'p,p_-ddt').
chemnote(id42,'unknown').
er_rba(id42,0).
f1_ring(id42,1).
f2_aromatic_ring(id42,1).
f3_phenolic_ring(id42,0).
f4_heteroatom(id42,0).
f5_phenol3nphenyl(id42,1).
f6_other_key_features(id42,0).
formula(id42,c14h9cl5).
log_er_rba(id42,-10000).
logp(id42,6.79).
mean_er_rba_chemclass(id42,0.0087).
molweight(id42,354.4901).
structureshown(id42,tested_form).
substancetype(id42,defined_organic).
testedform(id42,parent).
smiles(id42,'c(c(c1ccc(cc1)cl)c1ccc(cc1)cl)(cl)(cl)cl_').
%activity(id42,inactive).
atom(id42,a1,'C').
atom(id42,a2,'C').
atom(id42,a3,'C').
atom(id42,a4,'C').
atom(id42,a5,'C').
atom(id42,a6,'C').
atom(id42,a7,'C').
atom(id42,a8,'C').
atom(id42,a9,'Cl').
atom(id42,a10,'C').
atom(id42,a11,'C').
atom(id42,a12,'C').
atom(id42,a13,'C').
atom(id42,a14,'C').
atom(id42,a15,'C').
atom(id42,a16,'Cl').
atom(id42,a17,'Cl').
atom(id42,a18,'Cl').
atom(id42,a19,'Cl').
bond(id42,a1,a2,single).
bond(id42,a2,a3,single).
bond(id42,a3,a4,single).
bond(id42,a4,a5,double).
bond(id42,a5,a6,single).
bond(id42,a6,a7,double).
bond(id42,a7,a8,single).
bond(id42,a3,a8,double).
bond(id42,a6,a9,single).
bond(id42,a2,a10,single).
bond(id42,a10,a11,single).
bond(id42,a11,a12,double).
bond(id42,a12,a13,single).
bond(id42,a13,a14,double).
bond(id42,a14,a15,single).
bond(id42,a10,a15,double).
bond(id42,a13,a16,single).
bond(id42,a1,a17,single).
bond(id42,a1,a18,single).
bond(id42,a1,a19,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 43
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id43,43).
dsstox_filename(id43,nctrer_v1a_232_23oct03).
activity_category_er_rba(id43,active_medium).
cas(id43,'nocas').
chemclass_erb(id43,biphenyls_pcbs).
chemcount(id43,'1').
chemname(id43,'2,3,4,5-tetrachloro-4_-biphenylol').
chemnote(id43,'unknown').
er_rba(id43,0.23).
f1_ring(id43,1).
f2_aromatic_ring(id43,1).
f3_phenolic_ring(id43,1).
f4_heteroatom(id43,0).
f5_phenol3nphenyl(id43,0).
f6_other_key_features(id43,0).
formula(id43,c12h6cl4o).
log_er_rba(id43,-0.64).
logp(id43,5.85).
mean_er_rba_chemclass(id43,0.0028).
molweight(id43,307.9908).
structureshown(id43,tested_form).
substancetype(id43,defined_organic).
testedform(id43,parent).
smiles(id43,'c1(c(c(c2ccc(cc2)o)cc(c1cl)cl)cl)cl_').
%activity(id43,active).
atom(id43,a1,'C').
atom(id43,a2,'C').
atom(id43,a3,'C').
atom(id43,a4,'C').
atom(id43,a5,'C').
atom(id43,a6,'C').
atom(id43,a7,'C').
atom(id43,a8,'C').
atom(id43,a9,'C').
atom(id43,a10,'O').
atom(id43,a11,'C').
atom(id43,a12,'C').
atom(id43,a13,'C').
atom(id43,a14,'Cl').
atom(id43,a15,'Cl').
atom(id43,a16,'Cl').
atom(id43,a17,'Cl').
bond(id43,a1,a2,single).
bond(id43,a2,a3,double).
bond(id43,a3,a4,single).
bond(id43,a4,a5,single).
bond(id43,a5,a6,double).
bond(id43,a6,a7,single).
bond(id43,a7,a8,double).
bond(id43,a8,a9,single).
bond(id43,a4,a9,double).
bond(id43,a7,a10,single).
bond(id43,a3,a11,single).
bond(id43,a11,a12,double).
bond(id43,a12,a13,single).
bond(id43,a1,a13,double).
bond(id43,a13,a14,single).
bond(id43,a12,a15,single).
bond(id43,a2,a16,single).
bond(id43,a1,a17,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 44
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id44,44).
dsstox_filename(id44,nctrer_v1a_232_23oct03).
activity_category_er_rba(id44,active_medium).
cas(id44,'53905-28-5').
chemclass_erb(id44,biphenyls_pcbs).
chemcount(id44,'1').
chemname(id44,'2,5-dichloro-4_-biphenylol').
chemnote(id44,'unknown').
er_rba(id44,0.0363).
f1_ring(id44,1).
f2_aromatic_ring(id44,1).
f3_phenolic_ring(id44,1).
f4_heteroatom(id44,0).
f5_phenol3nphenyl(id44,0).
f6_other_key_features(id44,0).
formula(id44,c12h8cl2o).
log_er_rba(id44,-1.44).
logp(id44,4.57).
mean_er_rba_chemclass(id44,0.0028).
molweight(id44,239.1006).
structureshown(id44,tested_form).
substancetype(id44,defined_organic).
testedform(id44,parent).
smiles(id44,'c1(c2ccc(cc2)o)c(ccc(c1)cl)cl_').
%activity(id44,active).
atom(id44,a1,'C').
atom(id44,a2,'C').
atom(id44,a3,'C').
atom(id44,a4,'C').
atom(id44,a5,'C').
atom(id44,a6,'C').
atom(id44,a7,'C').
atom(id44,a8,'O').
atom(id44,a9,'C').
atom(id44,a10,'C').
atom(id44,a11,'C').
atom(id44,a12,'C').
atom(id44,a13,'C').
atom(id44,a14,'Cl').
atom(id44,a15,'Cl').
bond(id44,a1,a2,single).
bond(id44,a2,a3,double).
bond(id44,a3,a4,single).
bond(id44,a4,a5,double).
bond(id44,a5,a6,single).
bond(id44,a6,a7,double).
bond(id44,a2,a7,single).
bond(id44,a5,a8,single).
bond(id44,a1,a9,double).
bond(id44,a9,a10,single).
bond(id44,a10,a11,double).
bond(id44,a11,a12,single).
bond(id44,a12,a13,double).
bond(id44,a1,a13,single).
bond(id44,a12,a14,single).
bond(id44,a9,a15,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 45
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id45,45).
dsstox_filename(id45,nctrer_v1a_232_23oct03).
activity_category_er_rba(id45,active_weak).
cas(id45,'13049-13-3').
chemclass_erb(id45,biphenyls_pcbs).
chemcount(id45,'1').
chemname(id45,'3,3_,5,5_-tetrachloro-4,4_-biphenyldiol').
chemnote(id45,'unknown').
er_rba(id45,0.00056).
f1_ring(id45,1).
f2_aromatic_ring(id45,1).
f3_phenolic_ring(id45,1).
f4_heteroatom(id45,0).
f5_phenol3nphenyl(id45,0).
f6_other_key_features(id45,0).
formula(id45,c12h6cl4o2).
log_er_rba(id45,-3.25).
logp(id45,5.37).
mean_er_rba_chemclass(id45,0.0028).
molweight(id45,323.9902).
structureshown(id45,tested_form).
substancetype(id45,defined_organic).
testedform(id45,parent).
smiles(id45,'c1(c(cc(c2cc(cl)c(c(c2)cl)o)cc1cl)cl)o_').
%activity(id45,active).
atom(id45,a1,'C').
atom(id45,a2,'C').
atom(id45,a3,'C').
atom(id45,a4,'C').
atom(id45,a5,'C').
atom(id45,a6,'C').
atom(id45,a7,'C').
atom(id45,a8,'Cl').
atom(id45,a9,'C').
atom(id45,a10,'C').
atom(id45,a11,'C').
atom(id45,a12,'Cl').
atom(id45,a13,'O').
atom(id45,a14,'C').
atom(id45,a15,'C').
atom(id45,a16,'Cl').
atom(id45,a17,'Cl').
atom(id45,a18,'O').
bond(id45,a2,a1,double).
bond(id45,a3,a2,single).
bond(id45,a4,a3,double).
bond(id45,a5,a4,single).
bond(id45,a6,a5,single).
bond(id45,a7,a6,double).
bond(id45,a8,a7,single).
bond(id45,a9,a7,single).
bond(id45,a10,a9,double).
bond(id45,a11,a10,single).
bond(id45,a11,a5,double).
bond(id45,a12,a10,single).
bond(id45,a13,a9,single).
bond(id45,a14,a4,single).
bond(id45,a15,a14,double).
bond(id45,a15,a1,single).
bond(id45,a16,a15,single).
bond(id45,a17,a2,single).
bond(id45,a18,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 46
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id46,46).
dsstox_filename(id46,nctrer_v1a_232_23oct03).
activity_category_er_rba(id46,active_weak).
cas(id46,'92-04-6').
chemclass_erb(id46,biphenyls_pcbs).
chemcount(id46,'1').
chemname(id46,'2-chloro-4-biphenylol').
chemnote(id46,'unknown').
er_rba(id46,0.00169).
f1_ring(id46,1).
f2_aromatic_ring(id46,1).
f3_phenolic_ring(id46,1).
f4_heteroatom(id46,0).
f5_phenol3nphenyl(id46,0).
f6_other_key_features(id46,0).
formula(id46,c12h9clo).
log_er_rba(id46,-2.77).
logp(id46,3.92).
mean_er_rba_chemclass(id46,0.0028).
molweight(id46,204.6555).
structureshown(id46,tested_form).
substancetype(id46,defined_organic).
testedform(id46,parent).
smiles(id46,'c1(c(ccc(c1)o)c1ccccc1)cl_').
%activity(id46,active).
atom(id46,a1,'C').
atom(id46,a2,'C').
atom(id46,a3,'C').
atom(id46,a4,'C').
atom(id46,a5,'C').
atom(id46,a6,'C').
atom(id46,a7,'O').
atom(id46,a8,'C').
atom(id46,a9,'C').
atom(id46,a10,'C').
atom(id46,a11,'C').
atom(id46,a12,'C').
atom(id46,a13,'C').
atom(id46,a14,'Cl').
bond(id46,a1,a2,double).
bond(id46,a2,a3,single).
bond(id46,a3,a4,double).
bond(id46,a4,a5,single).
bond(id46,a5,a6,double).
bond(id46,a1,a6,single).
bond(id46,a5,a7,single).
bond(id46,a2,a8,single).
bond(id46,a8,a9,single).
bond(id46,a9,a10,double).
bond(id46,a10,a11,single).
bond(id46,a11,a12,double).
bond(id46,a12,a13,single).
bond(id46,a8,a13,double).
bond(id46,a1,a14,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 47
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id47,47).
dsstox_filename(id47,nctrer_v1a_232_23oct03).
activity_category_er_rba(id47,active_weak).
cas(id47,'28034-99-3').
chemclass_erb(id47,biphenyls_pcbs).
chemcount(id47,'1').
chemname(id47,'4-chloro-4_-biphenylol').
chemnote(id47,'unknown').
er_rba(id47,0.0066).
f1_ring(id47,1).
f2_aromatic_ring(id47,1).
f3_phenolic_ring(id47,1).
f4_heteroatom(id47,0).
f5_phenol3nphenyl(id47,0).
f6_other_key_features(id47,0).
formula(id47,c12h9clo).
log_er_rba(id47,-2.18).
logp(id47,3.92).
mean_er_rba_chemclass(id47,0.0028).
molweight(id47,204.6555).
structureshown(id47,tested_form).
substancetype(id47,defined_organic).
testedform(id47,parent).
smiles(id47,'c1(c2ccc(cc2)cl)ccc(cc1)o_').
%activity(id47,active).
atom(id47,a1,'C').
atom(id47,a2,'C').
atom(id47,a3,'C').
atom(id47,a4,'C').
atom(id47,a5,'C').
atom(id47,a6,'C').
atom(id47,a7,'C').
atom(id47,a8,'Cl').
atom(id47,a9,'C').
atom(id47,a10,'C').
atom(id47,a11,'C').
atom(id47,a12,'C').
atom(id47,a13,'C').
atom(id47,a14,'O').
bond(id47,a2,a1,single).
bond(id47,a3,a2,double).
bond(id47,a4,a3,single).
bond(id47,a5,a4,double).
bond(id47,a6,a5,single).
bond(id47,a7,a6,double).
bond(id47,a7,a2,single).
bond(id47,a8,a5,single).
bond(id47,a9,a1,double).
bond(id47,a10,a9,single).
bond(id47,a11,a10,double).
bond(id47,a12,a11,single).
bond(id47,a13,a12,double).
bond(id47,a13,a1,single).
bond(id47,a14,a11,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 48
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id48,48).
dsstox_filename(id48,nctrer_v1a_232_23oct03).
activity_category_er_rba(id48,active_weak).
cas(id48,'98-54-4').
chemclass_erb(id48,phenols_alkyl).
chemcount(id48,'1').
chemname(id48,'4-tert-butylphenol').
chemnote(id48,'unknown').
er_rba(id48,0.00024).
f1_ring(id48,1).
f2_aromatic_ring(id48,1).
f3_phenolic_ring(id48,1).
f4_heteroatom(id48,0).
f5_phenol3nphenyl(id48,0).
f6_other_key_features(id48,0).
formula(id48,c10h14o).
log_er_rba(id48,-3.61).
logp(id48,3.42).
mean_er_rba_chemclass(id48,0.00088).
molweight(id48,150.22).
structureshown(id48,tested_form).
substancetype(id48,defined_organic).
testedform(id48,parent).
smiles(id48,'c(c1ccc(cc1)o)(c)(c)c_').
%activity(id48,active).
atom(id48,a1,'C').
atom(id48,a2,'C').
atom(id48,a3,'C').
atom(id48,a4,'C').
atom(id48,a5,'C').
atom(id48,a6,'C').
atom(id48,a7,'C').
atom(id48,a8,'O').
atom(id48,a9,'C').
atom(id48,a10,'C').
atom(id48,a11,'C').
bond(id48,a2,a1,single).
bond(id48,a3,a2,double).
bond(id48,a4,a3,single).
bond(id48,a5,a4,double).
bond(id48,a6,a5,single).
bond(id48,a7,a6,double).
bond(id48,a7,a2,single).
bond(id48,a8,a5,single).
bond(id48,a9,a1,single).
bond(id48,a10,a1,single).
bond(id48,a11,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 49
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id49,49).
dsstox_filename(id49,nctrer_v1a_232_23oct03).
activity_category_er_rba(id49,inactive).
cas(id49,'1912-24-9').
chemclass_erb(id49,misc).
chemcount(id49,'1').
chemname(id49,'atrazine').
chemnote(id49,'unknown').
er_rba(id49,0).
f1_ring(id49,1).
f2_aromatic_ring(id49,1).
f3_phenolic_ring(id49,0).
f4_heteroatom(id49,0).
f5_phenol3nphenyl(id49,0).
f6_other_key_features(id49,0).
formula(id49,c8h14cln5).
log_er_rba(id49,-10000).
logp(id49,2.82).
mean_er_rba_chemclass(id49,na).
molweight(id49,215.6851).
structureshown(id49,tested_form).
substancetype(id49,defined_organic).
testedform(id49,parent).
smiles(id49,'c1(nc(ncc)nc(n1)cl)nc(c)c_').
%activity(id49,inactive).
atom(id49,a1,'C').
atom(id49,a2,'N').
atom(id49,a3,'C').
atom(id49,a4,'N').
atom(id49,a5,'C').
atom(id49,a6,'C').
atom(id49,a7,'N').
atom(id49,a8,'C').
atom(id49,a9,'N').
atom(id49,a10,'Cl').
atom(id49,a11,'N').
atom(id49,a12,'C').
atom(id49,a13,'C').
atom(id49,a14,'C').
bond(id49,a2,a1,single).
bond(id49,a3,a2,double).
bond(id49,a4,a3,single).
bond(id49,a5,a4,single).
bond(id49,a6,a5,single).
bond(id49,a7,a3,single).
bond(id49,a8,a7,double).
bond(id49,a9,a8,single).
bond(id49,a9,a1,double).
bond(id49,a10,a8,single).
bond(id49,a11,a1,single).
bond(id49,a12,a11,single).
bond(id49,a13,a12,single).
bond(id49,a14,a12,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 50
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id50,50).
dsstox_filename(id50,nctrer_v1a_232_23oct03).
activity_category_er_rba(id50,inactive).
cas(id50,'115-29-7').
chemclass_erb(id50,misc).
chemcount(id50,'1').
chemname(id50,'endosulfan,_technical_grade').
chemnote(id50,'stereochem').
er_rba(id50,0).
f1_ring(id50,1).
f2_aromatic_ring(id50,0).
f3_phenolic_ring(id50,0).
f4_heteroatom(id50,1).
f5_phenol3nphenyl(id50,0).
f6_other_key_features(id50,0).
formula(id50,c9h6cl6o3s).
log_er_rba(id50,-10000).
logp(id50,3.5).
mean_er_rba_chemclass(id50,na).
molweight(id50,406.9226).
structureshown(id50,tested_form).
substancetype(id50,defined_organic).
testedform(id50,parent).
smiles(id50,'clc12c3c(cos(=o)oc3)c(c1(cl)cl)(cl)c(=c2cl)cl_').
%activity(id50,inactive).
atom(id50,a1,'Cl').
atom(id50,a2,'C').
atom(id50,a3,'C').
atom(id50,a4,'C').
atom(id50,a5,'C').
atom(id50,a6,'O').
atom(id50,a7,'S').
atom(id50,a8,'O').
atom(id50,a9,'O').
atom(id50,a10,'C').
atom(id50,a11,'C').
atom(id50,a12,'C').
atom(id50,a13,'Cl').
atom(id50,a14,'Cl').
atom(id50,a15,'Cl').
atom(id50,a16,'C').
atom(id50,a17,'C').
atom(id50,a18,'Cl').
atom(id50,a19,'Cl').
bond(id50,a3,a2,single).
bond(id50,a4,a3,single).
bond(id50,a5,a4,single).
bond(id50,a6,a5,single).
bond(id50,a7,a6,single).
bond(id50,a8,a7,double).
bond(id50,a9,a7,single).
bond(id50,a10,a9,single).
bond(id50,a10,a3,single).
bond(id50,a11,a4,single).
bond(id50,a12,a11,single).
bond(id50,a12,a2,single).
bond(id50,a13,a12,single).
bond(id50,a14,a12,single).
bond(id50,a16,a11,single).
bond(id50,a17,a16,double).
bond(id50,a17,a2,single).
bond(id50,a18,a17,single).
bond(id50,a19,a16,single).
bond(id50,a,a,double).
bond(id50,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 51
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id51,51).
dsstox_filename(id51,nctrer_v1a_232_23oct03).
activity_category_er_rba(id51,active_medium).
cas(id51,'143-50-0').
chemclass_erb(id51,misc).
chemcount(id51,'1').
chemname(id51,'kepone').
chemnote(id51,'stereochem').
er_rba(id51,0.013).
f1_ring(id51,1).
f2_aromatic_ring(id51,0).
f3_phenolic_ring(id51,0).
f4_heteroatom(id51,1).
f5_phenol3nphenyl(id51,0).
f6_other_key_features(id51,1).
formula(id51,c10cl10o).
log_er_rba(id51,-1.89).
logp(id51,4.91).
mean_er_rba_chemclass(id51,na).
molweight(id51,490.6394).
structureshown(id51,tested_form).
substancetype(id51,defined_organic).
testedform(id51,parent).
smiles(id51,'clc12c3(c4(c5(c3(cl)c(c2(cl)c5(c1(c4(cl)cl)cl)cl)=o)cl)cl)cl_').
%activity(id51,active).
atom(id51,a1,'C').
atom(id51,a2,'C').
atom(id51,a3,'C').
atom(id51,a4,'C').
atom(id51,a5,'Cl').
atom(id51,a6,'C').
atom(id51,a7,'C').
atom(id51,a8,'Cl').
atom(id51,a9,'C').
atom(id51,a10,'C').
atom(id51,a11,'Cl').
atom(id51,a12,'C').
atom(id51,a13,'Cl').
atom(id51,a14,'C').
atom(id51,a15,'Cl').
atom(id51,a16,'Cl').
atom(id51,a17,'Cl').
atom(id51,a18,'Cl').
atom(id51,a19,'Cl').
atom(id51,a20,'O').
atom(id51,a21,'Cl').
bond(id51,a1,a2,single).
bond(id51,a1,a3,single).
bond(id51,a1,a4,single).
bond(id51,a2,a6,single).
bond(id51,a2,a7,single).
bond(id51,a3,a9,single).
bond(id51,a3,a10,single).
bond(id51,a4,a12,single).
bond(id51,a4,a9,single).
bond(id51,a6,a14,single).
bond(id51,a6,a10,single).
bond(id51,a7,a12,single).
bond(id51,a7,a14,single).
bond(id51,a9,a14,single).
bond(id51,a10,a18,single).
bond(id51,a10,a19,single).
bond(id51,a12,a20,double).
bond(id51,a,a,double).
bond(id51,a,a,double).
bond(id51,a,a,double).
bond(id51,a,a,double).
bond(id51,a,a,double).
bond(id51,a,a,double).
bond(id51,a,a,double).
bond(id51,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 52
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id52,52).
dsstox_filename(id52,nctrer_v1a_232_23oct03).
activity_category_er_rba(id52,inactive).
cas(id52,'58-89-9').
chemclass_erb(id52,misc).
chemcount(id52,'1').
chemname(id52,'lindane_(gama-hch)').
chemnote(id52,'stereochem').
er_rba(id52,0).
f1_ring(id52,1).
f2_aromatic_ring(id52,0).
f3_phenolic_ring(id52,0).
f4_heteroatom(id52,0).
f5_phenol3nphenyl(id52,0).
f6_other_key_features(id52,0).
formula(id52,c6h6cl6).
log_er_rba(id52,-10000).
logp(id52,4.26).
mean_er_rba_chemclass(id52,na).
molweight(id52,290.8314).
structureshown(id52,tested_form).
substancetype(id52,defined_organic).
testedform(id52,parent).
smiles(id52,'clc1c(c(c(c(c1cl)cl)cl)cl)cl_').
%activity(id52,inactive).
atom(id52,a1,'C').
atom(id52,a2,'C').
atom(id52,a3,'C').
atom(id52,a4,'Cl').
atom(id52,a5,'C').
atom(id52,a6,'C').
atom(id52,a7,'C').
atom(id52,a8,'Cl').
atom(id52,a9,'Cl').
atom(id52,a10,'Cl').
atom(id52,a11,'Cl').
atom(id52,a12,'Cl').
bond(id52,a1,a2,single).
bond(id52,a2,a3,single).
bond(id52,a3,a5,single).
bond(id52,a5,a6,single).
bond(id52,a6,a7,single).
bond(id52,a1,a7,single).
bond(id52,a,a,double).
bond(id52,a,a,double).
bond(id52,a,a,double).
bond(id52,a,a,double).
bond(id52,a,a,double).
bond(id52,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 53
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id53,53).
dsstox_filename(id53,nctrer_v1a_232_23oct03).
activity_category_er_rba(id53,active_medium).
cas(id53,'140-66-9').
chemclass_erb(id53,phenols_alkyl).
chemcount(id53,'1').
chemname(id53,'4-t-octylphenol').
chemnote(id53,'unknown').
er_rba(id53,0.015).
f1_ring(id53,1).
f2_aromatic_ring(id53,1).
f3_phenolic_ring(id53,1).
f4_heteroatom(id53,0).
f5_phenol3nphenyl(id53,0).
f6_other_key_features(id53,0).
formula(id53,c14h22o).
log_er_rba(id53,-1.82).
logp(id53,5.28).
mean_er_rba_chemclass(id53,0.00088).
molweight(id53,206.3272).
structureshown(id53,tested_form).
substancetype(id53,defined_organic).
testedform(id53,parent).
smiles(id53,'c(c1ccc(cc1)o)(cc(c)(c)c)(c)c_').
%activity(id53,active).
atom(id53,a1,'C').
atom(id53,a2,'C').
atom(id53,a3,'C').
atom(id53,a4,'C').
atom(id53,a5,'C').
atom(id53,a6,'C').
atom(id53,a7,'C').
atom(id53,a8,'O').
atom(id53,a9,'C').
atom(id53,a10,'C').
atom(id53,a11,'C').
atom(id53,a12,'C').
atom(id53,a13,'C').
atom(id53,a14,'C').
atom(id53,a15,'C').
bond(id53,a1,a2,single).
bond(id53,a2,a3,double).
bond(id53,a3,a4,single).
bond(id53,a4,a5,double).
bond(id53,a5,a6,single).
bond(id53,a6,a7,double).
bond(id53,a2,a7,single).
bond(id53,a5,a8,single).
bond(id53,a1,a9,single).
bond(id53,a9,a10,single).
bond(id53,a10,a11,single).
bond(id53,a10,a12,single).
bond(id53,a10,a13,single).
bond(id53,a1,a14,single).
bond(id53,a1,a15,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 54
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id54,54).
dsstox_filename(id54,nctrer_v1a_232_23oct03).
activity_category_er_rba(id54,inactive).
cas(id54,'50471-44-8').
chemclass_erb(id54,misc).
chemcount(id54,'1').
chemname(id54,'vinclozolin').
chemnote(id54,'unknown').
er_rba(id54,0).
f1_ring(id54,1).
f2_aromatic_ring(id54,1).
f3_phenolic_ring(id54,0).
f4_heteroatom(id54,0).
f5_phenol3nphenyl(id54,0).
f6_other_key_features(id54,0).
formula(id54,c12h9cl2no3).
log_er_rba(id54,-10000).
logp(id54,3.03).
mean_er_rba_chemclass(id54,na).
molweight(id54,286.114).
structureshown(id54,tested_form).
substancetype(id54,defined_organic).
testedform(id54,parent).
smiles(id54,'n1(c(oc(c1=o)(c=c)c)=o)c1cc(cl)cc(c1)cl_').
%activity(id54,inactive).
atom(id54,a1,'N').
atom(id54,a2,'C').
atom(id54,a3,'O').
atom(id54,a4,'C').
atom(id54,a5,'C').
atom(id54,a6,'O').
atom(id54,a7,'C').
atom(id54,a8,'C').
atom(id54,a9,'C').
atom(id54,a10,'O').
atom(id54,a11,'C').
atom(id54,a12,'C').
atom(id54,a13,'C').
atom(id54,a14,'Cl').
atom(id54,a15,'C').
atom(id54,a16,'C').
atom(id54,a17,'C').
atom(id54,a18,'Cl').
bond(id54,a1,a2,single).
bond(id54,a2,a3,single).
bond(id54,a3,a4,single).
bond(id54,a4,a5,single).
bond(id54,a1,a5,single).
bond(id54,a5,a6,double).
bond(id54,a4,a7,single).
bond(id54,a7,a8,double).
bond(id54,a4,a9,single).
bond(id54,a2,a10,double).
bond(id54,a1,a11,single).
bond(id54,a11,a12,double).
bond(id54,a12,a13,single).
bond(id54,a13,a14,single).
bond(id54,a13,a15,double).
bond(id54,a15,a16,single).
bond(id54,a16,a17,double).
bond(id54,a11,a17,single).
bond(id54,a16,a18,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 55
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id55,55).
dsstox_filename(id55,nctrer_v1a_232_23oct03).
activity_category_er_rba(id55,active_strong).
cas(id55,'56-53-1').
chemclass_erb(id55,des_derivatives).
chemcount(id55,'1').
chemname(id55,'diethylstilbestrol_(des)').
chemnote(id55,'unknown').
er_rba(id55,398.1).
f1_ring(id55,1).
f2_aromatic_ring(id55,1).
f3_phenolic_ring(id55,1).
f4_heteroatom(id55,0).
f5_phenol3nphenyl(id55,1).
f6_other_key_features(id55,0).
formula(id55,c18h20o2).
log_er_rba(id55,2.6).
logp(id55,5.64).
mean_er_rba_chemclass(id55,2.14).
molweight(id55,268.3548).
structureshown(id55,tested_form).
substancetype(id55,defined_organic).
testedform(id55,parent).
smiles(id55,'c(=c(c1ccc(cc1)o)cc)(c1ccc(cc1)o)cc_').
%activity(id55,active).
atom(id55,a1,'C').
atom(id55,a2,'C').
atom(id55,a3,'C').
atom(id55,a4,'C').
atom(id55,a5,'C').
atom(id55,a6,'C').
atom(id55,a7,'C').
atom(id55,a8,'C').
atom(id55,a9,'O').
atom(id55,a10,'C').
atom(id55,a11,'C').
atom(id55,a12,'C').
atom(id55,a13,'C').
atom(id55,a14,'C').
atom(id55,a15,'C').
atom(id55,a16,'C').
atom(id55,a17,'C').
atom(id55,a18,'O').
atom(id55,a19,'C').
atom(id55,a20,'C').
bond(id55,a1,a2,double).
bond(id55,a2,a3,single).
bond(id55,a3,a4,single).
bond(id55,a4,a5,double).
bond(id55,a5,a6,single).
bond(id55,a6,a7,double).
bond(id55,a7,a8,single).
bond(id55,a3,a8,double).
bond(id55,a6,a9,single).
bond(id55,a2,a10,single).
bond(id55,a10,a11,single).
bond(id55,a1,a12,single).
bond(id55,a12,a13,double).
bond(id55,a13,a14,single).
bond(id55,a14,a15,double).
bond(id55,a15,a16,single).
bond(id55,a16,a17,double).
bond(id55,a12,a17,single).
bond(id55,a15,a18,single).
bond(id55,a1,a19,single).
bond(id55,a19,a20,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 56
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id56,56).
dsstox_filename(id56,nctrer_v1a_232_23oct03).
activity_category_er_rba(id56,active_weak).
cas(id56,'80-05-7').
chemclass_erb(id56,diphenylmethanes_diphenolalkanes).
chemcount(id56,'1').
chemname(id56,'bisphenol_a').
chemnote(id56,'unknown').
er_rba(id56,0.0078).
f1_ring(id56,1).
f2_aromatic_ring(id56,1).
f3_phenolic_ring(id56,1).
f4_heteroatom(id56,0).
f5_phenol3nphenyl(id56,1).
f6_other_key_features(id56,0).
formula(id56,c15h16o2).
log_er_rba(id56,-2.11).
logp(id56,3.64).
mean_er_rba_chemclass(id56,0.0087).
molweight(id56,228.2902).
structureshown(id56,tested_form).
substancetype(id56,defined_organic).
testedform(id56,parent).
smiles(id56,'c(c1ccc(cc1)o)(c1ccc(cc1)o)(c)c_').
%activity(id56,active).
atom(id56,a1,'C').
atom(id56,a2,'C').
atom(id56,a3,'C').
atom(id56,a4,'C').
atom(id56,a5,'C').
atom(id56,a6,'C').
atom(id56,a7,'C').
atom(id56,a8,'O').
atom(id56,a9,'C').
atom(id56,a10,'C').
atom(id56,a11,'C').
atom(id56,a12,'C').
atom(id56,a13,'C').
atom(id56,a14,'C').
atom(id56,a15,'O').
atom(id56,a16,'C').
atom(id56,a17,'C').
bond(id56,a1,a2,single).
bond(id56,a2,a3,single).
bond(id56,a3,a4,double).
bond(id56,a4,a5,single).
bond(id56,a5,a6,double).
bond(id56,a6,a7,single).
bond(id56,a2,a7,double).
bond(id56,a5,a8,single).
bond(id56,a1,a9,single).
bond(id56,a9,a10,double).
bond(id56,a10,a11,single).
bond(id56,a11,a12,double).
bond(id56,a12,a13,single).
bond(id56,a13,a14,double).
bond(id56,a9,a14,single).
bond(id56,a12,a15,single).
bond(id56,a1,a16,single).
bond(id56,a1,a17,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 57
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id57,57).
dsstox_filename(id57,nctrer_v1a_232_23oct03).
activity_category_er_rba(id57,active_weak).
cas(id57,'521-18-6').
chemclass_erb(id57,steroids_without_aromatic_a_ring).
chemcount(id57,'1_of_2').
chemname(id57,'5alpha_dihydrotestosterone').
chemnote(id57,'stereochem,_2d_replicate_of_beta_form_cas_[571-22-2]').
er_rba(id57,0.0013).
f1_ring(id57,1).
f2_aromatic_ring(id57,0).
f3_phenolic_ring(id57,0).
f4_heteroatom(id57,1).
f5_phenol3nphenyl(id57,0).
f6_other_key_features(id57,1).
formula(id57,c19h30o2).
log_er_rba(id57,-2.89).
logp(id57,3.07).
mean_er_rba_chemclass(id57,1.24).
molweight(id57,290.4448).
structureshown(id57,tested_form).
substancetype(id57,defined_organic).
testedform(id57,parent).
smiles(id57,'c1c2c3c(ccc2c2(c(c1)cc(cc2)=o)c)(c(cc3)o)c_').
%activity(id57,active).
atom(id57,a1,'C').
atom(id57,a2,'C').
atom(id57,a3,'C').
atom(id57,a4,'C').
atom(id57,a5,'C').
atom(id57,a6,'C').
atom(id57,a7,'C').
atom(id57,a8,'C').
atom(id57,a9,'C').
atom(id57,a10,'C').
atom(id57,a11,'C').
atom(id57,a12,'C').
atom(id57,a13,'C').
atom(id57,a14,'O').
atom(id57,a15,'C').
atom(id57,a16,'C').
atom(id57,a17,'C').
atom(id57,a18,'C').
atom(id57,a19,'O').
atom(id57,a20,'C').
atom(id57,a21,'H').
atom(id57,a22,'H').
atom(id57,a23,'H').
atom(id57,a24,'C').
atom(id57,a25,'H').
bond(id57,a1,a2,single).
bond(id57,a2,a3,single).
bond(id57,a3,a4,single).
bond(id57,a4,a5,single).
bond(id57,a5,a6,single).
bond(id57,a6,a7,single).
bond(id57,a7,a8,single).
bond(id57,a8,a9,single).
bond(id57,a9,a10,single).
bond(id57,a1,a10,single).
bond(id57,a3,a8,single).
bond(id57,a7,a11,single).
bond(id57,a11,a12,single).
bond(id57,a12,a13,single).
bond(id57,a13,a14,double).
bond(id57,a13,a15,single).
bond(id57,a6,a15,single).
bond(id57,a2,a16,single).
bond(id57,a16,a17,single).
bond(id57,a17,a18,single).
bond(id57,a1,a18,single).
bond(id57,a,a,double).
bond(id57,a,a,double).
bond(id57,a,a,double).
bond(id57,a,a,double).
bond(id57,a,a,double).
bond(id57,a,a,double).
bond(id57,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 58
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id58,58).
dsstox_filename(id58,nctrer_v1a_232_23oct03).
activity_category_er_rba(id58,active_strong).
cas(id58,'50-28-2').
chemclass_erb(id58,steroids_with_aromatic_a_ring).
chemcount(id58,'1_of_2').
chemname(id58,'17beta_estradiol_(e2)').
chemnote(id58,'stereochem,_2d_replicate_of_alpha_form_cas_[57-91-0]').
er_rba(id58,100).
f1_ring(id58,1).
f2_aromatic_ring(id58,1).
f3_phenolic_ring(id58,1).
f4_heteroatom(id58,0).
f5_phenol3nphenyl(id58,0).
f6_other_key_features(id58,1).
formula(id58,c18h24o2).
log_er_rba(id58,2).
logp(id58,3.94).
mean_er_rba_chemclass(id58,1.24).
molweight(id58,272.3864).
structureshown(id58,tested_form).
substancetype(id58,defined_organic).
testedform(id58,parent).
smiles(id58,'c1c2c3c(ccc2c2c(c1)cc(cc2)o)(c(cc3)o)c_').
%activity(id58,active).
atom(id58,a1,'C').
atom(id58,a2,'C').
atom(id58,a3,'C').
atom(id58,a4,'C').
atom(id58,a5,'C').
atom(id58,a6,'C').
atom(id58,a7,'C').
atom(id58,a8,'C').
atom(id58,a9,'C').
atom(id58,a10,'C').
atom(id58,a11,'C').
atom(id58,a12,'C').
atom(id58,a13,'C').
atom(id58,a14,'O').
atom(id58,a15,'C').
atom(id58,a16,'C').
atom(id58,a17,'C').
atom(id58,a18,'C').
atom(id58,a19,'O').
atom(id58,a20,'C').
atom(id58,a21,'H').
atom(id58,a22,'H').
atom(id58,a23,'H').
bond(id58,a1,a2,single).
bond(id58,a2,a3,single).
bond(id58,a3,a4,single).
bond(id58,a4,a5,single).
bond(id58,a5,a6,single).
bond(id58,a6,a7,double).
bond(id58,a7,a8,single).
bond(id58,a8,a9,single).
bond(id58,a9,a10,single).
bond(id58,a1,a10,single).
bond(id58,a3,a8,single).
bond(id58,a7,a11,single).
bond(id58,a11,a12,double).
bond(id58,a12,a13,single).
bond(id58,a13,a14,single).
bond(id58,a13,a15,double).
bond(id58,a6,a15,single).
bond(id58,a2,a16,single).
bond(id58,a16,a17,single).
bond(id58,a17,a18,single).
bond(id58,a1,a18,single).
bond(id58,a,a,double).
bond(id58,a,a,double).
bond(id58,a,a,double).
bond(id58,a,a,double).
bond(id58,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 59
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id59,59).
dsstox_filename(id59,nctrer_v1a_232_23oct03).
activity_category_er_rba(id59,active_strong).
cas(id59,'50-27-1').
chemclass_erb(id59,steroids_with_aromatic_a_ring).
chemcount(id59,'1').
chemname(id59,'estriol').
chemnote(id59,'stereochem').
er_rba(id59,9.77).
f1_ring(id59,1).
f2_aromatic_ring(id59,1).
f3_phenolic_ring(id59,1).
f4_heteroatom(id59,0).
f5_phenol3nphenyl(id59,0).
f6_other_key_features(id59,1).
formula(id59,c18h24o3).
log_er_rba(id59,0.99).
logp(id59,2.81).
mean_er_rba_chemclass(id59,1.24).
molweight(id59,288.3858).
structureshown(id59,tested_form).
substancetype(id59,defined_organic).
testedform(id59,parent).
smiles(id59,'c1c2c3c(ccc2c2c(c1)cc(cc2)o)(c(c(c3)o)o)c_').
%activity(id59,active).
atom(id59,a1,'C').
atom(id59,a2,'C').
atom(id59,a3,'C').
atom(id59,a4,'C').
atom(id59,a5,'C').
atom(id59,a6,'C').
atom(id59,a7,'C').
atom(id59,a8,'C').
atom(id59,a9,'C').
atom(id59,a10,'C').
atom(id59,a11,'C').
atom(id59,a12,'C').
atom(id59,a13,'C').
atom(id59,a14,'O').
atom(id59,a15,'C').
atom(id59,a16,'C').
atom(id59,a17,'C').
atom(id59,a18,'C').
atom(id59,a19,'O').
atom(id59,a20,'C').
atom(id59,a21,'H').
atom(id59,a22,'O').
atom(id59,a23,'H').
atom(id59,a24,'H').
bond(id59,a1,a2,single).
bond(id59,a2,a3,single).
bond(id59,a3,a4,single).
bond(id59,a4,a5,single).
bond(id59,a5,a6,single).
bond(id59,a6,a7,double).
bond(id59,a7,a8,single).
bond(id59,a8,a9,single).
bond(id59,a9,a10,single).
bond(id59,a1,a10,single).
bond(id59,a3,a8,single).
bond(id59,a7,a11,single).
bond(id59,a11,a12,double).
bond(id59,a12,a13,single).
bond(id59,a13,a14,single).
bond(id59,a13,a15,double).
bond(id59,a6,a15,single).
bond(id59,a2,a16,single).
bond(id59,a16,a17,single).
bond(id59,a17,a18,single).
bond(id59,a1,a18,single).
bond(id59,a,a,double).
bond(id59,a,a,double).
bond(id59,a,a,double).
bond(id59,a,a,double).
bond(id59,a,a,double).
bond(id59,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 60
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id60,60).
dsstox_filename(id60,nctrer_v1a_232_23oct03).
activity_category_er_rba(id60,active_strong).
cas(id60,'53-16-7').
chemclass_erb(id60,steroids_with_aromatic_a_ring).
chemcount(id60,'1').
chemname(id60,'estrone').
chemnote(id60,'stereochem').
er_rba(id60,7.24).
f1_ring(id60,1).
f2_aromatic_ring(id60,1).
f3_phenolic_ring(id60,1).
f4_heteroatom(id60,0).
f5_phenol3nphenyl(id60,0).
f6_other_key_features(id60,1).
formula(id60,c18h22o2).
log_er_rba(id60,0.86).
logp(id60,3.43).
mean_er_rba_chemclass(id60,1.24).
molweight(id60,270.3706).
structureshown(id60,tested_form).
substancetype(id60,defined_organic).
testedform(id60,parent).
smiles(id60,'c1c2c3c(ccc2c2c(c1)cc(cc2)o)(c(cc3)=o)c_').
%activity(id60,active).
atom(id60,a1,'C').
atom(id60,a2,'C').
atom(id60,a3,'C').
atom(id60,a4,'C').
atom(id60,a5,'C').
atom(id60,a6,'C').
atom(id60,a7,'C').
atom(id60,a8,'C').
atom(id60,a9,'C').
atom(id60,a10,'C').
atom(id60,a11,'C').
atom(id60,a12,'C').
atom(id60,a13,'C').
atom(id60,a14,'O').
atom(id60,a15,'C').
atom(id60,a16,'C').
atom(id60,a17,'C').
atom(id60,a18,'C').
atom(id60,a19,'O').
atom(id60,a20,'C').
atom(id60,a21,'H').
atom(id60,a22,'H').
atom(id60,a23,'H').
bond(id60,a1,a2,single).
bond(id60,a2,a3,single).
bond(id60,a3,a4,single).
bond(id60,a4,a5,single).
bond(id60,a5,a6,single).
bond(id60,a6,a7,double).
bond(id60,a7,a8,single).
bond(id60,a8,a9,single).
bond(id60,a9,a10,single).
bond(id60,a1,a10,single).
bond(id60,a3,a8,single).
bond(id60,a7,a11,single).
bond(id60,a11,a12,double).
bond(id60,a12,a13,single).
bond(id60,a13,a14,single).
bond(id60,a13,a15,double).
bond(id60,a6,a15,single).
bond(id60,a2,a16,single).
bond(id60,a16,a17,single).
bond(id60,a17,a18,single).
bond(id60,a1,a18,single).
bond(id60,a18,a19,double).
bond(id60,a,a,double).
bond(id60,a,a,double).
bond(id60,a,a,double).
bond(id60,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 61
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id61,61).
dsstox_filename(id61,nctrer_v1a_232_23oct03).
activity_category_er_rba(id61,active_strong).
cas(id61,'57-63-6').
chemclass_erb(id61,steroids_with_aromatic_a_ring).
chemcount(id61,'1').
chemname(id61,'ethynyl_estradiol').
chemnote(id61,'stereochem').
er_rba(id61,190.5).
f1_ring(id61,1).
f2_aromatic_ring(id61,1).
f3_phenolic_ring(id61,1).
f4_heteroatom(id61,0).
f5_phenol3nphenyl(id61,0).
f6_other_key_features(id61,1).
formula(id61,c20h24o2).
log_er_rba(id61,2.28).
logp(id61,4.12).
mean_er_rba_chemclass(id61,1.24).
molweight(id61,296.4084).
structureshown(id61,tested_form).
substancetype(id61,defined_organic).
testedform(id61,parent).
smiles(id61,'c1c2c3c(ccc2c2c(c1)cc(cc2)o)(c(cc3)(o)c#c)c_').
%activity(id61,active).
atom(id61,a1,'C').
atom(id61,a2,'C').
atom(id61,a3,'C').
atom(id61,a4,'C').
atom(id61,a5,'C').
atom(id61,a6,'C').
atom(id61,a7,'C').
atom(id61,a8,'C').
atom(id61,a9,'C').
atom(id61,a10,'C').
atom(id61,a11,'C').
atom(id61,a12,'C').
atom(id61,a13,'C').
atom(id61,a14,'O').
atom(id61,a15,'C').
atom(id61,a16,'C').
atom(id61,a17,'C').
atom(id61,a18,'C').
atom(id61,a19,'O').
atom(id61,a20,'C').
atom(id61,a21,'H').
atom(id61,a22,'H').
atom(id61,a23,'H').
atom(id61,a24,'C').
atom(id61,a25,'C').
bond(id61,a1,a2,single).
bond(id61,a2,a3,single).
bond(id61,a3,a4,single).
bond(id61,a4,a5,single).
bond(id61,a5,a6,single).
bond(id61,a6,a7,double).
bond(id61,a7,a8,single).
bond(id61,a8,a9,single).
bond(id61,a9,a10,single).
bond(id61,a1,a10,single).
bond(id61,a3,a8,single).
bond(id61,a7,a11,single).
bond(id61,a11,a12,double).
bond(id61,a12,a13,single).
bond(id61,a13,a14,single).
bond(id61,a13,a15,double).
bond(id61,a6,a15,single).
bond(id61,a2,a16,single).
bond(id61,a16,a17,single).
bond(id61,a17,a18,single).
bond(id61,a1,a18,single).
bond(id61,a24,a25,double).
bond(id61,a,a,double).
bond(id61,a,a,double).
bond(id61,a,a,double).
bond(id61,a,a,double).
bond(id61,a,a,double).
bond(id61,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 62
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id62,62).
dsstox_filename(id62,nctrer_v1a_232_23oct03).
activity_category_er_rba(id62,active_strong).
cas(id62,'129453-61-8').
chemclass_erb(id62,steroids_with_aromatic_a_ring).
chemcount(id62,'1').
chemname(id62,'ici_182780').
chemnote(id62,'stereochem').
er_rba(id62,37.15).
f1_ring(id62,1).
f2_aromatic_ring(id62,1).
f3_phenolic_ring(id62,1).
f4_heteroatom(id62,0).
f5_phenol3nphenyl(id62,0).
f6_other_key_features(id62,1).
formula(id62,c32h47f5o3s).
log_er_rba(id62,1.57).
logp(id62,9.09).
mean_er_rba_chemclass(id62,1.24).
molweight(id62,606.7735).
structureshown(id62,tested_form).
substancetype(id62,defined_organic).
testedform(id62,parent).
smiles(id62,'c(cccccccc[s@@](=o)cccc(c(f)(f)f)(f)f)c1c2c3c(ccc2c2c(c1)cc(cc2)o)(c(cc3)o)c_').
%activity(id62,active).
atom(id62,a1,'C').
atom(id62,a2,'C').
atom(id62,a3,'C').
atom(id62,a4,'C').
atom(id62,a5,'C').
atom(id62,a6,'C').
atom(id62,a7,'C').
atom(id62,a8,'C').
atom(id62,a9,'C').
atom(id62,a10,'S').
atom(id62,a11,'O').
atom(id62,a12,'C').
atom(id62,a13,'C').
atom(id62,a14,'C').
atom(id62,a15,'C').
atom(id62,a16,'C').
atom(id62,a17,'F').
atom(id62,a18,'F').
atom(id62,a19,'F').
atom(id62,a20,'F').
atom(id62,a21,'F').
atom(id62,a22,'C').
atom(id62,a23,'C').
atom(id62,a24,'C').
atom(id62,a25,'C').
atom(id62,a26,'C').
atom(id62,a27,'C').
atom(id62,a28,'C').
atom(id62,a29,'C').
atom(id62,a30,'C').
atom(id62,a31,'C').
atom(id62,a32,'C').
atom(id62,a33,'C').
atom(id62,a34,'C').
atom(id62,a35,'O').
atom(id62,a36,'C').
atom(id62,a37,'C').
atom(id62,a38,'C').
atom(id62,a39,'C').
atom(id62,a40,'O').
atom(id62,a41,'C').
atom(id62,a42,'H').
atom(id62,a43,'H').
atom(id62,a44,'H').
bond(id62,a1,a2,single).
bond(id62,a2,a3,single).
bond(id62,a3,a4,single).
bond(id62,a4,a5,single).
bond(id62,a5,a6,single).
bond(id62,a6,a7,single).
bond(id62,a7,a8,single).
bond(id62,a8,a9,single).
bond(id62,a9,a10,single).
bond(id62,a10,a11,double).
bond(id62,a10,a12,single).
bond(id62,a12,a13,single).
bond(id62,a13,a14,single).
bond(id62,a14,a15,single).
bond(id62,a15,a16,single).
bond(id62,a16,a17,single).
bond(id62,a16,a18,single).
bond(id62,a16,a19,single).
bond(id62,a15,a20,single).
bond(id62,a15,a21,single).
bond(id62,a22,a23,single).
bond(id62,a23,a24,single).
bond(id62,a24,a25,single).
bond(id62,a25,a26,single).
bond(id62,a26,a27,single).
bond(id62,a27,a28,double).
bond(id62,a28,a29,single).
bond(id62,a29,a30,single).
bond(id62,a30,a31,single).
bond(id62,a22,a31,single).
bond(id62,a24,a29,single).
bond(id62,a28,a32,single).
bond(id62,a32,a33,double).
bond(id62,a33,a34,single).
bond(id62,a34,a35,single).
bond(id62,a34,a36,double).
bond(id62,a27,a36,single).
bond(id62,a23,a37,single).
bond(id62,a37,a38,single).
bond(id62,a38,a39,single).
bond(id62,a22,a39,single).
bond(id62,a25,a1,single).
bond(id62,a,a,double).
bond(id62,a,a,double).
bond(id62,a,a,double).
bond(id62,a,a,double).
bond(id62,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 63
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id63,63).
dsstox_filename(id63,nctrer_v1a_232_23oct03).
activity_category_er_rba(id63,inactive).
cas(id63,'57-83-0').
chemclass_erb(id63,steroids_without_aromatic_a_ring).
chemcount(id63,'1').
chemname(id63,'progesterone').
chemnote(id63,'stereochem').
er_rba(id63,0).
f1_ring(id63,1).
f2_aromatic_ring(id63,0).
f3_phenolic_ring(id63,0).
f4_heteroatom(id63,1).
f5_phenol3nphenyl(id63,0).
f6_other_key_features(id63,1).
formula(id63,c21h30o2).
log_er_rba(id63,-10000).
logp(id63,3.67).
mean_er_rba_chemclass(id63,1.24).
molweight(id63,314.4668).
structureshown(id63,tested_form).
substancetype(id63,defined_organic).
testedform(id63,parent).
smiles(id63,'c1c2c3c(ccc2c2(c(c1)=cc(cc2)=o)c)(c(cc3)c(=o)c)c_').
%activity(id63,inactive).
atom(id63,a1,'C').
atom(id63,a2,'C').
atom(id63,a3,'C').
atom(id63,a4,'C').
atom(id63,a5,'C').
atom(id63,a6,'C').
atom(id63,a7,'C').
atom(id63,a8,'C').
atom(id63,a9,'C').
atom(id63,a10,'C').
atom(id63,a11,'C').
atom(id63,a12,'C').
atom(id63,a13,'C').
atom(id63,a14,'O').
atom(id63,a15,'C').
atom(id63,a16,'C').
atom(id63,a17,'C').
atom(id63,a18,'C').
atom(id63,a19,'C').
atom(id63,a20,'C').
atom(id63,a21,'H').
atom(id63,a22,'H').
atom(id63,a23,'H').
atom(id63,a24,'C').
atom(id63,a25,'O').
atom(id63,a26,'C').
bond(id63,a1,a2,single).
bond(id63,a2,a3,single).
bond(id63,a3,a4,single).
bond(id63,a4,a5,single).
bond(id63,a5,a6,single).
bond(id63,a6,a7,single).
bond(id63,a7,a8,single).
bond(id63,a8,a9,single).
bond(id63,a9,a10,single).
bond(id63,a1,a10,single).
bond(id63,a3,a8,single).
bond(id63,a7,a11,single).
bond(id63,a11,a12,single).
bond(id63,a12,a13,single).
bond(id63,a13,a14,double).
bond(id63,a13,a15,single).
bond(id63,a6,a15,double).
bond(id63,a2,a16,single).
bond(id63,a16,a17,single).
bond(id63,a17,a18,single).
bond(id63,a1,a18,single).
bond(id63,a19,a25,double).
bond(id63,a19,a26,single).
bond(id63,a,a,double).
bond(id63,a,a,double).
bond(id63,a,a,double).
bond(id63,a,a,double).
bond(id63,a,a,double).
bond(id63,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 64
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id64,64).
dsstox_filename(id64,nctrer_v1a_232_23oct03).
activity_category_er_rba(id64,inactive).
cas(id64,'58-22-0').
chemclass_erb(id64,steroids_without_aromatic_a_ring).
chemcount(id64,'2_of_2').
chemname(id64,'beta_testosterone').
chemnote(id64,'stereochem,_2d_replicate_of_alpha_form_cas_[481-30-1]').
er_rba(id64,0).
f1_ring(id64,1).
f2_aromatic_ring(id64,0).
f3_phenolic_ring(id64,0).
f4_heteroatom(id64,1).
f5_phenol3nphenyl(id64,0).
f6_other_key_features(id64,1).
formula(id64,c19h28o2).
log_er_rba(id64,-10000).
logp(id64,3.27).
mean_er_rba_chemclass(id64,1.24).
molweight(id64,288.429).
structureshown(id64,tested_form).
substancetype(id64,defined_organic).
testedform(id64,parent).
smiles(id64,'c1c2c3c(ccc2c2(c(c1)=cc(cc2)=o)c)(c(cc3)o)c_').
%activity(id64,inactive).
atom(id64,a1,'C').
atom(id64,a2,'C').
atom(id64,a3,'C').
atom(id64,a4,'C').
atom(id64,a5,'C').
atom(id64,a6,'C').
atom(id64,a7,'C').
atom(id64,a8,'C').
atom(id64,a9,'C').
atom(id64,a10,'C').
atom(id64,a11,'C').
atom(id64,a12,'C').
atom(id64,a13,'C').
atom(id64,a14,'O').
atom(id64,a15,'C').
atom(id64,a16,'C').
atom(id64,a17,'C').
atom(id64,a18,'C').
atom(id64,a19,'O').
atom(id64,a20,'C').
atom(id64,a21,'H').
atom(id64,a22,'H').
atom(id64,a23,'H').
atom(id64,a24,'C').
bond(id64,a1,a2,single).
bond(id64,a2,a3,single).
bond(id64,a3,a4,single).
bond(id64,a4,a5,single).
bond(id64,a5,a6,single).
bond(id64,a6,a7,single).
bond(id64,a7,a8,single).
bond(id64,a8,a9,single).
bond(id64,a9,a10,single).
bond(id64,a1,a10,single).
bond(id64,a3,a8,single).
bond(id64,a7,a11,single).
bond(id64,a11,a12,single).
bond(id64,a12,a13,single).
bond(id64,a13,a14,double).
bond(id64,a13,a15,single).
bond(id64,a6,a15,double).
bond(id64,a2,a16,single).
bond(id64,a16,a17,single).
bond(id64,a17,a18,single).
bond(id64,a1,a18,single).
bond(id64,a,a,double).
bond(id64,a,a,double).
bond(id64,a,a,double).
bond(id64,a,a,double).
bond(id64,a,a,double).
bond(id64,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 65
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id65,65).
dsstox_filename(id65,nctrer_v1a_232_23oct03).
activity_category_er_rba(id65,active_strong).
cas(id65,'362-05-0').
chemclass_erb(id65,steroids_with_aromatic_a_ring).
chemcount(id65,'1').
chemname(id65,'2-hydroxy-estradiol').
chemnote(id65,'stereochem').
er_rba(id65,29.51).
f1_ring(id65,1).
f2_aromatic_ring(id65,1).
f3_phenolic_ring(id65,1).
f4_heteroatom(id65,0).
f5_phenol3nphenyl(id65,0).
f6_other_key_features(id65,1).
formula(id65,c18h24o3).
log_er_rba(id65,1.47).
logp(id65,3.46).
mean_er_rba_chemclass(id65,1.24).
molweight(id65,288.3858).
structureshown(id65,tested_form).
substancetype(id65,defined_organic).
testedform(id65,parent).
smiles(id65,'c1c2c3c(ccc2c2c(c1)cc(c(c2)o)o)(c(cc3)o)c_').
%activity(id65,active).
atom(id65,a1,'C').
atom(id65,a2,'C').
atom(id65,a3,'C').
atom(id65,a4,'C').
atom(id65,a5,'C').
atom(id65,a6,'C').
atom(id65,a7,'C').
atom(id65,a8,'C').
atom(id65,a9,'C').
atom(id65,a10,'C').
atom(id65,a11,'C').
atom(id65,a12,'C').
atom(id65,a13,'C').
atom(id65,a14,'O').
atom(id65,a15,'C').
atom(id65,a16,'C').
atom(id65,a17,'C').
atom(id65,a18,'C').
atom(id65,a19,'O').
atom(id65,a20,'C').
atom(id65,a21,'H').
atom(id65,a22,'H').
atom(id65,a23,'H').
atom(id65,a24,'O').
bond(id65,a1,a2,single).
bond(id65,a2,a3,single).
bond(id65,a3,a4,single).
bond(id65,a4,a5,single).
bond(id65,a5,a6,single).
bond(id65,a6,a7,double).
bond(id65,a7,a8,single).
bond(id65,a8,a9,single).
bond(id65,a9,a10,single).
bond(id65,a1,a10,single).
bond(id65,a3,a8,single).
bond(id65,a7,a11,single).
bond(id65,a11,a12,double).
bond(id65,a12,a13,single).
bond(id65,a13,a14,single).
bond(id65,a13,a15,double).
bond(id65,a6,a15,single).
bond(id65,a2,a16,single).
bond(id65,a16,a17,single).
bond(id65,a17,a18,single).
bond(id65,a1,a18,single).
bond(id65,a12,a24,single).
bond(id65,a,a,double).
bond(id65,a,a,double).
bond(id65,a,a,double).
bond(id65,a,a,double).
bond(id65,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 66
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id66,66).
dsstox_filename(id66,nctrer_v1a_232_23oct03).
activity_category_er_rba(id66,active_medium).
cas(id66,'25154-52-3').
chemclass_erb(id66,phenols_alkyl).
chemcount(id66,'1').
chemname(id66,'nonylphenol').
chemnote(id66,'unknown').
er_rba(id66,0.0295).
f1_ring(id66,1).
f2_aromatic_ring(id66,1).
f3_phenolic_ring(id66,1).
f4_heteroatom(id66,0).
f5_phenol3nphenyl(id66,0).
f6_other_key_features(id66,1).
formula(id66,c15h24o).
log_er_rba(id66,-1.53).
logp(id66,5.99).
mean_er_rba_chemclass(id66,0.00088).
molweight(id66,220.354).
structureshown(id66,tested_form).
substancetype(id66,defined_organic).
testedform(id66,parent).
smiles(id66,'c1(ccc(cc1)ccccccccc)o_').
%activity(id66,active).
atom(id66,a1,'C').
atom(id66,a2,'C').
atom(id66,a3,'C').
atom(id66,a4,'C').
atom(id66,a5,'C').
atom(id66,a6,'C').
atom(id66,a7,'C').
atom(id66,a8,'C').
atom(id66,a9,'C').
atom(id66,a10,'C').
atom(id66,a11,'C').
atom(id66,a12,'C').
atom(id66,a13,'C').
atom(id66,a14,'C').
atom(id66,a15,'C').
atom(id66,a16,'O').
bond(id66,a1,a2,double).
bond(id66,a2,a3,single).
bond(id66,a3,a4,double).
bond(id66,a4,a5,single).
bond(id66,a5,a6,double).
bond(id66,a1,a6,single).
bond(id66,a4,a7,single).
bond(id66,a7,a8,single).
bond(id66,a8,a9,single).
bond(id66,a9,a10,single).
bond(id66,a10,a11,single).
bond(id66,a11,a12,single).
bond(id66,a12,a13,single).
bond(id66,a13,a14,single).
bond(id66,a14,a15,single).
bond(id66,a1,a16,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 67
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id67,67).
dsstox_filename(id67,nctrer_v1a_232_23oct03).
activity_category_er_rba(id67,active_strong).
cas(id67,'5976-61-4').
chemclass_erb(id67,steroids_with_aromatic_a_ring).
chemcount(id67,'1').
chemname(id67,'4-hydroxy-estradiol').
chemnote(id67,'stereochem').
er_rba(id67,66.07).
f1_ring(id67,1).
f2_aromatic_ring(id67,1).
f3_phenolic_ring(id67,1).
f4_heteroatom(id67,0).
f5_phenol3nphenyl(id67,0).
f6_other_key_features(id67,1).
formula(id67,c18h24o3).
log_er_rba(id67,1.82).
logp(id67,3.46).
mean_er_rba_chemclass(id67,1.24).
molweight(id67,288.3858).
structureshown(id67,tested_form).
substancetype(id67,defined_organic).
testedform(id67,parent).
smiles(id67,'c1c2c3c(ccc2c2c(c1)c(c(cc2)o)o)(c(cc3)o)c_').
%activity(id67,active).
atom(id67,a1,'C').
atom(id67,a2,'C').
atom(id67,a3,'C').
atom(id67,a4,'C').
atom(id67,a5,'C').
atom(id67,a6,'C').
atom(id67,a7,'C').
atom(id67,a8,'C').
atom(id67,a9,'C').
atom(id67,a10,'C').
atom(id67,a11,'C').
atom(id67,a12,'C').
atom(id67,a13,'C').
atom(id67,a14,'O').
atom(id67,a15,'C').
atom(id67,a16,'C').
atom(id67,a17,'C').
atom(id67,a18,'C').
atom(id67,a19,'O').
atom(id67,a20,'C').
atom(id67,a21,'H').
atom(id67,a22,'H').
atom(id67,a23,'H').
atom(id67,a24,'O').
bond(id67,a1,a2,single).
bond(id67,a2,a3,single).
bond(id67,a3,a4,single).
bond(id67,a4,a5,single).
bond(id67,a5,a6,single).
bond(id67,a6,a7,double).
bond(id67,a7,a8,single).
bond(id67,a8,a9,single).
bond(id67,a9,a10,single).
bond(id67,a1,a10,single).
bond(id67,a3,a8,single).
bond(id67,a7,a11,single).
bond(id67,a11,a12,double).
bond(id67,a12,a13,single).
bond(id67,a13,a14,single).
bond(id67,a13,a15,double).
bond(id67,a6,a15,single).
bond(id67,a2,a16,single).
bond(id67,a16,a17,single).
bond(id67,a17,a18,single).
bond(id67,a1,a18,single).
bond(id67,a15,a24,single).
bond(id67,a,a,double).
bond(id67,a,a,double).
bond(id67,a,a,double).
bond(id67,a,a,double).
bond(id67,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 68
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id68,68).
dsstox_filename(id68,nctrer_v1a_232_23oct03).
activity_category_er_rba(id68,active_strong).
cas(id68,'34816-55-2').
chemclass_erb(id68,steroids_with_aromatic_a_ring).
chemcount(id68,'1').
chemname(id68,'moxestrol').
chemnote(id68,'incorrect_structure_listed_in_fig_1_of_main_citation').
er_rba(id68,13.8).
f1_ring(id68,1).
f2_aromatic_ring(id68,1).
f3_phenolic_ring(id68,1).
f4_heteroatom(id68,0).
f5_phenol3nphenyl(id68,0).
f6_other_key_features(id68,1).
formula(id68,c21h26o3).
log_er_rba(id68,1.14).
logp(id68,3.28).
mean_er_rba_chemclass(id68,1.24).
molweight(id68,326.4346).
structureshown(id68,tested_form).
substancetype(id68,defined_organic).
testedform(id68,parent).
smiles(id68,'c1c2c3c(cc(c2c2c(c1)cc(cc2)o)oc)(c(cc3)(o)c#c)c_').
%activity(id68,active).
atom(id68,a1,'C').
atom(id68,a2,'C').
atom(id68,a3,'C').
atom(id68,a4,'C').
atom(id68,a5,'C').
atom(id68,a6,'C').
atom(id68,a7,'C').
atom(id68,a8,'C').
atom(id68,a9,'C').
atom(id68,a10,'C').
atom(id68,a11,'C').
atom(id68,a12,'C').
atom(id68,a13,'C').
atom(id68,a14,'O').
atom(id68,a15,'C').
atom(id68,a16,'C').
atom(id68,a17,'C').
atom(id68,a18,'C').
atom(id68,a19,'O').
atom(id68,a20,'C').
atom(id68,a21,'C').
atom(id68,a22,'C').
atom(id68,a23,'O').
atom(id68,a24,'C').
bond(id68,a1,a2,single).
bond(id68,a2,a3,single).
bond(id68,a3,a4,single).
bond(id68,a4,a5,single).
bond(id68,a5,a6,single).
bond(id68,a6,a7,double).
bond(id68,a7,a8,single).
bond(id68,a8,a9,single).
bond(id68,a9,a10,single).
bond(id68,a1,a10,single).
bond(id68,a3,a8,single).
bond(id68,a7,a11,single).
bond(id68,a11,a12,double).
bond(id68,a12,a13,single).
bond(id68,a13,a14,single).
bond(id68,a13,a15,double).
bond(id68,a6,a15,single).
bond(id68,a2,a16,single).
bond(id68,a16,a17,single).
bond(id68,a17,a18,single).
bond(id68,a1,a18,single).
bond(id68,a18,a19,single).
bond(id68,a1,a20,single).
bond(id68,a9,a23,single).
bond(id68,a18,a21,single).
bond(id68,a21,a22,double).
bond(id68,a23,a24,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 69
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id69,69).
dsstox_filename(id69,nctrer_v1a_232_23oct03).
activity_category_er_rba(id69,active_strong).
cas(id69,'98007-99-9').
chemclass_erb(id69,steroids_with_aromatic_a_ring).
chemcount(id69,'1').
chemname(id69,'ici_164384').
chemnote(id69,'stereochem').
er_rba(id69,14.45).
f1_ring(id69,1).
f2_aromatic_ring(id69,1).
f3_phenolic_ring(id69,1).
f4_heteroatom(id69,0).
f5_phenol3nphenyl(id69,0).
f6_other_key_features(id69,1).
formula(id69,c34h55no3).
log_er_rba(id69,1.16).
logp(id69,8.94).
mean_er_rba_chemclass(id69,1.24).
molweight(id69,525.8134).
structureshown(id69,tested_form).
substancetype(id69,defined_organic).
testedform(id69,parent).
smiles(id69,'c(cccccccccc(n(cccc)c)=o)c1c2c3c(ccc2c2c(c1)cc(cc2)o)(c(cc3)o)c_').
%activity(id69,active).
atom(id69,a1,'C').
atom(id69,a2,'C').
atom(id69,a3,'C').
atom(id69,a4,'C').
atom(id69,a5,'C').
atom(id69,a6,'C').
atom(id69,a7,'C').
atom(id69,a8,'C').
atom(id69,a9,'C').
atom(id69,a10,'C').
atom(id69,a11,'C').
atom(id69,a12,'N').
atom(id69,a13,'C').
atom(id69,a14,'C').
atom(id69,a15,'C').
atom(id69,a16,'C').
atom(id69,a17,'C').
atom(id69,a18,'O').
atom(id69,a19,'C').
atom(id69,a20,'C').
atom(id69,a21,'C').
atom(id69,a22,'C').
atom(id69,a23,'C').
atom(id69,a24,'C').
atom(id69,a25,'C').
atom(id69,a26,'C').
atom(id69,a27,'C').
atom(id69,a28,'C').
atom(id69,a29,'C').
atom(id69,a30,'C').
atom(id69,a31,'C').
atom(id69,a32,'O').
atom(id69,a33,'C').
atom(id69,a34,'C').
atom(id69,a35,'C').
atom(id69,a36,'C').
atom(id69,a37,'O').
atom(id69,a38,'C').
atom(id69,a39,'H').
atom(id69,a40,'H').
atom(id69,a41,'H').
bond(id69,a1,a2,single).
bond(id69,a2,a3,single).
bond(id69,a3,a4,single).
bond(id69,a4,a5,single).
bond(id69,a5,a6,single).
bond(id69,a6,a7,single).
bond(id69,a7,a8,single).
bond(id69,a8,a9,single).
bond(id69,a9,a10,single).
bond(id69,a10,a11,single).
bond(id69,a11,a12,single).
bond(id69,a12,a13,single).
bond(id69,a13,a14,single).
bond(id69,a14,a15,single).
bond(id69,a15,a16,single).
bond(id69,a12,a17,single).
bond(id69,a11,a18,double).
bond(id69,a19,a20,single).
bond(id69,a20,a21,single).
bond(id69,a21,a22,single).
bond(id69,a22,a23,single).
bond(id69,a23,a24,single).
bond(id69,a24,a25,double).
bond(id69,a25,a26,single).
bond(id69,a26,a27,single).
bond(id69,a27,a28,single).
bond(id69,a19,a28,single).
bond(id69,a21,a26,single).
bond(id69,a25,a29,single).
bond(id69,a29,a30,double).
bond(id69,a30,a31,single).
bond(id69,a31,a32,single).
bond(id69,a31,a33,double).
bond(id69,a24,a33,single).
bond(id69,a20,a34,single).
bond(id69,a34,a35,single).
bond(id69,a35,a36,single).
bond(id69,a19,a36,single).
bond(id69,a22,a1,single).
bond(id69,a,a,double).
bond(id69,a,a,double).
bond(id69,a,a,double).
bond(id69,a,a,double).
bond(id69,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 70
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id70,70).
dsstox_filename(id70,nctrer_v1a_232_23oct03).
activity_category_er_rba(id70,active_strong).
cas(id70,'57-91-0').
chemclass_erb(id70,steroids_with_aromatic_a_ring).
chemcount(id70,'2_of_2').
chemname(id70,'17alpha_estradiol').
chemnote(id70,'stereochem,_2d_replicate_of_beta_form_cas_[50-28-2]').
er_rba(id70,3.09).
f1_ring(id70,1).
f2_aromatic_ring(id70,1).
f3_phenolic_ring(id70,1).
f4_heteroatom(id70,0).
f5_phenol3nphenyl(id70,0).
f6_other_key_features(id70,1).
formula(id70,c18h24o2).
log_er_rba(id70,0.49).
logp(id70,3.94).
mean_er_rba_chemclass(id70,1.24).
molweight(id70,272.3864).
structureshown(id70,tested_form).
substancetype(id70,defined_organic).
testedform(id70,parent).
smiles(id70,'c1c2c3c(ccc2c2c(c1)cc(cc2)o)(c(cc3)o)c_').
%activity(id70,active).
atom(id70,a1,'C').
atom(id70,a2,'C').
atom(id70,a3,'C').
atom(id70,a4,'C').
atom(id70,a5,'C').
atom(id70,a6,'C').
atom(id70,a7,'C').
atom(id70,a8,'C').
atom(id70,a9,'C').
atom(id70,a10,'C').
atom(id70,a11,'C').
atom(id70,a12,'C').
atom(id70,a13,'C').
atom(id70,a14,'O').
atom(id70,a15,'C').
atom(id70,a16,'C').
atom(id70,a17,'C').
atom(id70,a18,'C').
atom(id70,a19,'O').
atom(id70,a20,'C').
atom(id70,a21,'H').
atom(id70,a22,'H').
atom(id70,a23,'H').
bond(id70,a1,a2,single).
bond(id70,a2,a3,single).
bond(id70,a3,a4,single).
bond(id70,a4,a5,single).
bond(id70,a5,a6,single).
bond(id70,a6,a7,double).
bond(id70,a7,a8,single).
bond(id70,a8,a9,single).
bond(id70,a9,a10,single).
bond(id70,a1,a10,single).
bond(id70,a3,a8,single).
bond(id70,a7,a11,single).
bond(id70,a11,a12,double).
bond(id70,a12,a13,single).
bond(id70,a13,a14,single).
bond(id70,a13,a15,double).
bond(id70,a6,a15,single).
bond(id70,a2,a16,single).
bond(id70,a16,a17,single).
bond(id70,a17,a18,single).
bond(id70,a1,a18,single).
bond(id70,a,a,double).
bond(id70,a,a,double).
bond(id70,a,a,double).
bond(id70,a,a,double).
bond(id70,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 71
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id71,71).
dsstox_filename(id71,nctrer_v1a_232_23oct03).
activity_category_er_rba(id71,active_weak).
cas(id71,'1852-53-5').
chemclass_erb(id71,steroids_without_aromatic_a_ring).
chemcount(id71,'1_of_2').
chemname(id71,'3alpha_androstanediol').
chemnote(id71,'stereochem,_2d_replicate_of_beta_form_cas_[571-20-0]').
er_rba(id71,0.0021).
f1_ring(id71,1).
f2_aromatic_ring(id71,0).
f3_phenolic_ring(id71,0).
f4_heteroatom(id71,1).
f5_phenol3nphenyl(id71,0).
f6_other_key_features(id71,1).
formula(id71,c19h32o2).
log_er_rba(id71,-2.67).
logp(id71,3.98).
mean_er_rba_chemclass(id71,1.24).
molweight(id71,292.4606).
structureshown(id71,tested_form).
substancetype(id71,defined_organic).
testedform(id71,parent).
smiles(id71,'c1c2c3c(ccc2c2(c(c1)cc(cc2)o)c)(c(cc3)o)c_').
%activity(id71,active).
atom(id71,a1,'C').
atom(id71,a2,'C').
atom(id71,a3,'C').
atom(id71,a4,'C').
atom(id71,a5,'C').
atom(id71,a6,'C').
atom(id71,a7,'C').
atom(id71,a8,'C').
atom(id71,a9,'C').
atom(id71,a10,'C').
atom(id71,a11,'C').
atom(id71,a12,'C').
atom(id71,a13,'C').
atom(id71,a14,'O').
atom(id71,a15,'C').
atom(id71,a16,'C').
atom(id71,a17,'C').
atom(id71,a18,'C').
atom(id71,a19,'O').
atom(id71,a20,'C').
atom(id71,a21,'H').
atom(id71,a22,'H').
atom(id71,a23,'H').
atom(id71,a24,'C').
atom(id71,a25,'H').
bond(id71,a1,a2,single).
bond(id71,a2,a3,single).
bond(id71,a3,a4,single).
bond(id71,a4,a5,single).
bond(id71,a5,a6,single).
bond(id71,a6,a7,single).
bond(id71,a7,a8,single).
bond(id71,a8,a9,single).
bond(id71,a9,a10,single).
bond(id71,a1,a10,single).
bond(id71,a3,a8,single).
bond(id71,a7,a11,single).
bond(id71,a11,a12,single).
bond(id71,a12,a13,single).
bond(id71,a13,a15,single).
bond(id71,a6,a15,single).
bond(id71,a2,a16,single).
bond(id71,a16,a17,single).
bond(id71,a17,a18,single).
bond(id71,a1,a18,single).
bond(id71,a,a,double).
bond(id71,a,a,double).
bond(id71,a,a,double).
bond(id71,a,a,double).
bond(id71,a,a,double).
bond(id71,a,a,double).
bond(id71,a,a,double).
bond(id71,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 72
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id72,72).
dsstox_filename(id72,nctrer_v1a_232_23oct03).
activity_category_er_rba(id72,active_medium).
cas(id72,'571-20-0').
chemclass_erb(id72,steroids_without_aromatic_a_ring).
chemcount(id72,'2_of_2').
chemname(id72,'3beta_androstanediol').
chemnote(id72,'stereochem,_2d_replicate_of_alpha_form_cas_[1852-53-5]').
er_rba(id72,0.12).
f1_ring(id72,1).
f2_aromatic_ring(id72,0).
f3_phenolic_ring(id72,0).
f4_heteroatom(id72,1).
f5_phenol3nphenyl(id72,0).
f6_other_key_features(id72,1).
formula(id72,c19h32o2).
log_er_rba(id72,-0.92).
logp(id72,3.98).
mean_er_rba_chemclass(id72,1.24).
molweight(id72,292.4606).
structureshown(id72,tested_form).
substancetype(id72,defined_organic).
testedform(id72,parent).
smiles(id72,'c1c2c3c(ccc2c2(c(c1)cc(cc2)o)c)(c(cc3)o)c_').
%activity(id72,active).
atom(id72,a1,'C').
atom(id72,a2,'C').
atom(id72,a3,'C').
atom(id72,a4,'C').
atom(id72,a5,'C').
atom(id72,a6,'C').
atom(id72,a7,'C').
atom(id72,a8,'C').
atom(id72,a9,'C').
atom(id72,a10,'C').
atom(id72,a11,'C').
atom(id72,a12,'C').
atom(id72,a13,'C').
atom(id72,a14,'O').
atom(id72,a15,'C').
atom(id72,a16,'C').
atom(id72,a17,'C').
atom(id72,a18,'C').
atom(id72,a19,'O').
atom(id72,a20,'C').
atom(id72,a21,'H').
atom(id72,a22,'H').
atom(id72,a23,'H').
atom(id72,a24,'C').
atom(id72,a25,'H').
bond(id72,a1,a2,single).
bond(id72,a2,a3,single).
bond(id72,a3,a4,single).
bond(id72,a4,a5,single).
bond(id72,a5,a6,single).
bond(id72,a6,a7,single).
bond(id72,a7,a8,single).
bond(id72,a8,a9,single).
bond(id72,a9,a10,single).
bond(id72,a1,a10,single).
bond(id72,a3,a8,single).
bond(id72,a7,a11,single).
bond(id72,a11,a12,single).
bond(id72,a12,a13,single).
bond(id72,a13,a15,single).
bond(id72,a6,a15,single).
bond(id72,a2,a16,single).
bond(id72,a16,a17,single).
bond(id72,a17,a18,single).
bond(id72,a1,a18,single).
bond(id72,a,a,double).
bond(id72,a,a,double).
bond(id72,a,a,double).
bond(id72,a,a,double).
bond(id72,a,a,double).
bond(id72,a,a,double).
bond(id72,a,a,double).
bond(id72,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 73
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id73,73).
dsstox_filename(id73,nctrer_v1a_232_23oct03).
activity_category_er_rba(id73,slight_binder).
cas(id73,'85-68-7').
chemclass_erb(id73,misc).
chemcount(id73,'1').
chemname(id73,'butylbenzylphthalate').
chemnote(id73,'unknown').
er_rba(id73,0).
f1_ring(id73,1).
f2_aromatic_ring(id73,1).
f3_phenolic_ring(id73,0).
f4_heteroatom(id73,0).
f5_phenol3nphenyl(id73,0).
f6_other_key_features(id73,1).
formula(id73,c19h20o4).
log_er_rba(id73,-5000).
logp(id73,4.84).
mean_er_rba_chemclass(id73,na).
molweight(id73,312.3646).
structureshown(id73,tested_form).
substancetype(id73,defined_organic).
testedform(id73,parent).
smiles(id73,'c1(c(c(=o)occcc)cccc1)c(occ1ccccc1)=o_').
%activity(id73,inactive).
atom(id73,a1,'C').
atom(id73,a2,'C').
atom(id73,a3,'C').
atom(id73,a4,'O').
atom(id73,a5,'O').
atom(id73,a6,'C').
atom(id73,a7,'C').
atom(id73,a8,'C').
atom(id73,a9,'C').
atom(id73,a10,'C').
atom(id73,a11,'C').
atom(id73,a12,'C').
atom(id73,a13,'C').
atom(id73,a14,'C').
atom(id73,a15,'O').
atom(id73,a16,'C').
atom(id73,a17,'C').
atom(id73,a18,'C').
atom(id73,a19,'C').
atom(id73,a20,'C').
atom(id73,a21,'C').
atom(id73,a22,'C').
atom(id73,a23,'O').
bond(id73,a2,a1,double).
bond(id73,a3,a2,single).
bond(id73,a4,a3,double).
bond(id73,a5,a3,single).
bond(id73,a6,a5,single).
bond(id73,a7,a6,single).
bond(id73,a8,a7,single).
bond(id73,a9,a8,single).
bond(id73,a10,a2,single).
bond(id73,a11,a10,double).
bond(id73,a12,a11,single).
bond(id73,a13,a12,double).
bond(id73,a13,a1,single).
bond(id73,a14,a1,single).
bond(id73,a15,a14,single).
bond(id73,a16,a15,single).
bond(id73,a17,a16,single).
bond(id73,a18,a17,single).
bond(id73,a19,a18,double).
bond(id73,a20,a19,single).
bond(id73,a21,a20,double).
bond(id73,a22,a21,single).
bond(id73,a22,a17,double).
bond(id73,a23,a14,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 74
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id74,74).
dsstox_filename(id74,nctrer_v1a_232_23oct03).
activity_category_er_rba(id74,active_strong).
cas(id74,'84-16-2').
chemclass_erb(id74,des_hexestrol_derivatives).
chemcount(id74,'1').
chemname(id74,'meso_hexestrol').
chemnote(id74,'stereochem,_hexestrol_dl_mixed_isomer_result_(er_rba=3.6)_not_included_in_database').
er_rba(id74,301.1).
f1_ring(id74,1).
f2_aromatic_ring(id74,1).
f3_phenolic_ring(id74,1).
f4_heteroatom(id74,0).
f5_phenol3nphenyl(id74,1).
f6_other_key_features(id74,0).
formula(id74,c18h22o2).
log_er_rba(id74,2.48).
logp(id74,5.6).
mean_er_rba_chemclass(id74,2.14).
molweight(id74,270.3706).
structureshown(id74,tested_form).
substancetype(id74,defined_organic).
testedform(id74,parent).
smiles(id74,'c1(c(c(c2ccc(cc2)o)cc)cc)ccc(cc1)o_').
%activity(id74,active).
atom(id74,a1,'C').
atom(id74,a2,'C').
atom(id74,a3,'C').
atom(id74,a4,'C').
atom(id74,a5,'C').
atom(id74,a6,'C').
atom(id74,a7,'C').
atom(id74,a8,'C').
atom(id74,a9,'O').
atom(id74,a10,'C').
atom(id74,a11,'C').
atom(id74,a12,'C').
atom(id74,a13,'C').
atom(id74,a14,'C').
atom(id74,a15,'C').
atom(id74,a16,'C').
atom(id74,a17,'C').
atom(id74,a18,'O').
atom(id74,a19,'C').
atom(id74,a20,'C').
bond(id74,a2,a1,single).
bond(id74,a3,a2,single).
bond(id74,a4,a3,single).
bond(id74,a5,a4,double).
bond(id74,a6,a5,single).
bond(id74,a7,a6,double).
bond(id74,a8,a7,single).
bond(id74,a8,a3,double).
bond(id74,a9,a6,single).
bond(id74,a2,a10,single).
bond(id74,a11,a10,single).
bond(id74,a12,a1,single).
bond(id74,a13,a12,double).
bond(id74,a14,a13,single).
bond(id74,a15,a14,double).
bond(id74,a16,a15,single).
bond(id74,a17,a16,double).
bond(id74,a17,a12,single).
bond(id74,a18,a15,single).
bond(id74,a1,a19,single).
bond(id74,a20,a19,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 75
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id75,75).
dsstox_filename(id75,nctrer_v1a_232_23oct03).
activity_category_er_rba(id75,active_strong).
cas(id75,'84-17-3').
chemclass_erb(id75,des_hexestrol_derivatives).
chemcount(id75,'1').
chemname(id75,'dienestrol').
chemnote(id75,'not_in_fig_2b_of_main_citation').
er_rba(id75,37.15).
f1_ring(id75,1).
f2_aromatic_ring(id75,1).
f3_phenolic_ring(id75,1).
f4_heteroatom(id75,0).
f5_phenol3nphenyl(id75,1).
f6_other_key_features(id75,0).
formula(id75,c18h18o2).
log_er_rba(id75,1.57).
logp(id75,5.43).
mean_er_rba_chemclass(id75,2.14).
molweight(id75,266.339).
structureshown(id75,tested_form).
substancetype(id75,defined_organic).
testedform(id75,parent).
smiles(id75,'c(c(c1ccc(cc1)o)=cc)(c1ccc(cc1)o)=cc_').
%activity(id75,active).
atom(id75,a1,'C').
atom(id75,a2,'C').
atom(id75,a3,'C').
atom(id75,a4,'C').
atom(id75,a5,'C').
atom(id75,a6,'C').
atom(id75,a7,'C').
atom(id75,a8,'C').
atom(id75,a9,'O').
atom(id75,a10,'C').
atom(id75,a11,'C').
atom(id75,a12,'C').
atom(id75,a13,'C').
atom(id75,a14,'C').
atom(id75,a15,'C').
atom(id75,a16,'C').
atom(id75,a17,'C').
atom(id75,a18,'O').
atom(id75,a19,'C').
atom(id75,a20,'C').
bond(id75,a2,a1,single).
bond(id75,a3,a2,single).
bond(id75,a4,a3,double).
bond(id75,a5,a4,single).
bond(id75,a6,a5,double).
bond(id75,a7,a6,single).
bond(id75,a8,a7,double).
bond(id75,a8,a3,single).
bond(id75,a9,a6,single).
bond(id75,a10,a2,double).
bond(id75,a11,a10,single).
bond(id75,a12,a1,single).
bond(id75,a13,a12,single).
bond(id75,a14,a13,double).
bond(id75,a15,a14,single).
bond(id75,a16,a15,double).
bond(id75,a17,a16,single).
bond(id75,a17,a12,double).
bond(id75,a18,a15,single).
bond(id75,a19,a1,double).
bond(id75,a20,a19,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 76
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id76,76).
dsstox_filename(id76,nctrer_v1a_232_23oct03).
activity_category_er_rba(id76,active_strong).
cas(id76,'54965-24-1').
chemclass_erb(id76,des_triphenylethylenes).
chemcount(id76,'1').
chemname(id76,'tamoxifen_citrate').
chemnote(id76,'unknown').
er_rba(id76,1.62).
f1_ring(id76,1).
f2_aromatic_ring(id76,1).
f3_phenolic_ring(id76,0).
f4_heteroatom(id76,0).
f5_phenol3nphenyl(id76,0).
f6_other_key_features(id76,1).
formula(id76,c32h37no8).
log_er_rba(id76,0.21).
logp(id76,6.3).
mean_er_rba_chemclass(id76,2.14).
molweight(id76,563.6462).
structureshown(id76,tested_form).
substancetype(id76,defined_organic).
testedform(id76,complex).
smiles(id76,'c(=c(c1ccccc1)cc)(c1ccc(cc1)occn(c)c)c1ccccc1.c(cc(=o)o)(cc(=o)o)(c(=o)o)o_').
%activity(id76,active).
atom(id76,a1,'C').
atom(id76,a2,'C').
atom(id76,a3,'C').
atom(id76,a4,'C').
atom(id76,a5,'C').
atom(id76,a6,'C').
atom(id76,a7,'C').
atom(id76,a8,'C').
atom(id76,a9,'C').
atom(id76,a10,'C').
atom(id76,a11,'C').
atom(id76,a12,'C').
atom(id76,a13,'C').
atom(id76,a14,'C').
atom(id76,a15,'C').
atom(id76,a16,'C').
atom(id76,a17,'O').
atom(id76,a18,'C').
atom(id76,a19,'C').
atom(id76,a20,'N').
atom(id76,a21,'C').
atom(id76,a22,'C').
atom(id76,a23,'C').
atom(id76,a24,'C').
atom(id76,a25,'C').
atom(id76,a26,'C').
atom(id76,a27,'C').
atom(id76,a28,'C').
atom(id76,a29,'C').
atom(id76,a30,'C').
atom(id76,a31,'C').
atom(id76,a32,'O').
atom(id76,a33,'O').
atom(id76,a34,'C').
atom(id76,a35,'C').
atom(id76,a36,'O').
atom(id76,a37,'O').
atom(id76,a38,'C').
atom(id76,a39,'O').
atom(id76,a40,'O').
atom(id76,a41,'O').
bond(id76,a2,a1,double).
bond(id76,a3,a2,single).
bond(id76,a4,a3,single).
bond(id76,a5,a4,double).
bond(id76,a6,a5,single).
bond(id76,a7,a6,double).
bond(id76,a8,a7,single).
bond(id76,a8,a3,double).
bond(id76,a9,a2,single).
bond(id76,a10,a9,single).
bond(id76,a11,a1,single).
bond(id76,a12,a11,double).
bond(id76,a13,a12,single).
bond(id76,a14,a13,double).
bond(id76,a15,a14,single).
bond(id76,a16,a15,double).
bond(id76,a16,a11,single).
bond(id76,a17,a14,single).
bond(id76,a18,a17,single).
bond(id76,a19,a18,single).
bond(id76,a20,a19,single).
bond(id76,a21,a20,single).
bond(id76,a22,a20,single).
bond(id76,a23,a1,single).
bond(id76,a24,a23,double).
bond(id76,a25,a24,single).
bond(id76,a26,a25,double).
bond(id76,a27,a26,single).
bond(id76,a28,a27,double).
bond(id76,a28,a23,single).
bond(id76,a30,a29,single).
bond(id76,a31,a30,single).
bond(id76,a32,a31,double).
bond(id76,a33,a31,single).
bond(id76,a34,a29,single).
bond(id76,a35,a34,single).
bond(id76,a36,a35,double).
bond(id76,a37,a35,single).
bond(id76,a38,a29,single).
bond(id76,a39,a38,double).
bond(id76,a40,a38,single).
bond(id76,a41,a29,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 77
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id77,77).
dsstox_filename(id77,nctrer_v1a_232_23oct03).
activity_category_er_rba(id77,active_strong).
cas(id77,'68047-06-3').
chemclass_erb(id77,des_triphenylethylenes).
chemcount(id77,'1').
chemname(id77,'4-hydroxy-tamoxifen').
chemnote(id77,'unknown').
er_rba(id77,173.8).
f1_ring(id77,1).
f2_aromatic_ring(id77,1).
f3_phenolic_ring(id77,1).
f4_heteroatom(id77,0).
f5_phenol3nphenyl(id77,1).
f6_other_key_features(id77,0).
formula(id77,c26h29no2).
log_er_rba(id77,2.24).
logp(id77,5.82).
mean_er_rba_chemclass(id77,2.14).
molweight(id77,387.5206).
structureshown(id77,tested_form).
substancetype(id77,defined_organic).
testedform(id77,parent).
smiles(id77,'c(=c(c1ccccc1)cc)(c1ccc(cc1)o)c1ccc(cc1)occn(c)c_').
%activity(id77,active).
atom(id77,a1,'C').
atom(id77,a2,'C').
atom(id77,a3,'C').
atom(id77,a4,'C').
atom(id77,a5,'C').
atom(id77,a6,'C').
atom(id77,a7,'C').
atom(id77,a8,'C').
atom(id77,a9,'C').
atom(id77,a10,'C').
atom(id77,a11,'C').
atom(id77,a12,'C').
atom(id77,a13,'C').
atom(id77,a14,'C').
atom(id77,a15,'C').
atom(id77,a16,'C').
atom(id77,a17,'O').
atom(id77,a18,'C').
atom(id77,a19,'C').
atom(id77,a20,'C').
atom(id77,a21,'C').
atom(id77,a22,'C').
atom(id77,a23,'C').
atom(id77,a24,'O').
atom(id77,a25,'C').
atom(id77,a26,'C').
atom(id77,a27,'N').
atom(id77,a28,'C').
atom(id77,a29,'C').
bond(id77,a2,a1,double).
bond(id77,a3,a2,single).
bond(id77,a4,a3,double).
bond(id77,a5,a4,single).
bond(id77,a6,a5,double).
bond(id77,a7,a6,single).
bond(id77,a8,a7,double).
bond(id77,a8,a3,single).
bond(id77,a9,a2,single).
bond(id77,a10,a9,single).
bond(id77,a11,a1,single).
bond(id77,a12,a11,single).
bond(id77,a13,a12,double).
bond(id77,a14,a13,single).
bond(id77,a15,a14,double).
bond(id77,a16,a15,single).
bond(id77,a16,a11,double).
bond(id77,a17,a14,single).
bond(id77,a18,a1,single).
bond(id77,a19,a18,double).
bond(id77,a20,a19,single).
bond(id77,a21,a20,double).
bond(id77,a22,a21,single).
bond(id77,a23,a22,double).
bond(id77,a23,a18,single).
bond(id77,a24,a21,single).
bond(id77,a25,a24,single).
bond(id77,a26,a25,single).
bond(id77,a27,a26,single).
bond(id77,a28,a27,single).
bond(id77,a29,a27,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 78
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id78,78).
dsstox_filename(id78,nctrer_v1a_232_23oct03).
activity_category_er_rba(id78,active_medium).
cas(id78,'43054-45-1').
chemclass_erb(id78,des_triphenylethylenes).
chemcount(id78,'1').
chemname(id78,'clomiphene_citrate').
chemnote(id78,'unknown').
er_rba(id78,0.724).
f1_ring(id78,1).
f2_aromatic_ring(id78,1).
f3_phenolic_ring(id78,0).
f4_heteroatom(id78,0).
f5_phenol3nphenyl(id78,0).
f6_other_key_features(id78,1).
formula(id78,c32h36clno8).
log_er_rba(id78,-0.14).
logp(id78,6.74).
mean_er_rba_chemclass(id78,2.14).
molweight(id78,598.0913).
structureshown(id78,tested_form).
substancetype(id78,defined_organic).
testedform(id78,complex).
smiles(id78,'c(=c(c1ccccc1)cl)(c1ccc(cc1)occn(cc)cc)c1ccccc1.c(cc(=o)o)(cc(=o)o)(c(=o)o)o_').
%activity(id78,active).
atom(id78,a1,'C').
atom(id78,a2,'C').
atom(id78,a3,'C').
atom(id78,a4,'C').
atom(id78,a5,'C').
atom(id78,a6,'C').
atom(id78,a7,'C').
atom(id78,a8,'C').
atom(id78,a9,'Cl').
atom(id78,a10,'C').
atom(id78,a11,'C').
atom(id78,a12,'C').
atom(id78,a13,'C').
atom(id78,a14,'C').
atom(id78,a15,'C').
atom(id78,a16,'O').
atom(id78,a17,'C').
atom(id78,a18,'C').
atom(id78,a19,'N').
atom(id78,a20,'C').
atom(id78,a21,'C').
atom(id78,a22,'C').
atom(id78,a23,'C').
atom(id78,a24,'C').
atom(id78,a25,'C').
atom(id78,a26,'C').
atom(id78,a27,'C').
atom(id78,a28,'C').
atom(id78,a29,'C').
atom(id78,a30,'C').
atom(id78,a31,'C').
atom(id78,a32,'C').
atom(id78,a33,'O').
atom(id78,a34,'O').
atom(id78,a35,'C').
atom(id78,a36,'C').
atom(id78,a37,'O').
atom(id78,a38,'O').
atom(id78,a39,'C').
atom(id78,a40,'O').
atom(id78,a41,'O').
atom(id78,a42,'O').
bond(id78,a2,a1,double).
bond(id78,a3,a2,single).
bond(id78,a4,a3,single).
bond(id78,a5,a4,double).
bond(id78,a6,a5,single).
bond(id78,a7,a6,double).
bond(id78,a8,a7,single).
bond(id78,a8,a3,double).
bond(id78,a9,a2,single).
bond(id78,a10,a1,single).
bond(id78,a11,a10,double).
bond(id78,a12,a11,single).
bond(id78,a13,a12,double).
bond(id78,a14,a13,single).
bond(id78,a15,a14,double).
bond(id78,a15,a10,single).
bond(id78,a16,a13,single).
bond(id78,a17,a16,single).
bond(id78,a18,a17,single).
bond(id78,a19,a18,single).
bond(id78,a20,a19,single).
bond(id78,a21,a20,single).
bond(id78,a22,a19,single).
bond(id78,a23,a22,single).
bond(id78,a24,a1,single).
bond(id78,a25,a24,double).
bond(id78,a26,a25,single).
bond(id78,a27,a26,double).
bond(id78,a28,a27,single).
bond(id78,a29,a28,double).
bond(id78,a29,a24,single).
bond(id78,a31,a30,single).
bond(id78,a32,a31,single).
bond(id78,a33,a32,double).
bond(id78,a34,a32,single).
bond(id78,a35,a30,single).
bond(id78,a36,a35,single).
bond(id78,a37,a36,double).
bond(id78,a38,a36,single).
bond(id78,a39,a30,single).
bond(id78,a40,a39,double).
bond(id78,a41,a39,single).
bond(id78,a42,a30,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 79
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id79,79).
dsstox_filename(id79,nctrer_v1a_232_23oct03).
activity_category_er_rba(id79,active_medium).
cas(id79,'1845-11-0').
chemclass_erb(id79,des_triphenylethylenes).
chemcount(id79,'1').
chemname(id79,'nafoxidine').
chemnote(id79,'unknown').
er_rba(id79,0.724).
f1_ring(id79,1).
f2_aromatic_ring(id79,1).
f3_phenolic_ring(id79,0).
f4_heteroatom(id79,0).
f5_phenol3nphenyl(id79,0).
f6_other_key_features(id79,1).
formula(id79,c29h31no2).
log_er_rba(id79,-0.14).
logp(id79,7.2).
mean_er_rba_chemclass(id79,2.14).
molweight(id79,425.5694).
structureshown(id79,tested_form).
substancetype(id79,defined_organic).
testedform(id79,parent).
smiles(id79,'c1(=c(ccc2c1ccc(oc)c2)c1ccccc1)c1ccc(cc1)occn1cccc1_').
%activity(id79,active).
atom(id79,a1,'C').
atom(id79,a2,'C').
atom(id79,a3,'C').
atom(id79,a4,'C').
atom(id79,a5,'C').
atom(id79,a6,'C').
atom(id79,a7,'C').
atom(id79,a8,'C').
atom(id79,a9,'C').
atom(id79,a10,'O').
atom(id79,a11,'C').
atom(id79,a12,'C').
atom(id79,a13,'C').
atom(id79,a14,'C').
atom(id79,a15,'C').
atom(id79,a16,'C').
atom(id79,a17,'C').
atom(id79,a18,'C').
atom(id79,a19,'C').
atom(id79,a20,'C').
atom(id79,a21,'C').
atom(id79,a22,'C').
atom(id79,a23,'C').
atom(id79,a24,'C').
atom(id79,a25,'O').
atom(id79,a26,'C').
atom(id79,a27,'C').
atom(id79,a28,'N').
atom(id79,a29,'C').
atom(id79,a30,'C').
atom(id79,a31,'C').
atom(id79,a32,'C').
bond(id79,a2,a1,double).
bond(id79,a3,a2,single).
bond(id79,a4,a3,single).
bond(id79,a5,a4,single).
bond(id79,a6,a5,double).
bond(id79,a6,a1,single).
bond(id79,a7,a6,single).
bond(id79,a8,a7,double).
bond(id79,a9,a8,single).
bond(id79,a10,a9,single).
bond(id79,a11,a10,single).
bond(id79,a12,a9,double).
bond(id79,a12,a5,single).
bond(id79,a13,a2,single).
bond(id79,a14,a13,double).
bond(id79,a15,a14,single).
bond(id79,a16,a15,double).
bond(id79,a17,a16,single).
bond(id79,a18,a17,double).
bond(id79,a18,a13,single).
bond(id79,a19,a1,single).
bond(id79,a20,a19,single).
bond(id79,a21,a20,double).
bond(id79,a22,a21,single).
bond(id79,a23,a22,double).
bond(id79,a24,a23,single).
bond(id79,a24,a19,double).
bond(id79,a25,a22,single).
bond(id79,a26,a25,single).
bond(id79,a27,a26,single).
bond(id79,a28,a27,single).
bond(id79,a29,a28,single).
bond(id79,a30,a29,single).
bond(id79,a31,a30,single).
bond(id79,a32,a31,single).
bond(id79,a32,a28,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 80
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id80,80).
dsstox_filename(id80,nctrer_v1a_232_23oct03).
activity_category_er_rba(id80,active_medium).
cas(id80,'603-45-2').
chemclass_erb(id80,diphenylmethanes_diphenolalkanes).
chemcount(id80,'1').
chemname(id80,'aurin').
chemnote(id80,'unknown').
er_rba(id80,0.0316).
f1_ring(id80,1).
f2_aromatic_ring(id80,1).
f3_phenolic_ring(id80,1).
f4_heteroatom(id80,0).
f5_phenol3nphenyl(id80,1).
f6_other_key_features(id80,0).
formula(id80,c19h14o3).
log_er_rba(id80,-1.5).
logp(id80,3.03).
mean_er_rba_chemclass(id80,0.0087).
molweight(id80,290.3178).
structureshown(id80,tested_form).
substancetype(id80,defined_organic).
testedform(id80,parent).
smiles(id80,'c1(=c(c2ccc(cc2)o)c2ccc(cc2)o)c=cc(c=c1)=o_').
%activity(id80,active).
atom(id80,a1,'C').
atom(id80,a2,'C').
atom(id80,a3,'C').
atom(id80,a4,'C').
atom(id80,a5,'C').
atom(id80,a6,'C').
atom(id80,a7,'C').
atom(id80,a8,'C').
atom(id80,a9,'O').
atom(id80,a10,'C').
atom(id80,a11,'C').
atom(id80,a12,'C').
atom(id80,a13,'C').
atom(id80,a14,'C').
atom(id80,a15,'C').
atom(id80,a16,'O').
atom(id80,a17,'C').
atom(id80,a18,'C').
atom(id80,a19,'C').
atom(id80,a20,'C').
atom(id80,a21,'C').
atom(id80,a22,'O').
bond(id80,a2,a1,double).
bond(id80,a3,a2,single).
bond(id80,a4,a3,single).
bond(id80,a5,a4,double).
bond(id80,a6,a5,single).
bond(id80,a7,a6,double).
bond(id80,a8,a7,single).
bond(id80,a8,a3,double).
bond(id80,a9,a6,single).
bond(id80,a10,a2,single).
bond(id80,a11,a10,double).
bond(id80,a12,a11,single).
bond(id80,a13,a12,double).
bond(id80,a14,a13,single).
bond(id80,a15,a14,double).
bond(id80,a15,a10,single).
bond(id80,a16,a13,single).
bond(id80,a17,a1,single).
bond(id80,a18,a17,double).
bond(id80,a19,a18,single).
bond(id80,a20,a19,single).
bond(id80,a21,a20,double).
bond(id80,a21,a1,single).
bond(id80,a22,a19,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 81
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id81,81).
dsstox_filename(id81,nctrer_v1a_232_23oct03).
activity_category_er_rba(id81,inactive).
cas(id81,'84-74-2').
chemclass_erb(id81,misc).
chemcount(id81,'1').
chemname(id81,'di-n-butyl_phthalate_(dbup)').
chemnote(id81,'unknown').
er_rba(id81,0).
f1_ring(id81,1).
f2_aromatic_ring(id81,1).
f3_phenolic_ring(id81,1).
f4_heteroatom(id81,0).
f5_phenol3nphenyl(id81,0).
f6_other_key_features(id81,0).
formula(id81,c16h22o4).
log_er_rba(id81,-10000).
logp(id81,4.61).
mean_er_rba_chemclass(id81,na).
molweight(id81,278.3474).
structureshown(id81,tested_form).
substancetype(id81,defined_organic).
testedform(id81,parent).
smiles(id81,'c1(c(c(=o)occcc)cccc1)c(=o)occcc_').
%activity(id81,inactive).
atom(id81,a1,'C').
atom(id81,a2,'C').
atom(id81,a3,'C').
atom(id81,a4,'C').
atom(id81,a5,'O').
atom(id81,a6,'O').
atom(id81,a7,'O').
atom(id81,a8,'O').
atom(id81,a9,'C').
atom(id81,a10,'C').
atom(id81,a11,'C').
atom(id81,a12,'C').
atom(id81,a13,'C').
atom(id81,a14,'C').
atom(id81,a15,'C').
atom(id81,a16,'C').
atom(id81,a17,'C').
atom(id81,a18,'C').
atom(id81,a19,'C').
atom(id81,a20,'C').
bond(id81,a0,a0,double).
bond(id81,a0,a0,double).
bond(id81,a2,a1,double).
bond(id81,a3,a2,single).
bond(id81,a4,a1,single).
bond(id81,a5,a3,double).
bond(id81,a6,a4,double).
bond(id81,a7,a3,single).
bond(id81,a8,a4,single).
bond(id81,a9,a1,single).
bond(id81,a10,a2,single).
bond(id81,a11,a7,single).
bond(id81,a12,a8,single).
bond(id81,a13,a11,single).
bond(id81,a14,a12,single).
bond(id81,a15,a13,single).
bond(id81,a16,a14,single).
bond(id81,a17,a9,double).
bond(id81,a18,a17,single).
bond(id81,a19,a15,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 82
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id82,82).
dsstox_filename(id82,nctrer_v1a_232_23oct03).
activity_category_er_rba(id82,active_weak).
cas(id82,'491-67-8').
chemclass_erb(id82,phytoestrogens_flavones).
chemcount(id82,'1').
chemname(id82,'baicalein').
chemnote(id82,'unknown').
er_rba(id82,0.0009).
f1_ring(id82,1).
f2_aromatic_ring(id82,1).
f3_phenolic_ring(id82,1).
f4_heteroatom(id82,0).
f5_phenol3nphenyl(id82,1).
f6_other_key_features(id82,0).
formula(id82,c15h10o5).
log_er_rba(id82,-3.05).
logp(id82,3.27).
mean_er_rba_chemclass(id82,0.019).
molweight(id82,270.241).
structureshown(id82,tested_form).
substancetype(id82,defined_organic).
testedform(id82,parent).
smiles(id82,'c12c(cc(oc2cc(o)c(c1o)o)c1ccccc1)=o_').
%activity(id82,active).
atom(id82,a1,'C').
atom(id82,a2,'C').
atom(id82,a3,'C').
atom(id82,a4,'C').
atom(id82,a5,'C').
atom(id82,a6,'C').
atom(id82,a7,'O').
atom(id82,a8,'C').
atom(id82,a9,'C').
atom(id82,a10,'C').
atom(id82,a11,'O').
atom(id82,a12,'C').
atom(id82,a13,'O').
atom(id82,a14,'O').
atom(id82,a15,'O').
atom(id82,a16,'C').
atom(id82,a17,'C').
atom(id82,a18,'C').
atom(id82,a19,'C').
atom(id82,a20,'C').
bond(id82,a2,a1,single).
bond(id82,a3,a1,single).
bond(id82,a4,a1,double).
bond(id82,a5,a2,single).
bond(id82,a6,a7,single).
bond(id82,a7,a4,single).
bond(id82,a8,a3,double).
bond(id82,a9,a4,single).
bond(id82,a10,a9,double).
bond(id82,a11,a2,double).
bond(id82,a12,a6,single).
bond(id82,a13,a3,single).
bond(id82,a14,a8,single).
bond(id82,a15,a10,single).
bond(id82,a16,a12,single).
bond(id82,a17,a12,double).
bond(id82,a18,a17,single).
bond(id82,a19,a16,double).
bond(id82,a20,a18,double).
bond(id82,a10,a8,single).
bond(id82,a6,a5,double).
bond(id82,a20,a19,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 83
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id83,83).
dsstox_filename(id83,nctrer_v1a_232_23oct03).
activity_category_er_rba(id83,active_strong).
cas(id83,'72-33-3').
chemclass_erb(id83,steroids_with_aromatic_a_ring).
chemcount(id83,'1').
chemname(id83,'mestranol').
chemnote(id83,'stereochem').
er_rba(id83,2.24).
f1_ring(id83,1).
f2_aromatic_ring(id83,1).
f3_phenolic_ring(id83,0).
f4_heteroatom(id83,0).
f5_phenol3nphenyl(id83,0).
f6_other_key_features(id83,1).
formula(id83,c21h26o2).
log_er_rba(id83,0.35).
logp(id83,4.68).
mean_er_rba_chemclass(id83,1.24).
molweight(id83,310.4352).
structureshown(id83,tested_form).
substancetype(id83,defined_organic).
testedform(id83,parent).
smiles(id83,'c1c2c3c(ccc2c2c(c1)cc(cc2)oc)(c(cc3)(o)c#c)c_').
%activity(id83,active).
atom(id83,a1,'C').
atom(id83,a2,'C').
atom(id83,a3,'C').
atom(id83,a4,'C').
atom(id83,a5,'C').
atom(id83,a6,'C').
atom(id83,a7,'C').
atom(id83,a8,'C').
atom(id83,a9,'C').
atom(id83,a10,'C').
atom(id83,a11,'C').
atom(id83,a12,'C').
atom(id83,a13,'C').
atom(id83,a14,'C').
atom(id83,a15,'C').
atom(id83,a16,'C').
atom(id83,a17,'C').
atom(id83,a18,'O').
atom(id83,a19,'C').
atom(id83,a20,'H').
atom(id83,a21,'H').
atom(id83,a22,'H').
atom(id83,a23,'C').
atom(id83,a24,'C').
atom(id83,a25,'O').
atom(id83,a26,'C').
bond(id83,a1,a2,single).
bond(id83,a2,a3,single).
bond(id83,a3,a4,single).
bond(id83,a4,a5,single).
bond(id83,a5,a6,single).
bond(id83,a6,a7,double).
bond(id83,a7,a8,single).
bond(id83,a8,a9,single).
bond(id83,a9,a10,single).
bond(id83,a1,a10,single).
bond(id83,a3,a8,single).
bond(id83,a7,a11,single).
bond(id83,a11,a12,double).
bond(id83,a12,a13,single).
bond(id83,a13,a25,single).
bond(id83,a13,a14,double).
bond(id83,a6,a14,single).
bond(id83,a2,a15,single).
bond(id83,a15,a16,single).
bond(id83,a16,a17,single).
bond(id83,a1,a17,single).
bond(id83,a23,a24,double).
bond(id83,a25,a26,single).
bond(id83,a,a,double).
bond(id83,a,a,double).
bond(id83,a,a,double).
bond(id83,a,a,double).
bond(id83,a,a,double).
bond(id83,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 84
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id84,84).
dsstox_filename(id84,nctrer_v1a_232_23oct03).
activity_category_er_rba(id84,active_medium).
cas(id84,'520-36-5').
chemclass_erb(id84,phytoestrogens_flavones).
chemcount(id84,'1').
chemname(id84,'apigenin').
chemnote(id84,'unknown').
er_rba(id84,0.028).
f1_ring(id84,1).
f2_aromatic_ring(id84,1).
f3_phenolic_ring(id84,1).
f4_heteroatom(id84,0).
f5_phenol3nphenyl(id84,1).
f6_other_key_features(id84,0).
formula(id84,c15h10o5).
log_er_rba(id84,-1.55).
logp(id84,2.84).
mean_er_rba_chemclass(id84,0.019).
molweight(id84,270.241).
structureshown(id84,tested_form).
substancetype(id84,defined_organic).
testedform(id84,parent).
smiles(id84,'c12c(cc(oc1cc(cc2o)o)c1ccc(cc1)o)=o_').
%activity(id84,active).
atom(id84,a1,'C').
atom(id84,a2,'C').
atom(id84,a3,'C').
atom(id84,a4,'C').
atom(id84,a5,'O').
atom(id84,a6,'C').
atom(id84,a7,'C').
atom(id84,a8,'C').
atom(id84,a9,'C').
atom(id84,a10,'C').
atom(id84,a11,'O').
atom(id84,a12,'O').
atom(id84,a13,'C').
atom(id84,a14,'C').
atom(id84,a15,'C').
atom(id84,a16,'C').
atom(id84,a17,'C').
atom(id84,a18,'C').
atom(id84,a19,'O').
atom(id84,a20,'O').
bond(id84,a2,a1,single).
bond(id84,a3,a2,single).
bond(id84,a4,a3,double).
bond(id84,a5,a4,single).
bond(id84,a6,a5,single).
bond(id84,a6,a1,double).
bond(id84,a7,a6,single).
bond(id84,a8,a7,double).
bond(id84,a9,a8,single).
bond(id84,a10,a9,double).
bond(id84,a10,a1,single).
bond(id84,a11,a10,single).
bond(id84,a12,a8,single).
bond(id84,a13,a4,single).
bond(id84,a14,a13,single).
bond(id84,a15,a14,double).
bond(id84,a16,a15,single).
bond(id84,a17,a16,double).
bond(id84,a18,a17,single).
bond(id84,a18,a13,double).
bond(id84,a19,a16,single).
bond(id84,a20,a2,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 85
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id85,85).
dsstox_filename(id85,nctrer_v1a_232_23oct03).
activity_category_er_rba(id85,active_weak).
cas(id85,'480-41-1').
chemclass_erb(id85,phytoestrogens_flavanones).
chemcount(id85,'1').
chemname(id85,'naringenin').
chemnote(id85,'unknown').
er_rba(id85,0.0074).
f1_ring(id85,1).
f2_aromatic_ring(id85,1).
f3_phenolic_ring(id85,1).
f4_heteroatom(id85,0).
f5_phenol3nphenyl(id85,1).
f6_other_key_features(id85,0).
formula(id85,c15h12o5).
log_er_rba(id85,-2.13).
logp(id85,2.61).
mean_er_rba_chemclass(id85,0.019).
molweight(id85,272.2568).
structureshown(id85,tested_form).
substancetype(id85,defined_organic).
testedform(id85,parent).
smiles(id85,'c12c(cc(oc1cc(cc2o)o)c1ccc(cc1)o)=o_').
%activity(id85,active).
atom(id85,a1,'C').
atom(id85,a2,'C').
atom(id85,a3,'C').
atom(id85,a4,'C').
atom(id85,a5,'O').
atom(id85,a6,'C').
atom(id85,a7,'C').
atom(id85,a8,'C').
atom(id85,a9,'C').
atom(id85,a10,'C').
atom(id85,a11,'O').
atom(id85,a12,'O').
atom(id85,a13,'C').
atom(id85,a14,'C').
atom(id85,a15,'C').
atom(id85,a16,'C').
atom(id85,a17,'C').
atom(id85,a18,'C').
atom(id85,a19,'O').
atom(id85,a20,'O').
bond(id85,a2,a1,single).
bond(id85,a3,a2,single).
bond(id85,a4,a3,single).
bond(id85,a5,a4,single).
bond(id85,a6,a5,single).
bond(id85,a6,a1,double).
bond(id85,a7,a6,single).
bond(id85,a8,a7,double).
bond(id85,a9,a8,single).
bond(id85,a10,a9,double).
bond(id85,a10,a1,single).
bond(id85,a11,a10,single).
bond(id85,a12,a8,single).
bond(id85,a4,a13,single).
bond(id85,a14,a13,single).
bond(id85,a15,a14,double).
bond(id85,a16,a15,single).
bond(id85,a17,a16,double).
bond(id85,a18,a17,single).
bond(id85,a18,a13,double).
bond(id85,a19,a16,single).
bond(id85,a20,a2,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 86
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id86,86).
dsstox_filename(id86,nctrer_v1a_232_23oct03).
activity_category_er_rba(id86,active_medium).
cas(id86,'60-82-2').
chemclass_erb(id86,phytoestrogens_chalconoids).
chemcount(id86,'1').
chemname(id86,'phloretin').
chemnote(id86,'unknown').
er_rba(id86,0.069).
f1_ring(id86,1).
f2_aromatic_ring(id86,1).
f3_phenolic_ring(id86,1).
f4_heteroatom(id86,0).
f5_phenol3nphenyl(id86,1).
f6_other_key_features(id86,0).
formula(id86,c15h14o5).
log_er_rba(id86,-1.16).
logp(id86,3.51).
mean_er_rba_chemclass(id86,0.019).
molweight(id86,274.2726).
structureshown(id86,tested_form).
substancetype(id86,defined_organic).
testedform(id86,parent).
smiles(id86,'c1(c(cc(cc1o)o)o)c(=o)ccc1ccc(cc1)o_').
%activity(id86,active).
atom(id86,a1,'C').
atom(id86,a2,'C').
atom(id86,a3,'C').
atom(id86,a4,'C').
atom(id86,a5,'C').
atom(id86,a6,'C').
atom(id86,a7,'O').
atom(id86,a8,'O').
atom(id86,a9,'O').
atom(id86,a10,'C').
atom(id86,a11,'O').
atom(id86,a12,'C').
atom(id86,a13,'C').
atom(id86,a14,'C').
atom(id86,a15,'C').
atom(id86,a16,'C').
atom(id86,a17,'C').
atom(id86,a18,'C').
atom(id86,a19,'C').
atom(id86,a20,'O').
bond(id86,a2,a1,double).
bond(id86,a3,a2,single).
bond(id86,a4,a3,double).
bond(id86,a5,a4,single).
bond(id86,a6,a5,double).
bond(id86,a6,a1,single).
bond(id86,a7,a6,single).
bond(id86,a8,a4,single).
bond(id86,a9,a2,single).
bond(id86,a10,a1,single).
bond(id86,a11,a10,double).
bond(id86,a12,a10,single).
bond(id86,a13,a12,single).
bond(id86,a14,a13,single).
bond(id86,a15,a14,double).
bond(id86,a16,a15,single).
bond(id86,a17,a16,double).
bond(id86,a18,a17,single).
bond(id86,a19,a18,double).
bond(id86,a19,a14,single).
bond(id86,a20,a17,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 87
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id87,87).
dsstox_filename(id87,nctrer_v1a_232_23oct03).
activity_category_er_rba(id87,active_weak).
cas(id87,'491-80-5').
chemclass_erb(id87,phytoestrogens_isoflavones).
chemcount(id87,'1').
chemname(id87,'biochanin_a').
chemnote(id87,'unknown').
er_rba(id87,0.0043).
f1_ring(id87,1).
f2_aromatic_ring(id87,1).
f3_phenolic_ring(id87,1).
f4_heteroatom(id87,0).
f5_phenol3nphenyl(id87,1).
f6_other_key_features(id87,0).
formula(id87,c16h12o5).
log_er_rba(id87,-2.37).
logp(id87,3.41).
mean_er_rba_chemclass(id87,0.019).
molweight(id87,284.2678).
structureshown(id87,tested_form).
substancetype(id87,defined_organic).
testedform(id87,parent).
smiles(id87,'c1(c2c(cc(cc2o)o)occ1c1ccc(cc1)oc)=o_').
%activity(id87,active).
atom(id87,a1,'C').
atom(id87,a2,'C').
atom(id87,a3,'C').
atom(id87,a4,'C').
atom(id87,a5,'C').
atom(id87,a6,'C').
atom(id87,a7,'C').
atom(id87,a8,'O').
atom(id87,a9,'O').
atom(id87,a10,'O').
atom(id87,a11,'C').
atom(id87,a12,'C').
atom(id87,a13,'C').
atom(id87,a14,'C').
atom(id87,a15,'C').
atom(id87,a16,'C').
atom(id87,a17,'C').
atom(id87,a18,'C').
atom(id87,a19,'O').
atom(id87,a20,'C').
atom(id87,a21,'O').
bond(id87,a2,a1,single).
bond(id87,a3,a2,double).
bond(id87,a4,a3,single).
bond(id87,a5,a4,double).
bond(id87,a6,a5,single).
bond(id87,a7,a6,double).
bond(id87,a7,a2,single).
bond(id87,a8,a7,single).
bond(id87,a9,a5,single).
bond(id87,a10,a3,single).
bond(id87,a11,a10,single).
bond(id87,a12,a11,double).
bond(id87,a12,a1,single).
bond(id87,a13,a12,single).
bond(id87,a14,a13,single).
bond(id87,a15,a14,double).
bond(id87,a16,a15,single).
bond(id87,a17,a16,double).
bond(id87,a18,a17,single).
bond(id87,a18,a13,double).
bond(id87,a19,a16,single).
bond(id87,a20,a19,single).
bond(id87,a21,a1,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 88
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id88,88).
dsstox_filename(id88,nctrer_v1a_232_23oct03).
activity_category_er_rba(id88,active_strong).
cas(id88,'5975-78-0').
chemclass_erb(id88,phytoestrogens_mycoestrogens).
chemcount(id88,'1').
chemname(id88,'zearalanone').
chemnote(id88,'unknown').
er_rba(id88,2.09).
f1_ring(id88,1).
f2_aromatic_ring(id88,1).
f3_phenolic_ring(id88,1).
f4_heteroatom(id88,0).
f5_phenol3nphenyl(id88,0).
f6_other_key_features(id88,1).
formula(id88,c18h24o5).
log_er_rba(id88,0.32).
logp(id88,4.86).
mean_er_rba_chemclass(id88,0.019).
molweight(id88,320.3846).
structureshown(id88,tested_form).
substancetype(id88,defined_organic).
testedform(id88,parent).
smiles(id88,'c1(c2c(cc(cc2cccccc(=o)cccc(o1)c)o)o)=o_').
%activity(id88,active).
atom(id88,a1,'C').
atom(id88,a2,'C').
atom(id88,a3,'C').
atom(id88,a4,'C').
atom(id88,a5,'C').
atom(id88,a6,'C').
atom(id88,a7,'C').
atom(id88,a8,'C').
atom(id88,a9,'C').
atom(id88,a10,'C').
atom(id88,a11,'C').
atom(id88,a12,'C').
atom(id88,a13,'C').
atom(id88,a14,'O').
atom(id88,a15,'C').
atom(id88,a16,'C').
atom(id88,a17,'C').
atom(id88,a18,'C').
atom(id88,a19,'O').
atom(id88,a20,'C').
atom(id88,a21,'O').
atom(id88,a22,'O').
atom(id88,a23,'O').
bond(id88,a2,a1,single).
bond(id88,a3,a2,double).
bond(id88,a4,a3,single).
bond(id88,a5,a4,double).
bond(id88,a6,a5,single).
bond(id88,a7,a6,double).
bond(id88,a7,a2,single).
bond(id88,a8,a7,single).
bond(id88,a9,a8,single).
bond(id88,a10,a9,single).
bond(id88,a11,a10,single).
bond(id88,a12,a11,single).
bond(id88,a13,a12,single).
bond(id88,a14,a13,double).
bond(id88,a15,a13,single).
bond(id88,a16,a15,single).
bond(id88,a17,a16,single).
bond(id88,a18,a17,single).
bond(id88,a19,a18,single).
bond(id88,a19,a1,single).
bond(id88,a18,a20,single).
bond(id88,a21,a5,single).
bond(id88,a22,a3,single).
bond(id88,a23,a1,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 89
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id89,89).
dsstox_filename(id89,nctrer_v1a_232_23oct03).
activity_category_er_rba(id89,inactive).
cas(id89,'480-40-0').
chemclass_erb(id89,phytoestrogens_flavones).
chemcount(id89,'1').
chemname(id89,'chrysin').
chemnote(id89,'unknown').
er_rba(id89,0).
f1_ring(id89,1).
f2_aromatic_ring(id89,1).
f3_phenolic_ring(id89,1).
f4_heteroatom(id89,0).
f5_phenol3nphenyl(id89,1).
f6_other_key_features(id89,0).
formula(id89,c15h10o4).
log_er_rba(id89,-10000).
logp(id89,3.32).
mean_er_rba_chemclass(id89,0.019).
molweight(id89,254.2416).
structureshown(id89,tested_form).
substancetype(id89,defined_organic).
testedform(id89,parent).
smiles(id89,'c12c(cc(oc1cc(cc2o)o)c1ccccc1)=o_').
%activity(id89,inactive).
atom(id89,a1,'C').
atom(id89,a2,'C').
atom(id89,a3,'C').
atom(id89,a4,'C').
atom(id89,a5,'O').
atom(id89,a6,'C').
atom(id89,a7,'C').
atom(id89,a8,'C').
atom(id89,a9,'C').
atom(id89,a10,'C').
atom(id89,a11,'O').
atom(id89,a12,'O').
atom(id89,a13,'C').
atom(id89,a14,'C').
atom(id89,a15,'C').
atom(id89,a16,'C').
atom(id89,a17,'C').
atom(id89,a18,'C').
atom(id89,a19,'O').
bond(id89,a2,a1,single).
bond(id89,a3,a2,single).
bond(id89,a4,a3,double).
bond(id89,a5,a4,single).
bond(id89,a6,a5,single).
bond(id89,a6,a1,double).
bond(id89,a7,a6,single).
bond(id89,a8,a7,double).
bond(id89,a9,a8,single).
bond(id89,a10,a9,double).
bond(id89,a10,a1,single).
bond(id89,a11,a10,single).
bond(id89,a12,a8,single).
bond(id89,a13,a4,single).
bond(id89,a14,a13,single).
bond(id89,a15,a14,double).
bond(id89,a16,a15,single).
bond(id89,a17,a16,double).
bond(id89,a18,a17,single).
bond(id89,a18,a13,double).
bond(id89,a19,a2,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 90
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id90,90).
dsstox_filename(id90,nctrer_v1a_232_23oct03).
activity_category_er_rba(id90,active_medium).
cas(id90,'520-18-3').
chemclass_erb(id90,phytoestrogens_flavones).
chemcount(id90,'1').
chemname(id90,'kaempferol').
chemnote(id90,'unknown').
er_rba(id90,0.0245).
f1_ring(id90,1).
f2_aromatic_ring(id90,1).
f3_phenolic_ring(id90,1).
f4_heteroatom(id90,0).
f5_phenol3nphenyl(id90,1).
f6_other_key_features(id90,0).
formula(id90,c15h10o6).
log_er_rba(id90,-1.61).
logp(id90,1.96).
mean_er_rba_chemclass(id90,0.019).
molweight(id90,286.2404).
structureshown(id90,tested_form).
substancetype(id90,defined_organic).
testedform(id90,parent).
smiles(id90,'c1(c(c2c(cc(cc2oc1c1ccc(cc1)o)o)o)=o)o_').
%activity(id90,active).
atom(id90,a1,'C').
atom(id90,a2,'C').
atom(id90,a3,'C').
atom(id90,a4,'C').
atom(id90,a5,'C').
atom(id90,a6,'C').
atom(id90,a7,'C').
atom(id90,a8,'C').
atom(id90,a9,'O').
atom(id90,a10,'C').
atom(id90,a11,'C').
atom(id90,a12,'C').
atom(id90,a13,'C').
atom(id90,a14,'C').
atom(id90,a15,'C').
atom(id90,a16,'C').
atom(id90,a17,'O').
atom(id90,a18,'O').
atom(id90,a19,'O').
atom(id90,a20,'O').
atom(id90,a21,'O').
bond(id90,a2,a1,single).
bond(id90,a3,a2,single).
bond(id90,a4,a3,single).
bond(id90,a5,a4,double).
bond(id90,a6,a5,single).
bond(id90,a7,a6,double).
bond(id90,a8,a7,single).
bond(id90,a9,a8,single).
bond(id90,a10,a9,single).
bond(id90,a10,a1,double).
bond(id90,a11,a10,single).
bond(id90,a12,a11,double).
bond(id90,a13,a12,single).
bond(id90,a14,a13,double).
bond(id90,a15,a14,single).
bond(id90,a16,a15,double).
bond(id90,a16,a11,single).
bond(id90,a17,a14,single).
bond(id90,a8,a3,double).
bond(id90,a18,a6,single).
bond(id90,a19,a4,single).
bond(id90,a20,a2,double).
bond(id90,a21,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 91
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id91,91).
dsstox_filename(id91,nctrer_v1a_232_23oct03).
activity_category_er_rba(id91,active_weak).
cas(id91,'480-16-0').
chemclass_erb(id91,phytoestrogens_flavones).
chemcount(id91,'1').
chemname(id91,'morin').
chemnote(id91,'unknown').
er_rba(id91,0.00081).
f1_ring(id91,1).
f2_aromatic_ring(id91,1).
f3_phenolic_ring(id91,1).
f4_heteroatom(id91,0).
f5_phenol3nphenyl(id91,1).
f6_other_key_features(id91,0).
formula(id91,c15h10o7).
log_er_rba(id91,-3.09).
logp(id91,1.48).
mean_er_rba_chemclass(id91,0.019).
molweight(id91,302.2398).
structureshown(id91,tested_form).
substancetype(id91,defined_organic).
testedform(id91,parent).
smiles(id91,'c1(c(c(=o)c2c(o1)cc(cc2o)o)o)c1c(cc(cc1)o)o_').
%activity(id91,active).
atom(id91,a1,'C').
atom(id91,a2,'C').
atom(id91,a3,'C').
atom(id91,a4,'O').
atom(id91,a5,'C').
atom(id91,a6,'C').
atom(id91,a7,'O').
atom(id91,a8,'C').
atom(id91,a9,'C').
atom(id91,a10,'C').
atom(id91,a11,'C').
atom(id91,a12,'O').
atom(id91,a13,'O').
atom(id91,a14,'O').
atom(id91,a15,'C').
atom(id91,a16,'C').
atom(id91,a17,'C').
atom(id91,a18,'C').
atom(id91,a19,'C').
atom(id91,a20,'C').
atom(id91,a21,'O').
atom(id91,a22,'O').
bond(id91,a2,a1,double).
bond(id91,a3,a2,single).
bond(id91,a4,a3,double).
bond(id91,a5,a3,single).
bond(id91,a6,a5,double).
bond(id91,a7,a6,single).
bond(id91,a7,a1,single).
bond(id91,a8,a6,single).
bond(id91,a9,a8,double).
bond(id91,a10,a9,single).
bond(id91,a11,a10,double).
bond(id91,a11,a5,single).
bond(id91,a12,a11,single).
bond(id91,a13,a9,single).
bond(id91,a14,a2,single).
bond(id91,a15,a1,single).
bond(id91,a16,a15,double).
bond(id91,a17,a16,single).
bond(id91,a18,a17,double).
bond(id91,a19,a18,single).
bond(id91,a20,a19,double).
bond(id91,a20,a15,single).
bond(id91,a21,a18,single).
bond(id91,a22,a16,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 92
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id92,92).
dsstox_filename(id92,nctrer_v1a_232_23oct03).
activity_category_er_rba(id92,active_medium).
cas(id92,'479-13-0').
chemclass_erb(id92,phytoestrogens_coumestans).
chemcount(id92,'1').
chemname(id92,'coumestrol').
chemnote(id92,'unknown').
er_rba(id92,0.891).
f1_ring(id92,1).
f2_aromatic_ring(id92,1).
f3_phenolic_ring(id92,1).
f4_heteroatom(id92,0).
f5_phenol3nphenyl(id92,1).
f6_other_key_features(id92,0).
formula(id92,c15h8o5).
log_er_rba(id92,-0.05).
logp(id92,1.57).
mean_er_rba_chemclass(id92,0.019).
molweight(id92,268.2252).
structureshown(id92,tested_form).
substancetype(id92,defined_organic).
testedform(id92,parent).
smiles(id92,'c12c(oc3c1ccc(o)c3)c1ccc(cc1oc2=o)o_').
%activity(id92,active).
atom(id92,a1,'C').
atom(id92,a2,'C').
atom(id92,a3,'O').
atom(id92,a4,'C').
atom(id92,a5,'C').
atom(id92,a6,'C').
atom(id92,a7,'C').
atom(id92,a8,'C').
atom(id92,a9,'O').
atom(id92,a10,'C').
atom(id92,a11,'C').
atom(id92,a12,'C').
atom(id92,a13,'C').
atom(id92,a14,'C').
atom(id92,a15,'C').
atom(id92,a16,'C').
atom(id92,a17,'O').
atom(id92,a18,'C').
atom(id92,a19,'O').
atom(id92,a20,'O').
bond(id92,a2,a1,double).
bond(id92,a3,a2,single).
bond(id92,a4,a3,single).
bond(id92,a5,a4,double).
bond(id92,a5,a1,single).
bond(id92,a6,a5,single).
bond(id92,a7,a6,double).
bond(id92,a8,a7,single).
bond(id92,a9,a8,single).
bond(id92,a10,a8,double).
bond(id92,a10,a4,single).
bond(id92,a11,a2,single).
bond(id92,a12,a11,single).
bond(id92,a13,a12,double).
bond(id92,a14,a13,single).
bond(id92,a15,a14,double).
bond(id92,a16,a15,single).
bond(id92,a17,a16,single).
bond(id92,a18,a17,single).
bond(id92,a18,a1,single).
bond(id92,a19,a18,double).
bond(id92,a16,a11,double).
bond(id92,a20,a14,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 93
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id93,93).
dsstox_filename(id93,nctrer_v1a_232_23oct03).
activity_category_er_rba(id93,active_weak).
cas(id93,'529-44-2').
chemclass_erb(id93,phytoestrogens_flavones).
chemcount(id93,'1').
chemname(id93,'myricetin').
chemnote(id93,'unknown').
er_rba(id93,0.00177).
f1_ring(id93,1).
f2_aromatic_ring(id93,1).
f3_phenolic_ring(id93,1).
f4_heteroatom(id93,0).
f5_phenol3nphenyl(id93,1).
f6_other_key_features(id93,0).
formula(id93,c15h10o8).
log_er_rba(id93,-2.75).
logp(id93,1.42).
mean_er_rba_chemclass(id93,0.019).
molweight(id93,318.2392).
structureshown(id93,tested_form).
substancetype(id93,defined_organic).
testedform(id93,parent).
smiles(id93,'c1(c(c(=o)c2c(o1)cc(cc2o)o)o)c1cc(o)c(c(c1)o)o_').
%activity(id93,active).
atom(id93,a1,'C').
atom(id93,a2,'C').
atom(id93,a3,'C').
atom(id93,a4,'O').
atom(id93,a5,'C').
atom(id93,a6,'C').
atom(id93,a7,'O').
atom(id93,a8,'C').
atom(id93,a9,'C').
atom(id93,a10,'C').
atom(id93,a11,'C').
atom(id93,a12,'O').
atom(id93,a13,'O').
atom(id93,a14,'O').
atom(id93,a15,'C').
atom(id93,a16,'C').
atom(id93,a17,'C').
atom(id93,a18,'O').
atom(id93,a19,'C').
atom(id93,a20,'C').
atom(id93,a21,'C').
atom(id93,a22,'O').
atom(id93,a23,'O').
bond(id93,a2,a1,double).
bond(id93,a3,a2,single).
bond(id93,a4,a3,double).
bond(id93,a5,a3,single).
bond(id93,a6,a5,double).
bond(id93,a7,a6,single).
bond(id93,a7,a1,single).
bond(id93,a8,a6,single).
bond(id93,a9,a8,double).
bond(id93,a10,a9,single).
bond(id93,a11,a10,double).
bond(id93,a11,a5,single).
bond(id93,a12,a11,single).
bond(id93,a13,a9,single).
bond(id93,a14,a2,single).
bond(id93,a15,a1,single).
bond(id93,a16,a15,double).
bond(id93,a17,a16,single).
bond(id93,a18,a17,single).
bond(id93,a19,a17,double).
bond(id93,a20,a19,single).
bond(id93,a21,a20,double).
bond(id93,a21,a15,single).
bond(id93,a22,a20,single).
bond(id93,a23,a19,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 94
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id94,94).
dsstox_filename(id94,nctrer_v1a_232_23oct03).
activity_category_er_rba(id94,inactive).
cas(id94,'57-88-5').
chemclass_erb(id94,steroids_without_aromatic_a_ring).
chemcount(id94,'1').
chemname(id94,'cholesterol').
chemnote(id94,'stereochem').
er_rba(id94,0).
f1_ring(id94,1).
f2_aromatic_ring(id94,0).
f3_phenolic_ring(id94,0).
f4_heteroatom(id94,1).
f5_phenol3nphenyl(id94,0).
f6_other_key_features(id94,1).
formula(id94,c27h46o).
log_er_rba(id94,-10000).
logp(id94,8.74).
mean_er_rba_chemclass(id94,1.24).
molweight(id94,386.6598).
structureshown(id94,tested_form).
substancetype(id94,defined_organic).
testedform(id94,parent).
smiles(id94,'c1c2c3c(ccc2c2(c(=c1)cc(cc2)o)c)(c(cc3)c(cccc(c)c)c)c_').
%activity(id94,inactive).
atom(id94,a1,'C').
atom(id94,a2,'C').
atom(id94,a3,'C').
atom(id94,a4,'C').
atom(id94,a5,'C').
atom(id94,a6,'C').
atom(id94,a7,'C').
atom(id94,a8,'C').
atom(id94,a9,'C').
atom(id94,a10,'C').
atom(id94,a11,'C').
atom(id94,a12,'C').
atom(id94,a13,'C').
atom(id94,a14,'O').
atom(id94,a15,'C').
atom(id94,a16,'C').
atom(id94,a17,'C').
atom(id94,a18,'C').
atom(id94,a19,'C').
atom(id94,a20,'C').
atom(id94,a21,'H').
atom(id94,a22,'H').
atom(id94,a23,'H').
atom(id94,a24,'C').
atom(id94,a25,'H').
atom(id94,a26,'C').
atom(id94,a27,'C').
atom(id94,a28,'C').
atom(id94,a29,'C').
atom(id94,a30,'C').
atom(id94,a31,'C').
atom(id94,a32,'C').
bond(id94,a1,a2,single).
bond(id94,a2,a3,single).
bond(id94,a3,a4,single).
bond(id94,a4,a5,single).
bond(id94,a5,a6,double).
bond(id94,a6,a7,single).
bond(id94,a7,a8,single).
bond(id94,a8,a9,single).
bond(id94,a9,a10,single).
bond(id94,a1,a10,single).
bond(id94,a3,a8,single).
bond(id94,a7,a11,single).
bond(id94,a11,a12,single).
bond(id94,a12,a13,single).
bond(id94,a13,a15,single).
bond(id94,a6,a15,single).
bond(id94,a2,a16,single).
bond(id94,a16,a17,single).
bond(id94,a17,a18,single).
bond(id94,a1,a18,single).
bond(id94,a19,a26,single).
bond(id94,a26,a28,single).
bond(id94,a28,a29,single).
bond(id94,a29,a30,single).
bond(id94,a30,a31,single).
bond(id94,a30,a32,single).
bond(id94,a,a,double).
bond(id94,a,a,double).
bond(id94,a,a,double).
bond(id94,a,a,double).
bond(id94,a,a,double).
bond(id94,a,a,double).
bond(id94,a,a,double).
bond(id94,a,a,double).
bond(id94,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 95
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id95,95).
dsstox_filename(id95,nctrer_v1a_232_23oct03).
activity_category_er_rba(id95,active_strong).
cas(id95,'36455-72-8').
chemclass_erb(id95,phytoestrogens_mycoestrogens).
chemcount(id95,'1_of_2').
chemname(id95,'alpha_zearalenol').
chemnote(id95,'stereochem,_2d_replicate_of_beta_form_cas_[71030-11-0]').
er_rba(id95,42.66).
f1_ring(id95,1).
f2_aromatic_ring(id95,1).
f3_phenolic_ring(id95,1).
f4_heteroatom(id95,0).
f5_phenol3nphenyl(id95,0).
f6_other_key_features(id95,1).
formula(id95,c18h24o5).
log_er_rba(id95,1.63).
logp(id95,4.09).
mean_er_rba_chemclass(id95,0.019).
molweight(id95,320.3846).
structureshown(id95,tested_form).
substancetype(id95,defined_organic).
testedform(id95,parent).
smiles(id95,'c1(c2c(cc(cc2c=ccccc(o)cccc(o1)c)o)o)=o_').
%activity(id95,active).
atom(id95,a1,'C').
atom(id95,a2,'C').
atom(id95,a3,'C').
atom(id95,a4,'C').
atom(id95,a5,'C').
atom(id95,a6,'C').
atom(id95,a7,'C').
atom(id95,a8,'C').
atom(id95,a9,'C').
atom(id95,a10,'C').
atom(id95,a11,'C').
atom(id95,a12,'C').
atom(id95,a13,'C').
atom(id95,a14,'O').
atom(id95,a15,'C').
atom(id95,a16,'C').
atom(id95,a17,'C').
atom(id95,a18,'C').
atom(id95,a19,'O').
atom(id95,a20,'C').
atom(id95,a21,'O').
atom(id95,a22,'O').
atom(id95,a23,'O').
bond(id95,a2,a1,single).
bond(id95,a3,a2,double).
bond(id95,a4,a3,single).
bond(id95,a5,a4,double).
bond(id95,a6,a5,single).
bond(id95,a7,a6,double).
bond(id95,a7,a2,single).
bond(id95,a8,a7,single).
bond(id95,a9,a8,double).
bond(id95,a10,a9,single).
bond(id95,a11,a10,single).
bond(id95,a12,a11,single).
bond(id95,a13,a12,single).
bond(id95,a15,a13,single).
bond(id95,a16,a15,single).
bond(id95,a17,a16,single).
bond(id95,a18,a17,single).
bond(id95,a19,a18,single).
bond(id95,a19,a1,single).
bond(id95,a21,a5,single).
bond(id95,a22,a3,single).
bond(id95,a23,a1,double).
bond(id95,a,a,double).
bond(id95,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 96
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id96,96).
dsstox_filename(id96,nctrer_v1a_232_23oct03).
activity_category_er_rba(id96,inactive).
cas(id96,'131-53-3').
chemclass_erb(id96,diphenylmethanes_benzophenones).
chemcount(id96,'1').
chemname(id96,'2,2_-dihydroxy-4-methoxy_benzophenone').
chemnote(id96,'unknown').
er_rba(id96,0).
f1_ring(id96,1).
f2_aromatic_ring(id96,1).
f3_phenolic_ring(id96,1).
f4_heteroatom(id96,0).
f5_phenol3nphenyl(id96,1).
f6_other_key_features(id96,0).
formula(id96,c14h12o4).
log_er_rba(id96,-10000).
logp(id96,3.82).
mean_er_rba_chemclass(id96,0.0087).
molweight(id96,244.2464).
structureshown(id96,tested_form).
substancetype(id96,defined_organic).
testedform(id96,parent).
smiles(id96,'c(c1c(cc(cc1)oc)o)(c1c(o)cccc1)=o_').
%activity(id96,inactive).
atom(id96,a1,'C').
atom(id96,a2,'C').
atom(id96,a3,'C').
atom(id96,a4,'C').
atom(id96,a5,'C').
atom(id96,a6,'C').
atom(id96,a7,'C').
atom(id96,a8,'O').
atom(id96,a9,'C').
atom(id96,a10,'O').
atom(id96,a11,'C').
atom(id96,a12,'C').
atom(id96,a13,'O').
atom(id96,a14,'C').
atom(id96,a15,'C').
atom(id96,a16,'C').
atom(id96,a17,'C').
atom(id96,a18,'O').
bond(id96,a2,a1,single).
bond(id96,a3,a2,single).
bond(id96,a4,a3,double).
bond(id96,a5,a4,single).
bond(id96,a6,a5,double).
bond(id96,a7,a6,single).
bond(id96,a7,a2,double).
bond(id96,a8,a5,single).
bond(id96,a9,a8,single).
bond(id96,a10,a3,single).
bond(id96,a11,a1,single).
bond(id96,a12,a11,double).
bond(id96,a13,a12,single).
bond(id96,a14,a12,single).
bond(id96,a15,a14,double).
bond(id96,a16,a15,single).
bond(id96,a17,a16,double).
bond(id96,a17,a11,single).
bond(id96,a18,a1,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 97
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id97,97).
dsstox_filename(id97,nctrer_v1a_232_23oct03).
activity_category_er_rba(id97,inactive).
cas(id97,'835-11-0').
chemclass_erb(id97,diphenylmethanes_benzophenones).
chemcount(id97,'1').
chemname(id97,'2,2_-dihydroxy_benzophenone').
chemnote(id97,'unknown').
er_rba(id97,0).
f1_ring(id97,1).
f2_aromatic_ring(id97,1).
f3_phenolic_ring(id97,1).
f4_heteroatom(id97,0).
f5_phenol3nphenyl(id97,1).
f6_other_key_features(id97,0).
formula(id97,c13h10o3).
log_er_rba(id97,-10000).
logp(id97,3.74).
mean_er_rba_chemclass(id97,0.0087).
molweight(id97,214.2202).
structureshown(id97,tested_form).
substancetype(id97,defined_organic).
testedform(id97,parent).
smiles(id97,'c(c1c(o)cccc1)(c1c(o)cccc1)=o_').
%activity(id97,inactive).
atom(id97,a1,'C').
atom(id97,a2,'C').
atom(id97,a3,'C').
atom(id97,a4,'O').
atom(id97,a5,'C').
atom(id97,a6,'C').
atom(id97,a7,'C').
atom(id97,a8,'C').
atom(id97,a9,'C').
atom(id97,a10,'C').
atom(id97,a11,'O').
atom(id97,a12,'C').
atom(id97,a13,'C').
atom(id97,a14,'C').
atom(id97,a15,'C').
atom(id97,a16,'O').
bond(id97,a2,a1,single).
bond(id97,a3,a2,single).
bond(id97,a4,a3,single).
bond(id97,a5,a3,double).
bond(id97,a6,a5,single).
bond(id97,a7,a6,double).
bond(id97,a8,a7,single).
bond(id97,a8,a2,double).
bond(id97,a9,a1,single).
bond(id97,a10,a9,double).
bond(id97,a11,a10,single).
bond(id97,a12,a10,single).
bond(id97,a13,a12,double).
bond(id97,a14,a13,single).
bond(id97,a15,a14,double).
bond(id97,a15,a9,single).
bond(id97,a16,a1,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 98
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id98,98).
dsstox_filename(id98,nctrer_v1a_232_23oct03).
activity_category_er_rba(id98,inactive).
cas(id98,'131-57-7').
chemclass_erb(id98,diphenylmethanes_benzophenones).
chemcount(id98,'1').
chemname(id98,'2-hydroxy-4-methoxy_benzophenone').
chemnote(id98,'unknown').
er_rba(id98,0).
f1_ring(id98,1).
f2_aromatic_ring(id98,1).
f3_phenolic_ring(id98,1).
f4_heteroatom(id98,0).
f5_phenol3nphenyl(id98,1).
f6_other_key_features(id98,0).
formula(id98,c14h12o3).
log_er_rba(id98,-10000).
logp(id98,3.52).
mean_er_rba_chemclass(id98,0.0087).
molweight(id98,228.247).
structureshown(id98,tested_form).
substancetype(id98,defined_organic).
testedform(id98,parent).
smiles(id98,'c1(c(=o)c2ccccc2)c(cc(cc1)oc)o_').
%activity(id98,inactive).
atom(id98,a1,'C').
atom(id98,a2,'C').
atom(id98,a3,'O').
atom(id98,a4,'C').
atom(id98,a5,'C').
atom(id98,a6,'C').
atom(id98,a7,'C').
atom(id98,a8,'C').
atom(id98,a9,'C').
atom(id98,a10,'C').
atom(id98,a11,'C').
atom(id98,a12,'C').
atom(id98,a13,'C').
atom(id98,a14,'C').
atom(id98,a15,'O').
atom(id98,a16,'C').
atom(id98,a17,'O').
bond(id98,a2,a1,single).
bond(id98,a3,a2,double).
bond(id98,a4,a2,single).
bond(id98,a5,a4,single).
bond(id98,a6,a5,double).
bond(id98,a7,a6,single).
bond(id98,a8,a7,double).
bond(id98,a9,a8,single).
bond(id98,a9,a4,double).
bond(id98,a10,a1,single).
bond(id98,a11,a10,double).
bond(id98,a12,a11,single).
bond(id98,a13,a12,double).
bond(id98,a14,a13,single).
bond(id98,a14,a1,double).
bond(id98,a15,a12,single).
bond(id98,a16,a15,single).
bond(id98,a17,a10,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 99
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id99,99).
dsstox_filename(id99,nctrer_v1a_232_23oct03).
activity_category_er_rba(id99,active_weak).
cas(id99,'131-56-6').
chemclass_erb(id99,diphenylmethanes_benzophenones).
chemcount(id99,'1').
chemname(id99,'2,4-dihydroxy_benzophenone').
chemnote(id99,'unknown').
er_rba(id99,0.00245).
f1_ring(id99,1).
f2_aromatic_ring(id99,1).
f3_phenolic_ring(id99,1).
f4_heteroatom(id99,0).
f5_phenol3nphenyl(id99,1).
f6_other_key_features(id99,0).
formula(id99,c13h10o3).
log_er_rba(id99,-2.61).
logp(id99,2.96).
mean_er_rba_chemclass(id99,0.0087).
molweight(id99,214.2202).
structureshown(id99,tested_form).
substancetype(id99,defined_organic).
testedform(id99,parent).
smiles(id99,'c1(c(=o)c2ccccc2)c(cc(cc1)o)o_').
%activity(id99,active).
atom(id99,a1,'C').
atom(id99,a2,'C').
atom(id99,a3,'O').
atom(id99,a4,'C').
atom(id99,a5,'C').
atom(id99,a6,'C').
atom(id99,a7,'C').
atom(id99,a8,'C').
atom(id99,a9,'C').
atom(id99,a10,'C').
atom(id99,a11,'C').
atom(id99,a12,'C').
atom(id99,a13,'C').
atom(id99,a14,'C').
atom(id99,a15,'O').
atom(id99,a16,'O').
bond(id99,a2,a1,single).
bond(id99,a3,a2,double).
bond(id99,a4,a2,single).
bond(id99,a5,a4,single).
bond(id99,a6,a5,double).
bond(id99,a7,a6,single).
bond(id99,a8,a7,double).
bond(id99,a9,a8,single).
bond(id99,a9,a4,double).
bond(id99,a10,a1,single).
bond(id99,a11,a10,double).
bond(id99,a12,a11,single).
bond(id99,a13,a12,double).
bond(id99,a14,a13,single).
bond(id99,a14,a1,double).
bond(id99,a15,a12,single).
bond(id99,a16,a10,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 100
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id100,100).
dsstox_filename(id100,nctrer_v1a_232_23oct03).
activity_category_er_rba(id100,active_medium).
cas(id100,'77-09-8').
chemclass_erb(id100,diphenylmethanes_diphenolalkanes).
chemcount(id100,'1').
chemname(id100,'phenolphthalein').
chemnote(id100,'unknown').
er_rba(id100,0.0135).
f1_ring(id100,1).
f2_aromatic_ring(id100,1).
f3_phenolic_ring(id100,1).
f4_heteroatom(id100,0).
f5_phenol3nphenyl(id100,1).
f6_other_key_features(id100,0).
formula(id100,c20h14o4).
log_er_rba(id100,-1.87).
logp(id100,3.06).
mean_er_rba_chemclass(id100,0.0087).
molweight(id100,318.3282).
structureshown(id100,tested_form).
substancetype(id100,defined_organic).
testedform(id100,parent).
smiles(id100,'c1(oc(=o)c2c1cccc2)(c1ccc(cc1)o)c1ccc(cc1)o_').
%activity(id100,active).
atom(id100,a1,'C').
atom(id100,a2,'O').
atom(id100,a3,'C').
atom(id100,a4,'O').
atom(id100,a5,'C').
atom(id100,a6,'C').
atom(id100,a7,'C').
atom(id100,a8,'C').
atom(id100,a9,'C').
atom(id100,a10,'C').
atom(id100,a11,'C').
atom(id100,a12,'C').
atom(id100,a13,'C').
atom(id100,a14,'C').
atom(id100,a15,'C').
atom(id100,a16,'C').
atom(id100,a17,'O').
atom(id100,a18,'C').
atom(id100,a19,'C').
atom(id100,a20,'C').
atom(id100,a21,'C').
atom(id100,a22,'C').
atom(id100,a23,'C').
atom(id100,a24,'O').
bond(id100,a2,a1,single).
bond(id100,a3,a2,single).
bond(id100,a4,a3,double).
bond(id100,a5,a3,single).
bond(id100,a6,a5,double).
bond(id100,a6,a1,single).
bond(id100,a7,a6,single).
bond(id100,a8,a7,double).
bond(id100,a9,a8,single).
bond(id100,a10,a9,double).
bond(id100,a10,a5,single).
bond(id100,a11,a1,single).
bond(id100,a12,a11,single).
bond(id100,a13,a12,double).
bond(id100,a14,a13,single).
bond(id100,a15,a14,double).
bond(id100,a16,a15,single).
bond(id100,a16,a11,double).
bond(id100,a17,a14,single).
bond(id100,a18,a1,single).
bond(id100,a19,a18,double).
bond(id100,a20,a19,single).
bond(id100,a21,a20,double).
bond(id100,a22,a21,single).
bond(id100,a23,a22,double).
bond(id100,a23,a18,single).
bond(id100,a24,a21,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 101
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id101,101).
dsstox_filename(id101,nctrer_v1a_232_23oct03).
activity_category_er_rba(id101,active_weak).
cas(id101,'143-74-8').
chemclass_erb(id101,diphenylmethanes_diphenolalkanes).
chemcount(id101,'1').
chemname(id101,'phenol_red').
chemnote(id101,'unknown').
er_rba(id101,0.00056).
f1_ring(id101,1).
f2_aromatic_ring(id101,1).
f3_phenolic_ring(id101,1).
f4_heteroatom(id101,0).
f5_phenol3nphenyl(id101,1).
f6_other_key_features(id101,0).
formula(id101,c19h14o5s).
log_er_rba(id101,-3.25).
logp(id101,3.21).
mean_er_rba_chemclass(id101,0.0087).
molweight(id101,354.3766).
structureshown(id101,tested_form).
substancetype(id101,defined_organic).
testedform(id101,parent).
smiles(id101,'s1(oc(c2ccc(cc2)o)(c2ccc(cc2)o)c2c1cccc2)(=o)=o_').
%activity(id101,active).
atom(id101,a1,'S').
atom(id101,a2,'O').
atom(id101,a3,'C').
atom(id101,a4,'C').
atom(id101,a5,'C').
atom(id101,a6,'C').
atom(id101,a7,'C').
atom(id101,a8,'C').
atom(id101,a9,'C').
atom(id101,a10,'O').
atom(id101,a11,'C').
atom(id101,a12,'C').
atom(id101,a13,'C').
atom(id101,a14,'C').
atom(id101,a15,'C').
atom(id101,a16,'C').
atom(id101,a17,'O').
atom(id101,a18,'C').
atom(id101,a19,'C').
atom(id101,a20,'C').
atom(id101,a21,'C').
atom(id101,a22,'C').
atom(id101,a23,'C').
atom(id101,a24,'O').
atom(id101,a25,'O').
bond(id101,a2,a1,single).
bond(id101,a3,a2,single).
bond(id101,a4,a3,single).
bond(id101,a5,a4,single).
bond(id101,a6,a5,double).
bond(id101,a7,a6,single).
bond(id101,a8,a7,double).
bond(id101,a9,a8,single).
bond(id101,a9,a4,double).
bond(id101,a10,a7,single).
bond(id101,a11,a3,single).
bond(id101,a12,a11,double).
bond(id101,a13,a12,single).
bond(id101,a14,a13,double).
bond(id101,a15,a14,single).
bond(id101,a16,a15,double).
bond(id101,a16,a11,single).
bond(id101,a17,a14,single).
bond(id101,a18,a3,single).
bond(id101,a19,a18,double).
bond(id101,a19,a1,single).
bond(id101,a20,a19,single).
bond(id101,a21,a20,double).
bond(id101,a22,a21,single).
bond(id101,a23,a22,double).
bond(id101,a23,a18,single).
bond(id101,a24,a1,double).
bond(id101,a25,a1,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 102
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id102,102).
dsstox_filename(id102,nctrer_v1a_232_23oct03).
activity_category_er_rba(id102,active_weak).
cas(id102,'80-09-1').
chemclass_erb(id102,diphenylmethanes_benzophenones).
chemcount(id102,'1').
chemname(id102,'4,4_-sulfonyldiphenol').
chemnote(id102,'unknown').
er_rba(id102,0.00085).
f1_ring(id102,1).
f2_aromatic_ring(id102,1).
f3_phenolic_ring(id102,1).
f4_heteroatom(id102,0).
f5_phenol3nphenyl(id102,1).
f6_other_key_features(id102,0).
formula(id102,c12h10o4s).
log_er_rba(id102,-3.07).
logp(id102,1.65).
mean_er_rba_chemclass(id102,0.0087).
molweight(id102,250.2686).
structureshown(id102,tested_form).
substancetype(id102,defined_organic).
testedform(id102,parent).
smiles(id102,'s(c1ccc(cc1)o)(c1ccc(cc1)o)(=o)=o_').
%activity(id102,active).
atom(id102,a1,'S').
atom(id102,a2,'C').
atom(id102,a3,'C').
atom(id102,a4,'C').
atom(id102,a5,'C').
atom(id102,a6,'C').
atom(id102,a7,'C').
atom(id102,a8,'O').
atom(id102,a9,'C').
atom(id102,a10,'C').
atom(id102,a11,'C').
atom(id102,a12,'C').
atom(id102,a13,'C').
atom(id102,a14,'C').
atom(id102,a15,'O').
atom(id102,a16,'O').
atom(id102,a17,'O').
bond(id102,a2,a1,single).
bond(id102,a3,a2,single).
bond(id102,a4,a3,double).
bond(id102,a5,a4,single).
bond(id102,a6,a5,double).
bond(id102,a7,a6,single).
bond(id102,a7,a2,double).
bond(id102,a8,a5,single).
bond(id102,a9,a1,single).
bond(id102,a10,a9,double).
bond(id102,a11,a10,single).
bond(id102,a12,a11,double).
bond(id102,a13,a12,single).
bond(id102,a14,a13,double).
bond(id102,a14,a9,single).
bond(id102,a15,a12,single).
bond(id102,a16,a1,double).
bond(id102,a17,a1,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 103
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id103,103).
dsstox_filename(id103,nctrer_v1a_232_23oct03).
activity_category_er_rba(id103,inactive).
cas(id103,'15972-60-8').
chemclass_erb(id103,misc).
chemcount(id103,'1').
chemname(id103,'alachlor').
chemnote(id103,'unknown').
er_rba(id103,0).
f1_ring(id103,1).
f2_aromatic_ring(id103,1).
f3_phenolic_ring(id103,0).
f4_heteroatom(id103,0).
f5_phenol3nphenyl(id103,0).
f6_other_key_features(id103,0).
formula(id103,c14h20clno2).
log_er_rba(id103,-10000).
logp(id103,3.37).
mean_er_rba_chemclass(id103,na).
molweight(id103,269.7705).
structureshown(id103,tested_form).
substancetype(id103,defined_organic).
testedform(id103,parent).
smiles(id103,'c1(n(c(ccl)=o)coc)c(cccc1cc)cc_').
%activity(id103,inactive).
atom(id103,a1,'C').
atom(id103,a2,'N').
atom(id103,a3,'C').
atom(id103,a4,'C').
atom(id103,a5,'Cl').
atom(id103,a6,'O').
atom(id103,a7,'C').
atom(id103,a8,'O').
atom(id103,a9,'C').
atom(id103,a10,'C').
atom(id103,a11,'C').
atom(id103,a12,'C').
atom(id103,a13,'C').
atom(id103,a14,'C').
atom(id103,a15,'C').
atom(id103,a16,'C').
atom(id103,a17,'C').
atom(id103,a18,'C').
bond(id103,a2,a1,single).
bond(id103,a3,a2,single).
bond(id103,a4,a3,single).
bond(id103,a5,a4,single).
bond(id103,a6,a3,double).
bond(id103,a7,a2,single).
bond(id103,a8,a7,single).
bond(id103,a9,a8,single).
bond(id103,a10,a1,double).
bond(id103,a11,a10,single).
bond(id103,a12,a11,double).
bond(id103,a13,a12,single).
bond(id103,a14,a13,double).
bond(id103,a14,a1,single).
bond(id103,a15,a14,single).
bond(id103,a16,a15,single).
bond(id103,a17,a10,single).
bond(id103,a18,a17,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 104
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id104,104).
dsstox_filename(id104,nctrer_v1a_232_23oct03).
activity_category_er_rba(id104,inactive).
cas(id104,'118-82-1').
chemclass_erb(id104,diphenylmethanes_diphenolalkanes).
chemcount(id104,'1').
chemname(id104,'4,4_-methylenebis(2,6-di-t-butylphenol)').
chemnote(id104,'unknown').
er_rba(id104,0).
f1_ring(id104,1).
f2_aromatic_ring(id104,1).
f3_phenolic_ring(id104,1).
f4_heteroatom(id104,0).
f5_phenol3nphenyl(id104,1).
f6_other_key_features(id104,0).
formula(id104,c29h44o2).
log_er_rba(id104,-10000).
logp(id104,8.99).
mean_er_rba_chemclass(id104,0.0087).
molweight(id104,424.6654).
structureshown(id104,tested_form).
substancetype(id104,defined_organic).
testedform(id104,parent).
smiles(id104,'c(c1c(c(c(c)(c)c)cc(c1)cc1cc(c(c)(c)c)c(o)c(c1)c(c)(c)c)o)(c)(c)c_').
%activity(id104,inactive).
atom(id104,a1,'C').
atom(id104,a2,'C').
atom(id104,a3,'C').
atom(id104,a4,'C').
atom(id104,a5,'C').
atom(id104,a6,'C').
atom(id104,a7,'C').
atom(id104,a8,'C').
atom(id104,a9,'C').
atom(id104,a10,'C').
atom(id104,a11,'C').
atom(id104,a12,'C').
atom(id104,a13,'C').
atom(id104,a14,'C').
atom(id104,a15,'C').
atom(id104,a16,'C').
atom(id104,a17,'C').
atom(id104,a18,'C').
atom(id104,a19,'C').
atom(id104,a20,'C').
atom(id104,a21,'O').
atom(id104,a22,'C').
atom(id104,a23,'C').
atom(id104,a24,'C').
atom(id104,a25,'C').
atom(id104,a26,'C').
atom(id104,a27,'C').
atom(id104,a28,'O').
atom(id104,a29,'C').
atom(id104,a30,'C').
atom(id104,a31,'C').
bond(id104,a2,a1,single).
bond(id104,a3,a2,double).
bond(id104,a4,a3,single).
bond(id104,a5,a4,single).
bond(id104,a6,a5,single).
bond(id104,a7,a5,single).
bond(id104,a8,a5,single).
bond(id104,a9,a4,double).
bond(id104,a10,a9,single).
bond(id104,a11,a10,double).
bond(id104,a11,a2,single).
bond(id104,a12,a10,single).
bond(id104,a13,a12,single).
bond(id104,a14,a13,double).
bond(id104,a15,a14,single).
bond(id104,a16,a15,single).
bond(id104,a17,a16,single).
bond(id104,a18,a16,single).
bond(id104,a19,a16,single).
bond(id104,a20,a15,double).
bond(id104,a21,a20,single).
bond(id104,a22,a20,single).
bond(id104,a23,a22,double).
bond(id104,a23,a13,single).
bond(id104,a24,a22,single).
bond(id104,a25,a24,single).
bond(id104,a26,a24,single).
bond(id104,a27,a24,single).
bond(id104,a28,a3,single).
bond(id104,a29,a1,single).
bond(id104,a30,a1,single).
bond(id104,a31,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 105
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id105,105).
dsstox_filename(id105,nctrer_v1a_232_23oct03).
activity_category_er_rba(id105,inactive).
cas(id105,'54760-75-7').
chemclass_erb(id105,misc).
chemcount(id105,'1').
chemname(id105,'4,4_-diaminostilbene').
chemnote(id105,'unknown').
er_rba(id105,0).
f1_ring(id105,1).
f2_aromatic_ring(id105,1).
f3_phenolic_ring(id105,0).
f4_heteroatom(id105,0).
f5_phenol3nphenyl(id105,0).
f6_other_key_features(id105,0).
formula(id105,c14h14n2).
log_er_rba(id105,-10000).
logp(id105,2.69).
mean_er_rba_chemclass(id105,na).
molweight(id105,210.278).
structureshown(id105,tested_form).
substancetype(id105,defined_organic).
testedform(id105,parent).
smiles(id105,'c(=cc1ccc(cc1)n)c1ccc(cc1)n_').
%activity(id105,inactive).
atom(id105,a1,'C').
atom(id105,a2,'C').
atom(id105,a3,'C').
atom(id105,a4,'C').
atom(id105,a5,'C').
atom(id105,a6,'C').
atom(id105,a7,'C').
atom(id105,a8,'C').
atom(id105,a9,'N').
atom(id105,a10,'C').
atom(id105,a11,'C').
atom(id105,a12,'C').
atom(id105,a13,'C').
atom(id105,a14,'C').
atom(id105,a15,'C').
atom(id105,a16,'N').
bond(id105,a2,a1,double).
bond(id105,a3,a2,single).
bond(id105,a4,a3,double).
bond(id105,a5,a4,single).
bond(id105,a6,a5,double).
bond(id105,a7,a6,single).
bond(id105,a8,a7,double).
bond(id105,a8,a3,single).
bond(id105,a9,a6,single).
bond(id105,a10,a1,single).
bond(id105,a11,a10,double).
bond(id105,a12,a11,single).
bond(id105,a13,a12,double).
bond(id105,a14,a13,single).
bond(id105,a15,a14,double).
bond(id105,a15,a10,single).
bond(id105,a16,a13,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 106
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id106,106).
dsstox_filename(id106,nctrer_v1a_232_23oct03).
activity_category_er_rba(id106,inactive).
cas(id106,'97-54-1').
chemclass_erb(id106,phenols_alkyloxy).
chemcount(id106,'1').
chemname(id106,'isoeugenol').
chemnote(id106,'unknown').
er_rba(id106,0).
f1_ring(id106,1).
f2_aromatic_ring(id106,1).
f3_phenolic_ring(id106,1).
f4_heteroatom(id106,0).
f5_phenol3nphenyl(id106,0).
f6_other_key_features(id106,0).
formula(id106,c10h12o2).
log_er_rba(id106,-10000).
logp(id106,2.65).
mean_er_rba_chemclass(id106,0.00088).
molweight(id106,164.2036).
structureshown(id106,tested_form).
substancetype(id106,defined_organic).
testedform(id106,parent).
smiles(id106,'c1(c(ccc(c=cc)c1)o)oc_').
%activity(id106,inactive).
atom(id106,a1,'C').
atom(id106,a2,'C').
atom(id106,a3,'C').
atom(id106,a4,'C').
atom(id106,a5,'C').
atom(id106,a6,'C').
atom(id106,a7,'C').
atom(id106,a8,'C').
atom(id106,a9,'C').
atom(id106,a10,'O').
atom(id106,a11,'O').
atom(id106,a12,'C').
bond(id106,a2,a1,single).
bond(id106,a3,a2,double).
bond(id106,a4,a3,single).
bond(id106,a5,a4,double).
bond(id106,a6,a5,single).
bond(id106,a7,a6,double).
bond(id106,a8,a7,single).
bond(id106,a9,a5,single).
bond(id106,a9,a1,double).
bond(id106,a10,a2,single).
bond(id106,a11,a1,single).
bond(id106,a12,a11,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 107
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id107,107).
dsstox_filename(id107,nctrer_v1a_232_23oct03).
activity_category_er_rba(id107,inactive).
cas(id107,'505-48-6').
chemclass_erb(id107,misc).
chemcount(id107,'1').
chemname(id107,'suberic_acid').
chemnote(id107,'unknown').
er_rba(id107,0).
f1_ring(id107,0).
f2_aromatic_ring(id107,0).
f3_phenolic_ring(id107,0).
f4_heteroatom(id107,0).
f5_phenol3nphenyl(id107,0).
f6_other_key_features(id107,0).
formula(id107,c8h14o4).
log_er_rba(id107,-10000).
logp(id107,1.21).
mean_er_rba_chemclass(id107,na).
molweight(id107,174.1962).
structureshown(id107,tested_form).
substancetype(id107,defined_organic).
testedform(id107,parent).
smiles(id107,'c(ccccccc(o)=o)(o)=o_').
%activity(id107,inactive).
atom(id107,a1,'C').
atom(id107,a2,'C').
atom(id107,a3,'C').
atom(id107,a4,'C').
atom(id107,a5,'C').
atom(id107,a6,'C').
atom(id107,a7,'C').
atom(id107,a8,'C').
atom(id107,a9,'O').
atom(id107,a10,'O').
atom(id107,a11,'O').
atom(id107,a12,'O').
bond(id107,a2,a1,single).
bond(id107,a3,a2,single).
bond(id107,a4,a3,single).
bond(id107,a5,a4,single).
bond(id107,a6,a5,single).
bond(id107,a7,a6,single).
bond(id107,a8,a7,single).
bond(id107,a9,a8,single).
bond(id107,a10,a8,double).
bond(id107,a11,a1,single).
bond(id107,a12,a1,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 108
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id108,108).
dsstox_filename(id108,nctrer_v1a_232_23oct03).
activity_category_er_rba(id108,inactive).
cas(id108,'575-43-9').
chemclass_erb(id108,misc).
chemcount(id108,'1').
chemname(id108,'1,6-dimethylnaphthalene').
chemnote(id108,'unknown').
er_rba(id108,0).
f1_ring(id108,1).
f2_aromatic_ring(id108,1).
f3_phenolic_ring(id108,0).
f4_heteroatom(id108,0).
f5_phenol3nphenyl(id108,0).
f6_other_key_features(id108,0).
formula(id108,c12h12).
log_er_rba(id108,-10000).
logp(id108,4.26).
mean_er_rba_chemclass(id108,na).
molweight(id108,156.2268).
structureshown(id108,tested_form).
substancetype(id108,defined_organic).
testedform(id108,parent).
smiles(id108,'c12c(cc(cc1)c)cccc2c_').
%activity(id108,inactive).
atom(id108,a1,'C').
atom(id108,a2,'C').
atom(id108,a3,'C').
atom(id108,a4,'C').
atom(id108,a5,'C').
atom(id108,a6,'C').
atom(id108,a7,'C').
atom(id108,a8,'C').
atom(id108,a9,'C').
atom(id108,a10,'C').
atom(id108,a11,'C').
atom(id108,a12,'C').
bond(id108,a2,a1,double).
bond(id108,a3,a2,single).
bond(id108,a4,a3,double).
bond(id108,a5,a4,single).
bond(id108,a6,a5,double).
bond(id108,a6,a1,single).
bond(id108,a7,a4,single).
bond(id108,a8,a2,single).
bond(id108,a9,a8,double).
bond(id108,a10,a9,single).
bond(id108,a11,a10,double).
bond(id108,a11,a1,single).
bond(id108,a12,a11,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 109
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id109,109).
dsstox_filename(id109,nctrer_v1a_232_23oct03).
activity_category_er_rba(id109,inactive).
cas(id109,'629-41-4').
chemclass_erb(id109,misc).
chemcount(id109,'1').
chemname(id109,'1,8-octanediol').
chemnote(id109,'unknown').
er_rba(id109,0).
f1_ring(id109,0).
f2_aromatic_ring(id109,0).
f3_phenolic_ring(id109,0).
f4_heteroatom(id109,0).
f5_phenol3nphenyl(id109,0).
f6_other_key_features(id109,0).
formula(id109,c8h18o2).
log_er_rba(id109,-10000).
logp(id109,1.75).
mean_er_rba_chemclass(id109,na).
molweight(id109,146.229).
structureshown(id109,tested_form).
substancetype(id109,defined_organic).
testedform(id109,parent).
smiles(id109,'occcccccco_').
%activity(id109,inactive).
atom(id109,a1,'O').
atom(id109,a2,'C').
atom(id109,a3,'C').
atom(id109,a4,'C').
atom(id109,a5,'C').
atom(id109,a6,'C').
atom(id109,a7,'C').
atom(id109,a8,'C').
atom(id109,a9,'C').
atom(id109,a10,'O').
bond(id109,a2,a1,single).
bond(id109,a3,a2,single).
bond(id109,a4,a3,single).
bond(id109,a5,a4,single).
bond(id109,a6,a5,single).
bond(id109,a7,a6,single).
bond(id109,a8,a7,single).
bond(id109,a9,a8,single).
bond(id109,a10,a9,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 110
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id110,110).
dsstox_filename(id110,nctrer_v1a_232_23oct03).
activity_category_er_rba(id110,inactive).
cas(id110,'94-25-7').
chemclass_erb(id110,misc).
chemcount(id110,'1').
chemname(id110,'4-amino_butylbenzoate').
chemnote(id110,'unknown').
er_rba(id110,0).
f1_ring(id110,1).
f2_aromatic_ring(id110,1).
f3_phenolic_ring(id110,0).
f4_heteroatom(id110,0).
f5_phenol3nphenyl(id110,0).
f6_other_key_features(id110,0).
formula(id110,c11h15no2).
log_er_rba(id110,-10000).
logp(id110,2.78).
mean_er_rba_chemclass(id110,na).
molweight(id110,193.245).
structureshown(id110,tested_form).
substancetype(id110,defined_organic).
testedform(id110,parent).
smiles(id110,'c(c1ccc(cc1)n)(=o)occcc_').
%activity(id110,inactive).
atom(id110,a1,'C').
atom(id110,a2,'C').
atom(id110,a3,'C').
atom(id110,a4,'C').
atom(id110,a5,'C').
atom(id110,a6,'C').
atom(id110,a7,'C').
atom(id110,a8,'N').
atom(id110,a9,'O').
atom(id110,a10,'O').
atom(id110,a11,'C').
atom(id110,a12,'C').
atom(id110,a13,'C').
atom(id110,a14,'C').
bond(id110,a2,a1,single).
bond(id110,a3,a2,single).
bond(id110,a4,a3,double).
bond(id110,a5,a4,single).
bond(id110,a6,a5,double).
bond(id110,a7,a6,single).
bond(id110,a7,a2,double).
bond(id110,a8,a5,single).
bond(id110,a9,a1,double).
bond(id110,a10,a1,single).
bond(id110,a11,a10,single).
bond(id110,a12,a11,single).
bond(id110,a13,a12,single).
bond(id110,a14,a13,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 111
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id111,111).
dsstox_filename(id111,nctrer_v1a_232_23oct03).
activity_category_er_rba(id111,inactive).
cas(id111,'121-33-5').
chemclass_erb(id111,phenols_alkyloxy).
chemcount(id111,'1').
chemname(id111,'vanillin').
chemnote(id111,'not_in_fig_6c_of_main_citation').
er_rba(id111,0).
f1_ring(id111,1).
f2_aromatic_ring(id111,1).
f3_phenolic_ring(id111,1).
f4_heteroatom(id111,0).
f5_phenol3nphenyl(id111,0).
f6_other_key_features(id111,0).
formula(id111,c8h8o3).
log_er_rba(id111,-10000).
logp(id111,1.05).
mean_er_rba_chemclass(id111,0.00088).
molweight(id111,152.1494).
structureshown(id111,tested_form).
substancetype(id111,defined_organic).
testedform(id111,parent).
smiles(id111,'c1(c(ccc(c1)c=o)o)oc_').
%activity(id111,inactive).
atom(id111,a1,'C').
atom(id111,a2,'C').
atom(id111,a3,'C').
atom(id111,a4,'C').
atom(id111,a5,'C').
atom(id111,a6,'C').
atom(id111,a7,'C').
atom(id111,a8,'O').
atom(id111,a9,'O').
atom(id111,a10,'O').
atom(id111,a11,'C').
bond(id111,a2,a1,double).
bond(id111,a3,a2,single).
bond(id111,a4,a3,double).
bond(id111,a5,a4,single).
bond(id111,a6,a5,double).
bond(id111,a6,a1,single).
bond(id111,a7,a5,single).
bond(id111,a8,a7,double).
bond(id111,a9,a2,single).
bond(id111,a10,a1,single).
bond(id111,a11,a10,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 112
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id112,112).
dsstox_filename(id112,nctrer_v1a_232_23oct03).
activity_category_er_rba(id112,inactive).
cas(id112,'52-39-1').
chemclass_erb(id112,steroids_without_aromatic_a_ring).
chemcount(id112,'1').
chemname(id112,'aldosterone').
chemnote(id112,'stereochem').
er_rba(id112,0).
f1_ring(id112,1).
f2_aromatic_ring(id112,0).
f3_phenolic_ring(id112,0).
f4_heteroatom(id112,1).
f5_phenol3nphenyl(id112,0).
f6_other_key_features(id112,1).
formula(id112,c21h28o5).
log_er_rba(id112,-10000).
logp(id112,0.5).
mean_er_rba_chemclass(id112,1.24).
molweight(id112,360.4492).
structureshown(id112,tested_form).
substancetype(id112,defined_organic).
testedform(id112,parent).
smiles(id112,'c1c2c3c(cc(c2c2(c(c1)=cc(cc2)=o)c)o)(c(cc3)c(=o)co)c=o_').
%activity(id112,inactive).
atom(id112,a1,'C').
atom(id112,a2,'C').
atom(id112,a3,'C').
atom(id112,a4,'C').
atom(id112,a5,'C').
atom(id112,a6,'C').
atom(id112,a7,'C').
atom(id112,a8,'C').
atom(id112,a9,'C').
atom(id112,a10,'C').
atom(id112,a11,'C').
atom(id112,a12,'C').
atom(id112,a13,'C').
atom(id112,a14,'O').
atom(id112,a15,'C').
atom(id112,a16,'C').
atom(id112,a17,'C').
atom(id112,a18,'C').
atom(id112,a19,'C').
atom(id112,a20,'C').
atom(id112,a21,'H').
atom(id112,a22,'H').
atom(id112,a23,'H').
atom(id112,a24,'C').
atom(id112,a25,'O').
atom(id112,a26,'C').
atom(id112,a27,'O').
atom(id112,a28,'O').
atom(id112,a29,'O').
bond(id112,a1,a2,single).
bond(id112,a2,a3,single).
bond(id112,a3,a4,single).
bond(id112,a4,a5,single).
bond(id112,a5,a6,single).
bond(id112,a6,a7,single).
bond(id112,a7,a8,single).
bond(id112,a8,a9,single).
bond(id112,a9,a10,single).
bond(id112,a1,a10,single).
bond(id112,a3,a8,single).
bond(id112,a7,a11,single).
bond(id112,a11,a12,single).
bond(id112,a12,a13,single).
bond(id112,a13,a14,double).
bond(id112,a13,a15,single).
bond(id112,a6,a15,double).
bond(id112,a2,a16,single).
bond(id112,a16,a17,single).
bond(id112,a17,a18,single).
bond(id112,a1,a18,single).
bond(id112,a19,a25,double).
bond(id112,a19,a26,single).
bond(id112,a26,a27,single).
bond(id112,a20,a28,double).
bond(id112,a,a,double).
bond(id112,a,a,double).
bond(id112,a,a,double).
bond(id112,a,a,double).
bond(id112,a,a,double).
bond(id112,a,a,double).
bond(id112,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 113
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id113,113).
dsstox_filename(id113,nctrer_v1a_232_23oct03).
activity_category_er_rba(id113,inactive).
cas(id113,'51-61-6').
chemclass_erb(id113,misc).
chemcount(id113,'1').
chemname(id113,'dopamine').
chemnote(id113,'unknown').
er_rba(id113,0).
f1_ring(id113,1).
f2_aromatic_ring(id113,1).
f3_phenolic_ring(id113,1).
f4_heteroatom(id113,0).
f5_phenol3nphenyl(id113,0).
f6_other_key_features(id113,0).
formula(id113,c8h11no2).
log_er_rba(id113,-10000).
logp(id113,0.38).
mean_er_rba_chemclass(id113,na).
molweight(id113,153.1804).
structureshown(id113,tested_form).
substancetype(id113,defined_organic).
testedform(id113,parent).
smiles(id113,'nccc1cc(o)c(o)cc1_').
%activity(id113,inactive).
atom(id113,a1,'N').
atom(id113,a2,'C').
atom(id113,a3,'C').
atom(id113,a4,'C').
atom(id113,a5,'C').
atom(id113,a6,'C').
atom(id113,a7,'O').
atom(id113,a8,'C').
atom(id113,a9,'O').
atom(id113,a10,'C').
atom(id113,a11,'C').
bond(id113,a2,a1,single).
bond(id113,a3,a2,single).
bond(id113,a4,a3,single).
bond(id113,a5,a4,double).
bond(id113,a6,a5,single).
bond(id113,a7,a6,single).
bond(id113,a8,a6,double).
bond(id113,a9,a8,single).
bond(id113,a10,a8,single).
bond(id113,a11,a10,double).
bond(id113,a11,a4,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 114
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id114,114).
dsstox_filename(id114,nctrer_v1a_232_23oct03).
activity_category_er_rba(id114,inactive).
cas(id114,'73-31-4').
chemclass_erb(id114,misc).
chemcount(id114,'1').
chemname(id114,'melatonin').
chemnote(id114,'unknown').
er_rba(id114,0).
f1_ring(id114,1).
f2_aromatic_ring(id114,1).
f3_phenolic_ring(id114,0).
f4_heteroatom(id114,0).
f5_phenol3nphenyl(id114,0).
f6_other_key_features(id114,0).
formula(id114,c13h16n2o2).
log_er_rba(id114,-10000).
logp(id114,1.65).
mean_er_rba_chemclass(id114,na).
molweight(id114,232.2816).
structureshown(id114,tested_form).
substancetype(id114,defined_organic).
testedform(id114,parent).
smiles(id114,'o=c(c)nccc1c[nh]c2c1cc(oc)cc2_').
%activity(id114,inactive).
atom(id114,a1,'O').
atom(id114,a2,'C').
atom(id114,a3,'C').
atom(id114,a4,'N').
atom(id114,a5,'C').
atom(id114,a6,'C').
atom(id114,a7,'C').
atom(id114,a8,'C').
atom(id114,a9,'N').
atom(id114,a10,'C').
atom(id114,a11,'C').
atom(id114,a12,'C').
atom(id114,a13,'C').
atom(id114,a14,'O').
atom(id114,a15,'C').
atom(id114,a16,'C').
atom(id114,a17,'C').
bond(id114,a2,a1,double).
bond(id114,a3,a2,single).
bond(id114,a4,a2,single).
bond(id114,a5,a4,single).
bond(id114,a6,a5,single).
bond(id114,a7,a6,single).
bond(id114,a8,a7,double).
bond(id114,a9,a8,single).
bond(id114,a10,a9,single).
bond(id114,a11,a10,double).
bond(id114,a11,a7,single).
bond(id114,a12,a11,single).
bond(id114,a13,a12,double).
bond(id114,a14,a13,single).
bond(id114,a15,a14,single).
bond(id114,a16,a13,single).
bond(id114,a17,a16,double).
bond(id114,a17,a10,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 115
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id115,115).
dsstox_filename(id115,nctrer_v1a_232_23oct03).
activity_category_er_rba(id115,inactive).
cas(id115,'101-77-9').
chemclass_erb(id115,misc).
chemcount(id115,'1').
chemname(id115,'4,4_-methylenedianiline').
chemnote(id115,'unknown').
er_rba(id115,0).
f1_ring(id115,1).
f2_aromatic_ring(id115,1).
f3_phenolic_ring(id115,0).
f4_heteroatom(id115,0).
f5_phenol3nphenyl(id115,0).
f6_other_key_features(id115,0).
formula(id115,c13h14n2).
log_er_rba(id115,-10000).
logp(id115,2.18).
mean_er_rba_chemclass(id115,na).
molweight(id115,198.267).
structureshown(id115,tested_form).
substancetype(id115,defined_organic).
testedform(id115,parent).
smiles(id115,'c1(n)ccc(cc1)cc1ccc(cc1)n_').
%activity(id115,inactive).
atom(id115,a1,'C').
atom(id115,a2,'N').
atom(id115,a3,'C').
atom(id115,a4,'C').
atom(id115,a5,'C').
atom(id115,a6,'C').
atom(id115,a7,'C').
atom(id115,a8,'C').
atom(id115,a9,'C').
atom(id115,a10,'C').
atom(id115,a11,'C').
atom(id115,a12,'C').
atom(id115,a13,'C').
atom(id115,a14,'C').
atom(id115,a15,'N').
bond(id115,a2,a1,single).
bond(id115,a3,a1,single).
bond(id115,a4,a3,double).
bond(id115,a5,a4,single).
bond(id115,a6,a5,double).
bond(id115,a7,a6,single).
bond(id115,a7,a1,double).
bond(id115,a8,a5,single).
bond(id115,a9,a8,single).
bond(id115,a10,a9,double).
bond(id115,a11,a10,single).
bond(id115,a12,a11,double).
bond(id115,a13,a12,single).
bond(id115,a14,a13,double).
bond(id115,a14,a9,single).
bond(id115,a15,a12,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 116
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id116,116).
dsstox_filename(id116,nctrer_v1a_232_23oct03).
activity_category_er_rba(id116,inactive).
cas(id116,'95-57-8').
chemclass_erb(id116,phenols_alkyl).
chemcount(id116,'1').
chemname(id116,'2-chlorophenol').
chemnote(id116,'unknown').
er_rba(id116,0).
f1_ring(id116,1).
f2_aromatic_ring(id116,1).
f3_phenolic_ring(id116,1).
f4_heteroatom(id116,0).
f5_phenol3nphenyl(id116,0).
f6_other_key_features(id116,0).
formula(id116,c6h5clo).
log_er_rba(id116,-10000).
logp(id116,2.16).
mean_er_rba_chemclass(id116,0.00088).
molweight(id116,128.5579).
structureshown(id116,tested_form).
substancetype(id116,defined_organic).
testedform(id116,parent).
smiles(id116,'c1(c(o)cccc1)cl_').
%activity(id116,inactive).
atom(id116,a1,'C').
atom(id116,a2,'C').
atom(id116,a3,'O').
atom(id116,a4,'C').
atom(id116,a5,'C').
atom(id116,a6,'C').
atom(id116,a7,'C').
atom(id116,a8,'Cl').
bond(id116,a2,a1,double).
bond(id116,a3,a2,single).
bond(id116,a4,a2,single).
bond(id116,a5,a4,double).
bond(id116,a6,a5,single).
bond(id116,a7,a6,double).
bond(id116,a7,a1,single).
bond(id116,a8,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 117
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id117,117).
dsstox_filename(id117,nctrer_v1a_232_23oct03).
activity_category_er_rba(id117,inactive).
cas(id117,'60-57-1').
chemclass_erb(id117,misc).
chemcount(id117,'1').
chemname(id117,'dieldrin').
chemnote(id117,'stereochem').
er_rba(id117,0).
f1_ring(id117,1).
f2_aromatic_ring(id117,0).
f3_phenolic_ring(id117,0).
f4_heteroatom(id117,1).
f5_phenol3nphenyl(id117,0).
f6_other_key_features(id117,0).
formula(id117,c12h8cl6o).
log_er_rba(id117,-10000).
logp(id117,5.45).
mean_er_rba_chemclass(id117,na).
molweight(id117,380.9126).
structureshown(id117,tested_form).
substancetype(id117,defined_organic).
testedform(id117,parent).
smiles(id117,'o1c2c1c1cc2c2c3(c(=c(c(c12)(c3(cl)cl)cl)cl)cl)cl_').
%activity(id117,inactive).
atom(id117,a1,'C').
atom(id117,a2,'O').
atom(id117,a3,'C').
atom(id117,a4,'C').
atom(id117,a5,'C').
atom(id117,a6,'C').
atom(id117,a7,'C').
atom(id117,a8,'C').
atom(id117,a9,'C').
atom(id117,a10,'C').
atom(id117,a11,'C').
atom(id117,a12,'C').
atom(id117,a13,'Cl').
atom(id117,a14,'Cl').
atom(id117,a15,'Cl').
atom(id117,a16,'C').
atom(id117,a17,'Cl').
atom(id117,a18,'Cl').
atom(id117,a19,'Cl').
bond(id117,a1,a2,single).
bond(id117,a2,a3,single).
bond(id117,a3,a1,single).
bond(id117,a1,a4,single).
bond(id117,a4,a5,single).
bond(id117,a3,a6,single).
bond(id117,a6,a7,single).
bond(id117,a7,a4,single).
bond(id117,a6,a8,single).
bond(id117,a5,a9,single).
bond(id117,a8,a10,single).
bond(id117,a10,a11,single).
bond(id117,a9,a12,single).
bond(id117,a12,a11,double).
bond(id117,a12,a13,single).
bond(id117,a11,a14,single).
bond(id117,a10,a16,single).
bond(id117,a9,a16,single).
bond(id117,a16,a17,single).
bond(id117,a16,a18,single).
bond(id117,a5,a8,single).
bond(id117,a,a,double).
bond(id117,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 118
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id118,118).
dsstox_filename(id118,nctrer_v1a_232_23oct03).
activity_category_er_rba(id118,active_weak).
cas(id118,'611-99-4').
chemclass_erb(id118,diphenylmethanes_benzophenone).
chemcount(id118,'1').
chemname(id118,'4,4_-dihydoxy-benzophenone').
chemnote(id118,'unknown').
er_rba(id118,0.0035).
f1_ring(id118,1).
f2_aromatic_ring(id118,1).
f3_phenolic_ring(id118,1).
f4_heteroatom(id118,0).
f5_phenol3nphenyl(id118,1).
f6_other_key_features(id118,0).
formula(id118,c13h10o3).
log_er_rba(id118,-2.46).
logp(id118,2.19).
mean_er_rba_chemclass(id118,0.0087).
molweight(id118,214.2202).
structureshown(id118,tested_form).
substancetype(id118,defined_organic).
testedform(id118,parent).
smiles(id118,'c(c1ccc(cc1)o)(c1ccc(cc1)o)=o_').
%activity(id118,active).
atom(id118,a1,'C').
atom(id118,a2,'C').
atom(id118,a3,'C').
atom(id118,a4,'C').
atom(id118,a5,'C').
atom(id118,a6,'C').
atom(id118,a7,'C').
atom(id118,a8,'O').
atom(id118,a9,'C').
atom(id118,a10,'C').
atom(id118,a11,'C').
atom(id118,a12,'C').
atom(id118,a13,'C').
atom(id118,a14,'C').
atom(id118,a15,'O').
atom(id118,a16,'O').
bond(id118,a2,a1,single).
bond(id118,a3,a2,double).
bond(id118,a4,a3,single).
bond(id118,a5,a4,double).
bond(id118,a6,a5,single).
bond(id118,a7,a6,double).
bond(id118,a7,a2,single).
bond(id118,a8,a5,single).
bond(id118,a9,a1,single).
bond(id118,a10,a9,double).
bond(id118,a11,a10,single).
bond(id118,a12,a11,double).
bond(id118,a13,a12,single).
bond(id118,a14,a13,double).
bond(id118,a14,a9,single).
bond(id118,a15,a12,single).
bond(id118,a16,a1,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 119
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id119,119).
dsstox_filename(id119,nctrer_v1a_232_23oct03).
activity_category_er_rba(id119,inactive).
cas(id119,'94-75-7').
chemclass_erb(id119,misc).
chemcount(id119,'1').
chemname(id119,'2,4-d_(2,4-dichlorophenoxyacetic_acid)').
chemnote(id119,'unknown').
er_rba(id119,0).
f1_ring(id119,1).
f2_aromatic_ring(id119,1).
f3_phenolic_ring(id119,0).
f4_heteroatom(id119,0).
f5_phenol3nphenyl(id119,0).
f6_other_key_features(id119,0).
formula(id119,c8h6cl2o3).
log_er_rba(id119,-10000).
logp(id119,2.62).
mean_er_rba_chemclass(id119,na).
molweight(id119,221.0396).
structureshown(id119,tested_form).
substancetype(id119,defined_organic).
testedform(id119,parent).
smiles(id119,'c1(cc(cl)ccc1occ(=o)o)cl_').
%activity(id119,inactive).
atom(id119,a1,'C').
atom(id119,a2,'C').
atom(id119,a3,'C').
atom(id119,a4,'Cl').
atom(id119,a5,'C').
atom(id119,a6,'C').
atom(id119,a7,'C').
atom(id119,a8,'O').
atom(id119,a9,'C').
atom(id119,a10,'C').
atom(id119,a11,'O').
atom(id119,a12,'O').
atom(id119,a13,'Cl').
bond(id119,a2,a1,double).
bond(id119,a3,a2,single).
bond(id119,a4,a3,single).
bond(id119,a5,a3,double).
bond(id119,a6,a5,single).
bond(id119,a7,a6,double).
bond(id119,a7,a1,single).
bond(id119,a8,a7,single).
bond(id119,a9,a8,single).
bond(id119,a10,a9,single).
bond(id119,a11,a10,double).
bond(id119,a12,a10,single).
bond(id119,a13,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 120
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id120,120).
dsstox_filename(id120,nctrer_v1a_232_23oct03).
activity_category_er_rba(id120,inactive).
cas(id120,'101-80-4').
chemclass_erb(id120,misc).
chemcount(id120,'1').
chemname(id120,'4-aminophenyl_ether').
chemnote(id120,'unknown').
er_rba(id120,0).
f1_ring(id120,1).
f2_aromatic_ring(id120,1).
f3_phenolic_ring(id120,0).
f4_heteroatom(id120,0).
f5_phenol3nphenyl(id120,0).
f6_other_key_features(id120,0).
formula(id120,c12h12n2o).
log_er_rba(id120,-10000).
logp(id120,2.22).
mean_er_rba_chemclass(id120,na).
molweight(id120,200.2396).
structureshown(id120,tested_form).
substancetype(id120,defined_organic).
testedform(id120,parent).
smiles(id120,'o(c1ccc(cc1)n)c1ccc(cc1)n_').
%activity(id120,inactive).
atom(id120,a1,'O').
atom(id120,a2,'C').
atom(id120,a3,'C').
atom(id120,a4,'C').
atom(id120,a5,'C').
atom(id120,a6,'C').
atom(id120,a7,'C').
atom(id120,a8,'N').
atom(id120,a9,'C').
atom(id120,a10,'C').
atom(id120,a11,'C').
atom(id120,a12,'C').
atom(id120,a13,'C').
atom(id120,a14,'C').
atom(id120,a15,'N').
bond(id120,a2,a1,single).
bond(id120,a3,a2,double).
bond(id120,a4,a3,single).
bond(id120,a5,a4,double).
bond(id120,a6,a5,single).
bond(id120,a7,a6,double).
bond(id120,a7,a2,single).
bond(id120,a8,a5,single).
bond(id120,a9,a1,single).
bond(id120,a10,a9,single).
bond(id120,a11,a10,double).
bond(id120,a12,a11,single).
bond(id120,a13,a12,double).
bond(id120,a14,a13,single).
bond(id120,a14,a9,double).
bond(id120,a15,a12,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 121
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id121,121).
dsstox_filename(id121,nctrer_v1a_232_23oct03).
activity_category_er_rba(id121,inactive).
cas(id121,'14187-32-7').
chemclass_erb(id121,misc).
chemcount(id121,'1').
chemname(id121,'dibenzo-18-crown-6').
chemnote(id121,'unknown').
er_rba(id121,0).
f1_ring(id121,1).
f2_aromatic_ring(id121,1).
f3_phenolic_ring(id121,0).
f4_heteroatom(id121,0).
f5_phenol3nphenyl(id121,0).
f6_other_key_features(id121,0).
formula(id121,c20h24o6).
log_er_rba(id121,-10000).
logp(id121,3.31).
mean_er_rba_chemclass(id121,na).
molweight(id121,360.406).
structureshown(id121,tested_form).
substancetype(id121,defined_organic).
testedform(id121,parent).
smiles(id121,'c12c(occoccoc3c(occocco1)cccc3)cccc2_').
%activity(id121,inactive).
atom(id121,a1,'C').
atom(id121,a2,'C').
atom(id121,a3,'O').
atom(id121,a4,'C').
atom(id121,a5,'C').
atom(id121,a6,'O').
atom(id121,a7,'C').
atom(id121,a8,'C').
atom(id121,a9,'O').
atom(id121,a10,'C').
atom(id121,a11,'C').
atom(id121,a12,'O').
atom(id121,a13,'C').
atom(id121,a14,'C').
atom(id121,a15,'O').
atom(id121,a16,'C').
atom(id121,a17,'C').
atom(id121,a18,'O').
atom(id121,a19,'C').
atom(id121,a20,'C').
atom(id121,a21,'C').
atom(id121,a22,'C').
atom(id121,a23,'C').
atom(id121,a24,'C').
atom(id121,a25,'C').
atom(id121,a26,'C').
bond(id121,a2,a1,single).
bond(id121,a3,a2,single).
bond(id121,a4,a3,single).
bond(id121,a5,a4,single).
bond(id121,a6,a5,single).
bond(id121,a7,a6,single).
bond(id121,a8,a7,single).
bond(id121,a9,a8,single).
bond(id121,a10,a9,single).
bond(id121,a11,a10,double).
bond(id121,a12,a11,single).
bond(id121,a13,a12,single).
bond(id121,a14,a13,single).
bond(id121,a15,a14,single).
bond(id121,a16,a15,single).
bond(id121,a17,a16,single).
bond(id121,a18,a17,single).
bond(id121,a18,a1,single).
bond(id121,a19,a11,single).
bond(id121,a20,a19,double).
bond(id121,a21,a20,single).
bond(id121,a22,a21,double).
bond(id121,a22,a10,single).
bond(id121,a23,a2,double).
bond(id121,a24,a23,single).
bond(id121,a25,a24,double).
bond(id121,a26,a25,single).
bond(id121,a26,a1,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 122
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id122,122).
dsstox_filename(id122,nctrer_v1a_232_23oct03).
activity_category_er_rba(id122,active_weak).
cas(id122,'4250-77-5').
chemclass_erb(id122,phytoestrogens_flavanones).
chemcount(id122,'1').
chemname(id122,'6-hydroxyflavanone').
chemnote(id122,'unknown').
er_rba(id122,0.00089).
f1_ring(id122,1).
f2_aromatic_ring(id122,1).
f3_phenolic_ring(id122,1).
f4_heteroatom(id122,0).
f5_phenol3nphenyl(id122,1).
f6_other_key_features(id122,0).
formula(id122,c15h12o3).
log_er_rba(id122,-3.05).
logp(id122,2.8).
mean_er_rba_chemclass(id122,0.019).
molweight(id122,240.258).
structureshown(id122,tested_form).
substancetype(id122,defined_organic).
testedform(id122,parent).
smiles(id122,'c12c(cc(oc1ccc(c2)o)c1ccccc1)=o_').
%activity(id122,active).
atom(id122,a1,'C').
atom(id122,a2,'C').
atom(id122,a3,'C').
atom(id122,a4,'C').
atom(id122,a5,'O').
atom(id122,a6,'C').
atom(id122,a7,'C').
atom(id122,a8,'C').
atom(id122,a9,'C').
atom(id122,a10,'C').
atom(id122,a11,'O').
atom(id122,a12,'C').
atom(id122,a13,'C').
atom(id122,a14,'C').
atom(id122,a15,'C').
atom(id122,a16,'C').
atom(id122,a17,'C').
atom(id122,a18,'O').
bond(id122,a2,a1,single).
bond(id122,a3,a2,single).
bond(id122,a4,a3,single).
bond(id122,a5,a4,single).
bond(id122,a6,a5,single).
bond(id122,a6,a1,double).
bond(id122,a7,a6,single).
bond(id122,a8,a7,double).
bond(id122,a9,a8,single).
bond(id122,a10,a9,double).
bond(id122,a10,a1,single).
bond(id122,a11,a9,single).
bond(id122,a4,a12,single).
bond(id122,a13,a12,double).
bond(id122,a14,a13,single).
bond(id122,a15,a14,double).
bond(id122,a16,a15,single).
bond(id122,a17,a16,double).
bond(id122,a17,a12,single).
bond(id122,a18,a2,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 123
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id123,123).
dsstox_filename(id123,nctrer_v1a_232_23oct03).
activity_category_er_rba(id123,active_weak).
cas(id123,'6515-36-2').
chemclass_erb(id123,phytoestrogens_flavanones).
chemcount(id123,'1').
chemname(id123,'7-hydroxyflavanone').
chemnote(id123,'unknown').
er_rba(id123,0.00018).
f1_ring(id123,1).
f2_aromatic_ring(id123,1).
f3_phenolic_ring(id123,1).
f4_heteroatom(id123,0).
f5_phenol3nphenyl(id123,1).
f6_other_key_features(id123,0).
formula(id123,c15h12o3).
log_er_rba(id123,-3.73).
logp(id123,2.8).
mean_er_rba_chemclass(id123,0.019).
molweight(id123,240.258).
structureshown(id123,tested_form).
substancetype(id123,defined_organic).
testedform(id123,parent).
smiles(id123,'c12oc(c3ccccc3)cc(c1ccc(c2)o)=o_').
%activity(id123,active).
atom(id123,a1,'C').
atom(id123,a2,'O').
atom(id123,a3,'C').
atom(id123,a4,'C').
atom(id123,a5,'C').
atom(id123,a6,'C').
atom(id123,a7,'C').
atom(id123,a8,'C').
atom(id123,a9,'C').
atom(id123,a10,'C').
atom(id123,a11,'C').
atom(id123,a12,'C').
atom(id123,a13,'C').
atom(id123,a14,'C').
atom(id123,a15,'C').
atom(id123,a16,'C').
atom(id123,a17,'O').
atom(id123,a18,'O').
bond(id123,a2,a1,single).
bond(id123,a3,a2,single).
bond(id123,a3,a4,single).
bond(id123,a5,a4,double).
bond(id123,a6,a5,single).
bond(id123,a7,a6,double).
bond(id123,a8,a7,single).
bond(id123,a9,a8,double).
bond(id123,a9,a4,single).
bond(id123,a10,a3,single).
bond(id123,a11,a10,single).
bond(id123,a12,a11,single).
bond(id123,a12,a1,double).
bond(id123,a13,a12,single).
bond(id123,a14,a13,double).
bond(id123,a15,a14,single).
bond(id123,a16,a15,double).
bond(id123,a16,a1,single).
bond(id123,a17,a15,single).
bond(id123,a18,a11,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 124
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id124,124).
dsstox_filename(id124,nctrer_v1a_232_23oct03).
activity_category_er_rba(id124,inactive).
cas(id124,'915-67-3').
chemclass_erb(id124,misc).
chemcount(id124,'1').
chemname(id124,'amaranth_(fd&c_red_no._2)').
chemnote(id124,'unknown').
er_rba(id124,0).
f1_ring(id124,1).
f2_aromatic_ring(id124,1).
f3_phenolic_ring(id124,1).
f4_heteroatom(id124,0).
f5_phenol3nphenyl(id124,1).
f6_other_key_features(id124,0).
formula(id124,c20h11n2na3o10s3).
log_er_rba(id124,-10000).
logp(id124,1.63).
mean_er_rba_chemclass(id124,na).
molweight(id124,604.46361).
structureshown(id124,tested_form).
substancetype(id124,defined_organic).
testedform(id124,salt).
smiles(id124,'c12c(cc(s(=o)(=o)[o-])c(c1n=nc1c3c(c(s(=o)(=o)[o-])cc1)cccc3)o)cc(s(=o)(=o)[o-])cc2.[na+].[na+].[na+]_').
%activity(id124,inactive).
atom(id124,a1,'C').
atom(id124,a2,'C').
atom(id124,a3,'C').
atom(id124,a4,'C').
atom(id124,a5,'S').
atom(id124,a6,'O').
atom(id124,a7,'O').
atom(id124,a8,'O').
atom(id124,a9,'C').
atom(id124,a10,'C').
atom(id124,a11,'N').
atom(id124,a12,'N').
atom(id124,a13,'C').
atom(id124,a14,'C').
atom(id124,a15,'C').
atom(id124,a16,'C').
atom(id124,a17,'S').
atom(id124,a18,'O').
atom(id124,a19,'O').
atom(id124,a20,'O').
atom(id124,a21,'C').
atom(id124,a22,'C').
atom(id124,a23,'C').
atom(id124,a24,'C').
atom(id124,a25,'C').
atom(id124,a26,'C').
atom(id124,a27,'O').
atom(id124,a28,'C').
atom(id124,a29,'C').
atom(id124,a30,'S').
atom(id124,a31,'O').
atom(id124,a32,'O').
atom(id124,a33,'O').
atom(id124,a34,'C').
atom(id124,a35,'C').
atom(id124,a36,'Na').
atom(id124,a37,'Na').
atom(id124,a38,'Na').
bond(id124,a2,a1,single).
bond(id124,a3,a2,double).
bond(id124,a4,a3,single).
bond(id124,a5,a4,single).
bond(id124,a6,a5,double).
bond(id124,a7,a5,double).
bond(id124,a8,a5,single).
bond(id124,a9,a4,double).
bond(id124,a10,a9,single).
bond(id124,a10,a1,double).
bond(id124,a11,a10,single).
bond(id124,a12,a11,double).
bond(id124,a13,a12,single).
bond(id124,a14,a13,double).
bond(id124,a15,a14,single).
bond(id124,a16,a15,double).
bond(id124,a17,a16,single).
bond(id124,a18,a17,double).
bond(id124,a19,a17,double).
bond(id124,a20,a17,single).
bond(id124,a21,a16,single).
bond(id124,a22,a21,double).
bond(id124,a22,a13,single).
bond(id124,a23,a15,single).
bond(id124,a24,a23,double).
bond(id124,a25,a24,single).
bond(id124,a26,a25,double).
bond(id124,a26,a14,single).
bond(id124,a27,a9,single).
bond(id124,a28,a2,single).
bond(id124,a29,a28,double).
bond(id124,a30,a29,single).
bond(id124,a31,a30,double).
bond(id124,a32,a30,double).
bond(id124,a33,a30,single).
bond(id124,a34,a29,single).
bond(id124,a35,a34,double).
bond(id124,a35,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 125
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id125,125).
dsstox_filename(id125,nctrer_v1a_232_23oct03).
activity_category_er_rba(id125,inactive).
cas(id125,'218-01-9').
chemclass_erb(id125,misc).
chemcount(id125,'1').
chemname(id125,'chrysene').
chemnote(id125,'unknown').
er_rba(id125,0).
f1_ring(id125,1).
f2_aromatic_ring(id125,1).
f3_phenolic_ring(id125,0).
f4_heteroatom(id125,0).
f5_phenol3nphenyl(id125,0).
f6_other_key_features(id125,0).
formula(id125,c18h12).
log_er_rba(id125,-10000).
logp(id125,5.52).
mean_er_rba_chemclass(id125,na).
molweight(id125,228.2928).
structureshown(id125,tested_form).
substancetype(id125,defined_organic).
testedform(id125,parent).
smiles(id125,'c12c(c3ccccc3cc1)ccc1c2cccc1_').
%activity(id125,inactive).
atom(id125,a1,'C').
atom(id125,a2,'C').
atom(id125,a3,'C').
atom(id125,a4,'C').
atom(id125,a5,'C').
atom(id125,a6,'C').
atom(id125,a7,'C').
atom(id125,a8,'C').
atom(id125,a9,'C').
atom(id125,a10,'C').
atom(id125,a11,'C').
atom(id125,a12,'C').
atom(id125,a13,'C').
atom(id125,a14,'C').
atom(id125,a15,'C').
atom(id125,a16,'C').
atom(id125,a17,'C').
atom(id125,a18,'C').
bond(id125,a2,a1,double).
bond(id125,a3,a2,single).
bond(id125,a4,a3,single).
bond(id125,a5,a4,double).
bond(id125,a6,a5,single).
bond(id125,a7,a6,double).
bond(id125,a8,a7,single).
bond(id125,a9,a8,single).
bond(id125,a10,a9,double).
bond(id125,a10,a1,single).
bond(id125,a8,a3,double).
bond(id125,a11,a2,single).
bond(id125,a12,a11,double).
bond(id125,a13,a12,single).
bond(id125,a14,a13,double).
bond(id125,a14,a1,single).
bond(id125,a15,a14,single).
bond(id125,a16,a15,double).
bond(id125,a17,a16,single).
bond(id125,a18,a17,double).
bond(id125,a18,a13,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 126
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id126,126).
dsstox_filename(id126,nctrer_v1a_232_23oct03).
activity_category_er_rba(id126,inactive).
cas(id126,'63-25-2').
chemclass_erb(id126,misc).
chemcount(id126,'1').
chemname(id126,'carbaryl').
chemnote(id126,'unknown').
er_rba(id126,0).
f1_ring(id126,1).
f2_aromatic_ring(id126,1).
f3_phenolic_ring(id126,0).
f4_heteroatom(id126,0).
f5_phenol3nphenyl(id126,0).
f6_other_key_features(id126,0).
formula(id126,c12h11no2).
log_er_rba(id126,-10000).
logp(id126,2.35).
mean_er_rba_chemclass(id126,na).
molweight(id126,201.2244).
structureshown(id126,tested_form).
substancetype(id126,defined_organic).
testedform(id126,parent).
smiles(id126,'c(oc1c2c(cccc2)ccc1)(=o)nc_').
%activity(id126,inactive).
atom(id126,a1,'C').
atom(id126,a2,'O').
atom(id126,a3,'C').
atom(id126,a4,'C').
atom(id126,a5,'C').
atom(id126,a6,'C').
atom(id126,a7,'C').
atom(id126,a8,'C').
atom(id126,a9,'C').
atom(id126,a10,'C').
atom(id126,a11,'C').
atom(id126,a12,'C').
atom(id126,a13,'O').
atom(id126,a14,'N').
atom(id126,a15,'C').
bond(id126,a2,a1,single).
bond(id126,a3,a2,single).
bond(id126,a4,a3,single).
bond(id126,a5,a4,double).
bond(id126,a6,a5,single).
bond(id126,a7,a6,double).
bond(id126,a8,a7,single).
bond(id126,a9,a8,double).
bond(id126,a9,a4,single).
bond(id126,a10,a5,single).
bond(id126,a11,a10,double).
bond(id126,a12,a11,single).
bond(id126,a12,a3,double).
bond(id126,a13,a1,double).
bond(id126,a14,a1,single).
bond(id126,a15,a14,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 127
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id127,127).
dsstox_filename(id127,nctrer_v1a_232_23oct03).
activity_category_er_rba(id127,inactive).
cas(id127,'1563-66-2').
chemclass_erb(id127,misc).
chemcount(id127,'1').
chemname(id127,'carbofuran').
chemnote(id127,'unknown').
er_rba(id127,0).
f1_ring(id127,1).
f2_aromatic_ring(id127,1).
f3_phenolic_ring(id127,0).
f4_heteroatom(id127,0).
f5_phenol3nphenyl(id127,0).
f6_other_key_features(id127,0).
formula(id127,c12h15no3).
log_er_rba(id127,-10000).
logp(id127,2.3).
mean_er_rba_chemclass(id127,na).
molweight(id127,221.2554).
structureshown(id127,tested_form).
substancetype(id127,defined_organic).
testedform(id127,parent).
smiles(id127,'c12oc(c)(c)cc1cccc2oc(=o)nc_').
%activity(id127,inactive).
atom(id127,a1,'C').
atom(id127,a2,'O').
atom(id127,a3,'C').
atom(id127,a4,'C').
atom(id127,a5,'C').
atom(id127,a6,'C').
atom(id127,a7,'C').
atom(id127,a8,'C').
atom(id127,a9,'C').
atom(id127,a10,'C').
atom(id127,a11,'C').
atom(id127,a12,'O').
atom(id127,a13,'C').
atom(id127,a14,'O').
atom(id127,a15,'N').
atom(id127,a16,'C').
bond(id127,a2,a1,single).
bond(id127,a3,a2,single).
bond(id127,a4,a3,single).
bond(id127,a5,a3,single).
bond(id127,a6,a3,single).
bond(id127,a7,a6,single).
bond(id127,a7,a1,single).
bond(id127,a8,a7,double).
bond(id127,a9,a8,single).
bond(id127,a10,a9,double).
bond(id127,a11,a10,single).
bond(id127,a11,a1,double).
bond(id127,a12,a11,single).
bond(id127,a13,a12,single).
bond(id127,a14,a13,double).
bond(id127,a15,a13,single).
bond(id127,a16,a15,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 128
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id128,128).
dsstox_filename(id128,nctrer_v1a_232_23oct03).
activity_category_er_rba(id128,active_weak).
cas(id128,'97-23-4').
chemclass_erb(id128,diphenylmethanes_diphenolalkanes).
chemcount(id128,'1').
chemname(id128,'2,2_-methylenebis(4-chlorophenol)').
chemnote(id128,'unknown').
er_rba(id128,0.0035).
f1_ring(id128,1).
f2_aromatic_ring(id128,1).
f3_phenolic_ring(id128,1).
f4_heteroatom(id128,0).
f5_phenol3nphenyl(id128,1).
f6_other_key_features(id128,0).
formula(id128,c13h10cl2o2).
log_er_rba(id128,-2.45).
logp(id128,4.34).
mean_er_rba_chemclass(id128,0.0087).
molweight(id128,269.1268).
structureshown(id128,tested_form).
substancetype(id128,defined_organic).
testedform(id128,parent).
smiles(id128,'c1(cc2c(ccc(c2)cl)o)c(ccc(c1)cl)o_').
%activity(id128,active).
atom(id128,a1,'C').
atom(id128,a2,'C').
atom(id128,a3,'C').
atom(id128,a4,'C').
atom(id128,a5,'C').
atom(id128,a6,'C').
atom(id128,a7,'C').
atom(id128,a8,'C').
atom(id128,a9,'Cl').
atom(id128,a10,'O').
atom(id128,a11,'C').
atom(id128,a12,'C').
atom(id128,a13,'C').
atom(id128,a14,'C').
atom(id128,a15,'C').
atom(id128,a16,'Cl').
atom(id128,a17,'O').
bond(id128,a2,a1,single).
bond(id128,a3,a2,single).
bond(id128,a4,a3,double).
bond(id128,a5,a4,single).
bond(id128,a6,a5,double).
bond(id128,a7,a6,single).
bond(id128,a8,a7,double).
bond(id128,a8,a3,single).
bond(id128,a9,a7,single).
bond(id128,a10,a4,single).
bond(id128,a11,a1,double).
bond(id128,a12,a11,single).
bond(id128,a13,a12,double).
bond(id128,a14,a13,single).
bond(id128,a15,a14,double).
bond(id128,a15,a1,single).
bond(id128,a16,a14,single).
bond(id128,a17,a11,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 129
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id129,129).
dsstox_filename(id129,nctrer_v1a_232_23oct03).
activity_category_er_rba(id129,active_weak).
cas(id129,'126-00-1').
chemclass_erb(id129,diphenylmethanes_diphenolalkanes).
chemcount(id129,'1').
chemname(id129,'diphenolic_acid').
chemnote(id129,'unknown').
er_rba(id129,0.00074).
f1_ring(id129,1).
f2_aromatic_ring(id129,1).
f3_phenolic_ring(id129,1).
f4_heteroatom(id129,0).
f5_phenol3nphenyl(id129,1).
f6_other_key_features(id129,0).
formula(id129,c17h18o4).
log_er_rba(id129,-3.13).
logp(id129,3.39).
mean_er_rba_chemclass(id129,0.0087).
molweight(id129,286.3268).
structureshown(id129,tested_form).
substancetype(id129,defined_organic).
testedform(id129,parent).
smiles(id129,'c(ccc(=o)o)(c1ccc(cc1)o)(c1ccc(cc1)o)c_').
%activity(id129,active).
atom(id129,a1,'C').
atom(id129,a2,'C').
atom(id129,a3,'C').
atom(id129,a4,'C').
atom(id129,a5,'O').
atom(id129,a6,'O').
atom(id129,a7,'C').
atom(id129,a8,'C').
atom(id129,a9,'C').
atom(id129,a10,'C').
atom(id129,a11,'C').
atom(id129,a12,'C').
atom(id129,a13,'O').
atom(id129,a14,'C').
atom(id129,a15,'C').
atom(id129,a16,'C').
atom(id129,a17,'C').
atom(id129,a18,'C').
atom(id129,a19,'C').
atom(id129,a20,'O').
atom(id129,a21,'C').
bond(id129,a2,a1,single).
bond(id129,a3,a2,single).
bond(id129,a4,a3,single).
bond(id129,a5,a4,double).
bond(id129,a6,a4,single).
bond(id129,a7,a1,single).
bond(id129,a8,a7,single).
bond(id129,a9,a8,double).
bond(id129,a10,a9,single).
bond(id129,a11,a10,double).
bond(id129,a12,a11,single).
bond(id129,a12,a7,double).
bond(id129,a13,a10,single).
bond(id129,a14,a1,single).
bond(id129,a15,a14,double).
bond(id129,a16,a15,single).
bond(id129,a17,a16,double).
bond(id129,a18,a17,single).
bond(id129,a19,a18,double).
bond(id129,a19,a14,single).
bond(id129,a20,a17,single).
bond(id129,a21,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 130
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id130,130).
dsstox_filename(id130,nctrer_v1a_232_23oct03).
activity_category_er_rba(id130,active_medium).
cas(id130,'500-38-9').
chemclass_erb(id130,misc).
chemcount(id130,'1').
chemname(id130,'nordihydroguaiaretic_acid').
chemnote(id130,'stereochem').
er_rba(id130,0.0309).
f1_ring(id130,1).
f2_aromatic_ring(id130,1).
f3_phenolic_ring(id130,1).
f4_heteroatom(id130,0).
f5_phenol3nphenyl(id130,1).
f6_other_key_features(id130,0).
formula(id130,c18h22o4).
log_er_rba(id130,-1.51).
logp(id130,4.64).
mean_er_rba_chemclass(id130,na).
molweight(id130,302.3694).
structureshown(id130,tested_form).
substancetype(id130,defined_organic).
testedform(id130,parent).
smiles(id130,'c1(c(ccc(c1)cc(c(cc1cc(o)c(cc1)o)c)c)o)o_').
%activity(id130,active).
atom(id130,a1,'C').
atom(id130,a2,'C').
atom(id130,a3,'C').
atom(id130,a4,'C').
atom(id130,a5,'C').
atom(id130,a6,'C').
atom(id130,a7,'C').
atom(id130,a8,'C').
atom(id130,a9,'C').
atom(id130,a10,'C').
atom(id130,a11,'C').
atom(id130,a12,'C').
atom(id130,a13,'C').
atom(id130,a14,'O').
atom(id130,a15,'C').
atom(id130,a16,'C').
atom(id130,a17,'C').
atom(id130,a18,'O').
atom(id130,a19,'C').
atom(id130,a20,'C').
atom(id130,a21,'O').
atom(id130,a22,'O').
bond(id130,a2,a1,single).
bond(id130,a3,a2,double).
bond(id130,a4,a3,single).
bond(id130,a5,a4,double).
bond(id130,a6,a5,single).
bond(id130,a6,a1,double).
bond(id130,a7,a5,single).
bond(id130,a8,a7,single).
bond(id130,a9,a8,single).
bond(id130,a10,a9,single).
bond(id130,a11,a10,single).
bond(id130,a12,a11,single).
bond(id130,a13,a12,double).
bond(id130,a14,a13,single).
bond(id130,a15,a13,single).
bond(id130,a16,a15,double).
bond(id130,a17,a16,single).
bond(id130,a17,a11,double).
bond(id130,a18,a15,single).
bond(id130,a21,a2,single).
bond(id130,a22,a1,single).
bond(id130,a,a,double).
bond(id130,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 131
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id131,131).
dsstox_filename(id131,nctrer_v1a_232_23oct03).
activity_category_er_rba(id131,inactive).
cas(id131,'90-43-7').
chemclass_erb(id131,biphenyls_nonchlorinated).
chemcount(id131,'1').
chemname(id131,'2-hydroxy_biphenyl').
chemnote(id131,'2-phenylphenol').
er_rba(id131,0).
f1_ring(id131,1).
f2_aromatic_ring(id131,1).
f3_phenolic_ring(id131,1).
f4_heteroatom(id131,0).
f5_phenol3nphenyl(id131,0).
f6_other_key_features(id131,0).
formula(id131,c12h10o).
log_er_rba(id131,-10000).
logp(id131,3.28).
mean_er_rba_chemclass(id131,0.0028).
molweight(id131,170.2104).
structureshown(id131,tested_form).
substancetype(id131,defined_organic).
testedform(id131,parent).
smiles(id131,'c1(c(o)cccc1)c1ccccc1_').
%activity(id131,inactive).
atom(id131,a1,'C').
atom(id131,a2,'C').
atom(id131,a3,'O').
atom(id131,a4,'C').
atom(id131,a5,'C').
atom(id131,a6,'C').
atom(id131,a7,'C').
atom(id131,a8,'C').
atom(id131,a9,'C').
atom(id131,a10,'C').
atom(id131,a11,'C').
atom(id131,a12,'C').
atom(id131,a13,'C').
bond(id131,a2,a1,single).
bond(id131,a3,a2,single).
bond(id131,a4,a2,double).
bond(id131,a5,a4,single).
bond(id131,a6,a5,double).
bond(id131,a7,a6,single).
bond(id131,a7,a1,double).
bond(id131,a8,a1,single).
bond(id131,a9,a8,double).
bond(id131,a10,a9,single).
bond(id131,a11,a10,double).
bond(id131,a12,a11,single).
bond(id131,a13,a12,double).
bond(id131,a13,a8,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 132
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id132,132).
dsstox_filename(id132,nctrer_v1a_232_23oct03).
activity_category_er_rba(id132,active_weak).
cas(id132,'81-90-3').
chemclass_erb(id132,diphenylmethanes_diphenolalkanes).
chemcount(id132,'1').
chemname(id132,'phenolphthalin').
chemnote(id132,'unknown').
er_rba(id132,0.00021).
f1_ring(id132,1).
f2_aromatic_ring(id132,1).
f3_phenolic_ring(id132,1).
f4_heteroatom(id132,0).
f5_phenol3nphenyl(id132,1).
f6_other_key_features(id132,0).
formula(id132,c20h16o4).
log_er_rba(id132,-3.67).
logp(id132,3.95).
mean_er_rba_chemclass(id132,0.0087).
molweight(id132,320.344).
structureshown(id132,tested_form).
substancetype(id132,defined_organic).
testedform(id132,parent).
smiles(id132,'c1(c(c(=o)o)cccc1)c(c1ccc(cc1)o)c1ccc(cc1)o_').
%activity(id132,active).
atom(id132,a1,'C').
atom(id132,a2,'C').
atom(id132,a3,'C').
atom(id132,a4,'O').
atom(id132,a5,'O').
atom(id132,a6,'C').
atom(id132,a7,'C').
atom(id132,a8,'C').
atom(id132,a9,'C').
atom(id132,a10,'C').
atom(id132,a11,'C').
atom(id132,a12,'C').
atom(id132,a13,'C').
atom(id132,a14,'C').
atom(id132,a15,'C').
atom(id132,a16,'C').
atom(id132,a17,'O').
atom(id132,a18,'C').
atom(id132,a19,'C').
atom(id132,a20,'C').
atom(id132,a21,'C').
atom(id132,a22,'C').
atom(id132,a23,'C').
atom(id132,a24,'O').
bond(id132,a2,a1,double).
bond(id132,a3,a2,single).
bond(id132,a4,a3,double).
bond(id132,a5,a3,single).
bond(id132,a6,a2,single).
bond(id132,a7,a6,double).
bond(id132,a8,a7,single).
bond(id132,a9,a8,double).
bond(id132,a9,a1,single).
bond(id132,a10,a1,single).
bond(id132,a11,a10,single).
bond(id132,a12,a11,double).
bond(id132,a13,a12,single).
bond(id132,a14,a13,double).
bond(id132,a15,a14,single).
bond(id132,a16,a15,double).
bond(id132,a16,a11,single).
bond(id132,a17,a14,single).
bond(id132,a18,a10,single).
bond(id132,a19,a18,double).
bond(id132,a20,a19,single).
bond(id132,a21,a20,double).
bond(id132,a22,a21,single).
bond(id132,a23,a22,double).
bond(id132,a23,a18,single).
bond(id132,a24,a21,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 133
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id133,133).
dsstox_filename(id133,nctrer_v1a_232_23oct03).
activity_category_er_rba(id133,active_weak).
cas(id133,'92-69-3').
chemclass_erb(id133,biphenyls_nonchlorinated).
chemcount(id133,'1').
chemname(id133,'4-hydroxybiphenyl').
chemnote(id133,'4-phenylphenol').
er_rba(id133,0.00091).
f1_ring(id133,1).
f2_aromatic_ring(id133,1).
f3_phenolic_ring(id133,1).
f4_heteroatom(id133,0).
f5_phenol3nphenyl(id133,0).
f6_other_key_features(id133,1).
formula(id133,c12h10o).
log_er_rba(id133,-3.04).
logp(id133,3.28).
mean_er_rba_chemclass(id133,0.0028).
molweight(id133,170.2104).
structureshown(id133,tested_form).
substancetype(id133,defined_organic).
testedform(id133,parent).
smiles(id133,'c1(c2ccccc2)ccc(cc1)o_').
%activity(id133,active).
atom(id133,a1,'C').
atom(id133,a2,'C').
atom(id133,a3,'C').
atom(id133,a4,'C').
atom(id133,a5,'C').
atom(id133,a6,'C').
atom(id133,a7,'C').
atom(id133,a8,'C').
atom(id133,a9,'C').
atom(id133,a10,'C').
atom(id133,a11,'C').
atom(id133,a12,'C').
atom(id133,a13,'O').
bond(id133,a2,a1,single).
bond(id133,a3,a2,single).
bond(id133,a4,a3,double).
bond(id133,a5,a4,single).
bond(id133,a6,a5,double).
bond(id133,a7,a6,single).
bond(id133,a7,a2,double).
bond(id133,a8,a1,double).
bond(id133,a9,a8,single).
bond(id133,a10,a9,double).
bond(id133,a11,a10,single).
bond(id133,a12,a11,double).
bond(id133,a12,a1,single).
bond(id133,a13,a10,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 134
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id134,134).
dsstox_filename(id134,nctrer_v1a_232_23oct03).
activity_category_er_rba(id134,active_strong).
cas(id134,'82413-20-5').
chemclass_erb(id134,des_triphenylethylenes).
chemcount(id134,'1').
chemname(id134,'droloxifene').
chemnote(id134,'unknown').
er_rba(id134,15.14).
f1_ring(id134,1).
f2_aromatic_ring(id134,1).
f3_phenolic_ring(id134,1).
f4_heteroatom(id134,0).
f5_phenol3nphenyl(id134,1).
f6_other_key_features(id134,0).
formula(id134,c26h29no2).
log_er_rba(id134,1.18).
logp(id134,5.82).
mean_er_rba_chemclass(id134,2.14).
molweight(id134,387.5206).
structureshown(id134,tested_form).
substancetype(id134,defined_organic).
testedform(id134,parent).
smiles(id134,'c(=c(c1ccccc1)cc)(c1cc(o)ccc1)c1ccc(cc1)occn(c)c_').
%activity(id134,active).
atom(id134,a1,'C').
atom(id134,a2,'C').
atom(id134,a3,'C').
atom(id134,a4,'C').
atom(id134,a5,'C').
atom(id134,a6,'C').
atom(id134,a7,'C').
atom(id134,a8,'C').
atom(id134,a9,'C').
atom(id134,a10,'C').
atom(id134,a11,'C').
atom(id134,a12,'C').
atom(id134,a13,'C').
atom(id134,a14,'O').
atom(id134,a15,'C').
atom(id134,a16,'C').
atom(id134,a17,'C').
atom(id134,a18,'C').
atom(id134,a19,'C').
atom(id134,a20,'C').
atom(id134,a21,'C').
atom(id134,a22,'C').
atom(id134,a23,'C').
atom(id134,a24,'O').
atom(id134,a25,'C').
atom(id134,a26,'C').
atom(id134,a27,'N').
atom(id134,a28,'C').
atom(id134,a29,'C').
bond(id134,a2,a1,double).
bond(id134,a3,a2,single).
bond(id134,a4,a3,double).
bond(id134,a5,a4,single).
bond(id134,a6,a5,double).
bond(id134,a7,a6,single).
bond(id134,a8,a7,double).
bond(id134,a8,a3,single).
bond(id134,a9,a2,single).
bond(id134,a10,a9,single).
bond(id134,a11,a1,single).
bond(id134,a12,a11,double).
bond(id134,a13,a12,single).
bond(id134,a14,a13,single).
bond(id134,a15,a13,double).
bond(id134,a16,a15,single).
bond(id134,a17,a16,double).
bond(id134,a17,a11,single).
bond(id134,a18,a1,single).
bond(id134,a19,a18,double).
bond(id134,a20,a19,single).
bond(id134,a21,a20,double).
bond(id134,a22,a21,single).
bond(id134,a23,a22,double).
bond(id134,a23,a18,single).
bond(id134,a24,a21,single).
bond(id134,a25,a24,single).
bond(id134,a26,a25,single).
bond(id134,a27,a26,single).
bond(id134,a28,a27,single).
bond(id134,a29,a27,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 135
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id135,135).
dsstox_filename(id135,nctrer_v1a_232_23oct03).
activity_category_er_rba(id135,active_medium).
cas(id135,'77-40-7').
chemclass_erb(id135,diphenylmethanes_diphenolalkanes).
chemcount(id135,'1').
chemname(id135,'bisphenol_b').
chemnote(id135,'unknown').
er_rba(id135,0.0851).
f1_ring(id135,1).
f2_aromatic_ring(id135,1).
f3_phenolic_ring(id135,1).
f4_heteroatom(id135,0).
f5_phenol3nphenyl(id135,1).
f6_other_key_features(id135,0).
formula(id135,c16h18o2).
log_er_rba(id135,-1.07).
logp(id135,4.13).
mean_er_rba_chemclass(id135,0.0087).
molweight(id135,242.317).
structureshown(id135,tested_form).
substancetype(id135,defined_organic).
testedform(id135,parent).
smiles(id135,'c(c1ccc(cc1)o)(c1ccc(cc1)o)(cc)c_').
%activity(id135,active).
atom(id135,a1,'C').
atom(id135,a2,'C').
atom(id135,a3,'C').
atom(id135,a4,'C').
atom(id135,a5,'C').
atom(id135,a6,'C').
atom(id135,a7,'C').
atom(id135,a8,'O').
atom(id135,a9,'C').
atom(id135,a10,'C').
atom(id135,a11,'C').
atom(id135,a12,'C').
atom(id135,a13,'C').
atom(id135,a14,'C').
atom(id135,a15,'O').
atom(id135,a16,'C').
atom(id135,a17,'C').
atom(id135,a18,'C').
bond(id135,a2,a1,single).
bond(id135,a3,a2,single).
bond(id135,a4,a3,double).
bond(id135,a5,a4,single).
bond(id135,a6,a5,double).
bond(id135,a7,a6,single).
bond(id135,a7,a2,double).
bond(id135,a8,a5,single).
bond(id135,a9,a1,single).
bond(id135,a10,a9,double).
bond(id135,a11,a10,single).
bond(id135,a12,a11,double).
bond(id135,a13,a12,single).
bond(id135,a14,a13,double).
bond(id135,a14,a9,single).
bond(id135,a15,a12,single).
bond(id135,a16,a1,single).
bond(id135,a17,a16,single).
bond(id135,a18,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 136
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id136,136).
dsstox_filename(id136,nctrer_v1a_232_23oct03).
activity_category_er_rba(id136,active_strong).
cas(id136,'na').
chemclass_erb(id136,des_triphenylethylenes).
chemcount(id136,'1').
chemname(id136,'toremifene_citrate').
chemnote(id136,'cas_testedform_na,_parent_cas_[89778-26-7]').
er_rba(id136,1.38).
f1_ring(id136,1).
f2_aromatic_ring(id136,1).
f3_phenolic_ring(id136,0).
f4_heteroatom(id136,0).
f5_phenol3nphenyl(id136,0).
f6_other_key_features(id136,1).
formula(id136,c32h36clno8).
log_er_rba(id136,0.14).
logp(id136,6.56).
mean_er_rba_chemclass(id136,2.14).
molweight(id136,598.0913).
structureshown(id136,tested_form).
substancetype(id136,defined_organic).
testedform(id136,complex).
smiles(id136,'c(=c(c1ccccc1)cccl)(c1ccc(cc1)occn(c)c)c1ccccc1.c(cc(=o)o)(cc(=o)o)(c(=o)o)o_').
%activity(id136,active).
atom(id136,a1,'C').
atom(id136,a2,'C').
atom(id136,a3,'C').
atom(id136,a4,'C').
atom(id136,a5,'C').
atom(id136,a6,'C').
atom(id136,a7,'C').
atom(id136,a8,'C').
atom(id136,a9,'C').
atom(id136,a10,'C').
atom(id136,a11,'Cl').
atom(id136,a12,'C').
atom(id136,a13,'C').
atom(id136,a14,'C').
atom(id136,a15,'C').
atom(id136,a16,'C').
atom(id136,a17,'C').
atom(id136,a18,'O').
atom(id136,a19,'C').
atom(id136,a20,'C').
atom(id136,a21,'N').
atom(id136,a22,'C').
atom(id136,a23,'C').
atom(id136,a24,'C').
atom(id136,a25,'C').
atom(id136,a26,'C').
atom(id136,a27,'C').
atom(id136,a28,'C').
atom(id136,a29,'C').
atom(id136,a30,'C').
atom(id136,a31,'C').
atom(id136,a32,'C').
atom(id136,a33,'O').
atom(id136,a34,'O').
atom(id136,a35,'C').
atom(id136,a36,'C').
atom(id136,a37,'O').
atom(id136,a38,'O').
atom(id136,a39,'C').
atom(id136,a40,'O').
atom(id136,a41,'O').
atom(id136,a42,'O').
bond(id136,a2,a1,double).
bond(id136,a3,a2,single).
bond(id136,a4,a3,double).
bond(id136,a5,a4,single).
bond(id136,a6,a5,double).
bond(id136,a7,a6,single).
bond(id136,a8,a7,double).
bond(id136,a8,a3,single).
bond(id136,a9,a2,single).
bond(id136,a10,a9,single).
bond(id136,a11,a10,single).
bond(id136,a12,a1,single).
bond(id136,a13,a12,double).
bond(id136,a14,a13,single).
bond(id136,a15,a14,double).
bond(id136,a16,a15,single).
bond(id136,a17,a16,double).
bond(id136,a17,a12,single).
bond(id136,a18,a15,single).
bond(id136,a19,a18,single).
bond(id136,a20,a19,single).
bond(id136,a21,a20,single).
bond(id136,a22,a21,single).
bond(id136,a23,a21,single).
bond(id136,a24,a1,single).
bond(id136,a25,a24,double).
bond(id136,a26,a25,single).
bond(id136,a27,a26,double).
bond(id136,a28,a27,single).
bond(id136,a29,a28,double).
bond(id136,a29,a24,single).
bond(id136,a31,a30,single).
bond(id136,a32,a31,single).
bond(id136,a33,a32,double).
bond(id136,a34,a32,single).
bond(id136,a35,a30,single).
bond(id136,a36,a35,single).
bond(id136,a37,a36,double).
bond(id136,a38,a36,single).
bond(id136,a39,a30,single).
bond(id136,a40,a39,double).
bond(id136,a41,a39,single).
bond(id136,a42,a30,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 137
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id137,137).
dsstox_filename(id137,nctrer_v1a_232_23oct03).
activity_category_er_rba(id137,active_weak).
cas(id137,'80-46-6').
chemclass_erb(id137,phenols_alkyl).
chemcount(id137,'1').
chemname(id137,'4-tert-amylphenol').
chemnote(id137,'unknown').
er_rba(id137,0.00054).
f1_ring(id137,1).
f2_aromatic_ring(id137,1).
f3_phenolic_ring(id137,1).
f4_heteroatom(id137,0).
f5_phenol3nphenyl(id137,0).
f6_other_key_features(id137,1).
formula(id137,c11h16o).
log_er_rba(id137,-3.26).
logp(id137,3.91).
mean_er_rba_chemclass(id137,0.00088).
molweight(id137,164.2468).
structureshown(id137,tested_form).
substancetype(id137,defined_organic).
testedform(id137,parent).
smiles(id137,'c(c1ccc(cc1)o)(cc)(c)c_').
%activity(id137,active).
atom(id137,a1,'C').
atom(id137,a2,'C').
atom(id137,a3,'C').
atom(id137,a4,'C').
atom(id137,a5,'C').
atom(id137,a6,'C').
atom(id137,a7,'C').
atom(id137,a8,'O').
atom(id137,a9,'C').
atom(id137,a10,'C').
atom(id137,a11,'C').
atom(id137,a12,'C').
bond(id137,a2,a1,single).
bond(id137,a3,a2,single).
bond(id137,a4,a3,double).
bond(id137,a5,a4,single).
bond(id137,a6,a5,double).
bond(id137,a7,a6,single).
bond(id137,a7,a2,double).
bond(id137,a8,a5,single).
bond(id137,a9,a1,single).
bond(id137,a10,a9,single).
bond(id137,a11,a1,single).
bond(id137,a12,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 138
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id138,138).
dsstox_filename(id138,nctrer_v1a_232_23oct03).
activity_category_er_rba(id138,active_weak).
cas(id138,'620-92-8').
chemclass_erb(id138,diphenylmethanes_diphenolalkanes).
chemcount(id138,'1').
chemname(id138,'bis(4-hydroxyphenyl)methane').
chemnote(id138,'bisphenol_f').
er_rba(id138,0.00095).
f1_ring(id138,1).
f2_aromatic_ring(id138,1).
f3_phenolic_ring(id138,1).
f4_heteroatom(id138,0).
f5_phenol3nphenyl(id138,1).
f6_other_key_features(id138,0).
formula(id138,c13h12o2).
log_er_rba(id138,-3.02).
logp(id138,3.06).
mean_er_rba_chemclass(id138,0.0087).
molweight(id138,200.2366).
structureshown(id138,tested_form).
substancetype(id138,defined_organic).
testedform(id138,parent).
smiles(id138,'c1(cc2ccc(cc2)o)ccc(cc1)o_').
%activity(id138,active).
atom(id138,a1,'C').
atom(id138,a2,'C').
atom(id138,a3,'C').
atom(id138,a4,'C').
atom(id138,a5,'C').
atom(id138,a6,'C').
atom(id138,a7,'C').
atom(id138,a8,'C').
atom(id138,a9,'O').
atom(id138,a10,'C').
atom(id138,a11,'C').
atom(id138,a12,'C').
atom(id138,a13,'C').
atom(id138,a14,'C').
atom(id138,a15,'O').
bond(id138,a2,a1,single).
bond(id138,a3,a2,single).
bond(id138,a4,a3,single).
bond(id138,a5,a4,double).
bond(id138,a6,a5,single).
bond(id138,a7,a6,double).
bond(id138,a8,a7,single).
bond(id138,a8,a3,double).
bond(id138,a9,a6,single).
bond(id138,a10,a1,single).
bond(id138,a11,a10,double).
bond(id138,a12,a11,single).
bond(id138,a13,a12,double).
bond(id138,a14,a13,single).
bond(id138,a14,a1,double).
bond(id138,a15,a12,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 139
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id139,139).
dsstox_filename(id139,nctrer_v1a_232_23oct03).
activity_category_er_rba(id139,inactive).
cas(id139,'2467-02-9').
chemclass_erb(id139,diphenylmethanes_diphenolalkanes).
chemcount(id139,'1').
chemname(id139,'bis(2-hydroxyphenyl)methane').
chemnote(id139,'same_as_bisphenol_f,_structure_not_included_in_fig_4a_although_name_incorrectly_listed').
er_rba(id139,0).
f1_ring(id139,1).
f2_aromatic_ring(id139,1).
f3_phenolic_ring(id139,1).
f4_heteroatom(id139,0).
f5_phenol3nphenyl(id139,1).
f6_other_key_features(id139,0).
formula(id139,c13h12o2).
log_er_rba(id139,-10000).
logp(id139,3.06).
mean_er_rba_chemclass(id139,0.0087).
molweight(id139,200.2366).
structureshown(id139,tested_form).
substancetype(id139,defined_organic).
testedform(id139,parent).
smiles(id139,'c(c1c(o)cccc1)c1c(o)cccc1_').
%activity(id139,inactive).
atom(id139,a1,'C').
atom(id139,a2,'C').
atom(id139,a3,'C').
atom(id139,a4,'O').
atom(id139,a5,'C').
atom(id139,a6,'C').
atom(id139,a7,'C').
atom(id139,a8,'C').
atom(id139,a9,'C').
atom(id139,a10,'C').
atom(id139,a11,'O').
atom(id139,a12,'C').
atom(id139,a13,'C').
atom(id139,a14,'C').
atom(id139,a15,'C').
bond(id139,a2,a1,single).
bond(id139,a3,a2,double).
bond(id139,a4,a3,single).
bond(id139,a5,a3,single).
bond(id139,a6,a5,double).
bond(id139,a7,a6,single).
bond(id139,a8,a7,double).
bond(id139,a8,a2,single).
bond(id139,a9,a1,single).
bond(id139,a10,a9,double).
bond(id139,a11,a10,single).
bond(id139,a12,a10,single).
bond(id139,a13,a12,double).
bond(id139,a14,a13,single).
bond(id139,a15,a14,double).
bond(id139,a15,a9,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 140
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id140,140).
dsstox_filename(id140,nctrer_v1a_232_23oct03).
activity_category_er_rba(id140,active_weak).
cas(id140,'123-07-9').
chemclass_erb(id140,phenols_alkyl).
chemcount(id140,'1').
chemname(id140,'4-ethylphenol').
chemnote(id140,'unknown').
er_rba(id140,6.0E-005).
f1_ring(id140,1).
f2_aromatic_ring(id140,1).
f3_phenolic_ring(id140,1).
f4_heteroatom(id140,0).
f5_phenol3nphenyl(id140,0).
f6_other_key_features(id140,1).
formula(id140,c8h10o).
log_er_rba(id140,-4.17).
logp(id140,2.55).
mean_er_rba_chemclass(id140,0.00088).
molweight(id140,122.1664).
structureshown(id140,tested_form).
substancetype(id140,defined_organic).
testedform(id140,parent).
smiles(id140,'c1(ccc(cc1)cc)o_').
%activity(id140,active).
atom(id140,a1,'C').
atom(id140,a2,'C').
atom(id140,a3,'C').
atom(id140,a4,'C').
atom(id140,a5,'C').
atom(id140,a6,'C').
atom(id140,a7,'C').
atom(id140,a8,'C').
atom(id140,a9,'O').
bond(id140,a2,a1,double).
bond(id140,a3,a2,single).
bond(id140,a4,a3,double).
bond(id140,a5,a4,single).
bond(id140,a6,a5,double).
bond(id140,a6,a1,single).
bond(id140,a7,a4,single).
bond(id140,a8,a7,single).
bond(id140,a9,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 141
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id141,141).
dsstox_filename(id141,nctrer_v1a_232_23oct03).
activity_category_er_rba(id141,inactive).
cas(id141,'51218-45-2').
chemclass_erb(id141,misc).
chemcount(id141,'1').
chemname(id141,'netolachlor').
chemnote(id141,'unknown').
er_rba(id141,0).
f1_ring(id141,1).
f2_aromatic_ring(id141,1).
f3_phenolic_ring(id141,0).
f4_heteroatom(id141,0).
f5_phenol3nphenyl(id141,0).
f6_other_key_features(id141,0).
formula(id141,c15h22clno2).
log_er_rba(id141,-10000).
logp(id141,3.24).
mean_er_rba_chemclass(id141,na).
molweight(id141,283.7973).
structureshown(id141,tested_form).
substancetype(id141,defined_organic).
testedform(id141,parent).
smiles(id141,'n(c1c(cccc1cc)c)(c(=o)ccl)c(coc)c_').
%activity(id141,inactive).
atom(id141,a1,'N').
atom(id141,a2,'C').
atom(id141,a3,'C').
atom(id141,a4,'C').
atom(id141,a5,'C').
atom(id141,a6,'C').
atom(id141,a7,'C').
atom(id141,a8,'C').
atom(id141,a9,'C').
atom(id141,a10,'C').
atom(id141,a11,'C').
atom(id141,a12,'O').
atom(id141,a13,'C').
atom(id141,a14,'Cl').
atom(id141,a15,'C').
atom(id141,a16,'C').
atom(id141,a17,'O').
atom(id141,a18,'C').
atom(id141,a19,'C').
bond(id141,a2,a1,single).
bond(id141,a3,a2,single).
bond(id141,a4,a3,double).
bond(id141,a5,a4,single).
bond(id141,a6,a5,double).
bond(id141,a7,a6,single).
bond(id141,a7,a2,double).
bond(id141,a8,a7,single).
bond(id141,a9,a8,single).
bond(id141,a10,a3,single).
bond(id141,a11,a1,single).
bond(id141,a12,a11,double).
bond(id141,a13,a11,single).
bond(id141,a14,a13,single).
bond(id141,a15,a1,single).
bond(id141,a16,a15,single).
bond(id141,a17,a16,single).
bond(id141,a18,a17,single).
bond(id141,a15,a19,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 142
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id142,142).
dsstox_filename(id142,nctrer_v1a_232_23oct03).
activity_category_er_rba(id142,inactive).
cas(id142,'108-95-2').
chemclass_erb(id142,phenols_alkyl).
chemcount(id142,'1').
chemname(id142,'phenol').
chemnote(id142,'not_in_fig_6a_of_main_citation').
er_rba(id142,0).
f1_ring(id142,1).
f2_aromatic_ring(id142,1).
f3_phenolic_ring(id142,1).
f4_heteroatom(id142,0).
f5_phenol3nphenyl(id142,0).
f6_other_key_features(id142,0).
formula(id142,c6h6o).
log_er_rba(id142,-10000).
logp(id142,1.51).
mean_er_rba_chemclass(id142,0.00088).
molweight(id142,94.1128).
structureshown(id142,tested_form).
substancetype(id142,defined_organic).
testedform(id142,parent).
smiles(id142,'c1(o)ccccc1_').
%activity(id142,inactive).
atom(id142,a1,'C').
atom(id142,a2,'O').
atom(id142,a3,'C').
atom(id142,a4,'C').
atom(id142,a5,'C').
atom(id142,a6,'C').
atom(id142,a7,'C').
bond(id142,a2,a1,single).
bond(id142,a3,a1,double).
bond(id142,a4,a3,single).
bond(id142,a5,a4,double).
bond(id142,a6,a5,single).
bond(id142,a7,a6,double).
bond(id142,a7,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 143
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id143,143).
dsstox_filename(id143,nctrer_v1a_232_23oct03).
activity_category_er_rba(id143,inactive).
cas(id143,'480-18-2').
chemclass_erb(id143,phytoestrogens_flavanones).
chemcount(id143,'1').
chemname(id143,'taxifolin').
chemnote(id143,'stereochem').
er_rba(id143,0).
f1_ring(id143,1).
f2_aromatic_ring(id143,1).
f3_phenolic_ring(id143,1).
f4_heteroatom(id143,0).
f5_phenol3nphenyl(id143,1).
f6_other_key_features(id143,0).
formula(id143,c15h12o7).
log_er_rba(id143,-10000).
logp(id143,0.59).
mean_er_rba_chemclass(id143,0.019).
molweight(id143,304.2556).
structureshown(id143,tested_form).
substancetype(id143,defined_organic).
testedform(id143,parent).
smiles(id143,'c12c(c(o)c(oc1cc(cc2o)o)c1cc(o)c(cc1)o)=o_').
%activity(id143,inactive).
atom(id143,a1,'C').
atom(id143,a2,'C').
atom(id143,a3,'C').
atom(id143,a4,'O').
atom(id143,a5,'C').
atom(id143,a6,'O').
atom(id143,a7,'C').
atom(id143,a8,'C').
atom(id143,a9,'C').
atom(id143,a10,'C').
atom(id143,a11,'C').
atom(id143,a12,'O').
atom(id143,a13,'O').
atom(id143,a14,'C').
atom(id143,a15,'C').
atom(id143,a16,'C').
atom(id143,a17,'O').
atom(id143,a18,'C').
atom(id143,a19,'C').
atom(id143,a20,'C').
atom(id143,a21,'O').
atom(id143,a22,'O').
bond(id143,a2,a1,single).
bond(id143,a3,a2,single).
bond(id143,a5,a3,single).
bond(id143,a6,a5,single).
bond(id143,a7,a6,single).
bond(id143,a7,a1,single).
bond(id143,a8,a7,double).
bond(id143,a9,a8,single).
bond(id143,a10,a9,double).
bond(id143,a11,a10,single).
bond(id143,a11,a1,double).
bond(id143,a12,a11,single).
bond(id143,a13,a9,single).
bond(id143,a15,a14,single).
bond(id143,a16,a15,double).
bond(id143,a17,a16,single).
bond(id143,a18,a16,single).
bond(id143,a19,a18,double).
bond(id143,a20,a19,single).
bond(id143,a20,a14,double).
bond(id143,a21,a18,single).
bond(id143,a22,a2,double).
bond(id143,a,a,double).
bond(id143,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 144
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id144,144).
dsstox_filename(id144,nctrer_v1a_232_23oct03).
activity_category_er_rba(id144,active_weak).
cas(id144,'485-63-2').
chemclass_erb(id144,phytoestrogens_isoflavones).
chemcount(id144,'1').
chemname(id144,'3_,4_,7-trihydroxy_isoflavone').
chemnote(id144,'unknown').
er_rba(id144,0.00446).
f1_ring(id144,1).
f2_aromatic_ring(id144,1).
f3_phenolic_ring(id144,1).
f4_heteroatom(id144,0).
f5_phenol3nphenyl(id144,1).
f6_other_key_features(id144,0).
formula(id144,c15h10o5).
log_er_rba(id144,-2.35).
logp(id144,2.07).
mean_er_rba_chemclass(id144,0.019).
molweight(id144,270.241).
structureshown(id144,tested_form).
substancetype(id144,defined_organic).
testedform(id144,parent).
smiles(id144,'c1(c(c2ccc(cc2oc1)o)=o)c1cc(o)c(cc1)o_').
%activity(id144,active).
atom(id144,a1,'C').
atom(id144,a2,'C').
atom(id144,a3,'C').
atom(id144,a4,'C').
atom(id144,a5,'C').
atom(id144,a6,'C').
atom(id144,a7,'C').
atom(id144,a8,'C').
atom(id144,a9,'O').
atom(id144,a10,'C').
atom(id144,a11,'O').
atom(id144,a12,'O').
atom(id144,a13,'C').
atom(id144,a14,'C').
atom(id144,a15,'C').
atom(id144,a16,'O').
atom(id144,a17,'C').
atom(id144,a18,'C').
atom(id144,a19,'C').
atom(id144,a20,'O').
bond(id144,a2,a1,single).
bond(id144,a3,a2,single).
bond(id144,a4,a3,double).
bond(id144,a5,a4,single).
bond(id144,a6,a5,double).
bond(id144,a7,a6,single).
bond(id144,a8,a7,double).
bond(id144,a9,a8,single).
bond(id144,a10,a9,single).
bond(id144,a10,a1,double).
bond(id144,a8,a3,single).
bond(id144,a11,a6,single).
bond(id144,a12,a2,double).
bond(id144,a13,a1,single).
bond(id144,a14,a13,double).
bond(id144,a15,a14,single).
bond(id144,a16,a15,single).
bond(id144,a17,a15,double).
bond(id144,a18,a17,single).
bond(id144,a19,a18,double).
bond(id144,a19,a13,single).
bond(id144,a20,a17,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 145
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id145,145).
dsstox_filename(id145,nctrer_v1a_232_23oct03).
activity_category_er_rba(id145,inactive).
cas(id145,'17817-31-1').
chemclass_erb(id145,phytoestrogens_isoflavones).
chemcount(id145,'1').
chemname(id145,'4_,6,7-trihydroxy_isoflavone').
chemnote(id145,'unknown').
er_rba(id145,0).
f1_ring(id145,1).
f2_aromatic_ring(id145,1).
f3_phenolic_ring(id145,1).
f4_heteroatom(id145,0).
f5_phenol3nphenyl(id145,1).
f6_other_key_features(id145,0).
formula(id145,c15h10o5).
log_er_rba(id145,-10000).
logp(id145,2.07).
mean_er_rba_chemclass(id145,0.019).
molweight(id145,270.241).
structureshown(id145,tested_form).
substancetype(id145,defined_organic).
testedform(id145,parent).
smiles(id145,'c1(c(c2cc(o)c(cc2oc1)o)=o)c1ccc(cc1)o_').
%activity(id145,inactive).
atom(id145,a1,'C').
atom(id145,a2,'C').
atom(id145,a3,'C').
atom(id145,a4,'C').
atom(id145,a5,'C').
atom(id145,a6,'O').
atom(id145,a7,'C').
atom(id145,a8,'C').
atom(id145,a9,'C').
atom(id145,a10,'O').
atom(id145,a11,'C').
atom(id145,a12,'O').
atom(id145,a13,'O').
atom(id145,a14,'C').
atom(id145,a15,'C').
atom(id145,a16,'C').
atom(id145,a17,'C').
atom(id145,a18,'C').
atom(id145,a19,'C').
atom(id145,a20,'O').
bond(id145,a2,a1,single).
bond(id145,a3,a2,single).
bond(id145,a4,a3,double).
bond(id145,a5,a4,single).
bond(id145,a6,a5,single).
bond(id145,a7,a5,double).
bond(id145,a8,a7,single).
bond(id145,a9,a8,double).
bond(id145,a10,a9,single).
bond(id145,a11,a10,single).
bond(id145,a11,a1,double).
bond(id145,a9,a3,single).
bond(id145,a12,a7,single).
bond(id145,a13,a2,double).
bond(id145,a14,a1,single).
bond(id145,a15,a14,double).
bond(id145,a16,a15,single).
bond(id145,a17,a16,double).
bond(id145,a18,a17,single).
bond(id145,a19,a18,double).
bond(id145,a19,a14,single).
bond(id145,a20,a17,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 146
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id146,146).
dsstox_filename(id146,nctrer_v1a_232_23oct03).
activity_category_er_rba(id146,active_weak).
cas(id146,'20426-12-4').
chemclass_erb(id146,phytoestrogens_chalconoids).
chemcount(id146,'1').
chemname(id146,'4-hydroxy_chalcone').
chemnote(id146,'unknown').
er_rba(id146,0.00281).
f1_ring(id146,1).
f2_aromatic_ring(id146,1).
f3_phenolic_ring(id146,1).
f4_heteroatom(id146,0).
f5_phenol3nphenyl(id146,1).
f6_other_key_features(id146,0).
formula(id146,c15h12o2).
log_er_rba(id146,-2.55).
logp(id146,3.18).
mean_er_rba_chemclass(id146,0.019).
molweight(id146,224.2586).
structureshown(id146,tested_form).
substancetype(id146,defined_organic).
testedform(id146,parent).
smiles(id146,'c(c(=o)c1ccccc1)=cc1ccc(cc1)o_').
%activity(id146,active).
atom(id146,a1,'C').
atom(id146,a2,'C').
atom(id146,a3,'O').
atom(id146,a4,'C').
atom(id146,a5,'C').
atom(id146,a6,'C').
atom(id146,a7,'C').
atom(id146,a8,'C').
atom(id146,a9,'C').
atom(id146,a10,'C').
atom(id146,a11,'C').
atom(id146,a12,'C').
atom(id146,a13,'C').
atom(id146,a14,'C').
atom(id146,a15,'C').
atom(id146,a16,'C').
atom(id146,a17,'O').
bond(id146,a2,a1,single).
bond(id146,a3,a2,double).
bond(id146,a4,a2,single).
bond(id146,a5,a4,single).
bond(id146,a6,a5,double).
bond(id146,a7,a6,single).
bond(id146,a8,a7,double).
bond(id146,a9,a8,single).
bond(id146,a9,a4,double).
bond(id146,a10,a1,double).
bond(id146,a11,a10,single).
bond(id146,a12,a11,double).
bond(id146,a13,a12,single).
bond(id146,a14,a13,double).
bond(id146,a15,a14,single).
bond(id146,a16,a15,double).
bond(id146,a16,a11,single).
bond(id146,a17,a14,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 147
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id147,147).
dsstox_filename(id147,nctrer_v1a_232_23oct03).
activity_category_er_rba(id147,inactive).
cas(id147,'117-84-0').
chemclass_erb(id147,misc).
chemcount(id147,'1').
chemname(id147,'bis(n-octyl)_phthalate').
chemnote(id147,'unknown').
er_rba(id147,0).
f1_ring(id147,1).
f2_aromatic_ring(id147,1).
f3_phenolic_ring(id147,0).
f4_heteroatom(id147,0).
f5_phenol3nphenyl(id147,0).
f6_other_key_features(id147,0).
formula(id147,c24h38o4).
log_er_rba(id147,-10000).
logp(id147,8.54).
mean_er_rba_chemclass(id147,na).
molweight(id147,390.5618).
structureshown(id147,tested_form).
substancetype(id147,defined_organic).
testedform(id147,parent).
smiles(id147,'c1(c(c(=o)occcccccc)cccc1)c(=o)occcccccc_').
%activity(id147,inactive).
atom(id147,a1,'C').
atom(id147,a2,'C').
atom(id147,a3,'C').
atom(id147,a4,'O').
atom(id147,a5,'O').
atom(id147,a6,'C').
atom(id147,a7,'C').
atom(id147,a8,'C').
atom(id147,a9,'C').
atom(id147,a10,'C').
atom(id147,a11,'C').
atom(id147,a12,'C').
atom(id147,a13,'C').
atom(id147,a14,'C').
atom(id147,a15,'C').
atom(id147,a16,'C').
atom(id147,a17,'C').
atom(id147,a18,'C').
atom(id147,a19,'O').
atom(id147,a20,'O').
atom(id147,a21,'C').
atom(id147,a22,'C').
atom(id147,a23,'C').
atom(id147,a24,'C').
atom(id147,a25,'C').
atom(id147,a26,'C').
atom(id147,a27,'C').
atom(id147,a28,'C').
bond(id147,a2,a1,double).
bond(id147,a3,a2,single).
bond(id147,a4,a3,double).
bond(id147,a5,a3,single).
bond(id147,a6,a5,single).
bond(id147,a7,a6,single).
bond(id147,a8,a7,single).
bond(id147,a9,a8,single).
bond(id147,a10,a9,single).
bond(id147,a11,a10,single).
bond(id147,a12,a11,single).
bond(id147,a13,a12,single).
bond(id147,a14,a2,single).
bond(id147,a15,a14,double).
bond(id147,a16,a15,single).
bond(id147,a17,a16,double).
bond(id147,a17,a1,single).
bond(id147,a18,a1,single).
bond(id147,a19,a18,double).
bond(id147,a20,a18,single).
bond(id147,a21,a20,single).
bond(id147,a22,a21,single).
bond(id147,a23,a22,single).
bond(id147,a24,a23,single).
bond(id147,a25,a24,single).
bond(id147,a26,a25,single).
bond(id147,a27,a26,single).
bond(id147,a28,a27,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 148
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id148,148).
dsstox_filename(id148,nctrer_v1a_232_23oct03).
activity_category_er_rba(id148,inactive).
cas(id148,'131-11-3').
chemclass_erb(id148,misc).
chemcount(id148,'1').
chemname(id148,'dimethyl_phthalate').
chemnote(id148,'unknown').
er_rba(id148,0).
f1_ring(id148,1).
f2_aromatic_ring(id148,1).
f3_phenolic_ring(id148,0).
f4_heteroatom(id148,0).
f5_phenol3nphenyl(id148,0).
f6_other_key_features(id148,0).
formula(id148,c10h10o4).
log_er_rba(id148,-10000).
logp(id148,1.66).
mean_er_rba_chemclass(id148,na).
molweight(id148,194.1866).
structureshown(id148,tested_form).
substancetype(id148,defined_organic).
testedform(id148,parent).
smiles(id148,'c1(c(c(=o)oc)cccc1)c(=o)oc_').
%activity(id148,inactive).
atom(id148,a1,'C').
atom(id148,a2,'C').
atom(id148,a3,'C').
atom(id148,a4,'O').
atom(id148,a5,'O').
atom(id148,a6,'C').
atom(id148,a7,'C').
atom(id148,a8,'C').
atom(id148,a9,'C').
atom(id148,a10,'C').
atom(id148,a11,'C').
atom(id148,a12,'O').
atom(id148,a13,'O').
atom(id148,a14,'C').
bond(id148,a2,a1,double).
bond(id148,a3,a2,single).
bond(id148,a4,a3,double).
bond(id148,a5,a3,single).
bond(id148,a6,a5,single).
bond(id148,a7,a2,single).
bond(id148,a8,a7,double).
bond(id148,a9,a8,single).
bond(id148,a10,a9,double).
bond(id148,a10,a1,single).
bond(id148,a11,a1,single).
bond(id148,a12,a11,double).
bond(id148,a13,a11,single).
bond(id148,a14,a13,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 149
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id149,149).
dsstox_filename(id149,nctrer_v1a_232_23oct03).
activity_category_er_rba(id149,active_weak).
cas(id149,'59-50-7').
chemclass_erb(id149,phenols_alkyl).
chemcount(id149,'1').
chemname(id149,'4-chloro-3-methylphenol').
chemnote(id149,'unknown').
er_rba(id149,0.00041).
f1_ring(id149,1).
f2_aromatic_ring(id149,1).
f3_phenolic_ring(id149,1).
f4_heteroatom(id149,0).
f5_phenol3nphenyl(id149,0).
f6_other_key_features(id149,1).
formula(id149,c7h7clo).
log_er_rba(id149,-3.38).
logp(id149,2.7).
mean_er_rba_chemclass(id149,0.00088).
molweight(id149,142.5847).
structureshown(id149,tested_form).
substancetype(id149,defined_organic).
testedform(id149,parent).
smiles(id149,'c1(c(ccc(c1)o)cl)c_').
%activity(id149,active).
atom(id149,a1,'C').
atom(id149,a2,'C').
atom(id149,a3,'C').
atom(id149,a4,'C').
atom(id149,a5,'C').
atom(id149,a6,'C').
atom(id149,a7,'O').
atom(id149,a8,'Cl').
atom(id149,a9,'C').
bond(id149,a2,a1,single).
bond(id149,a3,a2,double).
bond(id149,a4,a3,single).
bond(id149,a5,a4,double).
bond(id149,a6,a5,single).
bond(id149,a6,a1,double).
bond(id149,a7,a5,single).
bond(id149,a8,a2,single).
bond(id149,a9,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 150
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id150,150).
dsstox_filename(id150,nctrer_v1a_232_23oct03).
activity_category_er_rba(id150,active_weak).
cas(id150,'106-44-5').
chemclass_erb(id150,phenols_alkyl).
chemcount(id150,'1').
chemname(id150,'4-cresol').
chemnote(id150,'not_in_fig_6a_of_main_citation').
er_rba(id150,3.0E-005).
f1_ring(id150,1).
f2_aromatic_ring(id150,1).
f3_phenolic_ring(id150,1).
f4_heteroatom(id150,0).
f5_phenol3nphenyl(id150,0).
f6_other_key_features(id150,1).
formula(id150,c7h8o).
log_er_rba(id150,-4.5).
logp(id150,2.06).
mean_er_rba_chemclass(id150,0.00088).
molweight(id150,108.1396).
structureshown(id150,tested_form).
substancetype(id150,defined_organic).
testedform(id150,parent).
smiles(id150,'c1(ccc(cc1)c)o_').
%activity(id150,active).
atom(id150,a1,'C').
atom(id150,a2,'C').
atom(id150,a3,'C').
atom(id150,a4,'C').
atom(id150,a5,'C').
atom(id150,a6,'C').
atom(id150,a7,'C').
atom(id150,a8,'O').
bond(id150,a2,a1,double).
bond(id150,a3,a2,single).
bond(id150,a4,a3,double).
bond(id150,a5,a4,single).
bond(id150,a6,a5,double).
bond(id150,a6,a1,single).
bond(id150,a7,a4,single).
bond(id150,a8,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 151
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id151,151).
dsstox_filename(id151,nctrer_v1a_232_23oct03).
activity_category_er_rba(id151,active_weak).
cas(id151,'2657-25-2').
chemclass_erb(id151,phytoestrogens_chalconoids).
chemcount(id151,'1').
chemname(id151,'4_-hydroxychalcone').
chemnote(id151,'unknown').
er_rba(id151,0.0037).
f1_ring(id151,1).
f2_aromatic_ring(id151,1).
f3_phenolic_ring(id151,1).
f4_heteroatom(id151,0).
f5_phenol3nphenyl(id151,1).
f6_other_key_features(id151,0).
formula(id151,c15h12o2).
log_er_rba(id151,-2.43).
logp(id151,3.18).
mean_er_rba_chemclass(id151,0.019).
molweight(id151,224.2586).
structureshown(id151,tested_form).
substancetype(id151,defined_organic).
testedform(id151,parent).
smiles(id151,'c(c(c1ccc(cc1)o)=o)=cc1ccccc1_').
%activity(id151,active).
atom(id151,a1,'C').
atom(id151,a2,'C').
atom(id151,a3,'C').
atom(id151,a4,'C').
atom(id151,a5,'C').
atom(id151,a6,'C').
atom(id151,a7,'C').
atom(id151,a8,'C').
atom(id151,a9,'O').
atom(id151,a10,'O').
atom(id151,a11,'C').
atom(id151,a12,'C').
atom(id151,a13,'C').
atom(id151,a14,'C').
atom(id151,a15,'C').
atom(id151,a16,'C').
atom(id151,a17,'C').
bond(id151,a2,a1,single).
bond(id151,a3,a2,single).
bond(id151,a4,a3,double).
bond(id151,a5,a4,single).
bond(id151,a6,a5,double).
bond(id151,a7,a6,single).
bond(id151,a8,a7,double).
bond(id151,a8,a3,single).
bond(id151,a9,a6,single).
bond(id151,a10,a2,double).
bond(id151,a11,a1,double).
bond(id151,a12,a11,single).
bond(id151,a13,a12,double).
bond(id151,a14,a13,single).
bond(id151,a15,a14,double).
bond(id151,a16,a15,single).
bond(id151,a17,a16,double).
bond(id151,a17,a12,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 152
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id152,152).
dsstox_filename(id152,nctrer_v1a_232_23oct03).
activity_category_er_rba(id152,inactive).
cas(id152,'886-65-7').
chemclass_erb(id152,misc).
chemcount(id152,'1').
chemname(id152,'trans,trans-1,4-diphenyl-1,3-butadiene').
chemnote(id152,'unknown').
er_rba(id152,0).
f1_ring(id152,1).
f2_aromatic_ring(id152,1).
f3_phenolic_ring(id152,0).
f4_heteroatom(id152,0).
f5_phenol3nphenyl(id152,0).
f6_other_key_features(id152,0).
formula(id152,c16h14).
log_er_rba(id152,-10000).
logp(id152,5.29).
mean_er_rba_chemclass(id152,na).
molweight(id152,206.2866).
structureshown(id152,tested_form).
substancetype(id152,defined_organic).
testedform(id152,parent).
smiles(id152,'c(c=cc1ccccc1)=cc1ccccc1_').
%activity(id152,inactive).
atom(id152,a1,'C').
atom(id152,a2,'C').
atom(id152,a3,'C').
atom(id152,a4,'C').
atom(id152,a5,'C').
atom(id152,a6,'C').
atom(id152,a7,'C').
atom(id152,a8,'C').
atom(id152,a9,'C').
atom(id152,a10,'C').
atom(id152,a11,'C').
atom(id152,a12,'C').
atom(id152,a13,'C').
atom(id152,a14,'C').
atom(id152,a15,'C').
atom(id152,a16,'C').
bond(id152,a2,a1,single).
bond(id152,a3,a2,double).
bond(id152,a4,a3,single).
bond(id152,a5,a4,single).
bond(id152,a6,a5,double).
bond(id152,a7,a6,single).
bond(id152,a8,a7,double).
bond(id152,a9,a8,single).
bond(id152,a9,a4,double).
bond(id152,a10,a1,double).
bond(id152,a11,a10,single).
bond(id152,a12,a11,double).
bond(id152,a13,a12,single).
bond(id152,a14,a13,double).
bond(id152,a15,a14,single).
bond(id152,a16,a15,double).
bond(id152,a16,a11,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 153
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id153,153).
dsstox_filename(id153,nctrer_v1a_232_23oct03).
activity_category_er_rba(id153,active_weak).
cas(id153,'6335-83-7').
chemclass_erb(id153,des_hexestrol_derivatives).
chemcount(id153,'1').
chemname(id153,'4-phenethylphenol').
chemnote(id153,'unknown').
er_rba(id153,0.00204).
f1_ring(id153,1).
f2_aromatic_ring(id153,1).
f3_phenolic_ring(id153,1).
f4_heteroatom(id153,0).
f5_phenol3nphenyl(id153,1).
f6_other_key_features(id153,0).
formula(id153,c14h14o).
log_er_rba(id153,-2.69).
logp(id153,4.26).
mean_er_rba_chemclass(id153,2.14).
molweight(id153,198.264).
structureshown(id153,tested_form).
substancetype(id153,defined_organic).
testedform(id153,parent).
smiles(id153,'c1(ccc(cc1)ccc1ccccc1)o_').
%activity(id153,active).
atom(id153,a1,'C').
atom(id153,a2,'C').
atom(id153,a3,'C').
atom(id153,a4,'C').
atom(id153,a5,'C').
atom(id153,a6,'C').
atom(id153,a7,'C').
atom(id153,a8,'C').
atom(id153,a9,'C').
atom(id153,a10,'C').
atom(id153,a11,'C').
atom(id153,a12,'C').
atom(id153,a13,'C').
atom(id153,a14,'C').
atom(id153,a15,'O').
bond(id153,a2,a1,double).
bond(id153,a3,a2,single).
bond(id153,a4,a3,double).
bond(id153,a5,a4,single).
bond(id153,a6,a5,double).
bond(id153,a6,a1,single).
bond(id153,a7,a4,single).
bond(id153,a8,a7,single).
bond(id153,a9,a8,single).
bond(id153,a10,a9,single).
bond(id153,a11,a10,double).
bond(id153,a12,a11,single).
bond(id153,a13,a12,double).
bond(id153,a14,a13,single).
bond(id153,a14,a9,double).
bond(id153,a15,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 154
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id154,154).
dsstox_filename(id154,nctrer_v1a_232_23oct03).
activity_category_er_rba(id154,active_medium).
cas(id154,'6052-84-2').
chemclass_erb(id154,des_hexestrol_derivatives).
chemcount(id154,'1').
chemname(id154,'4,4_-(1,2-ethanediyl)bisphenol').
chemnote(id154,'unknown').
er_rba(id154,0.0363).
f1_ring(id154,1).
f2_aromatic_ring(id154,1).
f3_phenolic_ring(id154,1).
f4_heteroatom(id154,0).
f5_phenol3nphenyl(id154,1).
f6_other_key_features(id154,0).
formula(id154,c14h14o2).
log_er_rba(id154,-1.44).
logp(id154,3.78).
mean_er_rba_chemclass(id154,2.14).
molweight(id154,214.2634).
structureshown(id154,tested_form).
substancetype(id154,defined_organic).
testedform(id154,parent).
smiles(id154,'c1(ccc(cc1)ccc1ccc(cc1)o)o_').
%activity(id154,active).
atom(id154,a1,'C').
atom(id154,a2,'C').
atom(id154,a3,'C').
atom(id154,a4,'C').
atom(id154,a5,'C').
atom(id154,a6,'C').
atom(id154,a7,'C').
atom(id154,a8,'C').
atom(id154,a9,'C').
atom(id154,a10,'C').
atom(id154,a11,'C').
atom(id154,a12,'C').
atom(id154,a13,'C').
atom(id154,a14,'C').
atom(id154,a15,'O').
atom(id154,a16,'O').
bond(id154,a2,a1,double).
bond(id154,a3,a2,single).
bond(id154,a4,a3,double).
bond(id154,a5,a4,single).
bond(id154,a6,a5,double).
bond(id154,a6,a1,single).
bond(id154,a7,a4,single).
bond(id154,a8,a7,single).
bond(id154,a9,a8,single).
bond(id154,a10,a9,double).
bond(id154,a11,a10,single).
bond(id154,a12,a11,double).
bond(id154,a13,a12,single).
bond(id154,a14,a13,double).
bond(id154,a14,a9,single).
bond(id154,a15,a12,single).
bond(id154,a16,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 155
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id155,155).
dsstox_filename(id155,nctrer_v1a_232_23oct03).
activity_category_er_rba(id155,active_weak).
cas(id155,'580-51-8').
chemclass_erb(id155,biphenyls_nonchlorinated).
chemcount(id155,'1').
chemname(id155,'3-phenylphenol').
chemnote(id155,'unknown').
er_rba(id155,0.00036).
f1_ring(id155,1).
f2_aromatic_ring(id155,1).
f3_phenolic_ring(id155,1).
f4_heteroatom(id155,0).
f5_phenol3nphenyl(id155,0).
f6_other_key_features(id155,0).
formula(id155,c12h10o).
log_er_rba(id155,-3.44).
logp(id155,3.28).
mean_er_rba_chemclass(id155,0.0028).
molweight(id155,170.2104).
structureshown(id155,tested_form).
substancetype(id155,defined_organic).
testedform(id155,parent).
smiles(id155,'c1(cc(o)ccc1)c1ccccc1_').
%activity(id155,active).
atom(id155,a1,'C').
atom(id155,a2,'C').
atom(id155,a3,'C').
atom(id155,a4,'O').
atom(id155,a5,'C').
atom(id155,a6,'C').
atom(id155,a7,'C').
atom(id155,a8,'C').
atom(id155,a9,'C').
atom(id155,a10,'C').
atom(id155,a11,'C').
atom(id155,a12,'C').
atom(id155,a13,'C').
bond(id155,a2,a1,double).
bond(id155,a3,a2,single).
bond(id155,a4,a3,single).
bond(id155,a5,a3,double).
bond(id155,a6,a5,single).
bond(id155,a7,a6,double).
bond(id155,a7,a1,single).
bond(id155,a8,a1,single).
bond(id155,a9,a8,double).
bond(id155,a10,a9,single).
bond(id155,a11,a10,double).
bond(id155,a12,a11,single).
bond(id155,a13,a12,double).
bond(id155,a13,a8,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 156
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id156,156).
dsstox_filename(id156,nctrer_v1a_232_23oct03).
activity_category_er_rba(id156,inactive).
cas(id156,'97-53-0').
chemclass_erb(id156,phenols_alkyloxy).
chemcount(id156,'1').
chemname(id156,'eugenol').
chemnote(id156,'not_in_fig_6c_of_main_citation').
er_rba(id156,0).
f1_ring(id156,1).
f2_aromatic_ring(id156,1).
f3_phenolic_ring(id156,1).
f4_heteroatom(id156,0).
f5_phenol3nphenyl(id156,0).
f6_other_key_features(id156,0).
formula(id156,c10h12o2).
log_er_rba(id156,-10000).
logp(id156,2.73).
mean_er_rba_chemclass(id156,0.00088).
molweight(id156,164.2036).
structureshown(id156,tested_form).
substancetype(id156,defined_organic).
testedform(id156,parent).
smiles(id156,'c1(c(ccc(c1)cc=c)o)oc_').
%activity(id156,inactive).
atom(id156,a1,'C').
atom(id156,a2,'C').
atom(id156,a3,'C').
atom(id156,a4,'C').
atom(id156,a5,'C').
atom(id156,a6,'C').
atom(id156,a7,'C').
atom(id156,a8,'C').
atom(id156,a9,'C').
atom(id156,a10,'O').
atom(id156,a11,'O').
atom(id156,a12,'C').
bond(id156,a2,a1,single).
bond(id156,a3,a2,double).
bond(id156,a4,a3,single).
bond(id156,a5,a4,double).
bond(id156,a6,a5,single).
bond(id156,a6,a1,double).
bond(id156,a7,a5,single).
bond(id156,a8,a7,single).
bond(id156,a9,a8,double).
bond(id156,a10,a2,single).
bond(id156,a11,a1,single).
bond(id156,a12,a11,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 157
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id157,157).
dsstox_filename(id157,nctrer_v1a_232_23oct03).
activity_category_er_rba(id157,slight_binder).
cas(id157,'6554-98-9').
chemclass_erb(id157,des_derivatives).
chemcount(id157,'1').
chemname(id157,'trans-4-hydroxystilbene').
chemnote(id157,'stereochem,_4-stilbenol').
er_rba(id157,0).
f1_ring(id157,1).
f2_aromatic_ring(id157,1).
f3_phenolic_ring(id157,1).
f4_heteroatom(id157,0).
f5_phenol3nphenyl(id157,1).
f6_other_key_features(id157,0).
formula(id157,c14h12o).
log_er_rba(id157,-5000).
logp(id157,4.04).
mean_er_rba_chemclass(id157,2.14).
molweight(id157,196.2482).
structureshown(id157,tested_form).
substancetype(id157,defined_organic).
testedform(id157,parent).
smiles(id157,'c(=cc1ccccc1)c1ccc(cc1)o_').
%activity(id157,inactive).
atom(id157,a1,'C').
atom(id157,a2,'C').
atom(id157,a3,'C').
atom(id157,a4,'C').
atom(id157,a5,'C').
atom(id157,a6,'C').
atom(id157,a7,'C').
atom(id157,a8,'C').
atom(id157,a9,'C').
atom(id157,a10,'C').
atom(id157,a11,'C').
atom(id157,a12,'C').
atom(id157,a13,'C').
atom(id157,a14,'C').
atom(id157,a15,'O').
bond(id157,a2,a1,double).
bond(id157,a3,a2,single).
bond(id157,a4,a3,double).
bond(id157,a5,a4,single).
bond(id157,a6,a5,double).
bond(id157,a7,a6,single).
bond(id157,a8,a7,double).
bond(id157,a8,a3,single).
bond(id157,a9,a1,single).
bond(id157,a10,a9,single).
bond(id157,a11,a10,double).
bond(id157,a12,a11,single).
bond(id157,a13,a12,double).
bond(id157,a14,a13,single).
bond(id157,a14,a9,double).
bond(id157,a15,a12,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 158
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id158,158).
dsstox_filename(id158,nctrer_v1a_232_23oct03).
activity_category_er_rba(id158,active_medium).
cas(id158,'659-22-3').
chemclass_erb(id158,des_derivatives).
chemcount(id158,'1').
chemname(id158,'4,4_-dihydroxy_stibene').
chemnote(id158,'unknown').
er_rba(id158,0.282).
f1_ring(id158,1).
f2_aromatic_ring(id158,1).
f3_phenolic_ring(id158,1).
f4_heteroatom(id158,0).
f5_phenol3nphenyl(id158,1).
f6_other_key_features(id158,0).
formula(id158,c14h12o2).
log_er_rba(id158,-0.55).
logp(id158,3.56).
mean_er_rba_chemclass(id158,2.14).
molweight(id158,212.2476).
structureshown(id158,tested_form).
substancetype(id158,defined_organic).
testedform(id158,parent).
smiles(id158,'c(=cc1ccc(cc1)o)c1ccc(cc1)o_').
%activity(id158,active).
atom(id158,a1,'C').
atom(id158,a2,'C').
atom(id158,a3,'C').
atom(id158,a4,'C').
atom(id158,a5,'C').
atom(id158,a6,'C').
atom(id158,a7,'C').
atom(id158,a8,'C').
atom(id158,a9,'O').
atom(id158,a10,'C').
atom(id158,a11,'C').
atom(id158,a12,'C').
atom(id158,a13,'C').
atom(id158,a14,'C').
atom(id158,a15,'C').
atom(id158,a16,'O').
bond(id158,a2,a1,double).
bond(id158,a3,a2,single).
bond(id158,a4,a3,double).
bond(id158,a5,a4,single).
bond(id158,a6,a5,double).
bond(id158,a7,a6,single).
bond(id158,a8,a7,double).
bond(id158,a8,a3,single).
bond(id158,a9,a6,single).
bond(id158,a10,a1,single).
bond(id158,a11,a10,double).
bond(id158,a12,a11,single).
bond(id158,a13,a12,double).
bond(id158,a14,a13,single).
bond(id158,a15,a14,double).
bond(id158,a15,a10,single).
bond(id158,a16,a13,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 159
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id159,159).
dsstox_filename(id159,nctrer_v1a_232_23oct03).
activity_category_er_rba(id159,active_medium).
cas(id159,'961-29-5').
chemclass_erb(id159,phytoestrogens_chalconoids).
chemcount(id159,'1').
chemname(id159,'2_,4,4_-trihydroxychalcone').
chemnote(id159,'unknown').
er_rba(id159,0.055).
f1_ring(id159,1).
f2_aromatic_ring(id159,1).
f3_phenolic_ring(id159,1).
f4_heteroatom(id159,0).
f5_phenol3nphenyl(id159,1).
f6_other_key_features(id159,0).
formula(id159,c15h12o4).
log_er_rba(id159,-1.26).
logp(id159,2.99).
mean_er_rba_chemclass(id159,0.019).
molweight(id159,256.2574).
structureshown(id159,tested_form).
substancetype(id159,defined_organic).
testedform(id159,parent).
smiles(id159,'oc1c(ccc(c1)o)c(=o)c=cc1ccc(o)cc1_').
%activity(id159,active).
atom(id159,a1,'O').
atom(id159,a2,'C').
atom(id159,a3,'C').
atom(id159,a4,'C').
atom(id159,a5,'C').
atom(id159,a6,'C').
atom(id159,a7,'C').
atom(id159,a8,'O').
atom(id159,a9,'C').
atom(id159,a10,'O').
atom(id159,a11,'C').
atom(id159,a12,'C').
atom(id159,a13,'C').
atom(id159,a14,'C').
atom(id159,a15,'C').
atom(id159,a16,'C').
atom(id159,a17,'O').
atom(id159,a18,'C').
atom(id159,a19,'C').
bond(id159,a2,a1,single).
bond(id159,a3,a2,single).
bond(id159,a4,a3,double).
bond(id159,a5,a4,single).
bond(id159,a6,a5,double).
bond(id159,a7,a6,single).
bond(id159,a7,a2,double).
bond(id159,a8,a6,single).
bond(id159,a9,a3,single).
bond(id159,a10,a9,double).
bond(id159,a11,a9,single).
bond(id159,a12,a11,double).
bond(id159,a13,a12,single).
bond(id159,a14,a13,single).
bond(id159,a15,a14,double).
bond(id159,a16,a15,single).
bond(id159,a17,a16,single).
bond(id159,a18,a16,double).
bond(id159,a19,a18,single).
bond(id159,a19,a13,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 160
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id160,160).
dsstox_filename(id160,nctrer_v1a_232_23oct03).
activity_category_er_rba(id160,active_medium).
cas(id160,'63046-09-3').
chemclass_erb(id160,phytoestrogens_flavones).
chemcount(id160,'1').
chemname(id160,'4_,6-dihydroxyflavone').
chemnote(id160,'unknown').
er_rba(id160,0.15135).
f1_ring(id160,1).
f2_aromatic_ring(id160,1).
f3_phenolic_ring(id160,1).
f4_heteroatom(id160,0).
f5_phenol3nphenyl(id160,1).
f6_other_key_features(id160,0).
formula(id160,c15h10o4).
log_er_rba(id160,-0.82).
logp(id160,2.55).
mean_er_rba_chemclass(id160,0.019).
molweight(id160,254.2416).
structureshown(id160,tested_form).
substancetype(id160,defined_organic).
testedform(id160,parent).
smiles(id160,'o1c(cc(c2cc(ccc12)o)=o)c1ccc(o)cc1_').
%activity(id160,active).
atom(id160,a1,'O').
atom(id160,a2,'C').
atom(id160,a3,'C').
atom(id160,a4,'C').
atom(id160,a5,'C').
atom(id160,a6,'C').
atom(id160,a7,'C').
atom(id160,a8,'C').
atom(id160,a9,'C').
atom(id160,a10,'C').
atom(id160,a11,'C').
atom(id160,a12,'C').
atom(id160,a13,'C').
atom(id160,a14,'C').
atom(id160,a15,'C').
atom(id160,a16,'C').
atom(id160,a17,'O').
atom(id160,a18,'O').
atom(id160,a19,'O').
bond(id160,a0,a0,double).
bond(id160,a0,a0,double).
bond(id160,a0,a0,double).
bond(id160,a0,a0,double).
bond(id160,a0,a0,double).
bond(id160,a7,a6,double).
bond(id160,a6,a5,single).
bond(id160,a5,a10,double).
bond(id160,a10,a4,single).
bond(id160,a4,a3,single).
bond(id160,a3,a2,double).
bond(id160,a2,a1,single).
bond(id160,a1,a9,single).
bond(id160,a10,a9,single).
bond(id160,a9,a8,double).
bond(id160,a7,a8,single).
bond(id160,a2,a11,single).
bond(id160,a11,a12,double).
bond(id160,a12,a13,single).
bond(id160,a13,a14,double).
bond(id160,a14,a17,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 161
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id161,161).
dsstox_filename(id161,nctrer_v1a_232_23oct03).
activity_category_er_rba(id161,active_strong).
cas(id161,'552-80-7').
chemclass_erb(id161,des_derivatives).
chemcount(id161,'1').
chemname(id161,'dimethylstibestrol').
chemnote(id161,'unknown').
er_rba(id161,14.45).
f1_ring(id161,1).
f2_aromatic_ring(id161,1).
f3_phenolic_ring(id161,1).
f4_heteroatom(id161,0).
f5_phenol3nphenyl(id161,1).
f6_other_key_features(id161,0).
formula(id161,c16h16o2).
log_er_rba(id161,1.16).
logp(id161,4.66).
mean_er_rba_chemclass(id161,2.14).
molweight(id161,240.3012).
structureshown(id161,tested_form).
substancetype(id161,defined_organic).
testedform(id161,parent).
smiles(id161,'c(=c(c1ccc(cc1)o)c)(c1ccc(cc1)o)c_').
%activity(id161,active).
atom(id161,a1,'C').
atom(id161,a2,'C').
atom(id161,a3,'C').
atom(id161,a4,'C').
atom(id161,a5,'C').
atom(id161,a6,'C').
atom(id161,a7,'C').
atom(id161,a8,'C').
atom(id161,a9,'O').
atom(id161,a10,'C').
atom(id161,a11,'C').
atom(id161,a12,'C').
atom(id161,a13,'C').
atom(id161,a14,'C').
atom(id161,a15,'C').
atom(id161,a16,'C').
atom(id161,a17,'O').
atom(id161,a18,'C').
bond(id161,a2,a1,double).
bond(id161,a3,a2,single).
bond(id161,a4,a3,double).
bond(id161,a5,a4,single).
bond(id161,a6,a5,double).
bond(id161,a7,a6,single).
bond(id161,a8,a7,double).
bond(id161,a8,a3,single).
bond(id161,a9,a6,single).
bond(id161,a10,a2,single).
bond(id161,a11,a1,single).
bond(id161,a12,a11,single).
bond(id161,a13,a12,double).
bond(id161,a14,a13,single).
bond(id161,a15,a14,double).
bond(id161,a16,a15,single).
bond(id161,a16,a11,double).
bond(id161,a17,a14,single).
bond(id161,a18,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 162
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id162,162).
dsstox_filename(id162,nctrer_v1a_232_23oct03).
activity_category_er_rba(id162,active_strong).
cas(id162,'18839-90-2').
chemclass_erb(id162,des_derivatives).
chemcount(id162,'1').
chemname(id162,'diethylstilbestrol_monomethyl_ether').
chemnote(id162,'unknown').
er_rba(id162,20.42).
f1_ring(id162,1).
f2_aromatic_ring(id162,1).
f3_phenolic_ring(id162,1).
f4_heteroatom(id162,0).
f5_phenol3nphenyl(id162,1).
f6_other_key_features(id162,0).
formula(id162,c19h22o2).
log_er_rba(id162,1.31).
logp(id162,6.2).
mean_er_rba_chemclass(id162,2.14).
molweight(id162,282.3816).
structureshown(id162,tested_form).
substancetype(id162,defined_organic).
testedform(id162,parent).
smiles(id162,'c(=c(c1ccc(cc1)oc)cc)(c1ccc(cc1)o)cc_').
%activity(id162,active).
atom(id162,a1,'C').
atom(id162,a2,'C').
atom(id162,a3,'C').
atom(id162,a4,'C').
atom(id162,a5,'C').
atom(id162,a6,'C').
atom(id162,a7,'C').
atom(id162,a8,'C').
atom(id162,a9,'O').
atom(id162,a10,'C').
atom(id162,a11,'C').
atom(id162,a12,'C').
atom(id162,a13,'C').
atom(id162,a14,'C').
atom(id162,a15,'C').
atom(id162,a16,'C').
atom(id162,a17,'C').
atom(id162,a18,'C').
atom(id162,a19,'O').
atom(id162,a20,'C').
atom(id162,a21,'C').
bond(id162,a2,a1,double).
bond(id162,a3,a2,single).
bond(id162,a4,a3,double).
bond(id162,a5,a4,single).
bond(id162,a6,a5,double).
bond(id162,a7,a6,single).
bond(id162,a8,a7,double).
bond(id162,a8,a3,single).
bond(id162,a9,a6,single).
bond(id162,a10,a9,single).
bond(id162,a11,a2,single).
bond(id162,a12,a11,single).
bond(id162,a13,a1,single).
bond(id162,a14,a13,single).
bond(id162,a15,a14,double).
bond(id162,a16,a15,single).
bond(id162,a17,a16,double).
bond(id162,a18,a17,single).
bond(id162,a18,a13,double).
bond(id162,a19,a16,single).
bond(id162,a20,a1,single).
bond(id162,a21,a20,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 163
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id163,163).
dsstox_filename(id163,nctrer_v1a_232_23oct03).
activity_category_er_rba(id163,active_medium).
cas(id163,'2529-64-8').
chemclass_erb(id163,steroids_with_aromatic_a_ring).
chemcount(id163,'1').
chemname(id163,'3-deoxyestradiol').
chemnote(id163,'stereochem').
er_rba(id163,0.501).
f1_ring(id163,1).
f2_aromatic_ring(id163,1).
f3_phenolic_ring(id163,0).
f4_heteroatom(id163,0).
f5_phenol3nphenyl(id163,0).
f6_other_key_features(id163,1).
formula(id163,c18h24o).
log_er_rba(id163,-0.3).
logp(id163,4.42).
mean_er_rba_chemclass(id163,1.24).
molweight(id163,256.387).
structureshown(id163,tested_form).
substancetype(id163,defined_organic).
testedform(id163,parent).
smiles(id163,'c1c2c3c(ccc2c2c(c1)cccc2)(c(cc3)o)c_').
%activity(id163,active).
atom(id163,a1,'C').
atom(id163,a2,'C').
atom(id163,a3,'C').
atom(id163,a4,'C').
atom(id163,a5,'C').
atom(id163,a6,'C').
atom(id163,a7,'C').
atom(id163,a8,'C').
atom(id163,a9,'C').
atom(id163,a10,'C').
atom(id163,a11,'C').
atom(id163,a12,'C').
atom(id163,a13,'C').
atom(id163,a14,'C').
atom(id163,a15,'C').
atom(id163,a16,'C').
atom(id163,a17,'C').
atom(id163,a18,'O').
atom(id163,a19,'C').
atom(id163,a20,'H').
atom(id163,a21,'H').
atom(id163,a22,'H').
bond(id163,a1,a2,single).
bond(id163,a2,a3,single).
bond(id163,a3,a4,single).
bond(id163,a4,a5,single).
bond(id163,a5,a6,single).
bond(id163,a6,a7,double).
bond(id163,a7,a8,single).
bond(id163,a8,a9,single).
bond(id163,a9,a10,single).
bond(id163,a1,a10,single).
bond(id163,a3,a8,single).
bond(id163,a7,a11,single).
bond(id163,a11,a12,double).
bond(id163,a12,a13,single).
bond(id163,a13,a14,double).
bond(id163,a6,a14,single).
bond(id163,a2,a15,single).
bond(id163,a15,a16,single).
bond(id163,a16,a17,single).
bond(id163,a1,a17,single).
bond(id163,a,a,double).
bond(id163,a,a,double).
bond(id163,a,a,double).
bond(id163,a,a,double).
bond(id163,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 164
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id164,164).
dsstox_filename(id164,nctrer_v1a_232_23oct03).
activity_category_er_rba(id164,active_strong).
cas(id164,'53-63-4').
chemclass_erb(id164,steroids_with_aromatic_a_ring).
chemcount(id164,'1').
chemname(id164,'17-deoxyestradiol').
chemnote(id164,'stereochem').
er_rba(id164,13.8).
f1_ring(id164,1).
f2_aromatic_ring(id164,1).
f3_phenolic_ring(id164,1).
f4_heteroatom(id164,0).
f5_phenol3nphenyl(id164,0).
f6_other_key_features(id164,1).
formula(id164,c18h24o).
log_er_rba(id164,1.14).
logp(id164,5.48).
mean_er_rba_chemclass(id164,1.24).
molweight(id164,256.387).
structureshown(id164,tested_form).
substancetype(id164,defined_organic).
testedform(id164,parent).
smiles(id164,'c1c2c3c(ccc2c2c(c1)cc(cc2)o)(ccc3)c_').
%activity(id164,active).
atom(id164,a1,'C').
atom(id164,a2,'C').
atom(id164,a3,'C').
atom(id164,a4,'C').
atom(id164,a5,'C').
atom(id164,a6,'C').
atom(id164,a7,'C').
atom(id164,a8,'C').
atom(id164,a9,'C').
atom(id164,a10,'C').
atom(id164,a11,'C').
atom(id164,a12,'C').
atom(id164,a13,'C').
atom(id164,a14,'O').
atom(id164,a15,'C').
atom(id164,a16,'C').
atom(id164,a17,'C').
atom(id164,a18,'C').
atom(id164,a19,'C').
atom(id164,a20,'H').
atom(id164,a21,'H').
atom(id164,a22,'H').
bond(id164,a1,a2,single).
bond(id164,a2,a3,single).
bond(id164,a3,a4,single).
bond(id164,a4,a5,single).
bond(id164,a5,a6,single).
bond(id164,a6,a7,double).
bond(id164,a7,a8,single).
bond(id164,a8,a9,single).
bond(id164,a9,a10,single).
bond(id164,a1,a10,single).
bond(id164,a3,a8,single).
bond(id164,a7,a11,single).
bond(id164,a11,a12,double).
bond(id164,a12,a13,single).
bond(id164,a13,a14,single).
bond(id164,a13,a15,double).
bond(id164,a6,a15,single).
bond(id164,a2,a16,single).
bond(id164,a16,a17,single).
bond(id164,a17,a18,single).
bond(id164,a1,a18,single).
bond(id164,a,a,double).
bond(id164,a,a,double).
bond(id164,a,a,double).
bond(id164,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 165
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id165,165).
dsstox_filename(id165,nctrer_v1a_232_23oct03).
activity_category_er_rba(id165,inactive).
cas(id165,'104-51-8').
chemclass_erb(id165,misc).
chemcount(id165,'1').
chemname(id165,'n-butylbenzene').
chemnote(id165,'unknown').
er_rba(id165,0).
f1_ring(id165,1).
f2_aromatic_ring(id165,1).
f3_phenolic_ring(id165,0).
f4_heteroatom(id165,0).
f5_phenol3nphenyl(id165,0).
f6_other_key_features(id165,0).
formula(id165,c10h14).
log_er_rba(id165,-10000).
logp(id165,4.01).
mean_er_rba_chemclass(id165,na).
molweight(id165,134.2206).
structureshown(id165,tested_form).
substancetype(id165,defined_organic).
testedform(id165,parent).
smiles(id165,'c1(cccc)ccccc1_').
%activity(id165,inactive).
atom(id165,a1,'C').
atom(id165,a2,'C').
atom(id165,a3,'C').
atom(id165,a4,'C').
atom(id165,a5,'C').
atom(id165,a6,'C').
atom(id165,a7,'C').
atom(id165,a8,'C').
atom(id165,a9,'C').
atom(id165,a10,'C').
bond(id165,a2,a1,single).
bond(id165,a3,a2,single).
bond(id165,a4,a3,single).
bond(id165,a5,a4,single).
bond(id165,a6,a1,single).
bond(id165,a7,a6,double).
bond(id165,a8,a7,single).
bond(id165,a9,a8,double).
bond(id165,a10,a9,single).
bond(id165,a10,a1,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 166
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id166,166).
dsstox_filename(id166,nctrer_v1a_232_23oct03).
activity_category_er_rba(id166,inactive).
cas(id166,'50-02-2').
chemclass_erb(id166,steroids_without_aromatic_a_ring).
chemcount(id166,'1').
chemname(id166,'dexamethasone').
chemnote(id166,'stereochem,_incorrect_structure_listed_in_fig_1_of_main_citation').
er_rba(id166,0).
f1_ring(id166,1).
f2_aromatic_ring(id166,0).
f3_phenolic_ring(id166,0).
f4_heteroatom(id166,1).
f5_phenol3nphenyl(id166,0).
f6_other_key_features(id166,1).
formula(id166,c22h29fo5).
log_er_rba(id166,-10000).
logp(id166,1.72).
mean_er_rba_chemclass(id166,1.24).
molweight(id166,392.4665).
structureshown(id166,tested_form).
substancetype(id166,defined_organic).
testedform(id166,parent).
smiles(id166,'c1c2c3c(cc(c2(c2(c(c1)=cc(c=c2)=o)c)f)o)(c(c(c3)c)(c(=o)co)o)c_').
%activity(id166,inactive).
atom(id166,a1,'C').
atom(id166,a2,'C').
atom(id166,a3,'C').
atom(id166,a4,'C').
atom(id166,a5,'C').
atom(id166,a6,'C').
atom(id166,a7,'C').
atom(id166,a8,'C').
atom(id166,a9,'C').
atom(id166,a10,'C').
atom(id166,a11,'C').
atom(id166,a12,'C').
atom(id166,a13,'C').
atom(id166,a14,'O').
atom(id166,a15,'C').
atom(id166,a16,'C').
atom(id166,a17,'C').
atom(id166,a18,'C').
atom(id166,a19,'C').
atom(id166,a20,'C').
atom(id166,a21,'H').
atom(id166,a22,'F').
atom(id166,a23,'H').
atom(id166,a24,'C').
atom(id166,a25,'O').
atom(id166,a26,'C').
atom(id166,a27,'O').
atom(id166,a28,'O').
atom(id166,a29,'O').
atom(id166,a30,'C').
bond(id166,a1,a2,single).
bond(id166,a2,a3,single).
bond(id166,a3,a4,single).
bond(id166,a4,a5,single).
bond(id166,a5,a6,single).
bond(id166,a6,a7,single).
bond(id166,a7,a8,single).
bond(id166,a8,a9,single).
bond(id166,a9,a10,single).
bond(id166,a1,a10,single).
bond(id166,a3,a8,single).
bond(id166,a7,a11,single).
bond(id166,a11,a12,double).
bond(id166,a12,a13,single).
bond(id166,a13,a14,double).
bond(id166,a13,a15,single).
bond(id166,a6,a15,double).
bond(id166,a2,a16,single).
bond(id166,a16,a17,single).
bond(id166,a17,a18,single).
bond(id166,a1,a18,single).
bond(id166,a19,a25,double).
bond(id166,a19,a26,single).
bond(id166,a26,a27,single).
bond(id166,a,a,double).
bond(id166,a,a,double).
bond(id166,a,a,double).
bond(id166,a,a,double).
bond(id166,a,a,double).
bond(id166,a,a,double).
bond(id166,a,a,double).
bond(id166,a,a,double).
bond(id166,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 167
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id167,167).
dsstox_filename(id167,nctrer_v1a_232_23oct03).
activity_category_er_rba(id167,inactive).
cas(id167,'50-22-6').
chemclass_erb(id167,steroids_without_aromatic_a_ring).
chemcount(id167,'1').
chemname(id167,'corticosterone').
chemnote(id167,'stereochem').
er_rba(id167,0).
f1_ring(id167,1).
f2_aromatic_ring(id167,0).
f3_phenolic_ring(id167,0).
f4_heteroatom(id167,1).
f5_phenol3nphenyl(id167,0).
f6_other_key_features(id167,1).
formula(id167,c21h30o4).
log_er_rba(id167,-10000).
logp(id167,1.99).
mean_er_rba_chemclass(id167,1.24).
molweight(id167,346.4656).
structureshown(id167,tested_form).
substancetype(id167,defined_organic).
testedform(id167,parent).
smiles(id167,'c1c2c3c(cc(c2c2(c(c1)=cc(cc2)=o)c)o)(c(cc3)c(=o)co)c_').
%activity(id167,inactive).
atom(id167,a1,'C').
atom(id167,a2,'C').
atom(id167,a3,'C').
atom(id167,a4,'C').
atom(id167,a5,'C').
atom(id167,a6,'C').
atom(id167,a7,'C').
atom(id167,a8,'C').
atom(id167,a9,'C').
atom(id167,a10,'C').
atom(id167,a11,'C').
atom(id167,a12,'C').
atom(id167,a13,'C').
atom(id167,a14,'O').
atom(id167,a15,'C').
atom(id167,a16,'C').
atom(id167,a17,'C').
atom(id167,a18,'C').
atom(id167,a19,'C').
atom(id167,a20,'C').
atom(id167,a21,'H').
atom(id167,a22,'H').
atom(id167,a23,'H').
atom(id167,a24,'C').
atom(id167,a25,'O').
atom(id167,a26,'C').
atom(id167,a27,'O').
atom(id167,a28,'O').
bond(id167,a1,a2,single).
bond(id167,a2,a3,single).
bond(id167,a3,a4,single).
bond(id167,a4,a5,single).
bond(id167,a5,a6,single).
bond(id167,a6,a7,single).
bond(id167,a7,a8,single).
bond(id167,a8,a9,single).
bond(id167,a9,a10,single).
bond(id167,a1,a10,single).
bond(id167,a3,a8,single).
bond(id167,a7,a11,single).
bond(id167,a11,a12,single).
bond(id167,a12,a13,single).
bond(id167,a13,a14,double).
bond(id167,a13,a15,single).
bond(id167,a6,a15,double).
bond(id167,a2,a16,single).
bond(id167,a16,a17,single).
bond(id167,a17,a18,single).
bond(id167,a1,a18,single).
bond(id167,a19,a25,double).
bond(id167,a19,a26,single).
bond(id167,a26,a27,single).
bond(id167,a,a,double).
bond(id167,a,a,double).
bond(id167,a,a,double).
bond(id167,a,a,double).
bond(id167,a,a,double).
bond(id167,a,a,double).
bond(id167,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 168
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id168,168).
dsstox_filename(id168,nctrer_v1a_232_23oct03).
activity_category_er_rba(id168,inactive).
cas(id168,'58-08-2').
chemclass_erb(id168,misc).
chemcount(id168,'1').
chemname(id168,'caffeine').
chemnote(id168,'unknown').
er_rba(id168,0).
f1_ring(id168,1).
f2_aromatic_ring(id168,1).
f3_phenolic_ring(id168,0).
f4_heteroatom(id168,0).
f5_phenol3nphenyl(id168,0).
f6_other_key_features(id168,0).
formula(id168,c8h10n4o2).
log_er_rba(id168,-10000).
logp(id168,0.16).
mean_er_rba_chemclass(id168,na).
molweight(id168,194.1926).
structureshown(id168,tested_form).
substancetype(id168,defined_organic).
testedform(id168,parent).
smiles(id168,'c12c(c(=o)n(c(n1c)=o)c)n(c)cn2_').
%activity(id168,inactive).
atom(id168,a1,'C').
atom(id168,a2,'C').
atom(id168,a3,'C').
atom(id168,a4,'O').
atom(id168,a5,'N').
atom(id168,a6,'C').
atom(id168,a7,'N').
atom(id168,a8,'C').
atom(id168,a9,'O').
atom(id168,a10,'C').
atom(id168,a11,'N').
atom(id168,a12,'C').
atom(id168,a13,'C').
atom(id168,a14,'N').
bond(id168,a2,a1,double).
bond(id168,a3,a2,single).
bond(id168,a4,a3,double).
bond(id168,a5,a3,single).
bond(id168,a6,a5,single).
bond(id168,a7,a6,single).
bond(id168,a7,a1,single).
bond(id168,a8,a7,single).
bond(id168,a9,a6,double).
bond(id168,a10,a5,single).
bond(id168,a11,a2,single).
bond(id168,a12,a11,single).
bond(id168,a13,a11,single).
bond(id168,a14,a13,double).
bond(id168,a14,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 169
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id169,169).
dsstox_filename(id169,nctrer_v1a_232_23oct03).
activity_category_er_rba(id169,inactive).
cas(id169,'115-86-6').
chemclass_erb(id169,misc).
chemcount(id169,'1').
chemname(id169,'triphenyl_phosphate').
chemnote(id169,'unknown').
er_rba(id169,0).
f1_ring(id169,1).
f2_aromatic_ring(id169,1).
f3_phenolic_ring(id169,0).
f4_heteroatom(id169,0).
f5_phenol3nphenyl(id169,0).
f6_other_key_features(id169,0).
formula(id169,c18h15o4p).
log_er_rba(id169,-10000).
logp(id169,4.7).
mean_er_rba_chemclass(id169,na).
molweight(id169,326.28786).
structureshown(id169,tested_form).
substancetype(id169,defined_organic).
testedform(id169,parent).
smiles(id169,'p(oc1ccccc1)(oc1ccccc1)(oc1ccccc1)=o_').
%activity(id169,inactive).
atom(id169,a1,'P').
atom(id169,a2,'O').
atom(id169,a3,'C').
atom(id169,a4,'C').
atom(id169,a5,'C').
atom(id169,a6,'C').
atom(id169,a7,'C').
atom(id169,a8,'C').
atom(id169,a9,'O').
atom(id169,a10,'C').
atom(id169,a11,'C').
atom(id169,a12,'C').
atom(id169,a13,'C').
atom(id169,a14,'C').
atom(id169,a15,'C').
atom(id169,a16,'O').
atom(id169,a17,'C').
atom(id169,a18,'C').
atom(id169,a19,'C').
atom(id169,a20,'C').
atom(id169,a21,'C').
atom(id169,a22,'C').
atom(id169,a23,'O').
bond(id169,a2,a1,single).
bond(id169,a3,a2,single).
bond(id169,a4,a3,double).
bond(id169,a5,a4,single).
bond(id169,a6,a5,double).
bond(id169,a7,a6,single).
bond(id169,a8,a7,double).
bond(id169,a8,a3,single).
bond(id169,a9,a1,single).
bond(id169,a10,a9,single).
bond(id169,a11,a10,double).
bond(id169,a12,a11,single).
bond(id169,a13,a12,double).
bond(id169,a14,a13,single).
bond(id169,a15,a14,double).
bond(id169,a15,a10,single).
bond(id169,a16,a1,single).
bond(id169,a17,a16,single).
bond(id169,a18,a17,double).
bond(id169,a19,a18,single).
bond(id169,a20,a19,double).
bond(id169,a21,a20,single).
bond(id169,a22,a21,double).
bond(id169,a22,a17,single).
bond(id169,a23,a1,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 170
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id170,170).
dsstox_filename(id170,nctrer_v1a_232_23oct03).
activity_category_er_rba(id170,inactive).
cas(id170,'243-17-4').
chemclass_erb(id170,misc).
chemcount(id170,'1').
chemname(id170,'2,3-benzofluorene').
chemnote(id170,'unknown').
er_rba(id170,0).
f1_ring(id170,1).
f2_aromatic_ring(id170,1).
f3_phenolic_ring(id170,0).
f4_heteroatom(id170,0).
f5_phenol3nphenyl(id170,0).
f6_other_key_features(id170,0).
formula(id170,c17h12).
log_er_rba(id170,-10000).
logp(id170,5.23).
mean_er_rba_chemclass(id170,na).
molweight(id170,216.2818).
structureshown(id170,tested_form).
substancetype(id170,defined_organic).
testedform(id170,parent).
smiles(id170,'c12c(cc3c1cccc3)cc1c(c2)cccc1_').
%activity(id170,inactive).
atom(id170,a1,'C').
atom(id170,a2,'C').
atom(id170,a3,'C').
atom(id170,a4,'C').
atom(id170,a5,'C').
atom(id170,a6,'C').
atom(id170,a7,'C').
atom(id170,a8,'C').
atom(id170,a9,'C').
atom(id170,a10,'C').
atom(id170,a11,'C').
atom(id170,a12,'C').
atom(id170,a13,'C').
atom(id170,a14,'C').
atom(id170,a15,'C').
atom(id170,a16,'C').
atom(id170,a17,'C').
bond(id170,a2,a1,double).
bond(id170,a3,a2,single).
bond(id170,a4,a3,single).
bond(id170,a5,a4,single).
bond(id170,a5,a1,single).
bond(id170,a6,a5,double).
bond(id170,a7,a6,single).
bond(id170,a8,a7,double).
bond(id170,a9,a8,single).
bond(id170,a9,a4,double).
bond(id170,a10,a2,single).
bond(id170,a11,a10,double).
bond(id170,a12,a11,single).
bond(id170,a13,a12,double).
bond(id170,a13,a1,single).
bond(id170,a14,a12,single).
bond(id170,a15,a14,double).
bond(id170,a16,a15,single).
bond(id170,a17,a16,double).
bond(id170,a17,a11,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 171
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id171,171).
dsstox_filename(id171,nctrer_v1a_232_23oct03).
activity_category_er_rba(id171,inactive).
cas(id171,'10236-47-2').
chemclass_erb(id171,phytoestrogens_flavanones).
chemcount(id171,'1').
chemname(id171,'naringin').
chemnote(id171,'stereochem').
er_rba(id171,0).
f1_ring(id171,1).
f2_aromatic_ring(id171,1).
f3_phenolic_ring(id171,1).
f4_heteroatom(id171,0).
f5_phenol3nphenyl(id171,1).
f6_other_key_features(id171,0).
formula(id171,c27h32o14).
log_er_rba(id171,-10000).
logp(id171,-0.52).
mean_er_rba_chemclass(id171,0.019).
molweight(id171,580.5414).
structureshown(id171,tested_form).
substancetype(id171,defined_organic).
testedform(id171,parent).
smiles(id171,'o1c(c(c(c(c1co)o)o)oc1c(c(o)c(c(o1)c)o)o)oc1cc2oc(c3ccc(cc3)o)cc(c2c(c1)o)=o_').
%activity(id171,inactive).
atom(id171,a1,'C').
atom(id171,a2,'C').
atom(id171,a3,'O').
atom(id171,a4,'C').
atom(id171,a5,'C').
atom(id171,a6,'C').
atom(id171,a7,'O').
atom(id171,a8,'O').
atom(id171,a9,'C').
atom(id171,a10,'O').
atom(id171,a11,'O').
atom(id171,a12,'C').
atom(id171,a13,'C').
atom(id171,a14,'C').
atom(id171,a15,'O').
atom(id171,a16,'C').
atom(id171,a17,'C').
atom(id171,a18,'C').
atom(id171,a19,'C').
atom(id171,a20,'C').
atom(id171,a21,'C').
atom(id171,a22,'C').
atom(id171,a23,'O').
atom(id171,a24,'C').
atom(id171,a25,'C').
atom(id171,a26,'C').
atom(id171,a27,'C').
atom(id171,a28,'C').
atom(id171,a29,'O').
atom(id171,a30,'O').
atom(id171,a31,'O').
atom(id171,a32,'C').
atom(id171,a33,'C').
atom(id171,a34,'C').
atom(id171,a35,'O').
atom(id171,a36,'C').
atom(id171,a37,'C').
atom(id171,a38,'O').
atom(id171,a39,'C').
atom(id171,a40,'O').
atom(id171,a41,'O').
bond(id171,a2,a1,single).
bond(id171,a3,a2,single).
bond(id171,a4,a3,single).
bond(id171,a5,a4,single).
bond(id171,a6,a5,single).
bond(id171,a6,a1,single).
bond(id171,a10,a9,single).
bond(id171,a12,a11,single).
bond(id171,a13,a12,single).
bond(id171,a14,a13,double).
bond(id171,a15,a14,single).
bond(id171,a16,a15,single).
bond(id171,a18,a17,double).
bond(id171,a19,a18,single).
bond(id171,a20,a19,double).
bond(id171,a21,a20,single).
bond(id171,a22,a21,double).
bond(id171,a22,a17,single).
bond(id171,a23,a20,single).
bond(id171,a24,a16,single).
bond(id171,a25,a24,single).
bond(id171,a26,a25,single).
bond(id171,a27,a26,double).
bond(id171,a28,a27,single).
bond(id171,a28,a12,double).
bond(id171,a29,a27,single).
bond(id171,a26,a14,single).
bond(id171,a30,a25,double).
bond(id171,a33,a32,single).
bond(id171,a34,a33,single).
bond(id171,a36,a34,single).
bond(id171,a37,a36,single).
bond(id171,a38,a37,single).
bond(id171,a38,a32,single).
bond(id171,a,a,double).
bond(id171,a,a,double).
bond(id171,a,a,double).
bond(id171,a,a,double).
bond(id171,a,a,double).
bond(id171,a,a,double).
bond(id171,a,a,double).
bond(id171,a,a,double).
bond(id171,a,a,double).
bond(id171,a,a,double).
bond(id171,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 172
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id172,172).
dsstox_filename(id172,nctrer_v1a_232_23oct03).
activity_category_er_rba(id172,slight_binder).
cas(id172,'90-00-6').
chemclass_erb(id172,phenols_alkyl).
chemcount(id172,'1').
chemname(id172,'2-ethylphenol').
chemnote(id172,'rba_less_than_1.0E-5').
er_rba(id172,0).
f1_ring(id172,1).
f2_aromatic_ring(id172,1).
f3_phenolic_ring(id172,1).
f4_heteroatom(id172,0).
f5_phenol3nphenyl(id172,0).
f6_other_key_features(id172,0).
formula(id172,c8h10o).
log_er_rba(id172,-5000).
logp(id172,2.55).
mean_er_rba_chemclass(id172,0.00088).
molweight(id172,122.1664).
structureshown(id172,tested_form).
substancetype(id172,defined_organic).
testedform(id172,parent).
smiles(id172,'c1(c(cc)cccc1)o_').
%activity(id172,inactive).
atom(id172,a1,'C').
atom(id172,a2,'C').
atom(id172,a3,'C').
atom(id172,a4,'C').
atom(id172,a5,'C').
atom(id172,a6,'C').
atom(id172,a7,'C').
atom(id172,a8,'C').
atom(id172,a9,'O').
bond(id172,a2,a1,double).
bond(id172,a3,a2,single).
bond(id172,a4,a3,single).
bond(id172,a5,a2,single).
bond(id172,a6,a5,double).
bond(id172,a7,a6,single).
bond(id172,a8,a7,double).
bond(id172,a8,a1,single).
bond(id172,a9,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 173
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id173,173).
dsstox_filename(id173,nctrer_v1a_232_23oct03).
activity_category_er_rba(id173,active_weak).
cas(id173,'620-17-7').
chemclass_erb(id173,phenols_alkyl).
chemcount(id173,'1').
chemname(id173,'m-ethylphenol').
chemnote(id173,'unknown').
er_rba(id173,0.00013).
f1_ring(id173,1).
f2_aromatic_ring(id173,1).
f3_phenolic_ring(id173,1).
f4_heteroatom(id173,0).
f5_phenol3nphenyl(id173,0).
f6_other_key_features(id173,1).
formula(id173,c8h10o).
log_er_rba(id173,-3.87).
logp(id173,2.55).
mean_er_rba_chemclass(id173,0.00088).
molweight(id173,122.1664).
structureshown(id173,tested_form).
substancetype(id173,defined_organic).
testedform(id173,parent).
smiles(id173,'c1c(o)cccc1cc_').
%activity(id173,active).
atom(id173,a1,'C').
atom(id173,a2,'C').
atom(id173,a3,'O').
atom(id173,a4,'C').
atom(id173,a5,'C').
atom(id173,a6,'C').
atom(id173,a7,'C').
atom(id173,a8,'C').
atom(id173,a9,'C').
bond(id173,a2,a1,double).
bond(id173,a3,a2,single).
bond(id173,a4,a2,single).
bond(id173,a5,a4,double).
bond(id173,a6,a5,single).
bond(id173,a7,a6,double).
bond(id173,a7,a1,single).
bond(id173,a8,a7,single).
bond(id173,a9,a8,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 174
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id174,174).
dsstox_filename(id174,nctrer_v1a_232_23oct03).
activity_category_er_rba(id174,inactive).
cas(id174,'83-46-5').
chemclass_erb(id174,steroids_without_aromatic_a_ring).
chemcount(id174,'1').
chemname(id174,'sitosterol').
chemnote(id174,'stereochem').
er_rba(id174,0).
f1_ring(id174,1).
f2_aromatic_ring(id174,0).
f3_phenolic_ring(id174,0).
f4_heteroatom(id174,1).
f5_phenol3nphenyl(id174,0).
f6_other_key_features(id174,1).
formula(id174,c29h50o).
log_er_rba(id174,-10000).
logp(id174,9.65).
mean_er_rba_chemclass(id174,1.24).
molweight(id174,414.7134).
structureshown(id174,tested_form).
substancetype(id174,defined_organic).
testedform(id174,parent).
smiles(id174,'c1c2c3c(ccc2c2(c(=c1)cc(cc2)o)c)(c(cc3)c(ccc(c(c)c)cc)c)c_').
%activity(id174,inactive).
atom(id174,a1,'C').
atom(id174,a2,'C').
atom(id174,a3,'C').
atom(id174,a4,'C').
atom(id174,a5,'C').
atom(id174,a6,'C').
atom(id174,a7,'C').
atom(id174,a8,'C').
atom(id174,a9,'C').
atom(id174,a10,'C').
atom(id174,a11,'C').
atom(id174,a12,'C').
atom(id174,a13,'C').
atom(id174,a14,'O').
atom(id174,a15,'C').
atom(id174,a16,'C').
atom(id174,a17,'C').
atom(id174,a18,'C').
atom(id174,a19,'C').
atom(id174,a20,'C').
atom(id174,a21,'H').
atom(id174,a22,'H').
atom(id174,a23,'H').
atom(id174,a24,'C').
atom(id174,a25,'C').
atom(id174,a26,'C').
atom(id174,a27,'C').
atom(id174,a28,'C').
atom(id174,a29,'C').
atom(id174,a30,'C').
atom(id174,a31,'C').
atom(id174,a32,'C').
atom(id174,a33,'C').
bond(id174,a1,a2,single).
bond(id174,a2,a3,single).
bond(id174,a3,a4,single).
bond(id174,a4,a5,single).
bond(id174,a5,a6,double).
bond(id174,a6,a7,single).
bond(id174,a7,a8,single).
bond(id174,a8,a9,single).
bond(id174,a9,a10,single).
bond(id174,a1,a10,single).
bond(id174,a3,a8,single).
bond(id174,a7,a11,single).
bond(id174,a11,a12,single).
bond(id174,a12,a13,single).
bond(id174,a13,a15,single).
bond(id174,a6,a15,single).
bond(id174,a2,a16,single).
bond(id174,a16,a17,single).
bond(id174,a17,a18,single).
bond(id174,a1,a18,single).
bond(id174,a19,a25,single).
bond(id174,a25,a27,single).
bond(id174,a28,a30,single).
bond(id174,a27,a28,single).
bond(id174,a29,a31,single).
bond(id174,a29,a32,single).
bond(id174,a30,a33,single).
bond(id174,a,a,double).
bond(id174,a,a,double).
bond(id174,a,a,double).
bond(id174,a,a,double).
bond(id174,a,a,double).
bond(id174,a,a,double).
bond(id174,a,a,double).
bond(id174,a,a,double).
bond(id174,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 175
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id175,175).
dsstox_filename(id175,nctrer_v1a_232_23oct03).
activity_category_er_rba(id175,active_medium).
cas(id175,'28463-03-8').
chemclass_erb(id175,diphenylmethanes_ddts).
chemcount(id175,'1').
chemname(id175,'monohydroxymethoxychlor').
chemnote(id175,'unknown').
er_rba(id175,0.129).
f1_ring(id175,1).
f2_aromatic_ring(id175,1).
f3_phenolic_ring(id175,1).
f4_heteroatom(id175,0).
f5_phenol3nphenyl(id175,1).
f6_other_key_features(id175,0).
formula(id175,c15h13cl3o2).
log_er_rba(id175,-0.89).
logp(id175,5.11).
mean_er_rba_chemclass(id175,0.0087).
molweight(id175,331.6255).
structureshown(id175,tested_form).
substancetype(id175,defined_organic).
testedform(id175,parent).
smiles(id175,'c(c(c1ccc(cc1)oc)c1ccc(cc1)o)(cl)(cl)cl_').
%activity(id175,active).
atom(id175,a1,'C').
atom(id175,a2,'C').
atom(id175,a3,'C').
atom(id175,a4,'C').
atom(id175,a5,'C').
atom(id175,a6,'C').
atom(id175,a7,'C').
atom(id175,a8,'C').
atom(id175,a9,'O').
atom(id175,a10,'C').
atom(id175,a11,'C').
atom(id175,a12,'C').
atom(id175,a13,'C').
atom(id175,a14,'C').
atom(id175,a15,'C').
atom(id175,a16,'C').
atom(id175,a17,'O').
atom(id175,a18,'Cl').
atom(id175,a19,'Cl').
atom(id175,a20,'Cl').
bond(id175,a2,a1,single).
bond(id175,a2,a3,single).
bond(id175,a4,a3,double).
bond(id175,a5,a4,single).
bond(id175,a6,a5,double).
bond(id175,a7,a6,single).
bond(id175,a8,a7,double).
bond(id175,a8,a3,single).
bond(id175,a9,a6,single).
bond(id175,a10,a9,single).
bond(id175,a11,a2,single).
bond(id175,a12,a11,single).
bond(id175,a13,a12,double).
bond(id175,a14,a13,single).
bond(id175,a15,a14,double).
bond(id175,a16,a15,single).
bond(id175,a16,a11,double).
bond(id175,a17,a14,single).
bond(id175,a18,a1,single).
bond(id175,a19,a1,single).
bond(id175,a20,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 176
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id176,176).
dsstox_filename(id176,nctrer_v1a_232_23oct03).
activity_category_er_rba(id176,active_weak).
cas(id176,'13037-86-0').
chemclass_erb(id176,phenols_alkyloxy).
chemcount(id176,'1').
chemname(id176,'4-heptyloxyphenol').
chemnote(id176,'unknown').
er_rba(id176,0.00131).
f1_ring(id176,1).
f2_aromatic_ring(id176,1).
f3_phenolic_ring(id176,1).
f4_heteroatom(id176,0).
f5_phenol3nphenyl(id176,0).
f6_other_key_features(id176,1).
formula(id176,c13h20o2).
log_er_rba(id176,-2.88).
logp(id176,4.54).
mean_er_rba_chemclass(id176,0.00088).
molweight(id176,208.2998).
structureshown(id176,tested_form).
substancetype(id176,defined_organic).
testedform(id176,parent).
smiles(id176,'c1(ccc(cc1)occccccc)o_').
%activity(id176,active).
atom(id176,a1,'C').
atom(id176,a2,'C').
atom(id176,a3,'C').
atom(id176,a4,'C').
atom(id176,a5,'C').
atom(id176,a6,'C').
atom(id176,a7,'O').
atom(id176,a8,'C').
atom(id176,a9,'C').
atom(id176,a10,'C').
atom(id176,a11,'C').
atom(id176,a12,'C').
atom(id176,a13,'C').
atom(id176,a14,'C').
atom(id176,a15,'O').
bond(id176,a2,a1,single).
bond(id176,a3,a2,double).
bond(id176,a4,a3,single).
bond(id176,a5,a4,double).
bond(id176,a6,a5,single).
bond(id176,a6,a1,double).
bond(id176,a7,a4,single).
bond(id176,a8,a7,single).
bond(id176,a9,a8,single).
bond(id176,a10,a9,single).
bond(id176,a11,a10,single).
bond(id176,a12,a11,single).
bond(id176,a13,a12,single).
bond(id176,a14,a13,single).
bond(id176,a15,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 177
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id177,177).
dsstox_filename(id177,nctrer_v1a_232_23oct03).
activity_category_er_rba(id177,active_medium).
cas(id177,'75938-34-0').
chemclass_erb(id177,diphenylmethanes_ddts).
chemcount(id177,'1').
chemname(id177,'monohydroxymethoxychlor_olefin').
chemnote(id177,'unknown').
er_rba(id177,0.234).
f1_ring(id177,1).
f2_aromatic_ring(id177,1).
f3_phenolic_ring(id177,1).
f4_heteroatom(id177,0).
f5_phenol3nphenyl(id177,1).
f6_other_key_features(id177,0).
formula(id177,c15h12cl2o2).
log_er_rba(id177,-0.63).
logp(id177,4.31).
mean_er_rba_chemclass(id177,0.0087).
molweight(id177,295.1646).
structureshown(id177,tested_form).
substancetype(id177,defined_organic).
testedform(id177,parent).
smiles(id177,'c(=c(cl)cl)(c1ccc(cc1)oc)c1ccc(cc1)o_').
%activity(id177,active).
atom(id177,a1,'C').
atom(id177,a2,'C').
atom(id177,a3,'Cl').
atom(id177,a4,'Cl').
atom(id177,a5,'C').
atom(id177,a6,'C').
atom(id177,a7,'C').
atom(id177,a8,'C').
atom(id177,a9,'C').
atom(id177,a10,'C').
atom(id177,a11,'O').
atom(id177,a12,'C').
atom(id177,a13,'C').
atom(id177,a14,'C').
atom(id177,a15,'C').
atom(id177,a16,'C').
atom(id177,a17,'C').
atom(id177,a18,'C').
atom(id177,a19,'O').
bond(id177,a2,a1,double).
bond(id177,a3,a2,single).
bond(id177,a4,a2,single).
bond(id177,a5,a1,single).
bond(id177,a6,a5,double).
bond(id177,a7,a6,single).
bond(id177,a8,a7,double).
bond(id177,a9,a8,single).
bond(id177,a10,a9,double).
bond(id177,a10,a5,single).
bond(id177,a11,a8,single).
bond(id177,a12,a11,single).
bond(id177,a13,a1,single).
bond(id177,a14,a13,double).
bond(id177,a15,a14,single).
bond(id177,a16,a15,double).
bond(id177,a17,a16,single).
bond(id177,a18,a17,double).
bond(id177,a18,a13,single).
bond(id177,a19,a16,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 178
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id178,178).
dsstox_filename(id178,nctrer_v1a_232_23oct03).
activity_category_er_rba(id178,active_strong).
cas(id178,'14868-03-2').
chemclass_erb(id178,diphenylmethanes_ddts).
chemcount(id178,'1').
chemname(id178,'dihydroxymethoxychlor_olefin').
chemnote(id178,'unknown').
er_rba(id178,2.63).
f1_ring(id178,1).
f2_aromatic_ring(id178,1).
f3_phenolic_ring(id178,1).
f4_heteroatom(id178,0).
f5_phenol3nphenyl(id178,1).
f6_other_key_features(id178,0).
formula(id178,c14h10cl2o2).
log_er_rba(id178,0.42).
logp(id178,3.75).
mean_er_rba_chemclass(id178,0.0087).
molweight(id178,281.1378).
structureshown(id178,tested_form).
substancetype(id178,defined_organic).
testedform(id178,parent).
smiles(id178,'c(=c(cl)cl)(c1ccc(cc1)o)c1ccc(cc1)o_').
%activity(id178,active).
atom(id178,a1,'C').
atom(id178,a2,'C').
atom(id178,a3,'Cl').
atom(id178,a4,'Cl').
atom(id178,a5,'C').
atom(id178,a6,'C').
atom(id178,a7,'C').
atom(id178,a8,'C').
atom(id178,a9,'C').
atom(id178,a10,'C').
atom(id178,a11,'O').
atom(id178,a12,'C').
atom(id178,a13,'C').
atom(id178,a14,'C').
atom(id178,a15,'C').
atom(id178,a16,'C').
atom(id178,a17,'C').
atom(id178,a18,'O').
bond(id178,a2,a1,double).
bond(id178,a3,a2,single).
bond(id178,a4,a2,single).
bond(id178,a5,a1,single).
bond(id178,a6,a5,double).
bond(id178,a7,a6,single).
bond(id178,a8,a7,double).
bond(id178,a9,a8,single).
bond(id178,a10,a9,double).
bond(id178,a10,a5,single).
bond(id178,a11,a8,single).
bond(id178,a12,a1,single).
bond(id178,a13,a12,double).
bond(id178,a14,a13,single).
bond(id178,a15,a14,double).
bond(id178,a16,a15,single).
bond(id178,a17,a16,double).
bond(id178,a17,a12,single).
bond(id178,a18,a15,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 179
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id179,179).
dsstox_filename(id179,nctrer_v1a_232_23oct03).
activity_category_er_rba(id179,inactive).
cas(id179,'103-23-1').
chemclass_erb(id179,misc).
chemcount(id179,'1').
chemname(id179,'di-2-ethylhexyl_adipate').
chemnote(id179,'stereochem').
er_rba(id179,0).
f1_ring(id179,0).
f2_aromatic_ring(id179,0).
f3_phenolic_ring(id179,0).
f4_heteroatom(id179,0).
f5_phenol3nphenyl(id179,0).
f6_other_key_features(id179,0).
formula(id179,c22h42o4).
log_er_rba(id179,-10000).
logp(id179,8.12).
mean_er_rba_chemclass(id179,na).
molweight(id179,370.5714).
structureshown(id179,tested_form).
substancetype(id179,defined_organic).
testedform(id179,parent).
smiles(id179,'c(=o)(occ(cc)cccc)ccccc(=o)occ(cc)cccc_').
%activity(id179,inactive).
atom(id179,a1,'C').
atom(id179,a2,'O').
atom(id179,a3,'O').
atom(id179,a4,'C').
atom(id179,a5,'C').
atom(id179,a6,'C').
atom(id179,a7,'C').
atom(id179,a8,'C').
atom(id179,a9,'C').
atom(id179,a10,'C').
atom(id179,a11,'C').
atom(id179,a12,'C').
atom(id179,a13,'C').
atom(id179,a14,'C').
atom(id179,a15,'C').
atom(id179,a16,'C').
atom(id179,a17,'O').
atom(id179,a18,'O').
atom(id179,a19,'C').
atom(id179,a20,'C').
atom(id179,a21,'C').
atom(id179,a22,'C').
atom(id179,a23,'C').
atom(id179,a24,'C').
atom(id179,a25,'C').
atom(id179,a26,'C').
bond(id179,a2,a1,double).
bond(id179,a3,a1,single).
bond(id179,a4,a3,single).
bond(id179,a5,a4,single).
bond(id179,a6,a5,single).
bond(id179,a7,a6,single).
bond(id179,a9,a8,single).
bond(id179,a10,a9,single).
bond(id179,a11,a10,single).
bond(id179,a12,a1,single).
bond(id179,a13,a12,single).
bond(id179,a14,a13,single).
bond(id179,a15,a14,single).
bond(id179,a16,a15,single).
bond(id179,a17,a16,double).
bond(id179,a18,a16,single).
bond(id179,a19,a18,single).
bond(id179,a21,a20,single).
bond(id179,a22,a21,single).
bond(id179,a23,a20,single).
bond(id179,a24,a23,single).
bond(id179,a25,a24,single).
bond(id179,a26,a25,single).
bond(id179,a,a,double).
bond(id179,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 180
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id180,180).
dsstox_filename(id180,nctrer_v1a_232_23oct03).
activity_category_er_rba(id180,active_weak).
cas(id180,'6515-37-3').
chemclass_erb(id180,phytoestrogens_flavanones).
chemcount(id180,'1').
chemname(id180,'4_-hydroxy_flavanone').
chemnote(id180,'unknown').
er_rba(id180,0.00223).
f1_ring(id180,1).
f2_aromatic_ring(id180,1).
f3_phenolic_ring(id180,1).
f4_heteroatom(id180,0).
f5_phenol3nphenyl(id180,1).
f6_other_key_features(id180,0).
formula(id180,c15h12o3).
log_er_rba(id180,-2.65).
logp(id180,2.8).
mean_er_rba_chemclass(id180,0.019).
molweight(id180,240.258).
structureshown(id180,tested_form).
substancetype(id180,defined_organic).
testedform(id180,parent).
smiles(id180,'o1c2c(cccc2)c(cc1c1ccc(cc1)o)=o_').
%activity(id180,active).
atom(id180,a1,'O').
atom(id180,a2,'C').
atom(id180,a3,'C').
atom(id180,a4,'C').
atom(id180,a5,'C').
atom(id180,a6,'C').
atom(id180,a7,'C').
atom(id180,a8,'C').
atom(id180,a9,'C').
atom(id180,a10,'C').
atom(id180,a11,'C').
atom(id180,a12,'C').
atom(id180,a13,'C').
atom(id180,a14,'C').
atom(id180,a15,'C').
atom(id180,a16,'C').
atom(id180,a17,'O').
atom(id180,a18,'O').
bond(id180,a2,a1,single).
bond(id180,a3,a2,double).
bond(id180,a4,a3,single).
bond(id180,a5,a4,double).
bond(id180,a6,a5,single).
bond(id180,a7,a6,double).
bond(id180,a7,a2,single).
bond(id180,a8,a3,single).
bond(id180,a9,a8,single).
bond(id180,a10,a9,single).
bond(id180,a10,a1,single).
bond(id180,a10,a11,single).
bond(id180,a12,a11,single).
bond(id180,a13,a12,double).
bond(id180,a14,a13,single).
bond(id180,a15,a14,double).
bond(id180,a16,a15,single).
bond(id180,a16,a11,double).
bond(id180,a17,a14,single).
bond(id180,a18,a8,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 181
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id181,181).
dsstox_filename(id181,nctrer_v1a_232_23oct03).
activity_category_er_rba(id181,inactive).
cas(id181,'571-22-2').
chemclass_erb(id181,steroids_without_aromatic_a_ring).
chemcount(id181,'2_of_2').
chemname(id181,'etiocholan-17-beta-ol-3-one_(5betadht)').
chemnote(id181,'stereochem,_5betadihydrotestosterone,_2d_replicate_of_alpha_form_cas_[521-18-6]').
er_rba(id181,0).
f1_ring(id181,1).
f2_aromatic_ring(id181,0).
f3_phenolic_ring(id181,0).
f4_heteroatom(id181,1).
f5_phenol3nphenyl(id181,0).
f6_other_key_features(id181,1).
formula(id181,c19h30o2).
log_er_rba(id181,-10000).
logp(id181,3.07).
mean_er_rba_chemclass(id181,1.24).
molweight(id181,290.4448).
structureshown(id181,tested_form).
substancetype(id181,defined_organic).
testedform(id181,parent).
smiles(id181,'c1c2c3c(ccc2c2(c(c1)cc(cc2)=o)c)(c(cc3)o)c_').
%activity(id181,inactive).
atom(id181,a1,'C').
atom(id181,a2,'C').
atom(id181,a3,'C').
atom(id181,a4,'C').
atom(id181,a5,'C').
atom(id181,a6,'C').
atom(id181,a7,'C').
atom(id181,a8,'C').
atom(id181,a9,'C').
atom(id181,a10,'C').
atom(id181,a11,'C').
atom(id181,a12,'C').
atom(id181,a13,'C').
atom(id181,a14,'O').
atom(id181,a15,'C').
atom(id181,a16,'C').
atom(id181,a17,'C').
atom(id181,a18,'C').
atom(id181,a19,'O').
atom(id181,a20,'C').
atom(id181,a21,'H').
atom(id181,a22,'H').
atom(id181,a23,'H').
atom(id181,a24,'C').
atom(id181,a25,'H').
bond(id181,a1,a2,single).
bond(id181,a2,a3,single).
bond(id181,a3,a4,single).
bond(id181,a4,a5,single).
bond(id181,a5,a6,single).
bond(id181,a6,a7,single).
bond(id181,a7,a8,single).
bond(id181,a8,a9,single).
bond(id181,a9,a10,single).
bond(id181,a1,a10,single).
bond(id181,a3,a8,single).
bond(id181,a7,a11,single).
bond(id181,a11,a12,single).
bond(id181,a12,a13,single).
bond(id181,a13,a14,double).
bond(id181,a13,a15,single).
bond(id181,a6,a15,single).
bond(id181,a2,a16,single).
bond(id181,a16,a17,single).
bond(id181,a17,a18,single).
bond(id181,a1,a18,single).
bond(id181,a,a,double).
bond(id181,a,a,double).
bond(id181,a,a,double).
bond(id181,a,a,double).
bond(id181,a,a,double).
bond(id181,a,a,double).
bond(id181,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 182
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id182,182).
dsstox_filename(id182,nctrer_v1a_232_23oct03).
activity_category_er_rba(id182,inactive).
cas(id182,'621-82-9').
chemclass_erb(id182,misc).
chemcount(id182,'1').
chemname(id182,'cinnamic_acid').
chemnote(id182,'unknown').
er_rba(id182,0).
f1_ring(id182,1).
f2_aromatic_ring(id182,1).
f3_phenolic_ring(id182,0).
f4_heteroatom(id182,0).
f5_phenol3nphenyl(id182,0).
f6_other_key_features(id182,0).
formula(id182,c9h8o2).
log_er_rba(id182,-10000).
logp(id182,2.07).
mean_er_rba_chemclass(id182,na).
molweight(id182,148.161).
structureshown(id182,tested_form).
substancetype(id182,defined_organic).
testedform(id182,parent).
smiles(id182,'c(c=cc1ccccc1)(=o)o_').
%activity(id182,inactive).
atom(id182,a1,'C').
atom(id182,a2,'C').
atom(id182,a3,'C').
atom(id182,a4,'C').
atom(id182,a5,'C').
atom(id182,a6,'C').
atom(id182,a7,'C').
atom(id182,a8,'C').
atom(id182,a9,'C').
atom(id182,a10,'O').
atom(id182,a11,'O').
bond(id182,a2,a1,single).
bond(id182,a3,a2,double).
bond(id182,a4,a3,single).
bond(id182,a5,a4,single).
bond(id182,a6,a5,double).
bond(id182,a7,a6,single).
bond(id182,a8,a7,double).
bond(id182,a9,a8,single).
bond(id182,a9,a4,double).
bond(id182,a10,a1,double).
bond(id182,a11,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 183
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id183,183).
dsstox_filename(id183,nctrer_v1a_232_23oct03).
activity_category_er_rba(id183,inactive).
cas(id183,'100-51-6').
chemclass_erb(id183,misc).
chemcount(id183,'1').
chemname(id183,'benzylalcohol').
chemnote(id183,'unknown').
er_rba(id183,0).
f1_ring(id183,1).
f2_aromatic_ring(id183,1).
f3_phenolic_ring(id183,0).
f4_heteroatom(id183,0).
f5_phenol3nphenyl(id183,0).
f6_other_key_features(id183,0).
formula(id183,c7h8o).
log_er_rba(id183,-10000).
logp(id183,1.08).
mean_er_rba_chemclass(id183,na).
molweight(id183,108.1396).
structureshown(id183,tested_form).
substancetype(id183,defined_organic).
testedform(id183,parent).
smiles(id183,'c1(co)ccccc1_').
%activity(id183,inactive).
atom(id183,a1,'C').
atom(id183,a2,'C').
atom(id183,a3,'O').
atom(id183,a4,'C').
atom(id183,a5,'C').
atom(id183,a6,'C').
atom(id183,a7,'C').
atom(id183,a8,'C').
bond(id183,a2,a1,single).
bond(id183,a3,a2,single).
bond(id183,a4,a1,double).
bond(id183,a5,a4,single).
bond(id183,a6,a5,double).
bond(id183,a7,a6,single).
bond(id183,a8,a7,double).
bond(id183,a8,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 184
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id184,184).
dsstox_filename(id184,nctrer_v1a_232_23oct03).
activity_category_er_rba(id184,inactive).
cas(id184,'111-71-7').
chemclass_erb(id184,misc).
chemcount(id184,'1').
chemname(id184,'heptaldehyde').
chemnote(id184,'unknown').
er_rba(id184,0).
f1_ring(id184,0).
f2_aromatic_ring(id184,0).
f3_phenolic_ring(id184,0).
f4_heteroatom(id184,0).
f5_phenol3nphenyl(id184,0).
f6_other_key_features(id184,0).
formula(id184,c7h14o).
log_er_rba(id184,-10000).
logp(id184,2.29).
mean_er_rba_chemclass(id184,na).
molweight(id184,114.187).
structureshown(id184,tested_form).
substancetype(id184,defined_organic).
testedform(id184,parent).
smiles(id184,'o=ccccccc_').
%activity(id184,inactive).
atom(id184,a1,'O').
atom(id184,a2,'C').
atom(id184,a3,'C').
atom(id184,a4,'C').
atom(id184,a5,'C').
atom(id184,a6,'C').
atom(id184,a7,'C').
atom(id184,a8,'C').
bond(id184,a2,a1,double).
bond(id184,a3,a2,single).
bond(id184,a4,a3,single).
bond(id184,a5,a4,single).
bond(id184,a6,a5,single).
bond(id184,a7,a6,single).
bond(id184,a8,a7,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 185
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id185,185).
dsstox_filename(id185,nctrer_v1a_232_23oct03).
activity_category_er_rba(id185,inactive).
cas(id185,'111-27-3').
chemclass_erb(id185,misc).
chemcount(id185,'1').
chemname(id185,'hexyl_alcohol').
chemnote(id185,'unknown').
er_rba(id185,0).
f1_ring(id185,0).
f2_aromatic_ring(id185,0).
f3_phenolic_ring(id185,0).
f4_heteroatom(id185,0).
f5_phenol3nphenyl(id185,0).
f6_other_key_features(id185,0).
formula(id185,c6h14o).
log_er_rba(id185,-10000).
logp(id185,1.82).
mean_er_rba_chemclass(id185,na).
molweight(id185,102.176).
structureshown(id185,tested_form).
substancetype(id185,defined_organic).
testedform(id185,parent).
smiles(id185,'occcccc_').
%activity(id185,inactive).
atom(id185,a1,'O').
atom(id185,a2,'C').
atom(id185,a3,'C').
atom(id185,a4,'C').
atom(id185,a5,'C').
atom(id185,a6,'C').
atom(id185,a7,'C').
bond(id185,a2,a1,single).
bond(id185,a3,a2,single).
bond(id185,a4,a3,single).
bond(id185,a5,a4,single).
bond(id185,a6,a5,single).
bond(id185,a7,a6,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 186
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id186,186).
dsstox_filename(id186,nctrer_v1a_232_23oct03).
activity_category_er_rba(id186,inactive).
cas(id186,'7212-44-4').
chemclass_erb(id186,misc).
chemcount(id186,'1').
chemname(id186,'nerolidol').
chemnote(id186,'unknown').
er_rba(id186,0).
f1_ring(id186,0).
f2_aromatic_ring(id186,0).
f3_phenolic_ring(id186,0).
f4_heteroatom(id186,0).
f5_phenol3nphenyl(id186,0).
f6_other_key_features(id186,0).
formula(id186,c15h26o).
log_er_rba(id186,-10000).
logp(id186,5.68).
mean_er_rba_chemclass(id186,na).
molweight(id186,222.3698).
structureshown(id186,tested_form).
substancetype(id186,defined_organic).
testedform(id186,parent).
smiles(id186,'c(c(o)(ccc=c(ccc=c(c)c)c)c)=c_').
%activity(id186,inactive).
atom(id186,a1,'C').
atom(id186,a2,'C').
atom(id186,a3,'O').
atom(id186,a4,'C').
atom(id186,a5,'C').
atom(id186,a6,'C').
atom(id186,a7,'C').
atom(id186,a8,'C').
atom(id186,a9,'C').
atom(id186,a10,'C').
atom(id186,a11,'C').
atom(id186,a12,'C').
atom(id186,a13,'C').
atom(id186,a14,'C').
atom(id186,a15,'C').
atom(id186,a16,'C').
bond(id186,a2,a1,single).
bond(id186,a2,a3,single).
bond(id186,a4,a2,single).
bond(id186,a5,a4,single).
bond(id186,a6,a5,single).
bond(id186,a7,a6,double).
bond(id186,a8,a7,single).
bond(id186,a9,a8,single).
bond(id186,a10,a9,single).
bond(id186,a11,a10,double).
bond(id186,a12,a11,single).
bond(id186,a13,a11,single).
bond(id186,a14,a7,single).
bond(id186,a15,a2,single).
bond(id186,a16,a1,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 187
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id187,187).
dsstox_filename(id187,nctrer_v1a_232_23oct03).
activity_category_er_rba(id187,active_medium).
cas(id187,'7773-34-4').
chemclass_erb(id187,des_derivatives).
chemcount(id187,'1').
chemname(id187,'diethylstilbestrol_dimethyl_ether').
chemnote(id187,'unknown').
er_rba(id187,0.056).
f1_ring(id187,1).
f2_aromatic_ring(id187,1).
f3_phenolic_ring(id187,0).
f4_heteroatom(id187,0).
f5_phenol3nphenyl(id187,0).
f6_other_key_features(id187,1).
formula(id187,c20h24o2).
log_er_rba(id187,-1.25).
logp(id187,6.76).
mean_er_rba_chemclass(id187,2.14).
molweight(id187,296.4084).
structureshown(id187,tested_form).
substancetype(id187,defined_organic).
testedform(id187,parent).
smiles(id187,'c(=c(c1ccc(cc1)oc)cc)(c1ccc(cc1)oc)cc_').
%activity(id187,active).
atom(id187,a1,'C').
atom(id187,a2,'C').
atom(id187,a3,'C').
atom(id187,a4,'C').
atom(id187,a5,'C').
atom(id187,a6,'C').
atom(id187,a7,'C').
atom(id187,a8,'C').
atom(id187,a9,'O').
atom(id187,a10,'C').
atom(id187,a11,'C').
atom(id187,a12,'C').
atom(id187,a13,'C').
atom(id187,a14,'C').
atom(id187,a15,'C').
atom(id187,a16,'C').
atom(id187,a17,'C').
atom(id187,a18,'C').
atom(id187,a19,'O').
atom(id187,a20,'C').
atom(id187,a21,'C').
atom(id187,a22,'C').
bond(id187,a2,a1,double).
bond(id187,a3,a2,single).
bond(id187,a4,a3,double).
bond(id187,a5,a4,single).
bond(id187,a6,a5,double).
bond(id187,a7,a6,single).
bond(id187,a8,a7,double).
bond(id187,a8,a3,single).
bond(id187,a9,a6,single).
bond(id187,a10,a9,single).
bond(id187,a11,a2,single).
bond(id187,a12,a11,single).
bond(id187,a13,a1,single).
bond(id187,a14,a13,single).
bond(id187,a15,a14,double).
bond(id187,a16,a15,single).
bond(id187,a17,a16,double).
bond(id187,a18,a17,single).
bond(id187,a18,a13,double).
bond(id187,a19,a16,single).
bond(id187,a20,a19,single).
bond(id187,a21,a1,single).
bond(id187,a22,a21,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 188
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id188,188).
dsstox_filename(id188,nctrer_v1a_232_23oct03).
activity_category_er_rba(id188,active_medium).
cas(id188,'3601-97-6').
chemclass_erb(id188,steroids_with_aromatic_a_ring).
chemcount(id188,'1').
chemname(id188,'3-hydroxy-estra-1,3,5(10)-trien-16-one').
chemnote(id188,'stereochem').
er_rba(id188,0.513).
f1_ring(id188,1).
f2_aromatic_ring(id188,1).
f3_phenolic_ring(id188,1).
f4_heteroatom(id188,0).
f5_phenol3nphenyl(id188,0).
f6_other_key_features(id188,1).
formula(id188,c18h22o2).
log_er_rba(id188,-0.29).
logp(id188,3.43).
mean_er_rba_chemclass(id188,1.24).
molweight(id188,270.3706).
structureshown(id188,tested_form).
substancetype(id188,defined_organic).
testedform(id188,parent).
smiles(id188,'c1c2c3c(ccc2c2c(c1)cc(cc2)o)(cc(c3)=o)c_').
%activity(id188,active).
atom(id188,a1,'C').
atom(id188,a2,'C').
atom(id188,a3,'C').
atom(id188,a4,'C').
atom(id188,a5,'C').
atom(id188,a6,'C').
atom(id188,a7,'C').
atom(id188,a8,'C').
atom(id188,a9,'C').
atom(id188,a10,'C').
atom(id188,a11,'C').
atom(id188,a12,'C').
atom(id188,a13,'C').
atom(id188,a14,'O').
atom(id188,a15,'C').
atom(id188,a16,'C').
atom(id188,a17,'C').
atom(id188,a18,'C').
atom(id188,a19,'C').
atom(id188,a20,'H').
atom(id188,a21,'H').
atom(id188,a22,'H').
atom(id188,a23,'O').
bond(id188,a1,a2,single).
bond(id188,a2,a3,single).
bond(id188,a3,a4,single).
bond(id188,a4,a5,single).
bond(id188,a5,a6,single).
bond(id188,a6,a7,double).
bond(id188,a7,a8,single).
bond(id188,a8,a9,single).
bond(id188,a9,a10,single).
bond(id188,a1,a10,single).
bond(id188,a3,a8,single).
bond(id188,a7,a11,single).
bond(id188,a11,a12,double).
bond(id188,a12,a13,single).
bond(id188,a13,a14,single).
bond(id188,a13,a15,double).
bond(id188,a6,a15,single).
bond(id188,a2,a16,single).
bond(id188,a16,a17,single).
bond(id188,a17,a18,single).
bond(id188,a1,a18,single).
bond(id188,a17,a23,double).
bond(id188,a,a,double).
bond(id188,a,a,double).
bond(id188,a,a,double).
bond(id188,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 189
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id189,189).
dsstox_filename(id189,nctrer_v1a_232_23oct03).
activity_category_er_rba(id189,active_weak).
cas(id189,'15372-34-6').
chemclass_erb(id189,misc).
chemcount(id189,'1').
chemname(id189,'doisynoestrol').
chemnote(id189,'stereochem').
er_rba(id189,0.00181).
f1_ring(id189,1).
f2_aromatic_ring(id189,1).
f3_phenolic_ring(id189,0).
f4_heteroatom(id189,0).
f5_phenol3nphenyl(id189,0).
f6_other_key_features(id189,1).
formula(id189,c19h22o3).
log_er_rba(id189,-2.74).
logp(id189,5.76).
mean_er_rba_chemclass(id189,na).
molweight(id189,298.381).
structureshown(id189,tested_form).
substancetype(id189,defined_organic).
testedform(id189,parent).
smiles(id189,'c12c(c(c(=o)o)(ccc2c2c(cc(cc2)oc)cc1)c)cc_').
%activity(id189,active).
atom(id189,a1,'C').
atom(id189,a2,'C').
atom(id189,a3,'C').
atom(id189,a4,'C').
atom(id189,a5,'O').
atom(id189,a6,'O').
atom(id189,a7,'C').
atom(id189,a8,'C').
atom(id189,a9,'C').
atom(id189,a10,'C').
atom(id189,a11,'C').
atom(id189,a12,'C').
atom(id189,a13,'C').
atom(id189,a14,'C').
atom(id189,a15,'C').
atom(id189,a16,'O').
atom(id189,a17,'C').
atom(id189,a18,'C').
atom(id189,a19,'C').
atom(id189,a20,'C').
atom(id189,a21,'C').
atom(id189,a22,'C').
bond(id189,a2,a1,single).
bond(id189,a3,a2,single).
bond(id189,a5,a4,double).
bond(id189,a6,a4,single).
bond(id189,a7,a3,single).
bond(id189,a8,a7,single).
bond(id189,a9,a8,single).
bond(id189,a10,a9,single).
bond(id189,a11,a10,single).
bond(id189,a12,a11,double).
bond(id189,a13,a12,single).
bond(id189,a14,a13,double).
bond(id189,a15,a14,single).
bond(id189,a15,a10,double).
bond(id189,a16,a13,single).
bond(id189,a17,a16,single).
bond(id189,a18,a11,single).
bond(id189,a19,a18,double).
bond(id189,a19,a1,single).
bond(id189,a9,a1,double).
bond(id189,a22,a21,single).
bond(id189,a,a,double).
bond(id189,a,a,double).
bond(id189,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 190
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id190,190).
dsstox_filename(id190,nctrer_v1a_232_23oct03).
activity_category_er_rba(id190,active_strong).
cas(id190,'13026-26-1').
chemclass_erb(id190,des_hexestrol_derivatives).
chemcount(id190,'1').
chemname(id190,'mono-methylether_hexestrol').
chemnote(id190,'unknown').
er_rba(id190,9.33).
f1_ring(id190,1).
f2_aromatic_ring(id190,1).
f3_phenolic_ring(id190,1).
f4_heteroatom(id190,0).
f5_phenol3nphenyl(id190,1).
f6_other_key_features(id190,0).
formula(id190,c19h24o2).
log_er_rba(id190,0.97).
logp(id190,6.16).
mean_er_rba_chemclass(id190,2.14).
molweight(id190,284.3974).
structureshown(id190,tested_form).
substancetype(id190,defined_organic).
testedform(id190,parent).
smiles(id190,'c1(c(c(c2ccc(cc2)o)cc)cc)ccc(cc1)oc_').
%activity(id190,active).
atom(id190,a1,'C').
atom(id190,a2,'C').
atom(id190,a3,'C').
atom(id190,a4,'C').
atom(id190,a5,'C').
atom(id190,a6,'C').
atom(id190,a7,'C').
atom(id190,a8,'C').
atom(id190,a9,'O').
atom(id190,a10,'C').
atom(id190,a11,'C').
atom(id190,a12,'C').
atom(id190,a13,'C').
atom(id190,a14,'C').
atom(id190,a15,'C').
atom(id190,a16,'C').
atom(id190,a17,'C').
atom(id190,a18,'C').
atom(id190,a19,'O').
atom(id190,a20,'C').
atom(id190,a21,'C').
bond(id190,a2,a1,single).
bond(id190,a3,a2,single).
bond(id190,a4,a3,double).
bond(id190,a5,a4,single).
bond(id190,a6,a5,double).
bond(id190,a7,a6,single).
bond(id190,a8,a7,double).
bond(id190,a8,a3,single).
bond(id190,a9,a6,single).
bond(id190,a10,a9,single).
bond(id190,a2,a11,single).
bond(id190,a12,a11,single).
bond(id190,a13,a1,single).
bond(id190,a14,a13,single).
bond(id190,a15,a14,double).
bond(id190,a16,a15,single).
bond(id190,a17,a16,double).
bond(id190,a18,a17,single).
bond(id190,a18,a13,double).
bond(id190,a19,a16,single).
bond(id190,a1,a20,single).
bond(id190,a21,a20,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 191
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id191,191).
dsstox_filename(id191,nctrer_v1a_232_23oct03).
activity_category_er_rba(id191,active_weak).
cas(id191,'53-45-2').
chemclass_erb(id191,steroids_with_aromatic_a_ring).
chemcount(id191,'1').
chemname(id191,'3-deoxy-estrone').
chemnote(id191,'stereochem').
er_rba(id191,0.0063).
f1_ring(id191,1).
f2_aromatic_ring(id191,1).
f3_phenolic_ring(id191,0).
f4_heteroatom(id191,0).
f5_phenol3nphenyl(id191,0).
f6_other_key_features(id191,1).
formula(id191,c18h22o).
log_er_rba(id191,-2.2).
logp(id191,3.91).
mean_er_rba_chemclass(id191,1.24).
molweight(id191,254.3712).
structureshown(id191,tested_form).
substancetype(id191,defined_organic).
testedform(id191,parent).
smiles(id191,'c1c2c3c(ccc2c2c(c1)cccc2)(c(cc3)=o)c_').
%activity(id191,active).
atom(id191,a1,'C').
atom(id191,a2,'C').
atom(id191,a3,'C').
atom(id191,a4,'C').
atom(id191,a5,'C').
atom(id191,a6,'C').
atom(id191,a7,'C').
atom(id191,a8,'C').
atom(id191,a9,'C').
atom(id191,a10,'C').
atom(id191,a11,'C').
atom(id191,a12,'C').
atom(id191,a13,'C').
atom(id191,a14,'C').
atom(id191,a15,'C').
atom(id191,a16,'C').
atom(id191,a17,'C').
atom(id191,a18,'C').
atom(id191,a19,'H').
atom(id191,a20,'H').
atom(id191,a21,'H').
atom(id191,a22,'O').
bond(id191,a1,a2,single).
bond(id191,a2,a3,single).
bond(id191,a3,a4,single).
bond(id191,a4,a5,single).
bond(id191,a5,a6,single).
bond(id191,a6,a7,double).
bond(id191,a7,a8,single).
bond(id191,a8,a9,single).
bond(id191,a9,a10,single).
bond(id191,a1,a10,single).
bond(id191,a3,a8,single).
bond(id191,a7,a11,single).
bond(id191,a11,a12,double).
bond(id191,a12,a13,single).
bond(id191,a13,a14,double).
bond(id191,a6,a14,single).
bond(id191,a2,a15,single).
bond(id191,a15,a16,single).
bond(id191,a16,a17,single).
bond(id191,a1,a17,single).
bond(id191,a17,a22,double).
bond(id191,a,a,double).
bond(id191,a,a,double).
bond(id191,a,a,double).
bond(id191,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 192
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id192,192).
dsstox_filename(id192,nctrer_v1a_232_23oct03).
activity_category_er_rba(id192,active_medium).
cas(id192,'3434-79-5').
chemclass_erb(id192,steroids_with_aromatic_a_ring).
chemcount(id192,'1').
chemname(id192,'3-methyl-estriol').
chemnote(id192,'stereochem').
er_rba(id192,0.0224).
f1_ring(id192,1).
f2_aromatic_ring(id192,1).
f3_phenolic_ring(id192,0).
f4_heteroatom(id192,0).
f5_phenol3nphenyl(id192,0).
f6_other_key_features(id192,1).
formula(id192,c19h26o3).
log_er_rba(id192,-1.65).
logp(id192,3.37).
mean_er_rba_chemclass(id192,1.24).
molweight(id192,302.4126).
structureshown(id192,tested_form).
substancetype(id192,defined_organic).
testedform(id192,parent).
smiles(id192,'c1c2c3c(ccc2c2c(c1)cc(cc2)oc)(c(c(c3)o)o)c_').
%activity(id192,active).
atom(id192,a1,'C').
atom(id192,a2,'C').
atom(id192,a3,'C').
atom(id192,a4,'C').
atom(id192,a5,'C').
atom(id192,a6,'C').
atom(id192,a7,'C').
atom(id192,a8,'C').
atom(id192,a9,'C').
atom(id192,a10,'C').
atom(id192,a11,'C').
atom(id192,a12,'C').
atom(id192,a13,'C').
atom(id192,a14,'C').
atom(id192,a15,'C').
atom(id192,a16,'C').
atom(id192,a17,'C').
atom(id192,a18,'O').
atom(id192,a19,'C').
atom(id192,a20,'H').
atom(id192,a21,'O').
atom(id192,a22,'H').
atom(id192,a23,'H').
atom(id192,a24,'O').
atom(id192,a25,'C').
bond(id192,a1,a2,single).
bond(id192,a2,a3,single).
bond(id192,a3,a4,single).
bond(id192,a4,a5,single).
bond(id192,a5,a6,single).
bond(id192,a6,a7,double).
bond(id192,a7,a8,single).
bond(id192,a8,a9,single).
bond(id192,a9,a10,single).
bond(id192,a1,a10,single).
bond(id192,a3,a8,single).
bond(id192,a7,a11,single).
bond(id192,a11,a12,double).
bond(id192,a12,a13,single).
bond(id192,a13,a24,single).
bond(id192,a13,a14,double).
bond(id192,a6,a14,single).
bond(id192,a2,a15,single).
bond(id192,a15,a16,single).
bond(id192,a16,a17,single).
bond(id192,a1,a17,single).
bond(id192,a24,a25,single).
bond(id192,a,a,double).
bond(id192,a,a,double).
bond(id192,a,a,double).
bond(id192,a,a,double).
bond(id192,a,a,double).
bond(id192,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 193
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id193,193).
dsstox_filename(id193,nctrer_v1a_232_23oct03).
activity_category_er_rba(id193,active_medium).
cas(id193,'5108-94-1').
chemclass_erb(id193,steroids_with_aromatic_a_ring).
chemcount(id193,'1').
chemname(id193,'16beta-hydroxy-16-methyl-3-methylether-17beta_estradiol').
chemnote(id193,'stereochem').
er_rba(id193,0.0331).
f1_ring(id193,1).
f2_aromatic_ring(id193,1).
f3_phenolic_ring(id193,0).
f4_heteroatom(id193,0).
f5_phenol3nphenyl(id193,0).
f6_other_key_features(id193,1).
formula(id193,c20h28o3).
log_er_rba(id193,-1.48).
logp(id193,3.83).
mean_er_rba_chemclass(id193,1.24).
molweight(id193,316.4394).
structureshown(id193,tested_form).
substancetype(id193,defined_organic).
testedform(id193,parent).
smiles(id193,'c1c2c3c(ccc2c2c(c1)cc(cc2)oc)(c(c(c3)(c)o)o)c_').
%activity(id193,active).
atom(id193,a1,'C').
atom(id193,a2,'C').
atom(id193,a3,'C').
atom(id193,a4,'C').
atom(id193,a5,'C').
atom(id193,a6,'C').
atom(id193,a7,'C').
atom(id193,a8,'C').
atom(id193,a9,'C').
atom(id193,a10,'C').
atom(id193,a11,'C').
atom(id193,a12,'C').
atom(id193,a13,'C').
atom(id193,a14,'C').
atom(id193,a15,'C').
atom(id193,a16,'C').
atom(id193,a17,'C').
atom(id193,a18,'O').
atom(id193,a19,'C').
atom(id193,a20,'H').
atom(id193,a21,'C').
atom(id193,a22,'H').
atom(id193,a23,'H').
atom(id193,a24,'O').
atom(id193,a25,'O').
atom(id193,a26,'C').
bond(id193,a1,a2,single).
bond(id193,a2,a3,single).
bond(id193,a3,a4,single).
bond(id193,a4,a5,single).
bond(id193,a5,a6,single).
bond(id193,a6,a7,double).
bond(id193,a7,a8,single).
bond(id193,a8,a9,single).
bond(id193,a9,a10,single).
bond(id193,a1,a10,single).
bond(id193,a3,a8,single).
bond(id193,a7,a11,single).
bond(id193,a11,a12,double).
bond(id193,a12,a13,single).
bond(id193,a13,a25,single).
bond(id193,a13,a14,double).
bond(id193,a6,a14,single).
bond(id193,a2,a15,single).
bond(id193,a15,a16,single).
bond(id193,a16,a17,single).
bond(id193,a1,a17,single).
bond(id193,a25,a26,single).
bond(id193,a,a,double).
bond(id193,a,a,double).
bond(id193,a,a,double).
bond(id193,a,a,double).
bond(id193,a,a,double).
bond(id193,a,a,double).
bond(id193,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 194
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id194,194).
dsstox_filename(id194,nctrer_v1a_232_23oct03).
activity_category_er_rba(id194,active_strong).
cas(id194,'nocas').
chemclass_erb(id194,des_hexestrol_derivatives).
chemcount(id194,'1').
chemname(id194,'meso-p-(alpha,beta-diethyl-p-methyl-phenethyl)-phenol').
chemnote(id194,'stereochem').
er_rba(id194,3.98).
f1_ring(id194,1).
f2_aromatic_ring(id194,1).
f3_phenolic_ring(id194,1).
f4_heteroatom(id194,0).
f5_phenol3nphenyl(id194,1).
f6_other_key_features(id194,0).
formula(id194,c19h24o).
log_er_rba(id194,0.6).
logp(id194,6.62).
mean_er_rba_chemclass(id194,2.14).
molweight(id194,268.398).
structureshown(id194,tested_form).
substancetype(id194,defined_organic).
testedform(id194,parent).
smiles(id194,'c1(c(c(c2ccc(cc2)o)cc)cc)ccc(cc1)c_').
%activity(id194,active).
atom(id194,a1,'C').
atom(id194,a2,'C').
atom(id194,a3,'C').
atom(id194,a4,'C').
atom(id194,a5,'C').
atom(id194,a6,'C').
atom(id194,a7,'C').
atom(id194,a8,'C').
atom(id194,a9,'C').
atom(id194,a10,'C').
atom(id194,a11,'C').
atom(id194,a12,'C').
atom(id194,a13,'C').
atom(id194,a14,'C').
atom(id194,a15,'C').
atom(id194,a16,'C').
atom(id194,a17,'C').
atom(id194,a18,'O').
atom(id194,a19,'C').
atom(id194,a20,'C').
bond(id194,a2,a1,single).
bond(id194,a3,a2,single).
bond(id194,a4,a3,double).
bond(id194,a5,a4,single).
bond(id194,a6,a5,double).
bond(id194,a7,a6,single).
bond(id194,a8,a7,double).
bond(id194,a8,a3,single).
bond(id194,a9,a6,single).
bond(id194,a2,a10,single).
bond(id194,a11,a10,single).
bond(id194,a12,a1,single).
bond(id194,a13,a12,single).
bond(id194,a14,a13,double).
bond(id194,a15,a14,single).
bond(id194,a16,a15,double).
bond(id194,a17,a16,single).
bond(id194,a17,a12,double).
bond(id194,a18,a15,single).
bond(id194,a1,a19,single).
bond(id194,a20,a19,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 195
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id195,195).
dsstox_filename(id195,nctrer_v1a_232_23oct03).
activity_category_er_rba(id195,active_medium).
cas(id195,'5394-98-9').
chemclass_erb(id195,des_hexestrol_derivatives).
chemcount(id195,'1').
chemname(id195,'2,2_,4,4_-tetrahydroxybenzil').
chemnote(id195,'not_in_fig_2b_of_main_citation').
er_rba(id195,0.209).
f1_ring(id195,1).
f2_aromatic_ring(id195,1).
f3_phenolic_ring(id195,1).
f4_heteroatom(id195,0).
f5_phenol3nphenyl(id195,1).
f6_other_key_features(id195,0).
formula(id195,c14h10o6).
log_er_rba(id195,-0.68).
logp(id195,3.19).
mean_er_rba_chemclass(id195,2.14).
molweight(id195,274.2294).
structureshown(id195,tested_form).
substancetype(id195,defined_organic).
testedform(id195,parent).
smiles(id195,'c(c(c1c(cc(cc1)o)o)=o)(c1c(cc(cc1)o)o)=o_').
%activity(id195,active).
atom(id195,a1,'C').
atom(id195,a2,'C').
atom(id195,a3,'C').
atom(id195,a4,'C').
atom(id195,a5,'C').
atom(id195,a6,'C').
atom(id195,a7,'C').
atom(id195,a8,'C').
atom(id195,a9,'O').
atom(id195,a10,'O').
atom(id195,a11,'O').
atom(id195,a12,'C').
atom(id195,a13,'C').
atom(id195,a14,'C').
atom(id195,a15,'C').
atom(id195,a16,'C').
atom(id195,a17,'C').
atom(id195,a18,'O').
atom(id195,a19,'O').
atom(id195,a20,'O').
bond(id195,a2,a1,single).
bond(id195,a3,a2,single).
bond(id195,a4,a3,double).
bond(id195,a5,a4,single).
bond(id195,a6,a5,double).
bond(id195,a7,a6,single).
bond(id195,a8,a7,double).
bond(id195,a8,a3,single).
bond(id195,a9,a6,single).
bond(id195,a10,a4,single).
bond(id195,a11,a2,double).
bond(id195,a12,a1,single).
bond(id195,a13,a12,double).
bond(id195,a14,a13,single).
bond(id195,a15,a14,double).
bond(id195,a16,a15,single).
bond(id195,a17,a16,double).
bond(id195,a17,a12,single).
bond(id195,a18,a15,single).
bond(id195,a19,a13,single).
bond(id195,a20,a1,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 196
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id196,196).
dsstox_filename(id196,nctrer_v1a_232_23oct03).
activity_category_er_rba(id196,active_strong).
cas(id196,'79199-51-2').
chemclass_erb(id196,des_hexestrol_derivatives).
chemcount(id196,'1').
chemname(id196,'3,3_-dihydroxyhexestrol').
chemnote(id196,'not_in_fig_2b_of_main_citation').
er_rba(id196,15.49).
f1_ring(id196,1).
f2_aromatic_ring(id196,1).
f3_phenolic_ring(id196,1).
f4_heteroatom(id196,0).
f5_phenol3nphenyl(id196,1).
f6_other_key_features(id196,0).
formula(id196,c18h22o4).
log_er_rba(id196,1.19).
logp(id196,4.64).
mean_er_rba_chemclass(id196,2.14).
molweight(id196,302.3694).
structureshown(id196,tested_form).
substancetype(id196,defined_organic).
testedform(id196,parent).
smiles(id196,'c1(c(c(c2cc(o)c(cc2)o)cc)cc)cc(o)c(cc1)o_').
%activity(id196,active).
atom(id196,a1,'C').
atom(id196,a2,'C').
atom(id196,a3,'C').
atom(id196,a4,'C').
atom(id196,a5,'C').
atom(id196,a6,'C').
atom(id196,a7,'O').
atom(id196,a8,'C').
atom(id196,a9,'C').
atom(id196,a10,'C').
atom(id196,a11,'O').
atom(id196,a12,'C').
atom(id196,a13,'C').
atom(id196,a14,'C').
atom(id196,a15,'C').
atom(id196,a16,'C').
atom(id196,a17,'C').
atom(id196,a18,'O').
atom(id196,a19,'C').
atom(id196,a20,'C').
atom(id196,a21,'C').
atom(id196,a22,'O').
bond(id196,a2,a1,single).
bond(id196,a3,a2,single).
bond(id196,a4,a3,single).
bond(id196,a5,a4,single).
bond(id196,a6,a5,double).
bond(id196,a7,a6,single).
bond(id196,a8,a6,single).
bond(id196,a9,a8,double).
bond(id196,a10,a9,single).
bond(id196,a10,a4,double).
bond(id196,a11,a8,single).
bond(id196,a3,a12,single).
bond(id196,a13,a12,single).
bond(id196,a2,a14,single).
bond(id196,a15,a14,single).
bond(id196,a16,a1,double).
bond(id196,a17,a16,single).
bond(id196,a18,a17,single).
bond(id196,a19,a17,double).
bond(id196,a20,a19,single).
bond(id196,a21,a20,double).
bond(id196,a21,a1,single).
bond(id196,a22,a19,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 197
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id197,197).
dsstox_filename(id197,nctrer_v1a_232_23oct03).
activity_category_er_rba(id197,active_strong).
cas(id197,'nocas').
chemclass_erb(id197,des_hexestrol_derivatives).
chemcount(id197,'1').
chemname(id197,'2,6-dimethyl_hexestrol').
chemnote(id197,'value_of_er_rba_in_main_citation_reported_in_error').
er_rba(id197,8.91).
f1_ring(id197,1).
f2_aromatic_ring(id197,1).
f3_phenolic_ring(id197,1).
f4_heteroatom(id197,0).
f5_phenol3nphenyl(id197,1).
f6_other_key_features(id197,0).
formula(id197,c20h26o2).
log_er_rba(id197,0.95).
logp(id197,6.69).
mean_er_rba_chemclass(id197,2.14).
molweight(id197,298.4242).
structureshown(id197,tested_form).
substancetype(id197,defined_organic).
testedform(id197,parent).
smiles(id197,'c1(c(c(c2ccc(o)cc2)cc)cc)cc(c)c(c(c1)c)o_').
%activity(id197,active).
atom(id197,a1,'C').
atom(id197,a2,'C').
atom(id197,a3,'C').
atom(id197,a4,'C').
atom(id197,a5,'C').
atom(id197,a6,'C').
atom(id197,a7,'C').
atom(id197,a8,'O').
atom(id197,a9,'C').
atom(id197,a10,'C').
atom(id197,a11,'C').
atom(id197,a12,'C').
atom(id197,a13,'C').
atom(id197,a14,'C').
atom(id197,a15,'C').
atom(id197,a16,'C').
atom(id197,a17,'C').
atom(id197,a18,'C').
atom(id197,a19,'C').
atom(id197,a20,'C').
atom(id197,a21,'C').
atom(id197,a22,'O').
bond(id197,a2,a1,single).
bond(id197,a3,a2,single).
bond(id197,a4,a3,single).
bond(id197,a5,a4,double).
bond(id197,a6,a5,single).
bond(id197,a7,a6,double).
bond(id197,a8,a7,single).
bond(id197,a9,a7,single).
bond(id197,a10,a9,double).
bond(id197,a10,a4,single).
bond(id197,a3,a11,single).
bond(id197,a12,a11,single).
bond(id197,a2,a13,single).
bond(id197,a14,a13,single).
bond(id197,a15,a1,double).
bond(id197,a16,a15,single).
bond(id197,a17,a16,single).
bond(id197,a18,a16,double).
bond(id197,a19,a18,single).
bond(id197,a20,a19,double).
bond(id197,a20,a1,single).
bond(id197,a21,a19,single).
bond(id197,a22,a18,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 198
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id198,198).
dsstox_filename(id198,nctrer_v1a_232_23oct03).
activity_category_er_rba(id198,active_medium).
cas(id198,'5219-17-0').
chemclass_erb(id198,phytoestrogens_coumestans).
chemcount(id198,'1').
chemname(id198,'4-ethyl-7-oh-3-(p-methoxyphenyl)-dihydro-1-benzopyran-2-one').
chemnote(id198,'unknown').
er_rba(id198,0.891).
f1_ring(id198,1).
f2_aromatic_ring(id198,1).
f3_phenolic_ring(id198,1).
f4_heteroatom(id198,0).
f5_phenol3nphenyl(id198,1).
f6_other_key_features(id198,0).
formula(id198,c18h16o4).
log_er_rba(id198,-0.05).
logp(id198,3.92).
mean_er_rba_chemclass(id198,0.019).
molweight(id198,296.322).
structureshown(id198,tested_form).
substancetype(id198,defined_organic).
testedform(id198,parent).
smiles(id198,'c1(c(c(cc)c2c(o1)cc(cc2)o)c1ccc(cc1)oc)=o_').
%activity(id198,active).
atom(id198,a1,'C').
atom(id198,a2,'C').
atom(id198,a3,'C').
atom(id198,a4,'C').
atom(id198,a5,'C').
atom(id198,a6,'C').
atom(id198,a7,'C').
atom(id198,a8,'O').
atom(id198,a9,'C').
atom(id198,a10,'C').
atom(id198,a11,'C').
atom(id198,a12,'C').
atom(id198,a13,'O').
atom(id198,a14,'C').
atom(id198,a15,'C').
atom(id198,a16,'C').
atom(id198,a17,'C').
atom(id198,a18,'C').
atom(id198,a19,'C').
atom(id198,a20,'O').
atom(id198,a21,'C').
atom(id198,a22,'O').
bond(id198,a2,a1,single).
bond(id198,a3,a2,double).
bond(id198,a4,a3,single).
bond(id198,a5,a4,single).
bond(id198,a6,a3,single).
bond(id198,a7,a6,single).
bond(id198,a8,a7,single).
bond(id198,a8,a1,single).
bond(id198,a9,a7,double).
bond(id198,a10,a9,single).
bond(id198,a11,a10,double).
bond(id198,a12,a11,single).
bond(id198,a12,a6,double).
bond(id198,a13,a10,single).
bond(id198,a14,a2,single).
bond(id198,a15,a14,single).
bond(id198,a16,a15,double).
bond(id198,a17,a16,single).
bond(id198,a18,a17,double).
bond(id198,a19,a18,single).
bond(id198,a19,a14,double).
bond(id198,a20,a17,single).
bond(id198,a21,a20,single).
bond(id198,a22,a1,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 199
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id199,199).
dsstox_filename(id199,nctrer_v1a_232_23oct03).
activity_category_er_rba(id199,active_medium).
cas(id199,'65118-81-2').
chemclass_erb(id199,misc).
chemcount(id199,'1').
chemname(id199,'alpha,alpha-dimethyl-beta-ethyl_allenolic_acid').
chemnote(id199,'stereochem').
er_rba(id199,0.955).
f1_ring(id199,1).
f2_aromatic_ring(id199,1).
f3_phenolic_ring(id199,1).
f4_heteroatom(id199,0).
f5_phenol3nphenyl(id199,0).
f6_other_key_features(id199,1).
formula(id199,c17h20o3).
log_er_rba(id199,-0.02).
logp(id199,4.76).
mean_er_rba_chemclass(id199,na).
molweight(id199,272.3432).
structureshown(id199,tested_form).
substancetype(id199,defined_organic).
testedform(id199,parent).
smiles(id199,'c(c(c(c1cc2ccc(cc2cc1)o)cc)(c)c)(=o)o_').
%activity(id199,active).
atom(id199,a1,'C').
atom(id199,a2,'C').
atom(id199,a3,'O').
atom(id199,a4,'O').
atom(id199,a5,'C').
atom(id199,a6,'C').
atom(id199,a7,'C').
atom(id199,a8,'C').
atom(id199,a9,'C').
atom(id199,a10,'C').
atom(id199,a11,'C').
atom(id199,a12,'C').
atom(id199,a13,'C').
atom(id199,a14,'C').
atom(id199,a15,'C').
atom(id199,a16,'O').
atom(id199,a17,'C').
atom(id199,a18,'C').
atom(id199,a19,'C').
atom(id199,a20,'C').
bond(id199,a2,a1,single).
bond(id199,a3,a2,double).
bond(id199,a4,a2,single).
bond(id199,a5,a1,single).
bond(id199,a6,a5,single).
bond(id199,a7,a6,double).
bond(id199,a8,a7,single).
bond(id199,a9,a8,double).
bond(id199,a10,a9,single).
bond(id199,a11,a10,double).
bond(id199,a12,a11,single).
bond(id199,a13,a12,double).
bond(id199,a14,a13,single).
bond(id199,a15,a14,double).
bond(id199,a15,a6,single).
bond(id199,a13,a8,single).
bond(id199,a16,a11,single).
bond(id199,a18,a17,single).
bond(id199,a,a,double).
bond(id199,a,a,double).
bond(id199,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 200
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id200,200).
dsstox_filename(id200,nctrer_v1a_232_23oct03).
activity_category_er_rba(id200,active_weak).
cas(id200,'103-16-2').
chemclass_erb(id200,phenols_alkyloxy).
chemcount(id200,'1').
chemname(id200,'4-(benzyloxyl)phenol').
chemnote(id200,'unknown').
er_rba(id200,0.00036).
f1_ring(id200,1).
f2_aromatic_ring(id200,1).
f3_phenolic_ring(id200,1).
f4_heteroatom(id200,0).
f5_phenol3nphenyl(id200,1).
f6_other_key_features(id200,0).
formula(id200,c13h12o2).
log_er_rba(id200,-3.44).
logp(id200,3.3).
mean_er_rba_chemclass(id200,0.00088).
molweight(id200,200.2366).
structureshown(id200,tested_form).
substancetype(id200,defined_organic).
testedform(id200,parent).
smiles(id200,'o(c1ccc(cc1)o)cc1ccccc1_').
%activity(id200,active).
atom(id200,a1,'O').
atom(id200,a2,'C').
atom(id200,a3,'C').
atom(id200,a4,'C').
atom(id200,a5,'C').
atom(id200,a6,'C').
atom(id200,a7,'C').
atom(id200,a8,'O').
atom(id200,a9,'C').
atom(id200,a10,'C').
atom(id200,a11,'C').
atom(id200,a12,'C').
atom(id200,a13,'C').
atom(id200,a14,'C').
atom(id200,a15,'C').
bond(id200,a2,a1,single).
bond(id200,a3,a2,double).
bond(id200,a4,a3,single).
bond(id200,a5,a4,double).
bond(id200,a6,a5,single).
bond(id200,a7,a6,double).
bond(id200,a7,a2,single).
bond(id200,a8,a5,single).
bond(id200,a9,a1,single).
bond(id200,a10,a9,single).
bond(id200,a11,a10,single).
bond(id200,a12,a11,double).
bond(id200,a13,a12,single).
bond(id200,a14,a13,double).
bond(id200,a15,a14,single).
bond(id200,a15,a10,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 201
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id201,201).
dsstox_filename(id201,nctrer_v1a_232_23oct03).
activity_category_er_rba(id201,active_medium).
cas(id201,'104-43-8').
chemclass_erb(id201,phenols_alkyl).
chemcount(id201,'1').
chemname(id201,'4-dodecylphenol').
chemnote(id201,'unknown').
er_rba(id201,0.0186).
f1_ring(id201,1).
f2_aromatic_ring(id201,1).
f3_phenolic_ring(id201,1).
f4_heteroatom(id201,0).
f5_phenol3nphenyl(id201,0).
f6_other_key_features(id201,1).
formula(id201,c18h30o).
log_er_rba(id201,-1.73).
logp(id201,7.46).
mean_er_rba_chemclass(id201,0.00088).
molweight(id201,262.4344).
structureshown(id201,tested_form).
substancetype(id201,defined_organic).
testedform(id201,parent).
smiles(id201,'c1(ccc(cc1)cccccccccccc)o_').
%activity(id201,active).
atom(id201,a1,'C').
atom(id201,a2,'C').
atom(id201,a3,'C').
atom(id201,a4,'C').
atom(id201,a5,'C').
atom(id201,a6,'C').
atom(id201,a7,'C').
atom(id201,a8,'C').
atom(id201,a9,'C').
atom(id201,a10,'C').
atom(id201,a11,'C').
atom(id201,a12,'C').
atom(id201,a13,'C').
atom(id201,a14,'C').
atom(id201,a15,'C').
atom(id201,a16,'C').
atom(id201,a17,'C').
atom(id201,a18,'C').
atom(id201,a19,'O').
bond(id201,a2,a1,double).
bond(id201,a3,a2,single).
bond(id201,a4,a3,double).
bond(id201,a5,a4,single).
bond(id201,a6,a5,double).
bond(id201,a6,a1,single).
bond(id201,a7,a4,single).
bond(id201,a8,a7,single).
bond(id201,a9,a8,single).
bond(id201,a10,a9,single).
bond(id201,a11,a10,single).
bond(id201,a12,a11,single).
bond(id201,a13,a12,single).
bond(id201,a14,a13,single).
bond(id201,a15,a14,single).
bond(id201,a16,a15,single).
bond(id201,a17,a16,single).
bond(id201,a18,a17,single).
bond(id201,a19,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 202
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id202,202).
dsstox_filename(id202,nctrer_v1a_232_23oct03).
activity_category_er_rba(id202,active_weak).
cas(id202,'94-26-8').
chemclass_erb(id202,phenols_parabens).
chemcount(id202,'1').
chemname(id202,'n-butyl_4-hydroxybenzoate').
chemnote(id202,'unknown').
er_rba(id202,0.00085).
f1_ring(id202,1).
f2_aromatic_ring(id202,1).
f3_phenolic_ring(id202,1).
f4_heteroatom(id202,0).
f5_phenol3nphenyl(id202,0).
f6_other_key_features(id202,1).
formula(id202,c11h14o3).
log_er_rba(id202,-3.07).
logp(id202,3.47).
mean_er_rba_chemclass(id202,0.00088).
molweight(id202,194.2298).
structureshown(id202,tested_form).
substancetype(id202,defined_organic).
testedform(id202,parent).
smiles(id202,'c(c1ccc(cc1)o)(=o)occcc_').
%activity(id202,active).
atom(id202,a1,'C').
atom(id202,a2,'C').
atom(id202,a3,'C').
atom(id202,a4,'C').
atom(id202,a5,'C').
atom(id202,a6,'C').
atom(id202,a7,'C').
atom(id202,a8,'O').
atom(id202,a9,'O').
atom(id202,a10,'O').
atom(id202,a11,'C').
atom(id202,a12,'C').
atom(id202,a13,'C').
atom(id202,a14,'C').
bond(id202,a2,a1,single).
bond(id202,a3,a2,double).
bond(id202,a4,a3,single).
bond(id202,a5,a4,double).
bond(id202,a6,a5,single).
bond(id202,a7,a6,double).
bond(id202,a7,a2,single).
bond(id202,a8,a5,single).
bond(id202,a9,a1,double).
bond(id202,a10,a1,single).
bond(id202,a11,a10,single).
bond(id202,a12,a11,single).
bond(id202,a13,a12,single).
bond(id202,a14,a13,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 203
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id203,203).
dsstox_filename(id203,nctrer_v1a_232_23oct03).
activity_category_er_rba(id203,active_weak).
cas(id203,'1570-64-5').
chemclass_erb(id203,phenols_alkyl).
chemcount(id203,'1').
chemname(id203,'4-chloro-2-methyl_phenol').
chemnote(id203,'unknown').
er_rba(id203,0.00021).
f1_ring(id203,1).
f2_aromatic_ring(id203,1).
f3_phenolic_ring(id203,1).
f4_heteroatom(id203,0).
f5_phenol3nphenyl(id203,0).
f6_other_key_features(id203,1).
formula(id203,c7h7clo).
log_er_rba(id203,-3.67).
logp(id203,2.7).
mean_er_rba_chemclass(id203,0.00088).
molweight(id203,142.5847).
structureshown(id203,tested_form).
substancetype(id203,defined_organic).
testedform(id203,parent).
smiles(id203,'c1(c(ccc(c1)cl)o)c_').
%activity(id203,active).
atom(id203,a1,'C').
atom(id203,a2,'C').
atom(id203,a3,'C').
atom(id203,a4,'C').
atom(id203,a5,'C').
atom(id203,a6,'C').
atom(id203,a7,'Cl').
atom(id203,a8,'O').
atom(id203,a9,'C').
bond(id203,a2,a1,double).
bond(id203,a3,a2,single).
bond(id203,a4,a3,double).
bond(id203,a5,a4,single).
bond(id203,a6,a5,double).
bond(id203,a6,a1,single).
bond(id203,a7,a5,single).
bond(id203,a8,a2,single).
bond(id203,a9,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 204
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id204,204).
dsstox_filename(id204,nctrer_v1a_232_23oct03).
activity_category_er_rba(id204,active_weak).
cas(id204,'34883-43-7').
chemclass_erb(id204,biphenyls_pcbs).
chemcount(id204,'1').
chemname(id204,'2,4_-dichlorobiphenyl').
chemnote(id204,'unknown').
er_rba(id204,0.00024).
f1_ring(id204,1).
f2_aromatic_ring(id204,1).
f3_phenolic_ring(id204,0).
f4_heteroatom(id204,0).
f5_phenol3nphenyl(id204,0).
f6_other_key_features(id204,1).
formula(id204,c12h8cl2).
log_er_rba(id204,-3.61).
logp(id204,5.05).
mean_er_rba_chemclass(id204,0.0028).
molweight(id204,223.1012).
structureshown(id204,tested_form).
substancetype(id204,defined_organic).
testedform(id204,parent).
smiles(id204,'c1(c2ccc(cc2)cl)c(cl)cccc1_').
%activity(id204,active).
atom(id204,a1,'C').
atom(id204,a2,'C').
atom(id204,a3,'C').
atom(id204,a4,'C').
atom(id204,a5,'C').
atom(id204,a6,'C').
atom(id204,a7,'C').
atom(id204,a8,'Cl').
atom(id204,a9,'C').
atom(id204,a10,'Cl').
atom(id204,a11,'C').
atom(id204,a12,'C').
atom(id204,a13,'C').
atom(id204,a14,'C').
bond(id204,a2,a1,single).
bond(id204,a3,a2,double).
bond(id204,a4,a3,single).
bond(id204,a5,a4,double).
bond(id204,a6,a5,single).
bond(id204,a7,a6,double).
bond(id204,a7,a2,single).
bond(id204,a8,a5,single).
bond(id204,a9,a1,double).
bond(id204,a10,a9,single).
bond(id204,a11,a9,single).
bond(id204,a12,a11,double).
bond(id204,a13,a12,single).
bond(id204,a14,a13,double).
bond(id204,a14,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 205
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id205,205).
dsstox_filename(id205,nctrer_v1a_232_23oct03).
activity_category_er_rba(id205,active_weak).
cas(id205,'6640-27-3').
chemclass_erb(id205,phenols_alkyl).
chemcount(id205,'1').
chemname(id205,'2-cholor-4-methyl-phenol').
chemnote(id205,'unknown').
er_rba(id205,0.00021).
f1_ring(id205,1).
f2_aromatic_ring(id205,1).
f3_phenolic_ring(id205,1).
f4_heteroatom(id205,0).
f5_phenol3nphenyl(id205,0).
f6_other_key_features(id205,1).
formula(id205,c7h7clo).
log_er_rba(id205,-3.66).
logp(id205,2.7).
mean_er_rba_chemclass(id205,0.00088).
molweight(id205,142.5847).
structureshown(id205,tested_form).
substancetype(id205,defined_organic).
testedform(id205,parent).
smiles(id205,'c1(c(ccc(c1)c)o)cl_').
%activity(id205,active).
atom(id205,a1,'C').
atom(id205,a2,'C').
atom(id205,a3,'C').
atom(id205,a4,'C').
atom(id205,a5,'C').
atom(id205,a6,'C').
atom(id205,a7,'C').
atom(id205,a8,'O').
atom(id205,a9,'Cl').
bond(id205,a2,a1,double).
bond(id205,a3,a2,single).
bond(id205,a4,a3,double).
bond(id205,a5,a4,single).
bond(id205,a6,a5,double).
bond(id205,a6,a1,single).
bond(id205,a7,a5,single).
bond(id205,a8,a2,single).
bond(id205,a9,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 206
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id206,206).
dsstox_filename(id206,nctrer_v1a_232_23oct03).
activity_category_er_rba(id206,inactive).
cas(id206,'2437-79-8').
chemclass_erb(id206,biphenyls_pcbs).
chemcount(id206,'1').
chemname(id206,'2,2_,4,4_-tetrachlorobiphenyl').
chemnote(id206,'unknown').
er_rba(id206,0).
f1_ring(id206,1).
f2_aromatic_ring(id206,1).
f3_phenolic_ring(id206,0).
f4_heteroatom(id206,0).
f5_phenol3nphenyl(id206,0).
f6_other_key_features(id206,0).
formula(id206,c12h6cl4).
log_er_rba(id206,-10000).
logp(id206,6.34).
mean_er_rba_chemclass(id206,0.0028).
molweight(id206,291.9914).
structureshown(id206,tested_form).
substancetype(id206,defined_organic).
testedform(id206,parent).
smiles(id206,'c1(c2c(cc(cc2)cl)cl)c(cc(cc1)cl)cl_').
%activity(id206,inactive).
atom(id206,a1,'C').
atom(id206,a2,'C').
atom(id206,a3,'C').
atom(id206,a4,'C').
atom(id206,a5,'C').
atom(id206,a6,'C').
atom(id206,a7,'C').
atom(id206,a8,'Cl').
atom(id206,a9,'Cl').
atom(id206,a10,'C').
atom(id206,a11,'C').
atom(id206,a12,'C').
atom(id206,a13,'C').
atom(id206,a14,'C').
atom(id206,a15,'Cl').
atom(id206,a16,'Cl').
bond(id206,a2,a1,single).
bond(id206,a3,a2,double).
bond(id206,a4,a3,single).
bond(id206,a5,a4,double).
bond(id206,a6,a5,single).
bond(id206,a7,a6,double).
bond(id206,a7,a2,single).
bond(id206,a8,a5,single).
bond(id206,a9,a3,single).
bond(id206,a10,a1,double).
bond(id206,a11,a10,single).
bond(id206,a12,a11,double).
bond(id206,a13,a12,single).
bond(id206,a14,a13,double).
bond(id206,a14,a1,single).
bond(id206,a15,a12,single).
bond(id206,a16,a10,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 207
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id207,207).
dsstox_filename(id207,nctrer_v1a_232_23oct03).
activity_category_er_rba(id207,slight_binder).
cas(id207,'32598-13-3').
chemclass_erb(id207,biphenyls_pcbs).
chemcount(id207,'1').
chemname(id207,'3,3_,4,4_-tetrachlorobiphenyl').
chemnote(id207,'unknown').
er_rba(id207,0).
f1_ring(id207,1).
f2_aromatic_ring(id207,1).
f3_phenolic_ring(id207,0).
f4_heteroatom(id207,0).
f5_phenol3nphenyl(id207,0).
f6_other_key_features(id207,0).
formula(id207,c12h6cl4).
log_er_rba(id207,-5000).
logp(id207,6.34).
mean_er_rba_chemclass(id207,0.0028).
molweight(id207,291.9914).
structureshown(id207,tested_form).
substancetype(id207,defined_organic).
testedform(id207,parent).
smiles(id207,'c1(c2cc(cl)c(cc2)cl)cc(cl)c(cc1)cl_').
%activity(id207,inactive).
atom(id207,a1,'C').
atom(id207,a2,'C').
atom(id207,a3,'C').
atom(id207,a4,'C').
atom(id207,a5,'Cl').
atom(id207,a6,'C').
atom(id207,a7,'C').
atom(id207,a8,'C').
atom(id207,a9,'Cl').
atom(id207,a10,'C').
atom(id207,a11,'C').
atom(id207,a12,'Cl').
atom(id207,a13,'C').
atom(id207,a14,'C').
atom(id207,a15,'C').
atom(id207,a16,'Cl').
bond(id207,a2,a1,single).
bond(id207,a3,a2,double).
bond(id207,a4,a3,single).
bond(id207,a5,a4,single).
bond(id207,a6,a4,double).
bond(id207,a7,a6,single).
bond(id207,a8,a7,double).
bond(id207,a8,a2,single).
bond(id207,a9,a6,single).
bond(id207,a10,a1,double).
bond(id207,a11,a10,single).
bond(id207,a12,a11,single).
bond(id207,a13,a11,double).
bond(id207,a14,a13,single).
bond(id207,a15,a14,double).
bond(id207,a15,a1,single).
bond(id207,a16,a13,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 208
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id208,208).
dsstox_filename(id208,nctrer_v1a_232_23oct03).
activity_category_er_rba(id208,inactive).
cas(id208,'2050-68-2').
chemclass_erb(id208,biphenyls_pcbs).
chemcount(id208,'1').
chemname(id208,'4,4_-dichlorobiphenyl').
chemnote(id208,'unknown').
er_rba(id208,0).
f1_ring(id208,1).
f2_aromatic_ring(id208,1).
f3_phenolic_ring(id208,0).
f4_heteroatom(id208,0).
f5_phenol3nphenyl(id208,0).
f6_other_key_features(id208,0).
formula(id208,c12h8cl2).
log_er_rba(id208,-10000).
logp(id208,5.05).
mean_er_rba_chemclass(id208,0.0028).
molweight(id208,223.1012).
structureshown(id208,tested_form).
substancetype(id208,defined_organic).
testedform(id208,parent).
smiles(id208,'c1(c2ccc(cc2)cl)ccc(cc1)cl_').
%activity(id208,inactive).
atom(id208,a1,'C').
atom(id208,a2,'C').
atom(id208,a3,'C').
atom(id208,a4,'C').
atom(id208,a5,'C').
atom(id208,a6,'C').
atom(id208,a7,'C').
atom(id208,a8,'Cl').
atom(id208,a9,'C').
atom(id208,a10,'C').
atom(id208,a11,'C').
atom(id208,a12,'C').
atom(id208,a13,'C').
atom(id208,a14,'Cl').
bond(id208,a2,a1,single).
bond(id208,a3,a2,double).
bond(id208,a4,a3,single).
bond(id208,a5,a4,double).
bond(id208,a6,a5,single).
bond(id208,a7,a6,double).
bond(id208,a7,a2,single).
bond(id208,a8,a5,single).
bond(id208,a9,a1,single).
bond(id208,a10,a9,double).
bond(id208,a11,a10,single).
bond(id208,a12,a11,double).
bond(id208,a13,a12,single).
bond(id208,a13,a1,double).
bond(id208,a14,a11,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 209
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id209,209).
dsstox_filename(id209,nctrer_v1a_232_23oct03).
activity_category_er_rba(id209,active_medium).
cas(id209,'1229-24-9').
chemclass_erb(id209,steroids_with_aromatic_a_ring).
chemcount(id209,'1').
chemname(id209,'6alpha-hydroxy-estradiol').
chemnote(id209,'stereochem').
er_rba(id209,0.708).
f1_ring(id209,1).
f2_aromatic_ring(id209,1).
f3_phenolic_ring(id209,1).
f4_heteroatom(id209,0).
f5_phenol3nphenyl(id209,0).
f6_other_key_features(id209,1).
formula(id209,c18h24o3).
log_er_rba(id209,-0.15).
logp(id209,2.81).
mean_er_rba_chemclass(id209,1.24).
molweight(id209,288.3858).
structureshown(id209,tested_form).
substancetype(id209,defined_organic).
testedform(id209,parent).
smiles(id209,'c1c2c3c(ccc2c2c(c1o)cc(cc2)o)(c(cc3)o)c_').
%activity(id209,active).
atom(id209,a1,'C').
atom(id209,a2,'C').
atom(id209,a3,'C').
atom(id209,a4,'C').
atom(id209,a5,'C').
atom(id209,a6,'C').
atom(id209,a7,'C').
atom(id209,a8,'C').
atom(id209,a9,'C').
atom(id209,a10,'C').
atom(id209,a11,'C').
atom(id209,a12,'C').
atom(id209,a13,'C').
atom(id209,a14,'O').
atom(id209,a15,'C').
atom(id209,a16,'C').
atom(id209,a17,'C').
atom(id209,a18,'C').
atom(id209,a19,'O').
atom(id209,a20,'C').
atom(id209,a21,'H').
atom(id209,a22,'H').
atom(id209,a23,'H').
atom(id209,a24,'O').
bond(id209,a1,a2,single).
bond(id209,a2,a3,single).
bond(id209,a3,a4,single).
bond(id209,a4,a5,single).
bond(id209,a5,a6,single).
bond(id209,a6,a7,double).
bond(id209,a7,a8,single).
bond(id209,a8,a9,single).
bond(id209,a9,a10,single).
bond(id209,a1,a10,single).
bond(id209,a3,a8,single).
bond(id209,a7,a11,single).
bond(id209,a11,a12,double).
bond(id209,a12,a13,single).
bond(id209,a13,a14,single).
bond(id209,a13,a15,double).
bond(id209,a6,a15,single).
bond(id209,a2,a16,single).
bond(id209,a16,a17,single).
bond(id209,a17,a18,single).
bond(id209,a1,a18,single).
bond(id209,a,a,double).
bond(id209,a,a,double).
bond(id209,a,a,double).
bond(id209,a,a,double).
bond(id209,a,a,double).
bond(id209,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 210
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id210,210).
dsstox_filename(id210,nctrer_v1a_232_23oct03).
activity_category_er_rba(id210,active_medium).
cas(id210,'68-23-5').
chemclass_erb(id210,steroids_without_aromatic_a_ring).
chemcount(id210,'1').
chemname(id210,'norethynodrel').
chemnote(id210,'stereochem').
er_rba(id210,0.214).
f1_ring(id210,1).
f2_aromatic_ring(id210,0).
f3_phenolic_ring(id210,0).
f4_heteroatom(id210,1).
f5_phenol3nphenyl(id210,0).
f6_other_key_features(id210,1).
formula(id210,c20h26o2).
log_er_rba(id210,-0.67).
logp(id210,3.51).
mean_er_rba_chemclass(id210,1.24).
molweight(id210,298.4242).
structureshown(id210,tested_form).
substancetype(id210,defined_organic).
testedform(id210,parent).
smiles(id210,'c1c2c3c(ccc2c2=c(c1)cc(cc2)=o)(c(cc3)(o)c#c)c_').
%activity(id210,active).
atom(id210,a1,'C').
atom(id210,a2,'C').
atom(id210,a3,'C').
atom(id210,a4,'C').
atom(id210,a5,'C').
atom(id210,a6,'C').
atom(id210,a7,'C').
atom(id210,a8,'C').
atom(id210,a9,'C').
atom(id210,a10,'C').
atom(id210,a11,'C').
atom(id210,a12,'C').
atom(id210,a13,'C').
atom(id210,a14,'O').
atom(id210,a15,'C').
atom(id210,a16,'C').
atom(id210,a17,'C').
atom(id210,a18,'C').
atom(id210,a19,'O').
atom(id210,a20,'C').
atom(id210,a21,'H').
atom(id210,a22,'H').
atom(id210,a23,'H').
atom(id210,a24,'C').
atom(id210,a25,'C').
bond(id210,a1,a2,single).
bond(id210,a2,a3,single).
bond(id210,a3,a4,single).
bond(id210,a4,a5,single).
bond(id210,a5,a6,single).
bond(id210,a6,a7,double).
bond(id210,a7,a8,single).
bond(id210,a8,a9,single).
bond(id210,a9,a10,single).
bond(id210,a1,a10,single).
bond(id210,a3,a8,single).
bond(id210,a7,a11,single).
bond(id210,a11,a12,single).
bond(id210,a12,a13,single).
bond(id210,a13,a14,double).
bond(id210,a13,a15,single).
bond(id210,a6,a15,single).
bond(id210,a2,a16,single).
bond(id210,a16,a17,single).
bond(id210,a17,a18,single).
bond(id210,a1,a18,single).
bond(id210,a24,a25,double).
bond(id210,a,a,double).
bond(id210,a,a,double).
bond(id210,a,a,double).
bond(id210,a,a,double).
bond(id210,a,a,double).
bond(id210,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 211
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id211,211).
dsstox_filename(id211,nctrer_v1a_232_23oct03).
activity_category_er_rba(id211,slight_binder).
cas(id211,'2132-70-9').
chemclass_erb(id211,diphenylmethanes_ddts).
chemcount(id211,'1').
chemname(id211,'p,p_-methoxychlor_olefin').
chemnote(id211,'unknown').
er_rba(id211,0).
f1_ring(id211,1).
f2_aromatic_ring(id211,1).
f3_phenolic_ring(id211,0).
f4_heteroatom(id211,0).
f5_phenol3nphenyl(id211,0).
f6_other_key_features(id211,0).
formula(id211,c16h14cl2o2).
log_er_rba(id211,-5000).
logp(id211,4.87).
mean_er_rba_chemclass(id211,0.0087).
molweight(id211,309.1914).
structureshown(id211,tested_form).
substancetype(id211,defined_organic).
testedform(id211,parent).
smiles(id211,'c(=c(cl)cl)(c1ccc(cc1)oc)c1ccc(cc1)oc_').
%activity(id211,inactive).
atom(id211,a1,'C').
atom(id211,a2,'C').
atom(id211,a3,'Cl').
atom(id211,a4,'Cl').
atom(id211,a5,'C').
atom(id211,a6,'C').
atom(id211,a7,'C').
atom(id211,a8,'C').
atom(id211,a9,'C').
atom(id211,a10,'C').
atom(id211,a11,'O').
atom(id211,a12,'C').
atom(id211,a13,'C').
atom(id211,a14,'C').
atom(id211,a15,'C').
atom(id211,a16,'C').
atom(id211,a17,'C').
atom(id211,a18,'C').
atom(id211,a19,'O').
atom(id211,a20,'C').
bond(id211,a2,a1,double).
bond(id211,a3,a2,single).
bond(id211,a4,a2,single).
bond(id211,a5,a1,single).
bond(id211,a6,a5,double).
bond(id211,a7,a6,single).
bond(id211,a8,a7,double).
bond(id211,a9,a8,single).
bond(id211,a10,a9,double).
bond(id211,a10,a5,single).
bond(id211,a11,a8,single).
bond(id211,a12,a11,single).
bond(id211,a13,a1,single).
bond(id211,a14,a13,double).
bond(id211,a15,a14,single).
bond(id211,a16,a15,double).
bond(id211,a17,a16,single).
bond(id211,a18,a17,double).
bond(id211,a18,a13,single).
bond(id211,a19,a16,single).
bond(id211,a20,a19,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 212
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id212,212).
dsstox_filename(id212,nctrer_v1a_232_23oct03).
activity_category_er_rba(id212,inactive).
cas(id212,'59-30-3').
chemclass_erb(id212,misc).
chemcount(id212,'1').
chemname(id212,'folic_acid').
chemnote(id212,'unknown').
er_rba(id212,0).
f1_ring(id212,1).
f2_aromatic_ring(id212,1).
f3_phenolic_ring(id212,0).
f4_heteroatom(id212,0).
f5_phenol3nphenyl(id212,0).
f6_other_key_features(id212,0).
formula(id212,c19h19n7o6).
log_er_rba(id212,-10000).
logp(id212,-2).
mean_er_rba_chemclass(id212,na).
molweight(id212,441.4024).
structureshown(id212,tested_form).
substancetype(id212,defined_organic).
testedform(id212,parent).
smiles(id212,'n1c(c2nc(cnc3ccc(c(nc(c(=o)o)ccc(=o)o)=o)cc3)cnc2nc1n)o_').
%activity(id212,inactive).
atom(id212,a1,'N').
atom(id212,a2,'C').
atom(id212,a3,'C').
atom(id212,a4,'N').
atom(id212,a5,'C').
atom(id212,a6,'C').
atom(id212,a7,'N').
atom(id212,a8,'C').
atom(id212,a9,'C').
atom(id212,a10,'C').
atom(id212,a11,'C').
atom(id212,a12,'C').
atom(id212,a13,'N').
atom(id212,a14,'C').
atom(id212,a15,'C').
atom(id212,a16,'O').
atom(id212,a17,'O').
atom(id212,a18,'C').
atom(id212,a19,'C').
atom(id212,a20,'C').
atom(id212,a21,'O').
atom(id212,a22,'O').
atom(id212,a23,'O').
atom(id212,a24,'C').
atom(id212,a25,'C').
atom(id212,a26,'C').
atom(id212,a27,'N').
atom(id212,a28,'C').
atom(id212,a29,'N').
atom(id212,a30,'C').
atom(id212,a31,'N').
atom(id212,a32,'O').
bond(id212,a2,a1,double).
bond(id212,a3,a2,single).
bond(id212,a4,a3,double).
bond(id212,a5,a4,single).
bond(id212,a6,a5,single).
bond(id212,a7,a6,single).
bond(id212,a8,a7,single).
bond(id212,a9,a8,double).
bond(id212,a10,a9,single).
bond(id212,a11,a10,double).
bond(id212,a12,a11,single).
bond(id212,a13,a12,single).
bond(id212,a14,a13,single).
bond(id212,a15,a14,single).
bond(id212,a16,a15,double).
bond(id212,a17,a15,single).
bond(id212,a18,a14,single).
bond(id212,a19,a18,single).
bond(id212,a20,a19,single).
bond(id212,a21,a20,double).
bond(id212,a22,a20,single).
bond(id212,a23,a12,double).
bond(id212,a24,a11,single).
bond(id212,a25,a24,double).
bond(id212,a25,a8,single).
bond(id212,a26,a5,double).
bond(id212,a27,a26,single).
bond(id212,a28,a27,double).
bond(id212,a29,a28,single).
bond(id212,a30,a29,double).
bond(id212,a30,a1,single).
bond(id212,a31,a30,single).
bond(id212,a28,a3,single).
bond(id212,a32,a2,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 213
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id213,213).
dsstox_filename(id213,nctrer_v1a_232_23oct03).
activity_category_er_rba(id213,inactive).
cas(id213,'103-36-6').
chemclass_erb(id213,misc).
chemcount(id213,'1').
chemname(id213,'ethyl_cinnamate').
chemnote(id213,'unknown').
er_rba(id213,0).
f1_ring(id213,1).
f2_aromatic_ring(id213,1).
f3_phenolic_ring(id213,0).
f4_heteroatom(id213,0).
f5_phenol3nphenyl(id213,0).
f6_other_key_features(id213,0).
formula(id213,c11h12o2).
log_er_rba(id213,-10000).
logp(id213,2.85).
mean_er_rba_chemclass(id213,na).
molweight(id213,176.2146).
structureshown(id213,tested_form).
substancetype(id213,defined_organic).
testedform(id213,parent).
smiles(id213,'c(c(=o)occ)=cc1ccccc1_').
%activity(id213,inactive).
atom(id213,a1,'C').
atom(id213,a2,'C').
atom(id213,a3,'O').
atom(id213,a4,'O').
atom(id213,a5,'C').
atom(id213,a6,'C').
atom(id213,a7,'C').
atom(id213,a8,'C').
atom(id213,a9,'C').
atom(id213,a10,'C').
atom(id213,a11,'C').
atom(id213,a12,'C').
atom(id213,a13,'C').
bond(id213,a2,a1,single).
bond(id213,a3,a2,double).
bond(id213,a4,a2,single).
bond(id213,a5,a4,single).
bond(id213,a6,a5,single).
bond(id213,a7,a1,double).
bond(id213,a8,a7,single).
bond(id213,a9,a8,single).
bond(id213,a10,a9,double).
bond(id213,a11,a10,single).
bond(id213,a12,a11,double).
bond(id213,a13,a12,single).
bond(id213,a13,a8,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 214
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id214,214).
dsstox_filename(id214,nctrer_v1a_232_23oct03).
activity_category_er_rba(id214,inactive).
cas(id214,'28553-12-0').
chemclass_erb(id214,misc).
chemcount(id214,'1').
chemname(id214,'diisononylphthalate').
chemnote(id214,'unknown').
er_rba(id214,0).
f1_ring(id214,1).
f2_aromatic_ring(id214,1).
f3_phenolic_ring(id214,0).
f4_heteroatom(id214,0).
f5_phenol3nphenyl(id214,0).
f6_other_key_features(id214,0).
formula(id214,c26h42o4).
log_er_rba(id214,-10000).
logp(id214,9.37).
mean_er_rba_chemclass(id214,na).
molweight(id214,418.6154).
structureshown(id214,tested_form).
substancetype(id214,defined_organic).
testedform(id214,parent).
smiles(id214,'c1(c(c(occccccc(c)c)=o)cccc1)c(occccccc(c)c)=o_').
%activity(id214,inactive).
atom(id214,a1,'C').
atom(id214,a2,'C').
atom(id214,a3,'C').
atom(id214,a4,'O').
atom(id214,a5,'C').
atom(id214,a6,'C').
atom(id214,a7,'C').
atom(id214,a8,'C').
atom(id214,a9,'C').
atom(id214,a10,'C').
atom(id214,a11,'C').
atom(id214,a12,'C').
atom(id214,a13,'C').
atom(id214,a14,'O').
atom(id214,a15,'C').
atom(id214,a16,'C').
atom(id214,a17,'C').
atom(id214,a18,'C').
atom(id214,a19,'C').
atom(id214,a20,'O').
atom(id214,a21,'C').
atom(id214,a22,'C').
atom(id214,a23,'C').
atom(id214,a24,'C').
atom(id214,a25,'C').
atom(id214,a26,'C').
atom(id214,a27,'C').
atom(id214,a28,'C').
atom(id214,a29,'C').
atom(id214,a30,'O').
bond(id214,a2,a1,double).
bond(id214,a3,a2,single).
bond(id214,a4,a3,single).
bond(id214,a5,a4,single).
bond(id214,a6,a5,single).
bond(id214,a7,a6,single).
bond(id214,a8,a7,single).
bond(id214,a9,a8,single).
bond(id214,a10,a9,single).
bond(id214,a11,a10,single).
bond(id214,a12,a11,single).
bond(id214,a13,a11,single).
bond(id214,a14,a3,double).
bond(id214,a15,a2,single).
bond(id214,a16,a15,double).
bond(id214,a17,a16,single).
bond(id214,a18,a17,double).
bond(id214,a18,a1,single).
bond(id214,a19,a1,single).
bond(id214,a20,a19,single).
bond(id214,a21,a20,single).
bond(id214,a22,a21,single).
bond(id214,a23,a22,single).
bond(id214,a24,a23,single).
bond(id214,a25,a24,single).
bond(id214,a26,a25,single).
bond(id214,a27,a26,single).
bond(id214,a28,a27,single).
bond(id214,a29,a27,single).
bond(id214,a30,a19,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 215
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id215,215).
dsstox_filename(id215,nctrer_v1a_232_23oct03).
activity_category_er_rba(id215,inactive).
cas(id215,'84-69-5').
chemclass_erb(id215,misc).
chemcount(id215,'1').
chemname(id215,'di-l-butyl_phthalate_(dibp)').
chemnote(id215,'unknown').
er_rba(id215,0).
f1_ring(id215,1).
f2_aromatic_ring(id215,1).
f3_phenolic_ring(id215,0).
f4_heteroatom(id215,0).
f5_phenol3nphenyl(id215,0).
f6_other_key_features(id215,0).
formula(id215,c16h22o4).
log_er_rba(id215,-10000).
logp(id215,4.46).
mean_er_rba_chemclass(id215,na).
molweight(id215,278.3474).
structureshown(id215,tested_form).
substancetype(id215,defined_organic).
testedform(id215,parent).
smiles(id215,'c1(c(c(occ(c)c)=o)cccc1)c(occ(c)c)=o_').
%activity(id215,inactive).
atom(id215,a1,'C').
atom(id215,a2,'C').
atom(id215,a3,'C').
atom(id215,a4,'O').
atom(id215,a5,'C').
atom(id215,a6,'C').
atom(id215,a7,'C').
atom(id215,a8,'C').
atom(id215,a9,'O').
atom(id215,a10,'C').
atom(id215,a11,'C').
atom(id215,a12,'C').
atom(id215,a13,'C').
atom(id215,a14,'C').
atom(id215,a15,'O').
atom(id215,a16,'C').
atom(id215,a17,'C').
atom(id215,a18,'C').
atom(id215,a19,'C').
atom(id215,a20,'O').
bond(id215,a2,a1,double).
bond(id215,a3,a2,single).
bond(id215,a4,a3,single).
bond(id215,a5,a4,single).
bond(id215,a6,a5,single).
bond(id215,a7,a6,single).
bond(id215,a8,a6,single).
bond(id215,a9,a3,double).
bond(id215,a10,a2,single).
bond(id215,a11,a10,double).
bond(id215,a12,a11,single).
bond(id215,a13,a12,double).
bond(id215,a13,a1,single).
bond(id215,a14,a1,single).
bond(id215,a15,a14,single).
bond(id215,a16,a15,single).
bond(id215,a17,a16,single).
bond(id215,a18,a17,single).
bond(id215,a19,a17,single).
bond(id215,a20,a14,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 216
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id216,216).
dsstox_filename(id216,nctrer_v1a_232_23oct03).
activity_category_er_rba(id216,active_weak).
cas(id216,'1085-12-7').
chemclass_erb(id216,phenols_parabens).
chemcount(id216,'1').
chemname(id216,'heptyl_p-hydroxybenzoate').
chemnote(id216,'unknown').
er_rba(id216,0.00812).
f1_ring(id216,1).
f2_aromatic_ring(id216,1).
f3_phenolic_ring(id216,1).
f4_heteroatom(id216,0).
f5_phenol3nphenyl(id216,0).
f6_other_key_features(id216,1).
formula(id216,c14h20o3).
log_er_rba(id216,-2.09).
logp(id216,4.94).
mean_er_rba_chemclass(id216,0.00088).
molweight(id216,236.3102).
structureshown(id216,tested_form).
substancetype(id216,defined_organic).
testedform(id216,parent).
smiles(id216,'c(c1ccc(cc1)o)(=o)occccccc_').
%activity(id216,active).
atom(id216,a1,'C').
atom(id216,a2,'C').
atom(id216,a3,'C').
atom(id216,a4,'C').
atom(id216,a5,'C').
atom(id216,a6,'C').
atom(id216,a7,'C').
atom(id216,a8,'O').
atom(id216,a9,'O').
atom(id216,a10,'O').
atom(id216,a11,'C').
atom(id216,a12,'C').
atom(id216,a13,'C').
atom(id216,a14,'C').
atom(id216,a15,'C').
atom(id216,a16,'C').
atom(id216,a17,'C').
bond(id216,a2,a1,single).
bond(id216,a3,a2,double).
bond(id216,a4,a3,single).
bond(id216,a5,a4,double).
bond(id216,a6,a5,single).
bond(id216,a7,a6,double).
bond(id216,a7,a2,single).
bond(id216,a8,a5,single).
bond(id216,a9,a1,double).
bond(id216,a10,a1,single).
bond(id216,a11,a10,single).
bond(id216,a12,a11,single).
bond(id216,a13,a12,single).
bond(id216,a14,a13,single).
bond(id216,a15,a14,single).
bond(id216,a16,a15,single).
bond(id216,a17,a16,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 217
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id217,217).
dsstox_filename(id217,nctrer_v1a_232_23oct03).
activity_category_er_rba(id217,inactive).
cas(id217,'50-35-1').
chemclass_erb(id217,misc).
chemcount(id217,'1').
chemname(id217,'thalidomide').
chemnote(id217,'unknown').
er_rba(id217,0).
f1_ring(id217,1).
f2_aromatic_ring(id217,1).
f3_phenolic_ring(id217,0).
f4_heteroatom(id217,0).
f5_phenol3nphenyl(id217,0).
f6_other_key_features(id217,0).
formula(id217,c13h10n2o4).
log_er_rba(id217,-10000).
logp(id217,-0.24).
mean_er_rba_chemclass(id217,na).
molweight(id217,258.233).
structureshown(id217,tested_form).
substancetype(id217,defined_organic).
testedform(id217,parent).
smiles(id217,'n1(c(c2ccccc2c1=o)=o)c1c(nc(cc1)=o)=o_').
%activity(id217,inactive).
atom(id217,a1,'N').
atom(id217,a2,'C').
atom(id217,a3,'C').
atom(id217,a4,'C').
atom(id217,a5,'C').
atom(id217,a6,'C').
atom(id217,a7,'C').
atom(id217,a8,'C').
atom(id217,a9,'C').
atom(id217,a10,'O').
atom(id217,a11,'O').
atom(id217,a12,'C').
atom(id217,a13,'C').
atom(id217,a14,'N').
atom(id217,a15,'C').
atom(id217,a16,'C').
atom(id217,a17,'C').
atom(id217,a18,'O').
atom(id217,a19,'O').
bond(id217,a2,a1,single).
bond(id217,a3,a2,single).
bond(id217,a4,a3,double).
bond(id217,a5,a4,single).
bond(id217,a6,a5,double).
bond(id217,a7,a6,single).
bond(id217,a8,a7,double).
bond(id217,a9,a8,single).
bond(id217,a9,a1,single).
bond(id217,a10,a9,double).
bond(id217,a8,a3,single).
bond(id217,a11,a2,double).
bond(id217,a12,a1,single).
bond(id217,a13,a12,single).
bond(id217,a14,a13,single).
bond(id217,a15,a14,single).
bond(id217,a16,a15,single).
bond(id217,a17,a16,single).
bond(id217,a17,a12,single).
bond(id217,a18,a15,double).
bond(id217,a19,a13,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 218
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id218,218).
dsstox_filename(id218,nctrer_v1a_232_23oct03).
activity_category_er_rba(id218,active_medium).
cas(id218,'5153-25-3').
chemclass_erb(id218,phenols_parabens).
chemcount(id218,'1').
chemname(id218,'2-ethylhexyl-4-hydroxybenzoate').
chemnote(id218,'unknown').
er_rba(id218,0.0182).
f1_ring(id218,1).
f2_aromatic_ring(id218,1).
f3_phenolic_ring(id218,1).
f4_heteroatom(id218,0).
f5_phenol3nphenyl(id218,0).
f6_other_key_features(id218,1).
formula(id218,c15h22o3).
log_er_rba(id218,-1.74).
logp(id218,5.36).
mean_er_rba_chemclass(id218,0.00088).
molweight(id218,250.337).
structureshown(id218,tested_form).
substancetype(id218,defined_organic).
testedform(id218,parent).
smiles(id218,'c(c1ccc(cc1)o)(occ(cc)cccc)=o_').
%activity(id218,active).
atom(id218,a1,'C').
atom(id218,a2,'C').
atom(id218,a3,'C').
atom(id218,a4,'C').
atom(id218,a5,'C').
atom(id218,a6,'C').
atom(id218,a7,'C').
atom(id218,a8,'O').
atom(id218,a9,'O').
atom(id218,a10,'C').
atom(id218,a11,'C').
atom(id218,a12,'C').
atom(id218,a13,'C').
atom(id218,a14,'C').
atom(id218,a15,'C').
atom(id218,a16,'C').
atom(id218,a17,'C').
atom(id218,a18,'O').
bond(id218,a2,a1,single).
bond(id218,a3,a2,single).
bond(id218,a4,a3,double).
bond(id218,a5,a4,single).
bond(id218,a6,a5,double).
bond(id218,a7,a6,single).
bond(id218,a7,a2,double).
bond(id218,a8,a5,single).
bond(id218,a9,a1,single).
bond(id218,a10,a9,single).
bond(id218,a11,a10,single).
bond(id218,a12,a11,single).
bond(id218,a13,a12,single).
bond(id218,a14,a11,single).
bond(id218,a15,a14,single).
bond(id218,a16,a15,single).
bond(id218,a17,a16,single).
bond(id218,a18,a1,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 219
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id219,219).
dsstox_filename(id219,nctrer_v1a_232_23oct03).
activity_category_er_rba(id219,active_weak).
cas(id219,'94-18-8').
chemclass_erb(id219,phenols_parabens).
chemcount(id219,'1').
chemname(id219,'benzyl_4-hydroxybenzoate').
chemnote(id219,'unknown').
er_rba(id219,0.00288).
f1_ring(id219,1).
f2_aromatic_ring(id219,1).
f3_phenolic_ring(id219,1).
f4_heteroatom(id219,0).
f5_phenol3nphenyl(id219,1).
f6_other_key_features(id219,0).
formula(id219,c14h12o3).
log_er_rba(id219,-2.54).
logp(id219,3.7).
mean_er_rba_chemclass(id219,0.00088).
molweight(id219,228.247).
structureshown(id219,tested_form).
substancetype(id219,defined_organic).
testedform(id219,parent).
smiles(id219,'c(occ1ccccc1)(c1ccc(o)cc1)=o_').
%activity(id219,active).
atom(id219,a1,'C').
atom(id219,a2,'O').
atom(id219,a3,'C').
atom(id219,a4,'C').
atom(id219,a5,'C').
atom(id219,a6,'C').
atom(id219,a7,'C').
atom(id219,a8,'C').
atom(id219,a9,'C').
atom(id219,a10,'C').
atom(id219,a11,'C').
atom(id219,a12,'C').
atom(id219,a13,'C').
atom(id219,a14,'O').
atom(id219,a15,'C').
atom(id219,a16,'C').
atom(id219,a17,'O').
bond(id219,a2,a1,single).
bond(id219,a3,a2,single).
bond(id219,a4,a3,single).
bond(id219,a5,a4,double).
bond(id219,a6,a5,single).
bond(id219,a7,a6,double).
bond(id219,a8,a7,single).
bond(id219,a9,a8,double).
bond(id219,a9,a4,single).
bond(id219,a10,a1,single).
bond(id219,a11,a10,single).
bond(id219,a12,a11,double).
bond(id219,a13,a12,single).
bond(id219,a14,a13,single).
bond(id219,a15,a13,double).
bond(id219,a16,a15,single).
bond(id219,a16,a10,double).
bond(id219,a17,a1,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 220
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id220,220).
dsstox_filename(id220,nctrer_v1a_232_23oct03).
activity_category_er_rba(id220,active_weak).
cas(id220,'94-13-3').
chemclass_erb(id220,phenols_parabens).
chemcount(id220,'1').
chemname(id220,'n-propyl_4-hydroxybenzoate').
chemnote(id220,'unknown').
er_rba(id220,0.0006).
f1_ring(id220,1).
f2_aromatic_ring(id220,1).
f3_phenolic_ring(id220,1).
f4_heteroatom(id220,0).
f5_phenol3nphenyl(id220,0).
f6_other_key_features(id220,1).
formula(id220,c10h12o3).
log_er_rba(id220,-3.22).
logp(id220,2.98).
mean_er_rba_chemclass(id220,0.00088).
molweight(id220,180.203).
structureshown(id220,tested_form).
substancetype(id220,defined_organic).
testedform(id220,parent).
smiles(id220,'c(c1ccc(cc1)o)(=o)occc_').
%activity(id220,active).
atom(id220,a1,'C').
atom(id220,a2,'C').
atom(id220,a3,'C').
atom(id220,a4,'C').
atom(id220,a5,'C').
atom(id220,a6,'C').
atom(id220,a7,'C').
atom(id220,a8,'O').
atom(id220,a9,'O').
atom(id220,a10,'O').
atom(id220,a11,'C').
atom(id220,a12,'C').
atom(id220,a13,'C').
bond(id220,a2,a1,single).
bond(id220,a3,a2,double).
bond(id220,a4,a3,single).
bond(id220,a5,a4,double).
bond(id220,a6,a5,single).
bond(id220,a7,a6,double).
bond(id220,a7,a2,single).
bond(id220,a8,a5,single).
bond(id220,a9,a1,double).
bond(id220,a10,a1,single).
bond(id220,a11,a10,single).
bond(id220,a12,a11,single).
bond(id220,a13,a12,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 221
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id221,221).
dsstox_filename(id221,nctrer_v1a_232_23oct03).
activity_category_er_rba(id221,active_weak).
cas(id221,'120-47-8').
chemclass_erb(id221,phenols_parabens).
chemcount(id221,'1').
chemname(id221,'ethyl_4-hydroxybenzoate').
chemnote(id221,'unknown').
er_rba(id221,0.0006).
f1_ring(id221,1).
f2_aromatic_ring(id221,1).
f3_phenolic_ring(id221,1).
f4_heteroatom(id221,0).
f5_phenol3nphenyl(id221,0).
f6_other_key_features(id221,1).
formula(id221,c9h10o3).
log_er_rba(id221,-3.22).
logp(id221,2.49).
mean_er_rba_chemclass(id221,0.00088).
molweight(id221,166.1762).
structureshown(id221,tested_form).
substancetype(id221,defined_organic).
testedform(id221,parent).
smiles(id221,'c(c1ccc(cc1)o)(=o)occ_').
%activity(id221,active).
atom(id221,a1,'C').
atom(id221,a2,'C').
atom(id221,a3,'C').
atom(id221,a4,'C').
atom(id221,a5,'C').
atom(id221,a6,'C').
atom(id221,a7,'C').
atom(id221,a8,'O').
atom(id221,a9,'O').
atom(id221,a10,'O').
atom(id221,a11,'C').
atom(id221,a12,'C').
bond(id221,a2,a1,single).
bond(id221,a3,a2,double).
bond(id221,a4,a3,single).
bond(id221,a5,a4,double).
bond(id221,a6,a5,single).
bond(id221,a7,a6,double).
bond(id221,a7,a2,single).
bond(id221,a8,a5,single).
bond(id221,a9,a1,double).
bond(id221,a10,a1,single).
bond(id221,a11,a10,single).
bond(id221,a12,a11,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 222
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id222,222).
dsstox_filename(id222,nctrer_v1a_232_23oct03).
activity_category_er_rba(id222,active_weak).
cas(id222,'99-76-3').
chemclass_erb(id222,phenols_parabens).
chemcount(id222,'1').
chemname(id222,'methyl_4-hydroxybenzoate').
chemnote(id222,'unknown').
er_rba(id222,0.00036).
f1_ring(id222,1).
f2_aromatic_ring(id222,1).
f3_phenolic_ring(id222,1).
f4_heteroatom(id222,0).
f5_phenol3nphenyl(id222,0).
f6_other_key_features(id222,1).
formula(id222,c8h8o3).
log_er_rba(id222,-3.44).
logp(id222,2).
mean_er_rba_chemclass(id222,0.00088).
molweight(id222,152.1494).
structureshown(id222,tested_form).
substancetype(id222,defined_organic).
testedform(id222,parent).
smiles(id222,'c(c1ccc(cc1)o)(=o)oc_').
%activity(id222,active).
atom(id222,a1,'C').
atom(id222,a2,'C').
atom(id222,a3,'C').
atom(id222,a4,'C').
atom(id222,a5,'C').
atom(id222,a6,'C').
atom(id222,a7,'C').
atom(id222,a8,'O').
atom(id222,a9,'O').
atom(id222,a10,'O').
atom(id222,a11,'C').
bond(id222,a2,a1,single).
bond(id222,a3,a2,double).
bond(id222,a4,a3,single).
bond(id222,a5,a4,double).
bond(id222,a6,a5,single).
bond(id222,a7,a6,double).
bond(id222,a7,a2,single).
bond(id222,a8,a5,single).
bond(id222,a9,a1,double).
bond(id222,a10,a1,single).
bond(id222,a11,a10,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 223
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id223,223).
dsstox_filename(id223,nctrer_v1a_232_23oct03).
activity_category_er_rba(id223,active_weak).
cas(id223,'552-59-0').
chemclass_erb(id223,phytoestrogens_isoflavones).
chemcount(id223,'1').
chemname(id223,'prunetin').
chemnote(id223,'unknown').
er_rba(id223,0.00181).
f1_ring(id223,1).
f2_aromatic_ring(id223,1).
f3_phenolic_ring(id223,1).
f4_heteroatom(id223,0).
f5_phenol3nphenyl(id223,1).
f6_other_key_features(id223,0).
formula(id223,c16h12o5).
log_er_rba(id223,-2.74).
logp(id223,3.41).
mean_er_rba_chemclass(id223,0.019).
molweight(id223,284.2678).
structureshown(id223,tested_form).
substancetype(id223,defined_organic).
testedform(id223,parent).
smiles(id223,'c1(c2c(cc(cc2o)oc)occ1c1ccc(cc1)o)=o_').
%activity(id223,active).
atom(id223,a1,'C').
atom(id223,a2,'C').
atom(id223,a3,'C').
atom(id223,a4,'C').
atom(id223,a5,'C').
atom(id223,a6,'C').
atom(id223,a7,'C').
atom(id223,a8,'O').
atom(id223,a9,'O').
atom(id223,a10,'C').
atom(id223,a11,'O').
atom(id223,a12,'C').
atom(id223,a13,'C').
atom(id223,a14,'C').
atom(id223,a15,'C').
atom(id223,a16,'C').
atom(id223,a17,'C').
atom(id223,a18,'C').
atom(id223,a19,'C').
atom(id223,a20,'O').
atom(id223,a21,'O').
bond(id223,a2,a1,single).
bond(id223,a3,a2,single).
bond(id223,a4,a3,double).
bond(id223,a5,a4,single).
bond(id223,a6,a5,double).
bond(id223,a7,a6,single).
bond(id223,a7,a2,double).
bond(id223,a8,a7,single).
bond(id223,a9,a5,single).
bond(id223,a10,a9,single).
bond(id223,a11,a3,single).
bond(id223,a12,a11,single).
bond(id223,a13,a12,double).
bond(id223,a13,a1,single).
bond(id223,a14,a13,single).
bond(id223,a15,a14,single).
bond(id223,a16,a15,double).
bond(id223,a17,a16,single).
bond(id223,a18,a17,double).
bond(id223,a19,a18,single).
bond(id223,a19,a14,double).
bond(id223,a20,a17,single).
bond(id223,a21,a1,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 224
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id224,224).
dsstox_filename(id224,nctrer_v1a_232_23oct03).
activity_category_er_rba(id224,active_weak).
cas(id224,'94-41-7').
chemclass_erb(id224,phytoestrogens_chalconoids).
chemcount(id224,'1').
chemname(id224,'chalcone').
chemnote(id224,'unknown').
er_rba(id224,0.00151).
f1_ring(id224,1).
f2_aromatic_ring(id224,1).
f3_phenolic_ring(id224,0).
f4_heteroatom(id224,0).
f5_phenol3nphenyl(id224,0).
f6_other_key_features(id224,1).
formula(id224,c15h12o).
log_er_rba(id224,-2.82).
logp(id224,3.66).
mean_er_rba_chemclass(id224,0.019).
molweight(id224,208.2592).
structureshown(id224,tested_form).
substancetype(id224,defined_organic).
testedform(id224,parent).
smiles(id224,'c(c(=o)c1ccccc1)=cc1ccccc1_').
%activity(id224,active).
atom(id224,a1,'C').
atom(id224,a2,'C').
atom(id224,a3,'O').
atom(id224,a4,'C').
atom(id224,a5,'C').
atom(id224,a6,'C').
atom(id224,a7,'C').
atom(id224,a8,'C').
atom(id224,a9,'C').
atom(id224,a10,'C').
atom(id224,a11,'C').
atom(id224,a12,'C').
atom(id224,a13,'C').
atom(id224,a14,'C').
atom(id224,a15,'C').
atom(id224,a16,'C').
bond(id224,a2,a1,single).
bond(id224,a3,a2,double).
bond(id224,a4,a2,single).
bond(id224,a5,a4,single).
bond(id224,a6,a5,double).
bond(id224,a7,a6,single).
bond(id224,a8,a7,double).
bond(id224,a9,a8,single).
bond(id224,a9,a4,double).
bond(id224,a10,a1,double).
bond(id224,a11,a10,single).
bond(id224,a12,a11,single).
bond(id224,a13,a12,double).
bond(id224,a14,a13,single).
bond(id224,a15,a14,double).
bond(id224,a16,a15,single).
bond(id224,a16,a11,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 225
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id225,225).
dsstox_filename(id225,nctrer_v1a_232_23oct03).
activity_category_er_rba(id225,active_medium).
cas(id225,'42422-68-4').
chemclass_erb(id225,phytoestrogens_mycoestrogens).
chemcount(id225,'2_of_2').
chemname(id225,'beta_zearalanol').
chemnote(id225,'stereochem,_2d_replicate_of_alpha_form_cas_[55331-29-8]').
er_rba(id225,0.646).
f1_ring(id225,1).
f2_aromatic_ring(id225,1).
f3_phenolic_ring(id225,1).
f4_heteroatom(id225,0).
f5_phenol3nphenyl(id225,0).
f6_other_key_features(id225,1).
formula(id225,c18h26o5).
log_er_rba(id225,-0.19).
logp(id225,5.37).
mean_er_rba_chemclass(id225,0.019).
molweight(id225,322.4004).
structureshown(id225,tested_form).
substancetype(id225,defined_organic).
testedform(id225,parent).
smiles(id225,'c1(c2c(cc(cc2cccccc(o)cccc(o1)c)o)o)=o_').
%activity(id225,active).
atom(id225,a1,'C').
atom(id225,a2,'C').
atom(id225,a3,'C').
atom(id225,a4,'C').
atom(id225,a5,'C').
atom(id225,a6,'C').
atom(id225,a7,'C').
atom(id225,a8,'C').
atom(id225,a9,'C').
atom(id225,a10,'C').
atom(id225,a11,'C').
atom(id225,a12,'C').
atom(id225,a13,'C').
atom(id225,a14,'O').
atom(id225,a15,'C').
atom(id225,a16,'C').
atom(id225,a17,'C').
atom(id225,a18,'C').
atom(id225,a19,'O').
atom(id225,a20,'C').
atom(id225,a21,'O').
atom(id225,a22,'O').
atom(id225,a23,'O').
bond(id225,a2,a1,single).
bond(id225,a3,a2,double).
bond(id225,a4,a3,single).
bond(id225,a5,a4,double).
bond(id225,a6,a5,single).
bond(id225,a7,a6,double).
bond(id225,a7,a2,single).
bond(id225,a8,a7,single).
bond(id225,a9,a8,single).
bond(id225,a10,a9,single).
bond(id225,a11,a10,single).
bond(id225,a12,a11,single).
bond(id225,a13,a12,single).
bond(id225,a15,a13,single).
bond(id225,a16,a15,single).
bond(id225,a17,a16,single).
bond(id225,a18,a17,single).
bond(id225,a19,a18,single).
bond(id225,a19,a1,single).
bond(id225,a21,a5,single).
bond(id225,a22,a3,single).
bond(id225,a23,a1,double).
bond(id225,a,a,double).
bond(id225,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 226
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id226,226).
dsstox_filename(id226,nctrer_v1a_232_23oct03).
activity_category_er_rba(id226,active_medium).
cas(id226,'71030-11-0').
chemclass_erb(id226,phytoestrogens_mycoestrogens).
chemcount(id226,'2_of_2').
chemname(id226,'beta_zearalenol').
chemnote(id226,'stereochem,_2d_replicate_of_alpha_form_cas_[36455-72-8]').
er_rba(id226,0.204).
f1_ring(id226,1).
f2_aromatic_ring(id226,1).
f3_phenolic_ring(id226,1).
f4_heteroatom(id226,0).
f5_phenol3nphenyl(id226,0).
f6_other_key_features(id226,1).
formula(id226,c18h24o5).
log_er_rba(id226,-0.69).
logp(id226,4.09).
mean_er_rba_chemclass(id226,0.019).
molweight(id226,320.3846).
structureshown(id226,tested_form).
substancetype(id226,defined_organic).
testedform(id226,parent).
smiles(id226,'c1(c2c(cc(cc2c=ccccc(o)cccc(o1)c)o)o)=o_').
%activity(id226,active).
atom(id226,a1,'C').
atom(id226,a2,'C').
atom(id226,a3,'C').
atom(id226,a4,'C').
atom(id226,a5,'C').
atom(id226,a6,'C').
atom(id226,a7,'C').
atom(id226,a8,'C').
atom(id226,a9,'C').
atom(id226,a10,'C').
atom(id226,a11,'C').
atom(id226,a12,'C').
atom(id226,a13,'C').
atom(id226,a14,'O').
atom(id226,a15,'C').
atom(id226,a16,'C').
atom(id226,a17,'C').
atom(id226,a18,'C').
atom(id226,a19,'O').
atom(id226,a20,'C').
atom(id226,a21,'O').
atom(id226,a22,'O').
atom(id226,a23,'O').
bond(id226,a2,a1,single).
bond(id226,a3,a2,double).
bond(id226,a4,a3,single).
bond(id226,a5,a4,double).
bond(id226,a6,a5,single).
bond(id226,a7,a6,double).
bond(id226,a7,a2,single).
bond(id226,a8,a7,single).
bond(id226,a9,a8,double).
bond(id226,a10,a9,single).
bond(id226,a11,a10,single).
bond(id226,a12,a11,single).
bond(id226,a13,a12,single).
bond(id226,a15,a13,single).
bond(id226,a16,a15,single).
bond(id226,a17,a16,single).
bond(id226,a18,a17,single).
bond(id226,a19,a18,single).
bond(id226,a19,a1,single).
bond(id226,a21,a5,single).
bond(id226,a22,a3,single).
bond(id226,a23,a1,double).
bond(id226,a,a,double).
bond(id226,a,a,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 227
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id227,227).
dsstox_filename(id227,nctrer_v1a_232_23oct03).
activity_category_er_rba(id227,inactive).
cas(id227,'98-01-1').
chemclass_erb(id227,misc).
chemcount(id227,'1').
chemname(id227,'2-furaldehyde').
chemnote(id227,'unknown').
er_rba(id227,0).
f1_ring(id227,1).
f2_aromatic_ring(id227,1).
f3_phenolic_ring(id227,0).
f4_heteroatom(id227,0).
f5_phenol3nphenyl(id227,0).
f6_other_key_features(id227,0).
formula(id227,c5h4o2).
log_er_rba(id227,-10000).
logp(id227,0.83).
mean_er_rba_chemclass(id227,na).
molweight(id227,96.0854).
structureshown(id227,tested_form).
substancetype(id227,defined_organic).
testedform(id227,parent).
smiles(id227,'c1(occc1)c=o_').
%activity(id227,inactive).
atom(id227,a1,'C').
atom(id227,a2,'O').
atom(id227,a3,'C').
atom(id227,a4,'C').
atom(id227,a5,'C').
atom(id227,a6,'C').
atom(id227,a7,'O').
bond(id227,a2,a1,single).
bond(id227,a3,a2,single).
bond(id227,a4,a3,double).
bond(id227,a5,a4,single).
bond(id227,a5,a1,double).
bond(id227,a6,a1,single).
bond(id227,a7,a6,double).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 228
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id228,228).
dsstox_filename(id228,nctrer_v1a_232_23oct03).
activity_category_er_rba(id228,inactive).
cas(id228,'470-82-6').
chemclass_erb(id228,misc).
chemcount(id228,'1').
chemname(id228,'cineole').
chemnote(id228,'stereochem').
er_rba(id228,0).
f1_ring(id228,1).
f2_aromatic_ring(id228,0).
f3_phenolic_ring(id228,0).
f4_heteroatom(id228,1).
f5_phenol3nphenyl(id228,0).
f6_other_key_features(id228,0).
formula(id228,c10h18o).
log_er_rba(id228,-10000).
logp(id228,3.13).
mean_er_rba_chemclass(id228,na).
molweight(id228,154.2516).
structureshown(id228,tested_form).
substancetype(id228,defined_organic).
testedform(id228,parent).
smiles(id228,'c1cc2ccc1(c)oc2(c)c_').
%activity(id228,inactive).
atom(id228,a1,'C').
atom(id228,a2,'C').
atom(id228,a3,'C').
atom(id228,a4,'C').
atom(id228,a5,'C').
atom(id228,a6,'C').
atom(id228,a7,'C').
atom(id228,a8,'O').
atom(id228,a9,'C').
atom(id228,a10,'C').
atom(id228,a11,'C').
bond(id228,a1,a2,single).
bond(id228,a2,a3,single).
bond(id228,a3,a4,single).
bond(id228,a4,a5,single).
bond(id228,a5,a6,single).
bond(id228,a6,a1,single).
bond(id228,a6,a7,single).
bond(id228,a6,a8,single).
bond(id228,a8,a9,single).
bond(id228,a9,a3,single).
bond(id228,a9,a10,single).
bond(id228,a9,a11,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 229
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id229,229).
dsstox_filename(id229,nctrer_v1a_232_23oct03).
activity_category_er_rba(id229,active_weak).
cas(id229,'599-64-4').
chemclass_erb(id229,diphenylmethanes_diphenolalkanes).
chemcount(id229,'1').
chemname(id229,'p-cumyl_phenol').
chemnote(id229,'unknown').
er_rba(id229,0.00501).
f1_ring(id229,1).
f2_aromatic_ring(id229,1).
f3_phenolic_ring(id229,1).
f4_heteroatom(id229,0).
f5_phenol3nphenyl(id229,1).
f6_other_key_features(id229,0).
formula(id229,c15h16o).
log_er_rba(id229,-2.3).
logp(id229,4.12).
mean_er_rba_chemclass(id229,0.0087).
molweight(id229,212.2908).
structureshown(id229,tested_form).
substancetype(id229,defined_organic).
testedform(id229,parent).
smiles(id229,'c(c1ccc(cc1)o)(c1ccccc1)(c)c_').
%activity(id229,active).
atom(id229,a1,'C').
atom(id229,a2,'C').
atom(id229,a3,'C').
atom(id229,a4,'C').
atom(id229,a5,'C').
atom(id229,a6,'C').
atom(id229,a7,'C').
atom(id229,a8,'O').
atom(id229,a9,'C').
atom(id229,a10,'C').
atom(id229,a11,'C').
atom(id229,a12,'C').
atom(id229,a13,'C').
atom(id229,a14,'C').
atom(id229,a15,'C').
atom(id229,a16,'C').
bond(id229,a2,a1,single).
bond(id229,a3,a2,double).
bond(id229,a4,a3,single).
bond(id229,a5,a4,double).
bond(id229,a6,a5,single).
bond(id229,a7,a6,double).
bond(id229,a7,a2,single).
bond(id229,a8,a5,single).
bond(id229,a9,a1,single).
bond(id229,a10,a9,single).
bond(id229,a11,a10,double).
bond(id229,a12,a11,single).
bond(id229,a13,a12,double).
bond(id229,a14,a13,single).
bond(id229,a14,a9,double).
bond(id229,a15,a1,single).
bond(id229,a16,a1,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 230
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id230,230).
dsstox_filename(id230,nctrer_v1a_232_23oct03).
activity_category_er_rba(id230,active_weak).
cas(id230,'56-33-7').
chemclass_erb(id230,misc).
chemcount(id230,'1').
chemname(id230,'1,3-diphenyltetramethyldisiloxane').
chemnote(id230,'metalloid_complex_excluded_from_dop_file').
er_rba(id230,0.00069).
f1_ring(id230,1).
f2_aromatic_ring(id230,1).
f3_phenolic_ring(id230,0).
f4_heteroatom(id230,0).
f5_phenol3nphenyl(id230,0).
f6_other_key_features(id230,1).
formula(id230,c16h22osi2).
log_er_rba(id230,-3.16).
logp(id230,7.2).
mean_er_rba_chemclass(id230,na).
molweight(id230,286.5212).
structureshown(id230,tested_form).
substancetype(id230,organometallic).
testedform(id230,complex).
smiles(id230,'o([si](c1ccccc1)(c)c)[si](c1ccccc1)(c)c_').
%activity(id230,active).
atom(id230,a1,'O').
atom(id230,a2,'Si').
atom(id230,a3,'C').
atom(id230,a4,'C').
atom(id230,a5,'C').
atom(id230,a6,'C').
atom(id230,a7,'C').
atom(id230,a8,'C').
atom(id230,a9,'C').
atom(id230,a10,'C').
atom(id230,a11,'Si').
atom(id230,a12,'C').
atom(id230,a13,'C').
atom(id230,a14,'C').
atom(id230,a15,'C').
atom(id230,a16,'C').
atom(id230,a17,'C').
atom(id230,a18,'C').
atom(id230,a19,'C').
bond(id230,a2,a1,single).
bond(id230,a3,a2,single).
bond(id230,a4,a3,double).
bond(id230,a5,a4,single).
bond(id230,a6,a5,double).
bond(id230,a7,a6,single).
bond(id230,a8,a7,double).
bond(id230,a8,a3,single).
bond(id230,a9,a2,single).
bond(id230,a10,a2,single).
bond(id230,a11,a1,single).
bond(id230,a12,a11,single).
bond(id230,a13,a12,double).
bond(id230,a14,a13,single).
bond(id230,a15,a14,double).
bond(id230,a16,a15,single).
bond(id230,a17,a16,double).
bond(id230,a17,a12,single).
bond(id230,a18,a11,single).
bond(id230,a19,a11,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 231
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id231,231).
dsstox_filename(id231,nctrer_v1a_232_23oct03).
activity_category_er_rba(id231,inactive).
cas(id231,'1833-27-8').
chemclass_erb(id231,misc).
chemcount(id231,'1').
chemname(id231,'1,3-dibenzyltetramethyldisiloxane').
chemnote(id231,'metalloid_complex_excluded_from_dop_file').
er_rba(id231,0).
f1_ring(id231,1).
f2_aromatic_ring(id231,1).
f3_phenolic_ring(id231,0).
f4_heteroatom(id231,0).
f5_phenol3nphenyl(id231,0).
f6_other_key_features(id231,0).
formula(id231,c18h26osi2).
log_er_rba(id231,-10000).
logp(id231,8.18).
mean_er_rba_chemclass(id231,na).
molweight(id231,314.5748).
structureshown(id231,tested_form).
substancetype(id231,organometallic).
testedform(id231,complex).
smiles(id231,'o([si](cc1ccccc1)(c)c)[si](cc1ccccc1)(c)c_').
%activity(id231,inactive).
atom(id231,a1,'O').
atom(id231,a2,'Si').
atom(id231,a3,'C').
atom(id231,a4,'C').
atom(id231,a5,'C').
atom(id231,a6,'C').
atom(id231,a7,'C').
atom(id231,a8,'C').
atom(id231,a9,'C').
atom(id231,a10,'C').
atom(id231,a11,'C').
atom(id231,a12,'Si').
atom(id231,a13,'C').
atom(id231,a14,'C').
atom(id231,a15,'C').
atom(id231,a16,'C').
atom(id231,a17,'C').
atom(id231,a18,'C').
atom(id231,a19,'C').
atom(id231,a20,'C').
atom(id231,a21,'C').
bond(id231,a2,a1,single).
bond(id231,a3,a2,single).
bond(id231,a4,a3,single).
bond(id231,a5,a4,single).
bond(id231,a6,a5,double).
bond(id231,a7,a6,single).
bond(id231,a8,a7,double).
bond(id231,a9,a8,single).
bond(id231,a9,a4,double).
bond(id231,a10,a2,single).
bond(id231,a11,a2,single).
bond(id231,a12,a1,single).
bond(id231,a13,a12,single).
bond(id231,a14,a13,single).
bond(id231,a15,a14,double).
bond(id231,a16,a15,single).
bond(id231,a17,a16,double).
bond(id231,a18,a17,single).
bond(id231,a19,a18,double).
bond(id231,a19,a14,single).
bond(id231,a20,a12,single).
bond(id231,a21,a12,single).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DSSTOX Entry: 232
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dsstox_id(id232,232).
dsstox_filename(id232,nctrer_v1a_232_23oct03).
activity_category_er_rba(id232,active_medium).
cas(id232,'nocas').
chemclass_erb(id232,phytoestrogens_flavones).
chemcount(id232,'1').
chemname(id232,'3,6,4_-trihydroxyflavone').
chemnote(id232,'unknown').
er_rba(id232,0.447).
f1_ring(id232,1).
f2_aromatic_ring(id232,1).
f3_phenolic_ring(id232,1).
f4_heteroatom(id232,0).
f5_phenol3nphenyl(id232,1).
f6_other_key_features(id232,0).
formula(id232,c15h10o5).
log_er_rba(id232,-0.35).
logp(id232,1.66).
mean_er_rba_chemclass(id232,0.019).
molweight(id232,270.241).
structureshown(id232,tested_form).
substancetype(id232,defined_organic).
testedform(id232,parent).
smiles(id232,'c1(c(oc2ccc(cc2c1=o)o)c1ccc(cc1)o)o_').
%activity(id232,active).
atom(id232,a1,'C').
atom(id232,a2,'C').
atom(id232,a3,'O').
atom(id232,a4,'C').
atom(id232,a5,'C').
atom(id232,a6,'C').
atom(id232,a7,'C').
atom(id232,a8,'C').
atom(id232,a9,'C').
atom(id232,a10,'C').
atom(id232,a11,'O').
atom(id232,a12,'O').
atom(id232,a13,'C').
atom(id232,a14,'C').
atom(id232,a15,'C').
atom(id232,a16,'C').
atom(id232,a17,'C').
atom(id232,a18,'C').
atom(id232,a19,'O').
atom(id232,a20,'O').
bond(id232,a2,a1,double).
bond(id232,a3,a2,single).
bond(id232,a4,a3,single).
bond(id232,a5,a4,double).
bond(id232,a6,a5,single).
bond(id232,a7,a6,double).
bond(id232,a8,a7,single).
bond(id232,a9,a8,double).
bond(id232,a10,a9,single).
bond(id232,a10,a1,single).
bond(id232,a11,a10,double).
bond(id232,a9,a4,single).
bond(id232,a12,a7,single).
bond(id232,a13,a2,single).
bond(id232,a14,a13,double).
bond(id232,a15,a14,single).
bond(id232,a16,a15,double).
bond(id232,a17,a16,single).
bond(id232,a18,a17,double).
bond(id232,a18,a13,single).
bond(id232,a19,a16,single).
bond(id232,a20,a1,single).


